/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.dto.request;

import com.baijia.tianxiao.biz.erp.constant.RepeatUnit;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.util.json.JacksonUtil;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class AddCourseLessonRequestDto {
    private Long lessonId;
    private String lessonName;
    private Long startDay;
    private transient Date startDayTime;
    private Long endDay;
    private transient Date endDayTime;
    private String startTime;
    private String endTime;
    private int enableRepeat;
    private Integer repeatUnit;
    private Integer repeatRange;
    private Integer repeatCount;
    private Long courseId;
    private Long roomId;
    private Long teacherId;
    private String studentIds;

    public RepeatUnit getRepeatUnit() {
        RepeatUnit result = RepeatUnit.getByCode(this.repeatUnit);
        if (result == null) {
            result = RepeatUnit.NONE;
        }
        return result;
    }

    public Collection<Long> getStudentIds() {
        if (StringUtils.isBlank((CharSequence)this.studentIds)) {
            return Collections.emptyList();
        }
        try {
            return JacksonUtil.str2List((String)this.studentIds, Long.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("\u5b66\u751fID\u6570\u7ec4\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
    }

    public OrgClassLesson conver2Po(Long orgId, Date startTime, Date endTime) {
        OrgClassLesson lesson = new OrgClassLesson();
        lesson.setId(this.lessonId);
        lesson.setCourseId(this.courseId);
        lesson.setDelStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
        lesson.setEndTime(endTime);
        lesson.setOrgId(orgId);
        lesson.setRoomId(this.roomId);
        lesson.setStartTime(startTime);
        lesson.setUpdateTime(new Date());
        return lesson;
    }

    public void validate() {
        if (this.startDay == null || this.startDay <= 0L) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.startDayTime = new Date(this.startDay);
        if (this.endDay != null && this.endDay > 0L) {
            this.endDayTime = new Date(this.endDay);
        }
        if (this.courseId == null || this.courseId < 0L) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u73ed\u7ea7\u7684ID\u4e0d\u6b63\u786e");
        }
        if (StringUtils.isBlank((CharSequence)this.startTime) || StringUtils.isBlank((CharSequence)this.endTime)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            if (DateUtils.parseDate((String)this.startTime, (String[])new String[]{"HH:mm"}).after(DateUtils.parseDate((String)this.endTime, (String[])new String[]{"HH:mm"}))) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65f6\u95f4");
            }
        }
        catch (ParseException e) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4e0a\u8bfe/\u4e0b\u8bfe\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        if (this.enableRepeat == 1) {
            if (this.repeatCount == null || this.repeatCount <= 0 || this.repeatCount > 99) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u91cd\u590d\u8bfe\u8282\u6570\u8303\u56f41-99");
            }
            if (this.repeatRange == null || this.repeatRange <= 0) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u91cd\u590d\u8bfe\u8282\u7684\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u5c0f\u4e8e0");
            }
            RepeatUnit unit = this.getRepeatUnit();
            if (unit == null || unit.getCode() > RepeatUnit.Year.getCode()) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u91cd\u590d\u7684\u65f6\u95f4\u7c92\u5ea6\u9519\u8bef");
            }
        }
    }

    public Long getLessonId() {
        return this.lessonId;
    }

    public String getLessonName() {
        return this.lessonName;
    }

    public Long getStartDay() {
        return this.startDay;
    }

    public Date getStartDayTime() {
        return this.startDayTime;
    }

    public Long getEndDay() {
        return this.endDay;
    }

    public Date getEndDayTime() {
        return this.endDayTime;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public int getEnableRepeat() {
        return this.enableRepeat;
    }

    public Integer getRepeatRange() {
        return this.repeatRange;
    }

    public Integer getRepeatCount() {
        return this.repeatCount;
    }

    public Long getCourseId() {
        return this.courseId;
    }

    public Long getRoomId() {
        return this.roomId;
    }

    public Long getTeacherId() {
        return this.teacherId;
    }

    public void setLessonId(Long lessonId) {
        this.lessonId = lessonId;
    }

    public void setLessonName(String lessonName) {
        this.lessonName = lessonName;
    }

    public void setStartDay(Long startDay) {
        this.startDay = startDay;
    }

    public void setStartDayTime(Date startDayTime) {
        this.startDayTime = startDayTime;
    }

    public void setEndDay(Long endDay) {
        this.endDay = endDay;
    }

    public void setEndDayTime(Date endDayTime) {
        this.endDayTime = endDayTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setEnableRepeat(int enableRepeat) {
        this.enableRepeat = enableRepeat;
    }

    public void setRepeatUnit(Integer repeatUnit) {
        this.repeatUnit = repeatUnit;
    }

    public void setRepeatRange(Integer repeatRange) {
        this.repeatRange = repeatRange;
    }

    public void setRepeatCount(Integer repeatCount) {
        this.repeatCount = repeatCount;
    }

    public void setCourseId(Long courseId) {
        this.courseId = courseId;
    }

    public void setRoomId(Long roomId) {
        this.roomId = roomId;
    }

    public void setTeacherId(Long teacherId) {
        this.teacherId = teacherId;
    }

    public void setStudentIds(String studentIds) {
        this.studentIds = studentIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddCourseLessonRequestDto)) {
            return false;
        }
        AddCourseLessonRequestDto other = (AddCourseLessonRequestDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$lessonId = this.getLessonId();
        Long other$lessonId = other.getLessonId();
        if (this$lessonId == null ? other$lessonId != null : !((Object)this$lessonId).equals(other$lessonId)) {
            return false;
        }
        String this$lessonName = this.getLessonName();
        String other$lessonName = other.getLessonName();
        if (this$lessonName == null ? other$lessonName != null : !this$lessonName.equals(other$lessonName)) {
            return false;
        }
        Long this$startDay = this.getStartDay();
        Long other$startDay = other.getStartDay();
        if (this$startDay == null ? other$startDay != null : !((Object)this$startDay).equals(other$startDay)) {
            return false;
        }
        Long this$endDay = this.getEndDay();
        Long other$endDay = other.getEndDay();
        if (this$endDay == null ? other$endDay != null : !((Object)this$endDay).equals(other$endDay)) {
            return false;
        }
        String this$startTime = this.getStartTime();
        String other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime)) {
            return false;
        }
        String this$endTime = this.getEndTime();
        String other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !this$endTime.equals(other$endTime)) {
            return false;
        }
        if (this.getEnableRepeat() != other.getEnableRepeat()) {
            return false;
        }
        RepeatUnit this$repeatUnit = this.getRepeatUnit();
        RepeatUnit other$repeatUnit = other.getRepeatUnit();
        if (this$repeatUnit == null ? other$repeatUnit != null : !((Object)((Object)this$repeatUnit)).equals((Object)other$repeatUnit)) {
            return false;
        }
        Integer this$repeatRange = this.getRepeatRange();
        Integer other$repeatRange = other.getRepeatRange();
        if (this$repeatRange == null ? other$repeatRange != null : !((Object)this$repeatRange).equals(other$repeatRange)) {
            return false;
        }
        Integer this$repeatCount = this.getRepeatCount();
        Integer other$repeatCount = other.getRepeatCount();
        if (this$repeatCount == null ? other$repeatCount != null : !((Object)this$repeatCount).equals(other$repeatCount)) {
            return false;
        }
        Long this$courseId = this.getCourseId();
        Long other$courseId = other.getCourseId();
        if (this$courseId == null ? other$courseId != null : !((Object)this$courseId).equals(other$courseId)) {
            return false;
        }
        Long this$roomId = this.getRoomId();
        Long other$roomId = other.getRoomId();
        if (this$roomId == null ? other$roomId != null : !((Object)this$roomId).equals(other$roomId)) {
            return false;
        }
        Long this$teacherId = this.getTeacherId();
        Long other$teacherId = other.getTeacherId();
        if (this$teacherId == null ? other$teacherId != null : !((Object)this$teacherId).equals(other$teacherId)) {
            return false;
        }
        Collection<Long> this$studentIds = this.getStudentIds();
        Collection<Long> other$studentIds = other.getStudentIds();
        return !(this$studentIds == null ? other$studentIds != null : !((Object)this$studentIds).equals(other$studentIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddCourseLessonRequestDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $lessonId = this.getLessonId();
        result = result * 59 + ($lessonId == null ? 43 : ((Object)$lessonId).hashCode());
        String $lessonName = this.getLessonName();
        result = result * 59 + ($lessonName == null ? 43 : $lessonName.hashCode());
        Long $startDay = this.getStartDay();
        result = result * 59 + ($startDay == null ? 43 : ((Object)$startDay).hashCode());
        Long $endDay = this.getEndDay();
        result = result * 59 + ($endDay == null ? 43 : ((Object)$endDay).hashCode());
        String $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : $startTime.hashCode());
        String $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : $endTime.hashCode());
        result = result * 59 + this.getEnableRepeat();
        RepeatUnit $repeatUnit = this.getRepeatUnit();
        result = result * 59 + ($repeatUnit == null ? 43 : ((Object)((Object)$repeatUnit)).hashCode());
        Integer $repeatRange = this.getRepeatRange();
        result = result * 59 + ($repeatRange == null ? 43 : ((Object)$repeatRange).hashCode());
        Integer $repeatCount = this.getRepeatCount();
        result = result * 59 + ($repeatCount == null ? 43 : ((Object)$repeatCount).hashCode());
        Long $courseId = this.getCourseId();
        result = result * 59 + ($courseId == null ? 43 : ((Object)$courseId).hashCode());
        Long $roomId = this.getRoomId();
        result = result * 59 + ($roomId == null ? 43 : ((Object)$roomId).hashCode());
        Long $teacherId = this.getTeacherId();
        result = result * 59 + ($teacherId == null ? 43 : ((Object)$teacherId).hashCode());
        Collection<Long> $studentIds = this.getStudentIds();
        result = result * 59 + ($studentIds == null ? 43 : ((Object)$studentIds).hashCode());
        return result;
    }

    public String toString() {
        return "AddCourseLessonRequestDto(lessonId=" + this.getLessonId() + ", lessonName=" + this.getLessonName() + ", startDay=" + this.getStartDay() + ", startDayTime=" + this.getStartDayTime() + ", endDay=" + this.getEndDay() + ", endDayTime=" + this.getEndDayTime() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", enableRepeat=" + this.getEnableRepeat() + ", repeatUnit=" + (Object)((Object)this.getRepeatUnit()) + ", repeatRange=" + this.getRepeatRange() + ", repeatCount=" + this.getRepeatCount() + ", courseId=" + this.getCourseId() + ", roomId=" + this.getRoomId() + ", teacherId=" + this.getTeacherId() + ", studentIds=" + this.getStudentIds() + ")";
    }
}

