/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.teacherCenter.service.impl;

import com.baijia.tianxiao.biz.erp.dto.request.ListLessonsRequestDto;
import com.baijia.tianxiao.biz.erp.dto.response.H5LessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.ListLessonResponseDto;
import com.baijia.tianxiao.biz.erp.service.CourseLessonService;
import com.baijia.tianxiao.biz.erp.teacherCenter.dto.LessonCommentStudentDto;
import com.baijia.tianxiao.biz.erp.teacherCenter.service.ErpTeacherCenterService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.CommentStatus;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonCommentSmsDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.sal.comment.dto.CommentAuditDto;
import com.baijia.tianxiao.sal.comment.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.comment.service.LessonCommentAudiService;
import com.baijia.tianxiao.sal.comment.service.LessonCommentService;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgStudentsChooseListDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ErpTeacherCenterServiceImpl
implements ErpTeacherCenterService {
    @Resource
    private CourseTeacherService courseTeacherService;
    @Resource
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Resource
    private CourseStudentService courseStudentService;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private CourseLessonService courseLessonService;
    @Resource
    private OrgCourseListService orgCourseListService;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgClassRoomDao orgClassRoomDao;
    @Resource
    private LessonCommentAudiService LessonCommentAudiService;
    @Resource
    private LessonCommentService LessonCommentService;
    @Resource
    private OrgLessonCommentSmsDao orgLessonCommentSmsDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;

    @Override
    @Transactional(readOnly=true)
    public TeacherResponseDto getTeacherInfo(Long teacherId, Long orgId) {
        Preconditions.checkArgument((teacherId != null ? 1 : 0) != 0, (Object)"teacher id is null!");
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        return this.courseTeacherService.getTeacher(teacherId, orgId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<CommentAuditDto> getTeacherComment(Long orgId, Long teacherId, Boolean isSystem, Integer userRole, PageDto pageDto) {
        List courseCommentsDto = this.LessonCommentAudiService.getTeacherCourseCommentAudit(teacherId, orgId, isSystem, userRole, pageDto);
        Collection courseIds = CollectorUtil.collect((Collection)courseCommentsDto, (Function)new Function<CommentAuditDto, Long>(){

            public Long apply(CommentAuditDto arg0) {
                return arg0.getId();
            }
        });
        Map nameMap = this.orgCourseDao.getCourseNameMap(courseIds);
        for (CommentAuditDto comment : courseCommentsDto) {
            comment.setName((String)nameMap.get(comment.getId()));
        }
        return courseCommentsDto;
    }

    @Override
    @Transactional(readOnly=true)
    public H5LessonResponseDto getLastLesson(List<H5LessonResponseDto> h5LessonList, Long lessonId) {
        if (lessonId != null) {
            for (H5LessonResponseDto h5LessonResponseDto : h5LessonList) {
                if (!h5LessonResponseDto.getLessonId().equals(lessonId)) continue;
                return h5LessonResponseDto;
            }
            return null;
        }
        Date now = new Date();
        H5LessonResponseDto result = null;
        for (H5LessonResponseDto h5LessonResponseDto : h5LessonList) {
            if (h5LessonResponseDto.getLessonStartTime().before(now)) {
                result = h5LessonResponseDto;
                continue;
            }
            return result;
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public List<LessonCommentStudentDto> getCommentList(Long orgId, Long lessonId, Integer userRole) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        Preconditions.checkArgument((userRole != null ? 1 : 0) != 0, (Object)"userRole is null!");
        if (lessonId == null) {
            return Lists.newArrayList();
        }
        List chooseList = this.courseStudentService.getLessonStudent(orgId, lessonId, false);
        Collection studentIds = CollectorUtil.collect((Collection)chooseList, (Function)new Function<OrgStudentsChooseListDto, Long>(){

            public Long apply(OrgStudentsChooseListDto arg0) {
                return arg0.getStudentId();
            }
        });
        Map userIdMap = this.orgStudentDao.getStudentIdUserIdMap(studentIds);
        Map<Long, CommentInfoDto> commentMap = this.getCommentMap(orgId, lessonId, userRole);
        Map smsMap = this.orgLessonCommentSmsDao.getSendMap(orgId, lessonId, userIdMap.values(), Integer.valueOf(UserRole.STUDENT.getRole()));
        ArrayList response = Lists.newArrayList();
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        for (OrgStudentsChooseListDto orgStudentsChooseListDto : chooseList) {
            LessonCommentStudentDto dto = new LessonCommentStudentDto();
            Long userId = (Long)userIdMap.get(orgStudentsChooseListDto.getStudentId());
            dto.setStudentInfo(orgStudentsChooseListDto);
            CommentInfoDto commentInfo = commentMap.get(userId);
            this.getAndSetCommentStatus(commentInfo, lesson, dto, userRole);
            dto.setSend(smsMap.get(userId) == null ? 0 : (Integer)smsMap.get(userId));
            response.add(dto);
        }
        return response;
    }

    private void getAndSetCommentStatus(CommentInfoDto commentInfo, OrgClassLesson lesson, LessonCommentStudentDto dto, Integer userRole) {
        dto.setCommentInfo(commentInfo);
        if (commentInfo == null) {
            dto.setCommentStatus(CommentStatus.getCommentStatusByTime((Date)lesson.getStartTime(), (Date)lesson.getEndTime(), (userRole.intValue() == UserRole.STUDENT.getRole() ? 1 : 0) != 0));
        } else {
            dto.setCommentStatus(CommentStatus.COMMENTED);
        }
    }

    private Map<Long, CommentInfoDto> getCommentMap(Long orgId, Long lessonId, final Integer userRole) {
        List commentInfos = this.LessonCommentService.getLessonComments(lessonId, orgId, userRole);
        return CollectorUtil.collectMap((Collection)commentInfos, (Function)new Function<CommentInfoDto, Long>(){

            public Long apply(CommentInfoDto arg0) {
                if (userRole.intValue() == UserRole.STUDENT.getRole()) {
                    return arg0.getFromId();
                }
                return arg0.getToId();
            }
        });
    }

    @Override
    public List<CourseListReponseDto> getCoursesList(Long orgId, Long teacherId, PageDto pageDto) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        Preconditions.checkArgument((teacherId != null ? 1 : 0) != 0, (Object)"teacherId is null!");
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        List courseIds = this.orgCourseTeacherDao.getCourseIdByTeacherId(teacherId);
        if (GenericsUtils.isNullOrEmpty((Object)courseIds)) {
            return GenericsUtils.emptyList();
        }
        List courses = this.orgCourseDao.getAndFilterOrgCourseByIn(account.getNumber(), (Collection)courseIds, null, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null, pageDto);
        OrgCourseListService.CourseListParam courseListParam = new OrgCourseListService.CourseListParam();
        courseListParam.setCourses(courses).setOrgId(orgId).setTeacherId(teacherId).setNeedLesson(true).setNeedStudent(true);
        List response = this.orgCourseListService.getCourseList(courseListParam);
        ListLessonsRequestDto params = new ListLessonsRequestDto();
        params.setTeacherId(teacherId);
        params.setStartTime(DateUtil.getCurrentDate().getTime());
        params.setStartTime(DateUtil.getDiffDateTime((Date)DateUtil.getCurrentDate(), (int)1).getTime());
        ListLessonResponseDto listLessonResponseDto = this.courseLessonService.listLessons(orgId, params);
        Map lessonMap = CollectorUtil.group(listLessonResponseDto.getList(), (Function)new Function<LessonResponseDto, Long>(){

            public Long apply(LessonResponseDto arg0) {
                return arg0.getCourseId();
            }
        });
        for (CourseListReponseDto courseListReponseDto : response) {
            List list = (List)lessonMap.get(courseListReponseDto.getOrgCourseId());
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                int count = 0;
                for (LessonResponseDto lessonResponseDto : list) {
                    if (!DateUtil.isToday((Date)lessonResponseDto.getLessonStartTime())) continue;
                    ++count;
                }
                courseListReponseDto.setLessonToday(Integer.valueOf(count));
                continue;
            }
            courseListReponseDto.setLessonToday(Integer.valueOf(0));
        }
        return response;
    }

    @Override
    @Transactional(readOnly=true)
    public List<CommentAuditDto> getTeacherAuditList(Long orgId, Integer userRole, Boolean isSystem, PageDto page) {
        List teacherList = this.courseTeacherService.listOrgTeacher(null, orgId, null, null, page);
        Map teacherMap = CollectorUtil.collectMap((Collection)teacherList, (Function)new Function<TeacherResponseDto, Long>(){

            public Long apply(TeacherResponseDto arg0) {
                return arg0.getTeacherId();
            }
        });
        List comments = this.LessonCommentAudiService.getTeacherAuditList(orgId, teacherMap.keySet(), userRole, isSystem);
        for (CommentAuditDto commentAuditDto : comments) {
            TeacherResponseDto teacher = (TeacherResponseDto)teacherMap.get(commentAuditDto.getId());
            if (teacher == null) continue;
            commentAuditDto.setName(teacher.getTeacherName());
            commentAuditDto.setAvatarUrl(teacher.getAvatar());
        }
        return comments;
    }
}

