/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.sync.impl;

import com.baijia.tianxiao.biz.erp.service.CourseClassService;
import com.baijia.tianxiao.biz.erp.sync.SyncPayService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.StudentFiannceOpType;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import com.baijia.tianxiao.sal.signup.constants.SignupSourceType;
import com.baijia.tianxiao.sal.signup.service.TxStudentFinanceAccountService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.SmsSendUtil;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="syncSignupSuccessAndSyncFail")
public class SyncSignupSuccessAndSyncFail
implements SyncPayService {
    private static final Logger log = LoggerFactory.getLogger(SyncSignupSuccessAndSyncFail.class);
    String SIGNUP_SMS_CONTENT_TEMPLATE = "\u60a8\u5df2\u6210\u529f\u5728%s\u62a5\u540d\u4e86\u8bfe\u7a0b%s!";
    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;
    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private TXSaleClueRuleService tXSaleClueRuleService;
    @Resource
    private CourseClassService courseClassService;
    @Resource
    private TXAccountService txAccountService;
    @Autowired
    private TXStudentCommentAPIService txStudentCommentAPIService;
    @Resource
    private TxStudentFinanceAccountService txStudentFinanceAccountService;

    @Override
    public void sync() {
        try {
            List syncSignupInfoList = this.orgSignupInfoDao.getSignupSuccessAndNotSync();
            log.info("SyncSignupSuccessAndSyncFail  syncSignupInfoList=={}", (Object)syncSignupInfoList);
            if (CollectionUtils.isNotEmpty((Collection)syncSignupInfoList)) {
                for (OrgSignupInfo signupInfo : syncSignupInfoList) {
                    TXSaleClueRule txSaleClueRule;
                    OrgStudent orgStudent;
                    List signupCourses = this.orgSignupCourseDao.loadByPurchaseId(signupInfo.getSignupPurchaseId(), new String[0]);
                    if (CollectionUtils.isEmpty((Collection)signupCourses)) continue;
                    signupInfo.setOrgSignupCourses(signupCourses);
                    Map courseMap = CollectorUtil.collectMap((Collection)signupCourses, (Function)new Function<OrgSignupCourse, Long>(){

                        public Long apply(OrgSignupCourse orgSignupCourse) {
                            return orgSignupCourse.getOrgCourseId();
                        }
                    });
                    StringBuilder sb = new StringBuilder();
                    ArrayList names = Lists.newArrayList();
                    List courseList = this.orgCourseDao.getByIds(courseMap.keySet(), new String[0]);
                    for (int i = 0; i < courseList.size(); ++i) {
                        OrgCourse tempCourse = (OrgCourse)courseList.get(i);
                        sb.append("\u201c" + tempCourse.getName() + "\u201c");
                        names.add(tempCourse.getName());
                        if (i < courseList.size() - 1) {
                            sb.append("\u3001");
                        }
                        if (tempCourse.getCourseType().intValue() != CourseTypeEnum.COURSE_TYPE_1v1.getCode().intValue()) continue;
                        this.orgSignupCourseDao.updateLessonCountByPurchaseId(signupInfo.getSignupPurchaseId(), tempCourse.getId());
                    }
                    this.updateSignupCourseCharge(courseList, courseMap);
                    Map courseMap_ = GenericsUtils.toFieldMap((Collection)courseList, (String[])new String[]{"id"});
                    log.info("courseMap_ is :{} ", (Object)courseMap_);
                    OrgSignupInfo orgSignupInfo = signupInfo;
                    HashMap orgSignupCourseMap = Maps.newHashMap();
                    HashMap orgCourseMap = Maps.newHashMap();
                    if (CollectionUtils.isNotEmpty((Collection)signupCourses)) {
                        for (OrgSignupCourse orgSignupCourse : signupCourses) {
                            orgCourseMap.put(orgSignupCourse.getOrgCourseId(), courseMap_.get(orgSignupCourse.getOrgCourseId()));
                            orgSignupCourseMap.put(orgSignupCourse.getOrgCourseId(), orgSignupCourse);
                        }
                    }
                    this.txStudentCommentAPIService.saveBySignUpPurchase(orgSignupInfo, (Map)orgSignupCourseMap, (Map)orgCourseMap);
                    Integer orgId = signupInfo.getOrgId().intValue();
                    OrgInfo orginfo = this.orgInfoDao.getOrgInfo(orgId, new String[]{"shortname"});
                    log.info("SignupInfoSmsProcessor :orgsignupInfo={}", (Object)signupInfo);
                    this.orgSignupCourseDao.updateStatusByPurchaseId(signupInfo.getSignupPurchaseId(), Integer.valueOf(SignupCourseStatus.HAS_PAY.getCode()));
                    if (signupInfo.getStudentPayPrice() > 0L && (orgStudent = this.orgStudentDao.getStudent(Long.valueOf(orgId.longValue()), signupInfo.getUserId(), Integer.valueOf(DataStatus.NORMAL.getValue()), new String[0])) != null) {
                        this.txStudentFinanceAccountService.changeStudentFiannceAccount(Long.valueOf(orgId.longValue()), Integer.valueOf(-1), orgStudent.getId(), StudentFiannceOpType.PAY_SUCCESS, signupInfo.getStudentPayPrice(), "\u652f\u4ed8\u6210\u529f", "");
                    }
                    if ((txSaleClueRule = this.tXSaleClueRuleService.getByOrgId(orgId)) != null && txSaleClueRule.getSignupMsg() != null && txSaleClueRule.getSignupMsg() == 0) {
                        SmsSendUtil.sendSms((String)signupInfo.getMobile(), (String)String.format(this.SIGNUP_SMS_CONTENT_TEMPLATE, orginfo.getShortName(), sb.toString()), (Integer)SmsMessageType.TIANXIAO_NOTIFY.getCode(), (Integer)orgId, (Integer)UserRole.ORGANIZATION.getRole(), (boolean)true, (Integer)this.txAccountService.getTxAccountSmsGate(orgId));
                    }
                    if (signupInfo == null) continue;
                    signupInfo.setSmsSend(Integer.valueOf(1));
                    log.info("sms before orgsignupinfo = {},result={}", (Object)signupInfo, (Object)(signupInfo.getSourceType().intValue() != SignupSourceType.TUIGUANG.getCode().intValue() ? 1 : 0));
                    this.orgSignupInfoDao.update((Object)signupInfo, new String[0]);
                }
            }
        }
        catch (Exception e) {
            log.warn("sy signup sms fail {}", (Throwable)e);
        }
    }

    private void updateSignupCourseCharge(List<OrgCourse> courseList, Map<Long, OrgSignupCourse> signupCourseMap) {
        for (OrgCourse orgCourse : courseList) {
            OrgSignupCourse orgSignupCourse = signupCourseMap.get(orgCourse.getId());
            if (orgSignupCourse.getChargeUnit().intValue() != ChargeUnit.BY_OTHER.getCode() || orgCourse.getChargeUnit().intValue() == ChargeUnit.BY_OTHER.getCode()) continue;
            this.orgSignupCourseDao.update((Object)orgSignupCourse, new String[]{"chargeUnit"});
        }
    }
}

