/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.sync.impl;

import com.baijia.tianxiao.biz.erp.enums.SyncSignupLessonCount;
import com.baijia.tianxiao.biz.erp.service.CourseClassService;
import com.baijia.tianxiao.biz.erp.sync.SyncPayService;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dto.StudentCourseKexiaoDocument;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.sal.wx.api.WxStudentCourseService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="syncSignupCourseSercieImpl")
public class SyncSignupCourseSercieImpl
implements SyncPayService {
    private static final Logger log = LoggerFactory.getLogger(SyncSignupCourseSercieImpl.class);
    @Autowired
    private WxStudentCourseService wxStudentCourseService;
    @Autowired
    private OrgSignupCourseDao signupCourseDao;
    @Autowired
    private OrgStudentCourseDao studentCourseDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private CourseClassService courseClassService;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgStudentKexiaoRecordDao orgStudentKexiaoRecordDao;
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    private AtomicBoolean coureFlag = new AtomicBoolean(false);

    @Override
    public void sync() {
        TxMsgSyncTimestamp syncInfo = this.getSyncInfo(MsgSyncType.SYNC_SIGNUP_COURSE_ID);
        try {
            if (!this.coureFlag.get()) {
                log.info("sync pay coursePurchase stat info :{}", (Object)syncInfo);
                this.coureFlag.set(true);
                this.syncSignupCourseInfo(syncInfo);
                this.coureFlag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", (Throwable)e);
        }
        finally {
            this.coureFlag.set(false);
        }
        log.info("save sync info:{}", (Object)syncInfo);
        this.txMsgSyncTimestampDao.saveOrUpdate((Object)syncInfo, new String[0]);
    }

    private void syncSignupCourseInfo(TxMsgSyncTimestamp syncInfo) {
        List signupCourseList = this.signupCourseDao.getCousePurchaseListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, SignupCourseStatus.inStudentCourseStatus, new String[0]);
        log.info("save syncSignupCourseInfo:{} success", (Object)signupCourseList);
        if (CollectionUtils.isNotEmpty((Collection)signupCourseList)) {
            for (OrgSignupCourse signupCourse : signupCourseList) {
                try {
                    if (signupCourse.getUpdateTime().after(syncInfo.getSyncTime())) {
                        syncInfo.setSyncTime(signupCourse.getUpdateTime());
                    }
                    boolean isNeedSyncLessonCount = true;
                    if (!SignupCourseStatus.statusInStudentCourse((int)signupCourse.getStatus())) {
                        isNeedSyncLessonCount = false;
                    }
                    if (signupCourse.getSyncLessonCount().intValue() == SyncSignupLessonCount.SYNC_SIGNUP.getCode()) {
                        isNeedSyncLessonCount = false;
                    }
                    OrgStudentCourse orgStudentCourse = this.studentCourseDao.getStudentCourseByRealCourseId(signupCourse.getOrgId(), signupCourse.getOrgCourseId(), signupCourse.getUserId());
                    if (isNeedSyncLessonCount) {
                        orgStudentCourse = this.saveOrUpdateStudentCourse(signupCourse, orgStudentCourse);
                        log.info("[SignUpCourseProcessor] orgStudentCourse = {}", (Object)orgStudentCourse);
                        boolean hasChange = false;
                        if (orgStudentCourse != null && signupCourse.getClassId() <= 0L) {
                            signupCourse.setClassId(orgStudentCourse.getCourseId());
                            hasChange = true;
                        }
                        if (signupCourse.getSyncLessonCount().intValue() != orgStudentCourse.getSyncLessonCount()) {
                            signupCourse.setSyncLessonCount(Integer.valueOf(orgStudentCourse.getSyncLessonCount()));
                            hasChange = true;
                        }
                        if (!hasChange) continue;
                        log.info("SignUpCourseProcessor =={},", (Object)signupCourse);
                        this.signupCourseDao.update((Object)signupCourse, new String[]{"classId", "syncLessonCount"});
                        continue;
                    }
                    if (orgStudentCourse == null || signupCourse.getClassId() > 0L) continue;
                    signupCourse.setClassId(orgStudentCourse.getCourseId());
                    this.signupCourseDao.update((Object)signupCourse, new String[]{"classId"});
                }
                catch (Exception e) {
                    log.warn("sygn course purchase fail {}", (Throwable)e);
                }
            }
        }
    }

    private OrgStudentCourse saveOrUpdateStudentCourse(OrgSignupCourse signupCourse, OrgStudentCourse studentCourse) {
        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(signupCourse.getOrgCourseId(), new String[0]);
        if (orgCourse == null) {
            log.error("SignUpCourseProcessor not have course ={}", (Object)signupCourse);
        }
        OrgStudent orgstudent = this.orgStudentDao.getStudentByUserId(signupCourse.getOrgId(), signupCourse.getUserId(), new String[0]);
        if (orgCourse == null) {
            log.error("SignUpCourseProcessor not have orgstudent ={}", (Object)signupCourse);
        }
        boolean isWangxiaoNewStu = false;
        if (studentCourse == null) {
            if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
                studentCourse = this.courseClassService.createClassFor1V1(signupCourse.getOrgId(), signupCourse.getSignupPurchaseId(), signupCourse.getOrgCourseId(), signupCourse.getUserId(), signupCourse.getChargeUnit(), signupCourse.getLessonCount());
            } else {
                studentCourse = this.newClassStudentCourse(signupCourse, orgstudent);
                if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_CLASS_LIVE.getCode() || orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_CLASS_VIDEO.getCode()) {
                    isWangxiaoNewStu = true;
                }
            }
            studentCourse.setSyncLessonCount(SyncSignupLessonCount.SYNC_SIGNUP.getCode());
        } else {
            studentCourse = this.updateLessonCountAndStatus(studentCourse, signupCourse);
        }
        studentCourse.setRealCourseId(signupCourse.getOrgCourseId());
        log.info("[SignUpCourseProcessor] studentCourse into =={}", (Object)studentCourse);
        this.studentCourseDao.saveOrUpdate((Object)studentCourse, new String[0]);
        if (isWangxiaoNewStu && studentCourse.getId() != null && studentCourse.getId() > 0L) {
            this.wxStudentCourseService.taskProcess(orgCourse, studentCourse);
        }
        return studentCourse;
    }

    private OrgStudentCourse newClassStudentCourse(OrgSignupCourse signupCourse, OrgStudent orgStudent) {
        OrgStudentCourse studentCourse = new OrgStudentCourse();
        studentCourse.setCourseId(signupCourse.getOrgCourseId());
        studentCourse.setRealCourseId(signupCourse.getOrgCourseId());
        studentCourse.setCreateTime(new Date());
        studentCourse.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        studentCourse.setStatus(Integer.valueOf(StudentCourseStatus.NORMAL.getCode()));
        studentCourse.setOrgId(signupCourse.getOrgId());
        studentCourse.setUserId(signupCourse.getUserId());
        studentCourse.setStudentMobile(orgStudent.getMobile());
        studentCourse.setStudentName(orgStudent.getName());
        studentCourse.setChargeUnit(signupCourse.getChargeUnit());
        if (signupCourse.getChargeUnit().intValue() == ChargeUnit.BY_HOUR.getCode()) {
            studentCourse.setLessonCount(Integer.valueOf(signupCourse.getLessonCount() * 60));
        } else if (signupCourse.getChargeUnit().intValue() == ChargeUnit.BY_HALF_HOUR.getCode()) {
            studentCourse.setLessonCount(Integer.valueOf(signupCourse.getLessonCount() * 30));
        } else {
            studentCourse.setLessonCount(signupCourse.getLessonCount());
        }
        studentCourse.setSignupPurchaseId(signupCourse.getSignupPurchaseId());
        return studentCourse;
    }

    private OrgStudentCourse updateLessonCountAndStatus(OrgStudentCourse studentCourse, OrgSignupCourse signupCourse) {
        Integer count = this.signupCourseDao.sumAllLessonCount(signupCourse.getOrgId(), signupCourse.getOrgCourseId(), signupCourse.getUserId(), SignupCourseStatus.inClassStatus, new String[0]);
        StudentCourseKexiaoDocument financed = this.orgStudentKexiaoRecordDao.finishCountMoney(signupCourse.getId(), signupCourse.getOrgCourseId(), signupCourse.getUserId(), null, SignupCourseStatus.quitClassStatus);
        if (signupCourse.getChargeUnit().intValue() == ChargeUnit.BY_HOUR.getCode()) {
            studentCourse.setLessonCount(Integer.valueOf(count * 60 + financed.getFinishTime().intValue()));
        } else if (signupCourse.getChargeUnit().intValue() == ChargeUnit.BY_HALF_HOUR.getCode()) {
            studentCourse.setLessonCount(Integer.valueOf(count * 30 + financed.getFinishTime().intValue()));
        } else {
            studentCourse.setLessonCount(Integer.valueOf(count + financed.getFinishCount().intValue()));
        }
        studentCourse.setChargeUnit(signupCourse.getChargeUnit());
        studentCourse.setSyncLessonCount(SyncSignupLessonCount.SYNC_SIGNUP.getCode());
        if (signupCourse.getStatus().intValue() == SignupCourseStatus.QUIT_CLASS.getCode()) {
            studentCourse.setStatus(Integer.valueOf(StudentCourseStatus.WITHDRAW.getCode()));
        } else {
            studentCourse.setStatus(Integer.valueOf(StudentCourseStatus.NORMAL.getCode()));
        }
        return studentCourse;
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(Long.valueOf(0L));
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(Integer.valueOf(syncType.getSyncType()));
        }
        return syncInfo;
    }
}

