/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.sync.impl;

import com.baijia.tianxiao.biz.erp.sync.SyncPayService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.signup.constant.SignupType;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="syncCoursePurchaseService")
public class SyncCoursePurchaseServiceImpl
implements SyncPayService {
    private static final Logger log = LoggerFactory.getLogger(SyncCoursePurchaseServiceImpl.class);
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    @Resource
    private CoursePurchaseDao coursePurchaseDao;
    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;
    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    private AtomicBoolean coureFlag = new AtomicBoolean(false);

    @Override
    public void sync() {
        TxMsgSyncTimestamp syncInfo = this.getSyncInfo(MsgSyncType.PAY_COURSE_PURCHASE);
        try {
            if (!this.coureFlag.get()) {
                log.info("sync pay coursePurchase stat info :{}", (Object)syncInfo);
                this.coureFlag.set(true);
                this.syncCoursePurchaseInfo(syncInfo);
                this.coureFlag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", (Throwable)e);
        }
        finally {
            this.coureFlag.set(false);
        }
        log.info("save sync info:{}", (Object)syncInfo);
        this.txMsgSyncTimestampDao.saveOrUpdate((Object)syncInfo, new String[0]);
    }

    private void syncCoursePurchaseInfo(TxMsgSyncTimestamp syncInfo) {
        List coursePurchases = this.coursePurchaseDao.getCousePurchaseListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, Integer.valueOf(CourseType.ORG_COURSE.getCode()), Integer.valueOf(1), Integer.valueOf(1), new String[0]);
        log.info("save payoursePurchases:{} success", (Object)coursePurchases.size());
        if (CollectionUtils.isNotEmpty((Collection)coursePurchases)) {
            for (CoursePurchase coursePurchase : coursePurchases) {
                try {
                    this.saveSignUpInfo(coursePurchase);
                    this.saveSignUpCourse(coursePurchase);
                }
                catch (Exception e) {
                    log.warn("sygn course purchase fail {}", (Throwable)e);
                }
            }
        }
    }

    private void saveSignUpInfo(CoursePurchase coursePurchase) {
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(coursePurchase.getPurchaseId(), new String[0]);
        if (orgSignupInfo == null) {
            String[] payTypeStr;
            orgSignupInfo = new OrgSignupInfo();
            orgSignupInfo.setOrgId(coursePurchase.getOrgId());
            OrgAccount orgAccount = this.orgAccountDao.getAccountById(coursePurchase.getOrgId().intValue(), new String[0]);
            if (orgAccount != null) {
                orgSignupInfo.setOrgNumber(Long.valueOf(orgAccount.getNumber().intValue()));
            }
            orgSignupInfo.setStudentName(coursePurchase.getUserName());
            orgSignupInfo.setUserId(coursePurchase.getUserId());
            List orgStudents = this.orgStudentDao.getStudentByUserId(coursePurchase.getUserId(), null);
            if (!orgStudents.isEmpty() && orgStudents.size() > 0) {
                OrgStudent temp = (OrgStudent)orgStudents.get(orgStudents.size() - 1);
                orgSignupInfo.setMobile(temp.getMobile());
            }
            orgSignupInfo.setOperator("task\u540c\u6b65");
            orgSignupInfo.setRemark("coursePruchase");
            orgSignupInfo.setSplitResult(Integer.valueOf(-1));
            orgSignupInfo.setSignupType(Integer.valueOf(SignupType.ONLINE.getCode()));
            String payType = coursePurchase.getPayType();
            if (payType != null && (payTypeStr = payType.split(":")) != null && payTypeStr.length > 0) {
                orgSignupInfo.setPayType(Integer.valueOf(Integer.parseInt(payTypeStr[0])));
            }
            Date now = new Date();
            orgSignupInfo.setCreateTime(now);
            orgSignupInfo.setUpdateTime(now);
            orgSignupInfo.setTotalPrices(Long.valueOf(Math.round(coursePurchase.getTotalPrices() * 100.0)));
            orgSignupInfo.setPurchaseStatus(Integer.valueOf(1));
            orgSignupInfo.setIsDel(Integer.valueOf(DataStatus.NORMAL.getValue()));
            orgSignupInfo.setTradeNo(coursePurchase.getPurchaseId());
            orgSignupInfo.setSignupPurchaseId(coursePurchase.getPurchaseId());
            orgSignupInfo.setPayPurchaseId(coursePurchase.getPurchaseId());
            orgSignupInfo.setSourceType(Integer.valueOf(1));
            log.debug("save orgsignup info =={}", (Object)orgSignupInfo);
            this.orgSignupInfoDao.save((Object)orgSignupInfo, new String[0]);
        }
    }

    private void saveSignUpCourse(CoursePurchase coursePurchase) {
        List orgSignupCourses = this.orgSignupCourseDao.loadByPurchaseId(coursePurchase.getPurchaseId(), new String[0]);
        if (orgSignupCourses == null || orgSignupCourses.size() == 0) {
            OrgSignupCourse orgSignupCourse = new OrgSignupCourse();
            orgSignupCourse.setOrgId(coursePurchase.getOrgId());
            orgSignupCourse.setSignupPurchaseId(coursePurchase.getPurchaseId());
            orgSignupCourse.setOrgCourseId(coursePurchase.getCourseId());
            orgSignupCourse.setOrgCourseNumber(coursePurchase.getCourseNumber());
            orgSignupCourse.setOriginPrice(Integer.valueOf((int)Math.round(coursePurchase.getTotalPrices() * 100.0)));
            orgSignupCourse.setCourseDiscount(Integer.valueOf(100));
            orgSignupCourse.setPreferential(Integer.valueOf(0));
            orgSignupCourse.setCount(Integer.valueOf(1));
            orgSignupCourse.setPayPrice(Long.valueOf(Math.round(coursePurchase.getTotalPrices() * 100.0)));
            orgSignupCourse.setCreateTime(new Date());
            orgSignupCourse.setUpdateTime(new Date());
            log.debug("save orgSignupCourse info =={}", (Object)orgSignupCourse);
            this.orgSignupCourseDao.save((Object)orgSignupCourse, new String[0]);
        }
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(Long.valueOf(0L));
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(Integer.valueOf(syncType.getSyncType()));
        }
        return syncInfo;
    }
}

