/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.dto.response.SignupDetailResponse;
import com.baijia.tianxiao.biz.erp.service.SignupRecordService;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.signup.constant.SignupStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.dal.statistic.dao.TxSignupRecordDayDao;
import com.baijia.tianxiao.dal.statistic.po.TxSignupRecordDay;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.finance.dto.SignupDateRequest;
import com.baijia.tianxiao.sal.organization.finance.dto.SignupRefundRequest;
import com.baijia.tianxiao.sal.organization.finance.dto.SignupRefundResponse;
import com.baijia.tianxiao.sal.organization.finance.dto.StatisticsByDayResponse;
import com.baijia.tianxiao.sal.organization.finance.dto.StatisticsByMonthResponse;
import com.baijia.tianxiao.sal.organization.finance.dto.SummaryExportDto;
import com.baijia.tianxiao.sal.signup.constants.SignupAndRefund;
import com.baijia.tianxiao.sal.signup.constants.SignupSourceType;
import com.baijia.tianxiao.sal.signup.dto.SignupCourseInfoDto;
import com.baijia.tianxiao.sal.signup.dto.request.SingupListRequestDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSingupInfoDto;
import com.baijia.tianxiao.util.ArithUtil;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SignupRecordServiceImpl
implements SignupRecordService {
    private static final Logger log = LoggerFactory.getLogger(SignupRecordServiceImpl.class);
    @Autowired
    OrgSignupRefundDao orgSignupRefundDao;
    @Autowired
    TxSignupRecordDayDao txSignupRecordDayDao;
    @Autowired
    CoursePurchaseDao coursePurchaseDao;
    @Autowired
    OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    OrgInfoDao orgInfoDao;
    @Autowired
    OrgAccountDao orgAccountDao;

    @Override
    public List<StatisticsByDayResponse> getListByMonth(int orgId, SignupDateRequest signupDateRequest) {
        Date beginTime = DateUtil.getDateByYearMonth((int)signupDateRequest.getYear(), (int)signupDateRequest.getMonth());
        Date endTime = DateUtil.endDateByYearMonth((int)signupDateRequest.getYear(), (int)signupDateRequest.getMonth());
        List txSignupRecordDay = this.txSignupRecordDayDao.getListByMonth(orgId, beginTime, endTime);
        List<StatisticsByDayResponse> statisticsByDayResponse = this.buildListByMonth(txSignupRecordDay);
        return statisticsByDayResponse;
    }

    private List<StatisticsByDayResponse> buildListByMonth(List<TxSignupRecordDay> txSignupRecordDay) {
        ArrayList<StatisticsByDayResponse> list = new ArrayList<StatisticsByDayResponse>();
        TreeMap map = new TreeMap();
        for (TxSignupRecordDay s : txSignupRecordDay) {
            if (map.containsKey(s.getMdate())) {
                ((ArrayList)map.get(s.getMdate())).add(s);
                continue;
            }
            ArrayList<TxSignupRecordDay> polist = new ArrayList<TxSignupRecordDay>();
            polist.add(s);
            map.put(s.getMdate(), polist);
        }
        for (ArrayList values : map.values()) {
            StatisticsByDayResponse dto = new StatisticsByDayResponse();
            for (TxSignupRecordDay value : values) {
                dto.setCreateTime(value.getMdate());
                if (value.getOpTo() == SignupAndRefund.SIGNUP.getCode()) {
                    if (value.getOpType() == SignupSourceType.SIGNUP.getCode() || value.getOpType() == SignupSourceType.TX_SIANGUP.getCode()) {
                        dto.setSignup(ArithUtil.round((double)(dto.getSignup() + value.getOpPrice()), (int)2));
                    } else if (value.getOpType() == SignupSourceType.WANXIAO.getCode()) {
                        dto.setWebsite(ArithUtil.round((double)(dto.getWebsite() + value.getOpPrice()), (int)2));
                    } else if (value.getOpType() == SignupSourceType.TUIGUANG.getCode()) {
                        dto.setExpend(ArithUtil.round((double)(dto.getExpend() + value.getOpPrice()), (int)2));
                    }
                } else if (value.getOpTo() == SignupAndRefund.REFUND.getCode()) {
                    dto.setRefund(ArithUtil.round((double)(dto.getRefund() + value.getOpPrice()), (int)2));
                }
                dto.setCount(ArithUtil.round((double)(dto.getExpend() + dto.getSignup() + dto.getWebsite()), (int)2));
            }
            list.add(dto);
        }
        Collections.sort(list, new Comparator<StatisticsByDayResponse>(){

            @Override
            public int compare(StatisticsByDayResponse o1, StatisticsByDayResponse o2) {
                return DateUtil.dateCompare((Date)o1.getCreateTime(), (Date)o2.getCreateTime());
            }
        });
        return list;
    }

    @Override
    public List<StatisticsByMonthResponse> getListByYear(int orgId, SignupDateRequest signupDateRequest) {
        ArrayList<StatisticsByMonthResponse> list = new ArrayList<StatisticsByMonthResponse>();
        Calendar cal = Calendar.getInstance();
        cal.set(signupDateRequest.getYear(), 0, 12);
        for (int i = 1; i < 13; ++i) {
            cal.set(5, 1);
            Date beginTime = cal.getTime();
            String begin = DateUtil.getAllDayStr((Date)beginTime).substring(0, 10) + " 00:00:00";
            beginTime = DateUtil.getDateByStr((String)begin);
            cal.set(5, 1);
            cal.roll(5, -1);
            Date endTime = cal.getTime();
            String end = DateUtil.getAllDayStr((Date)endTime).substring(0, 10) + " 23:59:59";
            endTime = DateUtil.getDateByStr((String)end);
            cal.set(2, i);
            List txSignupRecordDay = this.txSignupRecordDayDao.getListByMonth(orgId, beginTime, endTime);
            List<StatisticsByDayResponse> statisticsByDayResponse = this.buildListByMonth(txSignupRecordDay);
            StatisticsByMonthResponse dto = new StatisticsByMonthResponse();
            double count = 0.0;
            double refund = 0.0;
            for (StatisticsByDayResponse s : statisticsByDayResponse) {
                count = ArithUtil.round((double)(count + s.getCount()), (int)2);
                refund = ArithUtil.round((double)(refund + s.getRefund()), (int)2);
            }
            dto.setYear(signupDateRequest.getYear().intValue());
            dto.setMonth(i);
            dto.setCount(count);
            dto.setRefund(refund);
            list.add(dto);
        }
        ArrayList resultList = Lists.newArrayList();
        for (StatisticsByMonthResponse monthDto : list) {
            if (monthDto.getCount() == 0.0 && monthDto.getRefund() == 0.0) continue;
            resultList.add(monthDto);
        }
        Collections.sort(resultList, new Comparator<StatisticsByMonthResponse>(){

            @Override
            public int compare(StatisticsByMonthResponse o1, StatisticsByMonthResponse o2) {
                return o1.getMonth() < o2.getMonth() ? 1 : -1;
            }
        });
        return resultList;
    }

    @Override
    public SignupDetailResponse buildDetailList(OrgSingupInfoDto dto, long courseId) {
        SignupDetailResponse detailDto = new SignupDetailResponse();
        detailDto.setChinesePrice(dto.getChinesePrice());
        detailDto.setCourseInfos(dto.getCourseInfos());
        detailDto.setCreateTime(dto.getCreateTime());
        detailDto.setFeeItemDtos(dto.getFeeItemDtos());
        detailDto.setId(dto.getId());
        detailDto.setLastSendTime(dto.getLastSendTime());
        detailDto.setOperator(dto.getOperator());
        detailDto.setOrgId(dto.getOrgId());
        detailDto.setOrgLogoUrl(dto.getOrgLogoUrl());
        detailDto.setOrgName(dto.getOrgName());
        detailDto.setPayResult(dto.getPayResult());
        detailDto.setPayResultStr(dto.getPayResultStr());
        detailDto.setPayTypeStr(dto.getPayTypeStr());
        detailDto.setPayUrlWinxin(dto.getPayUrlWinxin());
        detailDto.setSignUpTime(dto.getSignUpTime());
        if (dto.getStatus() != 2) {
            detailDto.setPayTime(dto.getPayTime());
        }
        detailDto.setCascadeIdStr(dto.getCascadeIdStr());
        detailDto.setStudentName(dto.getStudentName());
        detailDto.setStudentMobile(dto.getStudentMobile());
        detailDto.setSignupPurchaseId(dto.getSignupPurchaseId());
        detailDto.setStatus(dto.getStatus());
        detailDto.setPayType(dto.getPayType());
        detailDto.setSourceType(dto.getSourceType());
        if (courseId == 0L) {
            detailDto.setSignupRefundDto(null);
            detailDto.setTotalRefundMoney(0.0);
            detailDto.setProfit(0.0);
            SignupCourseInfoDto c = new SignupCourseInfoDto();
            c.setCount(0);
            c.setOrgCourseName("");
            c.setOriginPrice(Double.valueOf(0.0));
            c.setPayPrice(dto.getTotalPrice());
            c.setPoundage(0.0);
            detailDto.setCourseInfo(c);
        } else {
            List refundDtoList = Lists.newArrayList();
            refundDtoList = this.orgSignupRefundDao.getOrgSignupRefundListByPurchaseId(dto.getOrgId(), dto.getSignupPurchaseId(), Long.valueOf(courseId));
            ArrayList<SignupRefundResponse> signupRefundDto = new ArrayList<SignupRefundResponse>();
            for (OrgSignupRefund o : refundDtoList) {
                SignupRefundResponse s = new SignupRefundResponse();
                s.setCourseId(o.getCourseId());
                s.setSignupPurchaseId(o.getSignupPurchaseId());
                s.setRefundMoney((double)o.getRefundPrice().longValue() / 100.0);
                s.setRefundTime(o.getCreateTime());
                s.setRemark(o.getRemark());
                s.setRefundType(o.getRefundType());
                signupRefundDto.add(s);
            }
            detailDto.setSignupRefundDto(signupRefundDto);
            for (SignupCourseInfoDto c : dto.getCourseInfos()) {
                if (c.getOrgCourseId() != courseId) continue;
                detailDto.setCourseInfo(c);
            }
            double totalRefundMoney = 0.0;
            for (SignupRefundResponse refund : detailDto.getSignupRefundDto()) {
                totalRefundMoney = ArithUtil.round((double)(totalRefundMoney + refund.getRefundMoney()), (int)2);
            }
            detailDto.setTotalRefundMoney(totalRefundMoney);
            double fee = 0.0;
            CoursePurchase coursePurchase = this.coursePurchaseDao.getByPurcahseIdCourse(detailDto.getSignupPurchaseId(), detailDto.getCourseInfo().getOrgCourseId());
            if (coursePurchase != null) {
                fee = coursePurchase.getPoundage();
            }
            detailDto.getCourseInfo().setPoundage(fee);
            double profit = ArithUtil.round((double)(detailDto.getCourseInfo().getPayPrice() - fee - detailDto.getTotalRefundMoney()), (int)2);
            detailDto.setProfit(profit);
        }
        return detailDto;
    }

    @Override
    public void refund(Long orgId, SignupRefundRequest signupRefundRequest) {
        int count = this.orgSignupRefundDao.getRefundTime(orgId, signupRefundRequest.getSignupPurchaseId(), signupRefundRequest.getCourseId());
        if (count < 5) {
            CoursePurchase coursePurchase = this.coursePurchaseDao.getByPurcahseIdCourse(signupRefundRequest.getSignupPurchaseId(), signupRefundRequest.getCourseId());
            OrgSignupCourse course = this.orgSignupCourseDao.getByCourseId(orgId, signupRefundRequest.getSignupPurchaseId(), signupRefundRequest.getCourseId());
            double fee = 0.0;
            if (coursePurchase != null) {
                fee = coursePurchase.getPoundage();
            }
            double price = 0.0;
            if (course != null) {
                price = (double)course.getPayPrice().longValue() / 100.0;
            }
            List refundDtoList = this.orgSignupRefundDao.getOrgSignupRefundListByPurchaseId(orgId, signupRefundRequest.getSignupPurchaseId(), signupRefundRequest.getCourseId());
            double totalRefundMoney = 0.0;
            for (OrgSignupRefund refund : refundDtoList) {
                totalRefundMoney = ArithUtil.round((double)(totalRefundMoney + (double)refund.getRefundPrice().longValue()), (int)2);
            }
            log.debug("****************fee={},price={},refund={}", new Object[]{fee, price, totalRefundMoney /= 100.0});
            if (!(signupRefundRequest.getRefundMoney() <= price - fee - totalRefundMoney)) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9000\u6b3e\u6570\u76ee\u4e0d\u5f97\u8d85\u8fc7\u5b9e\u6536\u51c0\u989d");
            }
        } else {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9000\u6b3e\u6b21\u6570\u4e0d\u5f97\u8d85\u8fc75\u6b21");
        }
        OrgSignupRefund poRefund = new OrgSignupRefund();
        poRefund.setCourseId(signupRefundRequest.getCourseId());
        poRefund.setCreateTime(new Date());
        poRefund.setOrgId(orgId);
        poRefund.setRefundPrice(Long.valueOf((long)(signupRefundRequest.getRefundMoney() * 100.0)));
        poRefund.setSignupPurchaseId(signupRefundRequest.getSignupPurchaseId());
        poRefund.setRemark(signupRefundRequest.getRemark() != null ? signupRefundRequest.getRemark() : "");
        poRefund.setRefundType(signupRefundRequest.getRefundType());
        this.orgSignupRefundDao.save((Object)poRefund, new String[0]);
    }

    @Override
    public void summaryExport(Integer orgId, SignupDateRequest signupDateRequest, HttpServletResponse response, List<OrgSingupInfoDto> resultList, SingupListRequestDto s) {
        List txSignupRecordDay = Lists.newArrayList();
        if (signupDateRequest.getDate() != null) {
            String sdate = signupDateRequest.getYear() + "-" + signupDateRequest.getMonth() + "-" + signupDateRequest.getDate();
            Date date = DateUtil.getDateByStr((String)sdate);
            txSignupRecordDay = this.txSignupRecordDayDao.getListByDate(orgId, date);
        } else {
            Date beginTime = DateUtil.getDateByYearMonth((int)signupDateRequest.getYear(), (int)signupDateRequest.getMonth());
            Date endTime = DateUtil.endDateByYearMonth((int)signupDateRequest.getYear(), (int)signupDateRequest.getMonth());
            txSignupRecordDay = this.txSignupRecordDayDao.getListByMonth(orgId.intValue(), beginTime, endTime);
        }
        SummaryExportDto signup = new SummaryExportDto();
        SummaryExportDto website = new SummaryExportDto();
        SummaryExportDto expond = new SummaryExportDto();
        int refundCount = 0;
        double refundMoney = 0.0;
        for (TxSignupRecordDay value : txSignupRecordDay) {
            if (value.getOpTo() == SignupAndRefund.SIGNUP.getCode()) {
                if (value.getOpType() == SignupSourceType.SIGNUP.getCode() || value.getOpType() == SignupSourceType.TX_SIANGUP.getCode()) {
                    signup.setCount(signup.getCount() + value.getOpCount());
                    signup.setCountPrice(ArithUtil.round((double)(signup.getCountPrice() + value.getOpPrice()), (int)2));
                    signup.setPoundage(ArithUtil.round((double)(signup.getPoundage() + value.getPoundage()), (int)2));
                    continue;
                }
                if (value.getOpType() == SignupSourceType.WANXIAO.getCode()) {
                    website.setCount(website.getCount() + value.getOpCount());
                    website.setCountPrice(ArithUtil.round((double)(website.getCountPrice() + value.getOpPrice()), (int)2));
                    website.setPoundage(ArithUtil.round((double)(website.getPoundage() + value.getPoundage()), (int)2));
                    continue;
                }
                if (value.getOpType() != SignupSourceType.TUIGUANG.getCode()) continue;
                expond.setCount(expond.getCount() + value.getOpCount());
                expond.setCountPrice(ArithUtil.round((double)(expond.getCountPrice() + value.getOpPrice()), (int)2));
                expond.setPoundage(ArithUtil.round((double)(expond.getPoundage() + value.getPoundage()), (int)2));
                continue;
            }
            if (value.getOpTo() != SignupAndRefund.REFUND.getCode()) continue;
            refundCount += value.getOpCount().intValue();
            refundMoney = ArithUtil.round((double)(refundMoney + value.getOpPrice()), (int)2);
        }
        signup.setProfit(ArithUtil.round((double)(signup.getCountPrice() - signup.getPoundage()), (int)2));
        website.setProfit(ArithUtil.round((double)(website.getCountPrice() - website.getPoundage()), (int)2));
        expond.setProfit(ArithUtil.round((double)(expond.getCountPrice() - expond.getPoundage()), (int)2));
        String[] header = new String[]{"\u4ea4\u6613\u8ba2\u5355\u603b\u7b14\u6570", "\u8ba2\u5355\u91d1\u989d\uff08\u5143\uff09", "\u5546\u5bb6\u5b9e\u6536\uff08\u5143\uff09", "\u670d\u52a1\u8d39\uff08\u5143\uff09", "\u5b9e\u6536\u51c0\u989d\uff08\u5143\uff09"};
        this.summaryExport(orgId, response, signup, website, expond, signupDateRequest, header, refundCount, refundMoney, resultList, s);
    }

    public void summaryExport(Integer orgId, HttpServletResponse response, SummaryExportDto signup, SummaryExportDto website, SummaryExportDto expond, SignupDateRequest s, String[] header, int refundCount, double refundMoney, List<OrgSingupInfoDto> resultList, SingupListRequestDto sdto) {
        SXSSFWorkbook wb = new SXSSFWorkbook();
        try {
            Sheet sheet = wb.createSheet("\u6c47\u603b");
            Row row0 = sheet.createRow(0);
            Cell cell00 = row0.createCell(0);
            cell00.setCellValue("#\u5929\u6821\u62a5\u540d\u6c47\u603b\u67e5\u8be2");
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId, new String[0]);
            OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
            Row row1 = sheet.createRow(1);
            Cell cell10 = row1.createCell(0);
            cell10.setCellValue("#\u8d26\u53f7:" + orgInfo.getShortName() + "(" + orgAccount.getNumber() + ")");
            Row row2 = sheet.createRow(2);
            Cell cell20 = row2.createCell(0);
            if (s.getDate() != null) {
                Date date = DateUtil.getDateByDay((int)s.getYear(), (int)s.getMonth(), (int)s.getDate());
                date = DateUtil.getEndOfDay((Date)date);
                if (new Date().getDate() == s.getDate().intValue()) {
                    cell20.setCellValue("#\u8d77\u59cb\u65e5\u671f\uff1a[" + s.getYear() + "\u5e74" + s.getMonth() + "\u6708" + s.getDate() + "\u65e5 00:00:00]   \u7ec8\u6b62\u65e5\u671f\uff1a[" + DateUtil.getStrByDateFormate((Date)new Date(), (String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss") + "]");
                } else {
                    cell20.setCellValue("#\u8d77\u59cb\u65e5\u671f\uff1a[" + s.getYear() + "\u5e74" + s.getMonth() + "\u6708" + s.getDate() + "\u65e5 00:00:00]   \u7ec8\u6b62\u65e5\u671f\uff1a[" + DateUtil.getAllDayStr((Date)date) + "]");
                }
            } else {
                Date startDate = DateUtil.getDateByYearMonth((int)s.getYear(), (int)s.getMonth());
                Date endDate = DateUtil.endDateByYearMonth((int)s.getYear(), (int)s.getMonth());
                startDate = DateUtil.getStartOfDay((Date)startDate);
                endDate = DateUtil.getEndOfDay((Date)endDate);
                if (DateUtil.getThisMonth() == s.getMonth()) {
                    cell20.setCellValue("#\u8d77\u59cb\u65e5\u671f\uff1a[" + s.getYear() + "\u5e74" + s.getMonth() + "\u67081\u65e5 00:00:00]   \u7ec8\u6b62\u65e5\u671f\uff1a[" + DateUtil.getStrByDateFormate((Date)new Date(), (String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss") + "]");
                } else {
                    cell20.setCellValue("#\u8d77\u59cb\u65e5\u671f\uff1a[" + DateUtil.getAllDayStr((Date)startDate) + "]  \u7ec8\u6b62\u65e5\u671f\uff1a[" + DateUtil.getAllDayStr((Date)endDate) + "]");
                }
            }
            Row row3 = sheet.createRow(3);
            Cell cell30 = row3.createCell(0);
            cell30.setCellValue("#-----------------------------------------\u4e1a\u52a1\u6c47\u603b\u5217\u8868----------------------------------------");
            Row row4 = sheet.createRow(4);
            for (int j = 1; j < 6; ++j) {
                Cell cellTitle = row4.createCell(j);
                cellTitle.setCellValue(header[j - 1]);
            }
            Row row5 = sheet.createRow(5);
            this.setColumnWidth(row5, 5);
            row5.createCell(0).setCellValue("\u62a5\u540d\u6536\u6b3e");
            row5.createCell(1).setCellValue((double)signup.getCount());
            row5.createCell(2).setCellValue(NumberUtil.get2FromDouble((double)signup.getCountPrice()));
            row5.createCell(3).setCellValue(NumberUtil.get2FromDouble((double)signup.getCountPrice()));
            row5.createCell(4).setCellValue(NumberUtil.get2FromDouble((double)signup.getPoundage()));
            row5.createCell(5).setCellValue(NumberUtil.get2FromDouble((double)signup.getProfit()));
            Row row6 = sheet.createRow(6);
            this.setColumnWidth(row6, 5);
            row6.createCell(0).setCellValue("\u5fae\u5b98\u7f51\u62a5\u540d");
            row6.createCell(1).setCellValue((double)website.getCount());
            row6.createCell(2).setCellValue(NumberUtil.get2FromDouble((double)website.getCountPrice()));
            row6.createCell(3).setCellValue(NumberUtil.get2FromDouble((double)website.getCountPrice()));
            row6.createCell(4).setCellValue(NumberUtil.get2FromDouble((double)website.getPoundage()));
            row6.createCell(5).setCellValue(NumberUtil.get2FromDouble((double)website.getProfit()));
            Row row7 = sheet.createRow(7);
            this.setColumnWidth(row7, 5);
            row7.createCell(0).setCellValue("\u63a8\u5e7f\u62a5\u540d");
            row7.createCell(1).setCellValue((double)expond.getCount());
            row7.createCell(2).setCellValue(NumberUtil.get2FromDouble((double)expond.getCountPrice()));
            row7.createCell(3).setCellValue(NumberUtil.get2FromDouble((double)expond.getCountPrice()));
            row7.createCell(4).setCellValue(NumberUtil.get2FromDouble((double)expond.getPoundage()));
            row7.createCell(5).setCellValue(NumberUtil.get2FromDouble((double)expond.getProfit()));
            Row row8 = sheet.createRow(8);
            this.setColumnWidth(row8, 5);
            row8.createCell(0).setCellValue("\u5408\u8ba1");
            row8.createCell(1).setCellValue((double)(signup.getCount() + website.getCount() + expond.getCount()));
            row8.createCell(2).setCellValue(NumberUtil.get2FromDouble((double)(signup.getCountPrice() + website.getCountPrice() + expond.getCountPrice())));
            row8.createCell(3).setCellValue(NumberUtil.get2FromDouble((double)(signup.getCountPrice() + website.getCountPrice() + expond.getCountPrice())));
            row8.createCell(4).setCellValue(NumberUtil.get2FromDouble((double)(signup.getPoundage() + website.getPoundage() + expond.getPoundage())));
            row8.createCell(5).setCellValue(NumberUtil.get2FromDouble((double)(signup.getProfit() + website.getProfit() + expond.getProfit())));
            Row row9 = sheet.createRow(9);
            row9.createCell(1).setCellValue("\u9000\u6b3e\u8ba2\u5355\u603b\u7b14\u6570");
            row9.createCell(2).setCellValue("\u9000\u6b3e\u91d1\u989d\uff08\u5143\uff09");
            Row row10 = sheet.createRow(10);
            row10.createCell(0).setCellValue("\u9000\u6b3e");
            row10.createCell(1).setCellValue((double)refundCount);
            row10.createCell(2).setCellValue(refundMoney);
            Row row11 = sheet.createRow(11);
            row11.createCell(0).setCellValue("\u5408\u8ba1");
            row11.createCell(1).setCellValue((double)refundCount);
            row11.createCell(2).setCellValue(refundMoney);
            Row row12 = sheet.createRow(12);
            Cell cell120 = row12.createCell(0);
            cell120.setCellValue("#----------------------------------------\u4e1a\u52a1\u6c47\u603b\u5217\u8868\u7ed3\u675f-------------------------------------");
            Row row13 = sheet.createRow(13);
            Cell cell130 = row13.createCell(0);
            cell130.setCellValue("#\u5bfc\u51fa\u65f6\u95f4\uff1a[" + DateUtil.getStrByDateFormate((Date)new Date(), (String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss") + "]");
            this.detailExport((Workbook)wb, orgId, response, sdto, resultList, s, refundCount, refundMoney);
        }
        catch (Exception e) {
            throw new RuntimeException("export data error", e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)wb);
        }
    }

    public void detailExport(Workbook wb, Integer orgId, HttpServletResponse response, SingupListRequestDto s, List<OrgSingupInfoDto> resultList, SignupDateRequest s2, int refundCount, double refund) {
        String[] header = new String[]{"\u8ba2\u5355\u53f7", "\u6458\u8981", "\u521b\u5efa\u65f6\u95f4", "\u652f\u4ed8\u65f6\u95f4", "\u5355\u4ef7", "\u6570\u91cf", "\u4f18\u60e0\u91d1\u989d", "\u5b9e\u6536\u6b3e\uff08\u5143\uff09", "\u7d2f\u8ba1\u9000\u6b3e\u91d1\u989d", "\u624b\u7eed\u8d39", "\u5b9e\u6536\u51c0\u989d", "\u5b66\u5458", "\u8ba2\u5355\u72b6\u6001", "\u652f\u4ed8\u65b9\u5f0f", "\u8ba2\u5355\u6765\u6e90", "\u6536\u6b3e\u4eba"};
        String fileName = "\u5929\u6821\u62a5\u540d\u8bb0\u5f55.xlsx";
        try {
            Sheet sheet = wb.createSheet("\u660e\u7ec6");
            Row row0 = sheet.createRow(0);
            Cell cell00 = row0.createCell(0);
            cell00.setCellValue("#\u5929\u6821\u4e1a\u52a1\u660e\u7ec6\u67e5\u8be2");
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId, new String[0]);
            OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
            Row row1 = sheet.createRow(1);
            Cell cell10 = row1.createCell(0);
            cell10.setCellValue("#\u8d26\u53f7:" + orgInfo.getShortName() + "(" + orgAccount.getNumber() + ")");
            Row row2 = sheet.createRow(2);
            Cell cell20 = row2.createCell(0);
            if (s2.getDate() != null) {
                Date date = DateUtil.getDateByDay((int)s2.getYear(), (int)s2.getMonth(), (int)s2.getDate());
                date = DateUtil.getEndOfDay((Date)date);
                if (new Date().getDate() == s2.getDate().intValue()) {
                    cell20.setCellValue("#\u8d77\u59cb\u65e5\u671f\uff1a[" + s2.getYear() + "\u5e74" + s2.getMonth() + "\u6708" + s2.getDate() + "\u65e5 00:00:00]   \u7ec8\u6b62\u65e5\u671f\uff1a[" + DateUtil.getStrByDateFormate((Date)new Date(), (String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss") + "]");
                } else {
                    cell20.setCellValue("#\u8d77\u59cb\u65e5\u671f\uff1a[" + s2.getYear() + "\u5e74" + s2.getMonth() + "\u6708" + s2.getDate() + "\u65e5 00:00:00]   \u7ec8\u6b62\u65e5\u671f\uff1a[" + DateUtil.getAllDayStr((Date)date) + "]");
                }
            } else if (DateUtil.getThisMonth() == s2.getMonth()) {
                cell20.setCellValue("#\u8d77\u59cb\u65e5\u671f\uff1a[" + s2.getYear() + "\u5e74" + s2.getMonth() + "\u67081\u65e5 00:00:00]   \u7ec8\u6b62\u65e5\u671f\uff1a[" + DateUtil.getStrByDateFormate((Date)new Date(), (String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss") + "]");
            } else {
                cell20.setCellValue("#\u8d77\u59cb\u65e5\u671f\uff1a[" + DateUtil.getStrByDateFormate((Date)s.getStartTime(), (String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss") + "]   \u7ec8\u6b62\u65e5\u671f\uff1a[" + DateUtil.getStrByDateFormate((Date)s.getEndTime(), (String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss") + "]");
            }
            Row row3 = sheet.createRow(3);
            Cell cell30 = row3.createCell(0);
            cell30.setCellValue("#-----------------------------------------\u4e1a\u52a1\u6c47\u603b\u5217\u8868----------------------------------------");
            Row row4 = sheet.createRow(4);
            for (int i = 0; i < header.length; ++i) {
                Cell cellTitle = row4.createCell(i);
                cellTitle.setCellValue(header[i]);
            }
            int rowNumber = 5;
            int index = 0;
            double pay = 0.0;
            int count = 0;
            for (OrgSingupInfoDto sdr : resultList) {
                for (SignupCourseInfoDto c : sdr.getCourseInfos()) {
                    Row row = sheet.createRow(rowNumber++);
                    ++count;
                    row.getSheet().setColumnWidth(0, 5120);
                    row.getSheet().setColumnWidth(1, 5120);
                    row.getSheet().setColumnWidth(2, 6400);
                    row.getSheet().setColumnWidth(3, 6400);
                    row.getSheet().setColumnWidth(11, 5120);
                    row.createCell(index++ % header.length).setCellValue(String.valueOf(sdr.getSignupPurchaseId()));
                    row.createCell(index++ % header.length).setCellValue(c.getOrgCourseName());
                    row.createCell(index++ % header.length).setCellValue(DateUtil.getStrByDateFormate((Date)sdr.getSignUpTime(), (String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss"));
                    row.createCell(index++ % header.length).setCellValue(DateUtil.getStrByDateFormate((Date)sdr.getPayTime(), (String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss"));
                    row.createCell(index++ % header.length).setCellValue(c.getOriginPrice().doubleValue());
                    row.createCell(index++ % header.length).setCellValue((double)c.getCount());
                    row.createCell(index++ % header.length).setCellValue(c.getPreferential());
                    row.createCell(index++ % header.length).setCellValue(c.getPayPrice().doubleValue());
                    row.createCell(index++ % header.length).setCellValue(c.getTotalRefundMoney());
                    row.createCell(index++ % header.length).setCellValue(c.getPoundage());
                    row.createCell(index++ % header.length).setCellValue(c.getProfit());
                    String string = sdr.getStudentName() + "(" + sdr.getStudentMobile() + ")";
                    row.createCell(index++ % header.length).setCellValue(string);
                    int status = sdr.getStatus();
                    if (status == SignupStatus.ALL.getCode()) {
                        row.createCell(index++ % header.length).setCellValue("\u5168\u90e8");
                    } else if (status == SignupStatus.FINISHED.getCode()) {
                        row.createCell(index++ % header.length).setCellValue("\u5df2\u5b8c\u6210");
                    } else if (status == SignupStatus.NOT_PAY.getCode()) {
                        row.createCell(index++ % header.length).setCellValue("\u5f85\u6536\u6b3e");
                    } else if (status == SignupStatus.NOT_SIGN.getCode()) {
                        row.createCell(index++ % header.length).setCellValue("\u5f85\u62a5\u540d");
                    }
                    row.createCell(index++ % header.length).setCellValue(sdr.getPayTypeStr());
                    int source = sdr.getSourceType();
                    if (source == SignupSourceType.SIGNUP.getCode() || source == SignupSourceType.TX_SIANGUP.getCode()) {
                        row.createCell(index++ % header.length).setCellValue("\u62a5\u540d\u6536\u6b3e");
                    } else if (source == SignupSourceType.TUIGUANG.getCode()) {
                        row.createCell(index++ % header.length).setCellValue("\u63a8\u5e7f");
                    } else if (source == SignupSourceType.WANXIAO.getCode()) {
                        row.createCell(index++ % header.length).setCellValue("\u5fae\u5b98\u7f51");
                    }
                    row.createCell(index++ % header.length).setCellValue(sdr.getCascadeIdStr());
                    pay += c.getPayPrice().doubleValue();
                }
            }
            sheet.createRow(rowNumber++).createCell(0).setCellValue("#----------------------------------------\u4e1a\u52a1\u6c47\u603b\u5217\u8868\u7ed3\u675f-------------------------------------");
            String payStr = "#\u4ea4\u6613\u5408\u8ba1\uff1a" + count + "\u7b14\uff0c\u4ea4\u6613\u91d1\u989d\u5171" + NumberUtil.get2FromDouble((double)pay) + "\u5143";
            sheet.createRow(rowNumber++).createCell(0).setCellValue(payStr);
            String refundStr = "#\u9000\u6b3e\u5408\u8ba1\uff1a" + refundCount + "\u7b14\uff0c\u4ea4\u6613\u9000\u6b3e\u91d1\u989d\u5171" + refund + "\u5143";
            sheet.createRow(rowNumber++).createCell(0).setCellValue(refundStr);
            sheet.createRow(rowNumber++).createCell(0).setCellValue("#\u5bfc\u51fa\u65f6\u95f4\uff1a[" + DateUtil.getStrByDateFormate((Date)new Date(), (String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss") + "]");
            SignupRecordServiceImpl.exportExcel(response, wb, fileName);
        }
        catch (Exception e) {
            throw new RuntimeException("export data error", e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)wb);
        }
    }

    public static void exportExcel(HttpServletResponse response, Workbook workBook, String excelFileName) {
        if (StringUtils.isBlank((CharSequence)excelFileName)) {
            excelFileName = System.currentTimeMillis() + ".xlsx";
        }
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(excelFileName, "utf-8"));
        }
        catch (UnsupportedEncodingException e1) {
            response.setHeader("Content-Disposition", "attachment; filename=" + excelFileName);
        }
        try {
            workBook.write((OutputStream)response.getOutputStream());
            response.getOutputStream().flush();
        }
        catch (IOException e) {
            log.error("export data catch error:", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u51fa\u6570\u636e\u5904\u7406\u5931\u8d25");
        }
    }

    @Override
    public List<OrgSingupInfoDto> addInfo(List<OrgSingupInfoDto> list) {
        HashSet purchaseIds = Sets.newHashSet();
        for (OrgSingupInfoDto o : list) {
            purchaseIds.add(o.getSignupPurchaseId());
        }
        Map refundMap = Maps.newHashMap();
        Map coursePurchaseMap = Maps.newHashMap();
        Map coursePurchaseMap1 = Maps.newHashMap();
        if (purchaseIds != null && purchaseIds.size() > 0) {
            List refundDtoList = this.orgSignupRefundDao.getByPurcahseIds((Set)purchaseIds);
            List coursePurchaseList = this.coursePurchaseDao.getByPurcahseIds((Set)purchaseIds);
            refundMap = CollectorUtil.group((Collection)refundDtoList, (Function)new Function<OrgSignupRefund, String>(){

                public String apply(OrgSignupRefund input) {
                    return input.getSignupPurchaseId() + "" + input.getCourseId();
                }
            });
            coursePurchaseMap = CollectorUtil.collectMap((Collection)coursePurchaseList, (Function)new Function<CoursePurchase, String>(){

                public String apply(CoursePurchase input) {
                    return input.getPurchaseId() + "" + input.getCourseId();
                }
            });
            coursePurchaseMap1 = CollectorUtil.collectMap((Collection)coursePurchaseList, (Function)new Function<CoursePurchase, String>(){

                public String apply(CoursePurchase input) {
                    return input.getParentPurchaseId() + "" + input.getCourseId();
                }
            });
            coursePurchaseMap.putAll(coursePurchaseMap1);
        }
        for (OrgSingupInfoDto o : list) {
            if (o.getCourseInfos().size() <= 0) continue;
            for (SignupCourseInfoDto c : o.getCourseInfos()) {
                CoursePurchase cp = (CoursePurchase)coursePurchaseMap.get(o.getSignupPurchaseId() + "" + c.getOrgCourseId());
                List osr = (List)refundMap.get(o.getSignupPurchaseId() + "" + c.getOrgCourseId());
                List refundDtoList = Lists.newArrayList();
                ArrayList<SignupRefundResponse> signupRefundDto = new ArrayList<SignupRefundResponse>();
                if (osr != null) {
                    refundDtoList = osr;
                    for (OrgSignupRefund renfund : refundDtoList) {
                        SignupRefundResponse s = new SignupRefundResponse();
                        s.setCourseId(renfund.getCourseId());
                        s.setSignupPurchaseId(o.getSignupPurchaseId());
                        s.setRefundMoney((double)renfund.getRefundPrice().longValue() / 100.0);
                        s.setRefundTime(renfund.getCreateTime());
                        s.setRemark(renfund.getRemark());
                        signupRefundDto.add(s);
                    }
                }
                c.setSignupRefundDto(signupRefundDto);
                double totalRefundMoney = 0.0;
                for (SignupRefundResponse refund : c.getSignupRefundDto()) {
                    totalRefundMoney = ArithUtil.round((double)(totalRefundMoney + refund.getRefundMoney()), (int)2);
                }
                c.setTotalRefundMoney(totalRefundMoney);
                double fee = 0.0;
                if (cp != null && c.getOrgCourseId().longValue() == cp.getCourseId().longValue()) {
                    fee = cp.getPoundage();
                }
                c.setPoundage(fee);
                double profit = ArithUtil.round((double)(c.getPayPrice() - fee - c.getTotalRefundMoney()), (int)2);
                c.setProfit(profit);
            }
        }
        return list;
    }

    private void setColumnWidth(Row row, int length) {
        for (int i = 0; i <= length; ++i) {
            row.getSheet().setColumnWidth(i, 5120);
        }
    }
}

