/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.service.ErpStudentService;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.signup.constant.SignupType;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.solr.dto.StudentDto;
import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.StudentDao;
import com.baijia.tianxiao.dal.user.po.Student;
import com.baijia.tianxiao.dto.PersonBaseDto;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.baijia.tianxiao.sal.common.api.StudentKexiaoStatisticsApiService;
import com.baijia.tianxiao.sal.common.dto.KexiaoStatisticsSuper;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.OrgLessonSignService;
import com.baijia.tianxiao.sal.course.util.StudentNameUtil;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.signup.dto.SignupCourseInfoDto;
import com.baijia.tianxiao.sal.signup.dto.request.FillCourseInfoRequestDto;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.dto.request.StudentListRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentInfoListReponseDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentInfoReponseDto;
import com.baijia.tianxiao.sal.student.enums.StudentErrorCode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.HanZiPinYinUtils;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ErpStudentServiceImpl
implements ErpStudentService {
    private static final Logger log = LoggerFactory.getLogger(ErpStudentServiceImpl.class);
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private SignupService signupService;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private CourseStudentService courseStudentService;
    @Resource
    private OrgStudentService orgStudentService;
    @Resource
    private OrgLessonSignService orgLessonSignService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Resource
    private StudentDao studentDao;
    @Resource
    private StorageDao storageDao;
    @Resource
    private OrgLessonSignDao orgLessonSignDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgStudentApiService studentApiService;
    @Resource
    private TxCascadeCredentialService txCascadeCredentialService;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;
    @Resource
    private StudentKexiaoStatisticsApiService studentKexiaoStatisticsApiService;

    @Override
    public StudentInfoListReponseDto getStudentListWithAttendanceRate(StudentListRequestDto studentListRequestDto, Long orgId, PageDto pageDto) {
        TXCascadeAccount txCascadeAccount;
        boolean needFilter = false;
        List tempcourseIds = null;
        List tempstudentIds = null;
        if (TianxiaoMContext.getTXCascadeId() != null && (txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)TianxiaoMContext.getTXCascadeId(), new String[0])).getAccountType().intValue() == CascadeType.STAFF.getValue()) {
            tempcourseIds = this.orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId(), null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
            tempstudentIds = this.orgStudentService.getStudentidsByCourseIds(orgId, tempcourseIds);
            if (CollectionUtils.isEmpty((Collection)tempstudentIds)) {
                return new StudentInfoListReponseDto();
            }
            needFilter = true;
        }
        log.debug("tempcourseIds={}", tempcourseIds);
        log.debug("tempstudentIds={}", tempstudentIds);
        StudentInfoListReponseDto studentInfoListReponseDto = null;
        studentInfoListReponseDto = needFilter ? this.orgStudentService.getStudentList(studentListRequestDto, tempstudentIds, orgId, pageDto) : this.orgStudentService.getStudentList(studentListRequestDto, orgId, pageDto);
        log.debug("studentInfoListReponseDto={}", (Object)studentInfoListReponseDto);
        ArrayList studentIds = Lists.newArrayList();
        for (StudentInfoReponseDto stu : studentInfoListReponseDto.getList()) {
            studentIds.add(stu.getStudentId());
        }
        Map map = this.orgLessonSignService.getAttendanceRateOfStudents(orgId, (Collection)studentIds);
        log.debug("map={}", (Object)map);
        Iterator iterator = studentInfoListReponseDto.getList().iterator();
        while (iterator.hasNext()) {
            StudentInfoReponseDto stu;
            Double rate = (Double)map.get((stu = (StudentInfoReponseDto)iterator.next()).getStudentId());
            stu.setAttendanceRate(Double.valueOf(rate == null ? 0.0 : rate));
        }
        return studentInfoListReponseDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrgCourseStudent(Long orgId, Long courseId, Collection<Long> studentIds, Collection<Header> headers, boolean doSignup) {
        if (CollectionUtils.isEmpty(studentIds)) {
            log.info("studentIds is empty");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751fID\u4e3a\u7a7a");
        }
        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(courseId, new String[0]);
        if (orgCourse == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u73ed\u7ea7\u4e0d\u5b58\u5728");
        }
        if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "1\u5bf91\u8bfe\u7a0b\u4e0d\u80fd\u6dfb\u52a0\u5b66\u751f");
        }
        List orgStudents = this.orgStudentDao.getStudentByIds(orgId, studentIds, new String[0]);
        for (OrgStudent orgStudent : orgStudents) {
            OrgStudentCourse osc = this.orgStudentCourseDao.getStudentCourse(orgId, courseId, orgStudent.getUserId());
            if (osc == null) {
                OrgStudentCourse orgStudentCourse = new OrgStudentCourse();
                this.buildOrgStudentCourse(orgStudentCourse, orgStudent, courseId);
                orgStudentCourse.setStatus(Integer.valueOf(StudentCourseStatus.NORMAL.getCode()));
                this.orgStudentCourseDao.save((Object)orgStudentCourse, new String[0]);
                if (!doSignup) continue;
                this.signUp(orgId, orgCourse, orgStudent.getId());
                continue;
            }
            osc.setStatus(Integer.valueOf(StudentCourseStatus.NORMAL.getCode()));
            this.orgStudentCourseDao.update((Object)osc, new String[]{"status"});
            if (!doSignup) continue;
            this.signUp(orgId, orgCourse, orgStudent.getId());
        }
    }

    private void signUp(Long orgId, OrgCourse orgCourse, Long studentId) {
        ArrayList courseInfos = Lists.newArrayList();
        FillCourseInfoRequestDto signUpDto = new FillCourseInfoRequestDto();
        SignupCourseInfoDto courseInfo = new SignupCourseInfoDto();
        courseInfo.setCount(1);
        courseInfo.setDiscount(100);
        courseInfo.setOrgCourseName(orgCourse.getName());
        courseInfo.setOrgCourseId(orgCourse.getId());
        courseInfo.setOrgCourseNumber(orgCourse.getNumber());
        courseInfo.setOriginPrice(orgCourse.getPrice());
        courseInfo.setPayPrice(orgCourse.getPrice());
        courseInfo.setPreferential(0.0);
        courseInfos.add(courseInfo);
        signUpDto.setCourseInfos((List)courseInfos);
        signUpDto.setOrgId(orgId);
        signUpDto.setSignupType(SignupType.FRONTED.getCode());
        OrgStudent student = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
        if (student == null || student.getDelStatus().intValue() != DeleteStatus.NORMAL.getValue()) {
            log.warn("student = null, orgId = {}, studentId = {}", (Object)orgId, (Object)studentId);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "studentId = " + studentId + " not found!");
        }
        signUpDto.setStudentMobile(student.getMobile());
        signUpDto.setStudentName(StudentNameUtil.buildStudentName((OrgStudent)student));
        log.debug("signUpDto = {}", (Object)signUpDto);
        this.signupService.signUp(signUpDto);
    }

    private void buildOrgStudentCourse(OrgStudentCourse orgStudentCourse, OrgStudent ttsStudent, @NonNull Long courseId) {
        if (courseId == null) {
            throw new NullPointerException("courseId");
        }
        orgStudentCourse.setCourseId(courseId);
        orgStudentCourse.setRealCourseId(courseId);
        orgStudentCourse.setOrgId(ttsStudent.getOrgId());
        orgStudentCourse.setUserId(ttsStudent.getUserId());
        orgStudentCourse.setStudentMobile(MaskUtil.maskMobile((String)ttsStudent.getMobile()));
        if (StringUtils.isEmpty((String)ttsStudent.getName())) {
            orgStudentCourse.setStudentName("");
        } else {
            orgStudentCourse.setStudentName(ttsStudent.getName());
        }
        orgStudentCourse.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        orgStudentCourse.setRealCourseId(courseId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void transferOrgCourseStudent(@NonNull Long orgId, @NonNull Long studentId, @NonNull Long fromCourseId, @NonNull Long toCourseId, String cause, @NonNull Collection<Header> headers) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (studentId == null) {
            throw new NullPointerException("studentId");
        }
        if (fromCourseId == null) {
            throw new NullPointerException("fromCourseId");
        }
        if (toCourseId == null) {
            throw new NullPointerException("toCourseId");
        }
        if (headers == null) {
            throw new NullPointerException("headers");
        }
        this.courseStudentService.transferOrgCourseStudent(orgId, studentId, fromCourseId, toCourseId, cause);
        ArrayList studentIds = Lists.newArrayList();
        studentIds.add(studentId);
        this.addOrgCourseStudent(orgId, toCourseId, studentIds, headers, false);
    }

    @Override
    @Transactional(readOnly=true)
    public List<PersonBaseDto> searchOrgStudents(Long orgId, Integer studentStatus, Long courseNumber, String searchKey, PageDto page) throws Exception {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        if (account == null) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.ORG_NOT_EXIST);
        }
        StudentListRequestDto studentListRequestDto = new StudentListRequestDto();
        studentListRequestDto.setStudentStatus(studentStatus);
        studentListRequestDto.setSearchKey(searchKey);
        studentListRequestDto.setNeedClassInfo(false);
        List searchStudentList = this.orgStudentService.searchStudentList(studentListRequestDto, orgId, page);
        log.info("searchStudentList is:{} ", (Object)searchStudentList);
        HashMap studentStatusMap = Maps.newHashMap();
        HashMap KexiaoStatisticsSupers = Maps.newHashMap();
        ArrayList students = Lists.newArrayList();
        for (StudentDto sd : searchStudentList) {
            OrgStudent os = new OrgStudent();
            os.setId(sd.getStudentId());
            os.setWeixin(sd.getWeixin());
            os.setUserId(sd.getUserId());
            os.setAvatar(sd.getAvatar());
            os.setLessonStatus(sd.getStuLessonStatus());
            os.setName(sd.getName());
            os.setMobile(sd.getMobile());
            studentStatusMap.put(sd.getUserId(), 0);
            students.add(os);
        }
        OrgCourse byCourseNumber = null;
        if (GenericsUtils.notNullAndEmpty((Object)searchStudentList) && courseNumber != null) {
            List userIds = ListUtil.toKeyList((Collection)searchStudentList, (String)"userId", StudentDto.class);
            byCourseNumber = this.orgCourseDao.getByCourseNumber(courseNumber, new String[]{"id", "chargeUnit"});
            Long courseId = byCourseNumber.getId();
            ArrayList kexiaoSupers = Lists.newArrayList();
            for (Long userId : userIds) {
                KexiaoStatisticsSuper kss = KexiaoStatisticsSuper.newInstanceWithUserId();
                kss.setUserId(userId);
                kss.setCourseId(courseId);
                kexiaoSupers.add(kss);
                KexiaoStatisticsSupers.put(userId, kss);
            }
            this.studentKexiaoStatisticsApiService.fillStudentKeXiaoStatistics(orgId, (Collection)kexiaoSupers, Integer.valueOf(3));
            for (KexiaoStatisticsSuper kss : kexiaoSupers) {
                Long userId = kss.getUserId();
                boolean hasSignupRecord = kss.isHasSignupCourseRecord();
                Integer leftClassTimes = kss.getLeftClassTimesForKexiaoValue();
                Integer totalClassTimes = kss.getTotalClassTimesForKexiaoValue();
                if (!hasSignupRecord) {
                    studentStatusMap.put(userId, 0);
                    continue;
                }
                if (leftClassTimes == null || totalClassTimes == null) continue;
                if (leftClassTimes < totalClassTimes) {
                    studentStatusMap.put(userId, 1);
                    continue;
                }
                studentStatusMap.put(userId, 2);
            }
        }
        Integer chargeUnit = ChargeUnit.BY_TIMES.getCode();
        if (byCourseNumber != null) {
            chargeUnit = byCourseNumber.getChargeUnit();
        }
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)students)) {
            boolean isShowMobile = this.txCascadeCredentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
            Map avatarMap = this.studentApiService.batchGetStudentAvatarUrl((Collection)students);
            for (OrgStudent orgStudent : students) {
                PersonBaseDto dto = new PersonBaseDto();
                dto.setId(orgStudent.getId());
                dto.setName(orgStudent.getName());
                dto.setPinyinName(HanZiPinYinUtils.getLowerCasePinYin((String)orgStudent.getName()));
                dto.setAvatarUrl((String)avatarMap.get(orgStudent.getId()));
                if (!isShowMobile) {
                    dto.setMobile(MaskUtil.maskMobile((String)dto.getMobile()));
                } else {
                    dto.setMobile(orgStudent.getMobile());
                }
                dto.setStudentClassStatus((Integer)studentStatusMap.get(orgStudent.getUserId()));
                KexiaoStatisticsSuper kexiaoStatisticsSuper = (KexiaoStatisticsSuper)KexiaoStatisticsSupers.get(orgStudent.getUserId());
                dto.setChargeUnit(chargeUnit);
                if (kexiaoStatisticsSuper != null) {
                    dto.setFinishClassHourForKexiao(kexiaoStatisticsSuper.getFinishClassTimesForKexiao());
                    dto.setTotalClassHourForKexiao(kexiaoStatisticsSuper.getTotalClassTimesForKexiao());
                } else {
                    String showZero = "0";
                    if (chargeUnit == null || chargeUnit.intValue() == ChargeUnit.BY_OTHER.getCode()) {
                        showZero = "--";
                    } else if (ChargeUnit.isByTime((int)chargeUnit)) {
                        showZero = "0.0";
                    }
                    dto.setFinishClassHourForKexiao(showZero);
                    dto.setTotalClassHourForKexiao(showZero);
                }
                list.add(dto);
            }
        }
        return list;
    }

    public void setStudentLessonStatus(Integer lessonStatus, PersonBaseDto dto) {
        if (lessonStatus == null) {
            lessonStatus = StudentLessonStatus.NOT_ENROLL.getStatus();
        }
        if (StudentLessonStatus.NOT_ENROLL.getStatus() == lessonStatus.intValue()) {
            dto.setStudentClassStatus(Integer.valueOf(0));
        } else if (StudentLessonStatus.STUDYING.getStatus() == lessonStatus.intValue() || StudentLessonStatus.TO_CHARGE.getStatus() == lessonStatus.intValue()) {
            dto.setStudentClassStatus(Integer.valueOf(1));
        } else if (StudentLessonStatus.PAST.getStatus() == lessonStatus.intValue()) {
            dto.setStudentClassStatus(Integer.valueOf(2));
        } else {
            dto.setStudentClassStatus(Integer.valueOf(0));
        }
    }

    private Map<Long, String> getAndCacheStudentAvatar(Collection<Long> usrIds) {
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isEmpty(usrIds)) {
            return map;
        }
        List students = this.studentDao.getByUserIds(usrIds, new String[]{"userId", "avatar"});
        HashMap userIdStorageIdMap = Maps.newHashMap();
        HashSet avatarIds = Sets.newHashSet();
        for (Student student : students) {
            if (student.getAvatar() != null) {
                avatarIds.add(student.getAvatar());
            }
            userIdStorageIdMap.put(student.getUserId(), student.getAvatar());
        }
        HashMap storageIdUrlMap = Maps.newHashMap();
        List storages = this.storageDao.getByIds((Collection)avatarIds, new String[0]);
        for (Storage storage : storages) {
            storageIdUrlMap.put(storage.getId(), StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn()));
        }
        for (Student student : students) {
            if (student.getAvatar() == null) continue;
            map.put(student.getUserId(), storageIdUrlMap.get(((Integer)userIdStorageIdMap.get(student.getUserId())).longValue()));
        }
        return map;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveCourseStudents(Long orgId, Long courseId, Collection<Long> studentIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        ArrayList studentUserIds = Lists.newArrayList();
        Map userIdAndIdMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(studentIds)) {
            userIdAndIdMap = this.orgStudentDao.getStudentUserIdAndIdMap(studentIds);
            studentUserIds.addAll(userIdAndIdMap.keySet());
        }
        Set<Object> existStudents = Sets.newHashSet();
        List courseStudents = this.orgStudentCourseDao.getStudentListByCourseId(orgId, courseId, new String[0]);
        for (OrgStudentCourse orgStudentCourse : courseStudents) {
            if (orgStudentCourse.getStatus() != 0) continue;
            existStudents.add(orgStudentCourse.getUserId());
        }
        Map existStudentMap = this.orgStudentDao.getUserIdStudentIdMap((Collection)existStudents, orgId, true);
        existStudents = existStudentMap.keySet();
        HashSet tempStudents = Sets.newHashSet((Iterable)existStudents);
        HashSet toDelStudents = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty((Collection)studentUserIds)) {
            tempStudents.removeAll(studentUserIds);
        }
        toDelStudents.addAll(tempStudents);
        List lessonStudents = this.orgStudentLessonDao.getOrgStudentLessonsByCourseIds(Arrays.asList(courseId));
        Set arrangeStudents = BaseUtils.getPropertiesList((List)lessonStudents, (String)"userId");
        for (Long studentId : toDelStudents) {
            if (!arrangeStudents.contains(studentId)) continue;
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5df2\u6392\u8bfe\u7684\u5b66\u751f\u65e0\u6cd5\u5220\u9664");
        }
        if (CollectionUtils.isNotEmpty((Collection)toDelStudents)) {
            this.orgStudentCourseDao.batchDeleteOrgCourseStudent(orgId, courseId, (Collection)toDelStudents, Integer.valueOf(StudentCourseStatus.WITHDRAW.getCode()));
        }
        studentUserIds.removeAll(existStudents);
        if (CollectionUtils.isNotEmpty((Collection)studentUserIds)) {
            HashSet toAddStudents = Sets.newHashSet();
            for (Long userId : studentUserIds) {
                toAddStudents.add(userIdAndIdMap.get(userId));
            }
            this.addOrgCourseStudent(orgId, courseId, toAddStudents, null, false);
        }
    }
}

