/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.erp.service;

import com.baijia.tianxiao.biz.erp.dto.response.CourseListInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.WeiKeListInfoDto;
import com.baijia.tianxiao.sal.course.dto.request.CourseListRequestDto;
import com.baijia.tianxiao.sal.course.dto.request.WeikeRequestDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.Date;
import java.util.List;

/**
 * @title ErpCourseListService
 * @desc TODO
 * @author shanyu
 * @date 2015年12月25日
 * @version 1.0
 */

public interface ErpCourseListService {

    /**
     * 
     * @param orgId 获取机构班级列表（设班模块）
     * @param startTime
     * @param endTime
     * @param searchKey
     * @param pageDto
     * @return
     */
    public List<CourseListInfoDto> getCourseList(Long orgId, Date startTime, Date endTime,CourseListRequestDto params, PageDto pageDto);

    /**
     * 查看课节详情
     * 
     * @param orgId
     * @param courseId
     * @return
     */
    public CourseListInfoDto getCourseDetail(Long orgId, Long orgCourseId);

    /**
     * 带有到课率统计信息的课程列表
     * 
     * @param orgId
     * @param searchKey
     * @param pageDto
     * @return
     */
    List<CourseListInfoDto> getCourseListWithAttendanceRate(Long orgId, String searchKey, PageDto pageDto);

    /**
     * 设班微课列表
     * @author shizuwei
     * @param orgId
     * @param requestDto
     * @return
     */
    List<WeiKeListInfoDto> getWeikeList(Long orgId, WeikeRequestDto requestDto);
}
