package com.baijia.tianxiao.biz.erp.dto.response.studentCenter;

import java.util.Date;
import java.util.List;

import lombok.Data;

import com.baijia.tianxiao.constant.OrgLessonStatus;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;

/**
 * 学生个人中心课表
 * 
 * @title StudentCenterLessonListDto
 * @desc TODO
 * @author shizuwei
 * @date 2016年1月4日
 * @version 1.0
 */
@Data
public class StudentCenterLessonListDto {
    private Date firstLessonStartTime = null;
    private Date lastLessonStartTime = null;
    private List<InfoDay> list = Lists.newArrayList();

    @Data
    public static class InfoDay {
        private String date;
        private Integer weekDay;// 星期（0，周日；1，周一；2，周二；3，周三；4，周四；5，周五；6，周六）
        private List<LessonInfo> lessons = Lists.newArrayList();

        public void setDate(Date date) {
            this.weekDay = DateUtil.getWeekDay(date);
            this.date = DateUtil.getStrByDateFormate(date, "yyyy-MM-dd");
        }

    }

    @Data
    public static class LessonInfo {

        private Date startTime;
        private Date endTime;
        private Integer lessonId;
        private Integer index;
        private String courseName;
        private String teacherName;
        private String roomName;
        private Integer status = 0;// 课节开始状态:0,未开始；1，上课中;2,已经结束
        private Integer commentTimeout = 0;// 是否超过评论时间:0,未超过；1，超过（七天之后无法评价）
        private Integer signStatus = 0;// 签到状态:0,未签到;1,已签到；2，请假；3,旷课
        private Integer commentStatus = 0;// 评价状态：0，待评价，1，已评价；

        public void setStartAndEndTime(Date startTime, Date endTime) {
            Date now = new Date();
            this.endTime = endTime;
            this.startTime = startTime;
            if (DateUtil.getDateDiff(now, endTime) > 7) {
                this.commentTimeout = 1;
            } else {
                this.commentTimeout = 0;
            }

            if (endTime.before(now)) {
                this.status = OrgLessonStatus.NOT_START;
            } else if (endTime.after(now) && startTime.before(now)) {
                this.status = OrgLessonStatus.IN_PROCRESS;
            } else {
                this.status = OrgLessonStatus.FINISHED;
            }
        }

    }

    /**
     * 
     * @param startTime 添加时需要按时间递增顺序
     * @param endTime
     * @param lessonId
     * @param index
     * @param courseName
     * @param teacherName
     * @param roomName
     * @param status
     * @param signStatus
     * @param commentStatus
     */
    public void addLessonInfo(Date startTime, Date endTime, Integer lessonId, Integer index, String courseName,
        String teacherName, String roomName, Integer status, Integer signStatus, Integer commentStatus) {

        int dayDiff = 1;

        if (this.lastLessonStartTime != null) {
            dayDiff = DateUtil.getDateDiff(startTime, startTime);
        }

        if (dayDiff > 0) {
            InfoDay infoDay = new InfoDay();
            infoDay.setDate(startTime);
            infoDay.getLessons().add(
                buildLessonInfo(startTime, endTime, lessonId, index, courseName, teacherName, roomName, status,
                    signStatus, commentStatus));
            list.add(infoDay);
        } else if (dayDiff == 0) {
            InfoDay infoDay = this.list.get(list.size() - 1);
            infoDay.getLessons().add(
                buildLessonInfo(startTime, endTime, lessonId, index, courseName, teacherName, roomName, status,
                    signStatus, commentStatus));
        } else {
            throw new IllegalArgumentException("startTime 必须按时间递增顺序");
        }
        
        // 最早开始时间
        if (this.firstLessonStartTime == null || this.firstLessonStartTime.getTime() > startTime.getTime()) {
            this.firstLessonStartTime = startTime;
        }
        // 最晚开始时间
        if (this.lastLessonStartTime == null || this.lastLessonStartTime.getTime() < startTime.getTime()) {
            this.lastLessonStartTime = startTime;
        }

    }

    public LessonInfo buildLessonInfo(Date startTime, Date endTime, Integer lessonId, Integer index, String courseName,
        String teacherName, String roomName, Integer status, Integer signStatus, Integer commentStatus) {
        LessonInfo lessonInfo = new LessonInfo();
        lessonInfo.setStartAndEndTime(startTime, endTime);
        lessonInfo.setLessonId(lessonId);
        lessonInfo.setIndex(index);
        lessonInfo.setCourseName(courseName);
        lessonInfo.setTeacherName(teacherName);
        lessonInfo.setRoomName(roomName);
        lessonInfo.setStatus(commentStatus);
        lessonInfo.setSignStatus(signStatus);
        lessonInfo.setCommentStatus(commentStatus);
        return lessonInfo;
    }

}
