/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.sync.impl;

import com.baijia.tianxiao.biz.erp.sync.SyncPayService;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.dal.finance.dao.TxFinanceInfoDao;
import com.baijia.tianxiao.dal.finance.po.TxxFinanceInfo;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgFinanceAccountRecordDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgFinanceAccountRecord;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.dal.statistic.dao.TxFinanceRecordDayDao;
import com.baijia.tianxiao.dal.statistic.dao.TxSignupRecordDayDao;
import com.baijia.tianxiao.dal.statistic.po.TxFinanceRecordDay;
import com.baijia.tianxiao.dal.statistic.po.TxSignupRecordDay;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpType;
import com.baijia.tianxiao.util.date.DateUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="syncSignupRefundRecordService")
public class SyncSignupRefundRecordServiceImpl
implements SyncPayService {
    private static final Logger log = LoggerFactory.getLogger(SyncSignupRefundRecordServiceImpl.class);
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;
    @Resource
    private OrgSignupRefundDao orgSignupRefundDao;
    @Resource
    private TxSignupRecordDayDao txSignupRecordDayDao;
    @Resource
    private OrgFinanceAccountRecordDao orgFinanceAccountRecordDao;
    @Resource
    private TxFinanceInfoDao txFinanceInfoDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private TxFinanceRecordDayDao txFinanceRecordDayDao;
    private AtomicBoolean signupRefundRecordFlag = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() {
        TxMsgSyncTimestamp syncInfo = this.getSyncInfo(MsgSyncType.CW_SIGNUP_REFUND_RECORD);
        try {
            if (!this.signupRefundRecordFlag.get()) {
                log.info("sync cw signuprecord refund info :{}", (Object)syncInfo);
                this.signupRefundRecordFlag.set(true);
                this.syncSignupRefundRecordDay(syncInfo);
                this.signupRefundRecordFlag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", (Throwable)e);
        }
        finally {
            this.signupRefundRecordFlag.set(false);
        }
        log.info("save sync signuprefund info:{}", (Object)syncInfo);
        this.txMsgSyncTimestampDao.saveOrUpdate((Object)syncInfo, new String[0]);
    }

    private void syncSignupRefundRecordDay(TxMsgSyncTimestamp syncInfo) {
        List signupRefunds = this.orgSignupRefundDao.getOrgSignupRefundListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        log.info("save syncSignupRefundRecordDay:{} success", (Object)signupRefunds.size());
        if (CollectionUtils.isNotEmpty((Collection)signupRefunds)) {
            for (OrgSignupRefund orgSignupRefund : signupRefunds) {
                try {
                    OrgSignupInfo orgSignupInfo;
                    if ((long)orgSignupRefund.getId() > syncInfo.getSyncId()) {
                        syncInfo.setSyncId(Long.valueOf(orgSignupRefund.getId()));
                    }
                    if ((orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(orgSignupRefund.getSignupPurchaseId(), new String[0])) == null) continue;
                    this.saveSignupRecordDay(orgSignupInfo, orgSignupRefund);
                    this.saveFinanceInfo(orgSignupInfo, orgSignupRefund);
                    this.saveFinanceRecordDay(orgSignupInfo, orgSignupRefund);
                }
                catch (Exception e) {
                    log.warn("sync finance record fail {}", (Throwable)e);
                }
            }
        }
    }

    private void saveFinanceInfo(OrgSignupInfo orgSignupInfo, OrgSignupRefund orgSignupRefund) {
        int opTo = 2;
        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(orgSignupRefund.getCourseId(), new String[0]);
        OrgFinanceAccountRecord orgFinanceAccountRecord = this.orgFinanceAccountRecordDao.currentAccount(orgSignupInfo.getOrgId(), orgSignupRefund.getCreateTime(), new String[0]);
        TxxFinanceInfo txFinanceInfo = new TxxFinanceInfo();
        txFinanceInfo.setOrgId(orgSignupInfo.getOrgId());
        txFinanceInfo.setCreateTime(orgSignupRefund.getCreateTime());
        txFinanceInfo.setCurrBalance(Double.valueOf(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrBalance()));
        txFinanceInfo.setCurrFreezeMoney(Double.valueOf(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrFreezeMoney()));
        txFinanceInfo.setExpectedEarning(Double.valueOf(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrExpectedEarning()));
        txFinanceInfo.setOpMoney(Double.valueOf(orgSignupRefund.getRefundPrice().doubleValue() / 100.0));
        txFinanceInfo.setOpType(FinanceOpType.DRAWBACK.getCode());
        txFinanceInfo.setPayType(Integer.valueOf(PayType.CASH.getCode()));
        txFinanceInfo.setPurchaseId(orgSignupRefund.getSignupPurchaseId() + "");
        txFinanceInfo.setCourseId(orgCourse.getId());
        StringBuffer opinfo = new StringBuffer();
        opinfo.append(orgCourse != null ? orgCourse.getName() : "").append(" ");
        opinfo.append("\u5b66\u751f:").append(orgSignupInfo.getStudentName()).append(" ");
        txFinanceInfo.setOpInfo(opinfo.toString());
        txFinanceInfo.setOpTo(Integer.valueOf(opTo));
        log.debug("saveFinanceInfo={}", (Object)txFinanceInfo);
        this.txFinanceInfoDao.save((Object)txFinanceInfo, new String[0]);
    }

    private void saveFinanceRecordDay(OrgSignupInfo orgSignupInfo, OrgSignupRefund orgSignupRefund) {
        int opType = PayType.CASH.getCode();
        int opTo = 2;
        String mdate = DateUtil.getStrByDate((Date)orgSignupRefund.getCreateTime());
        TxFinanceRecordDay txFinanceRecordDay = this.txFinanceRecordDayDao.getByDayType(orgSignupInfo.getOrgId(), mdate, opType, opTo, new String[0]);
        if (txFinanceRecordDay == null) {
            txFinanceRecordDay = new TxFinanceRecordDay();
            txFinanceRecordDay.setOrgId(orgSignupInfo.getOrgId());
            txFinanceRecordDay.setMdate(orgSignupRefund.getCreateTime());
            txFinanceRecordDay.setOpCount(Integer.valueOf(1));
            txFinanceRecordDay.setOpPrice(Double.valueOf(orgSignupRefund.getRefundPrice().doubleValue() / 100.0));
            txFinanceRecordDay.setOpType(Integer.valueOf(opType));
            txFinanceRecordDay.setOpTo(Integer.valueOf(opTo));
        } else {
            txFinanceRecordDay.setOpPrice(Double.valueOf(txFinanceRecordDay.getOpPrice() + orgSignupRefund.getRefundPrice().doubleValue() / 100.0));
            txFinanceRecordDay.setOpCount(Integer.valueOf(txFinanceRecordDay.getOpCount() + 1));
        }
        log.debug("saveFinanceRecordDay={}", (Object)txFinanceRecordDay);
        this.txFinanceRecordDayDao.saveOrUpdate((Object)txFinanceRecordDay, new String[0]);
    }

    private void saveSignupRecordDay(OrgSignupInfo orgSignupInfo, OrgSignupRefund orgSignupRefund) {
        int opType = orgSignupInfo.getSourceType();
        int opTo = 2;
        String mdate = DateUtil.getStrByDate((Date)orgSignupRefund.getCreateTime());
        TxSignupRecordDay txSignupRecordDay = this.txSignupRecordDayDao.getByDayType(orgSignupInfo.getOrgId(), mdate, opType, opTo, new String[0]);
        if (txSignupRecordDay == null) {
            txSignupRecordDay = new TxSignupRecordDay();
            txSignupRecordDay.setOrgId(orgSignupInfo.getOrgId());
            txSignupRecordDay.setMdate(orgSignupRefund.getCreateTime());
            txSignupRecordDay.setOpCount(Integer.valueOf(1));
            txSignupRecordDay.setOpPrice(Double.valueOf(orgSignupRefund.getRefundPrice().doubleValue() / 100.0));
            txSignupRecordDay.setOpType(Integer.valueOf(opType));
            txSignupRecordDay.setOpTo(Integer.valueOf(opTo));
        } else {
            txSignupRecordDay.setOpPrice(Double.valueOf(txSignupRecordDay.getOpPrice() + orgSignupRefund.getRefundPrice().doubleValue() / 100.0));
            txSignupRecordDay.setOpCount(Integer.valueOf(txSignupRecordDay.getOpCount() + 1));
        }
        log.debug("saveSignupRecordDay={}", (Object)txSignupRecordDay);
        this.txSignupRecordDayDao.saveOrUpdate((Object)txSignupRecordDay, new String[0]);
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(Long.valueOf(0L));
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(Integer.valueOf(syncType.getSyncType()));
        }
        return syncInfo;
    }
}

