/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.dto.response.CourseListInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.WeiKeListInfoDto;
import com.baijia.tianxiao.biz.erp.service.ErpCourseListService;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dto.FieldShow;
import com.baijia.tianxiao.dto.query.QueryCondition;
import com.baijia.tianxiao.sal.course.dto.request.CourseListRequestDto;
import com.baijia.tianxiao.sal.course.dto.request.WeikeRequestDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.sal.course.service.OrgLessonSignService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.CollectorUtil;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Sets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ErpCourseListServiceImpl
implements ErpCourseListService {
    private static final Logger log = LoggerFactory.getLogger(ErpCourseListServiceImpl.class);
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Resource
    private OrgCourseRoomDao orgCourseRoomDao;
    @Resource
    private OrgCourseListService orgCourseListService;
    @Resource
    private OrgLessonSignService orgLessonSignService;
    @Resource
    private CourseTeacherService courseTeacherService;
    @Resource
    private CourseStudentService courseStudentService;

    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (account == null) {
            return null;
        }
        Integer number = account.getNumber();
        return number != null ? Long.valueOf(number.longValue()) : null;
    }

    private Map<Long, List<String>> getTeachersOfCourses(Long orgId, Collection<Long> courseIds) {
        log.info("orgId={},courseIds={}", (Object)orgId, courseIds);
        HashMap resultMap = Maps.newHashMap();
        Map courseTeachersMap = this.orgCourseTeacherDao.getTeacherMap(courseIds);
        Set teacherIdsSet = Sets.newHashSet();
        for (Long key : courseTeachersMap.keySet()) {
            teacherIdsSet.addAll((Collection)courseTeachersMap.get(key));
        }
        List teacherDtoList = this.courseTeacherService.getTeachers((Collection)teacherIdsSet, orgId);
        Map teacherMap = CollectorUtil.collectMap((Collection)teacherDtoList, (Function)new Function<TeacherResponseDto, Long>(){

            public Long apply(TeacherResponseDto from) {
                return from.getTeacherId();
            }
        }, (Function)new Function<TeacherResponseDto, String>(){

            public String apply(TeacherResponseDto from) {
                return from.getTeacherName();
            }
        });
        for (Long courseId : courseIds) {
            List teacherIds = (List)courseTeachersMap.get(courseId);
            List teacherList = Lists.newArrayList();
            if (!CollectionUtils.isNotEmpty((Collection)teacherIds)) continue;
            for (Long tid : teacherIds) {
                teacherList.add(teacherMap.get(tid));
            }
            resultMap.put(courseId, teacherList);
        }
        log.debug("resultMap={}", (Object)resultMap);
        return resultMap;
    }

    @Override
    public List<WeiKeListInfoDto> getWeikeList(Long orgId, WeikeRequestDto requestDto) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"illegal orgId");
        List dtos = this.orgCourseListService.getWeikeList(orgId, requestDto);
        if (CollectionUtils.isEmpty((Collection)dtos)) {
            return Collections.emptyList();
        }
        Collection courseIds = CollectorUtil.collect((Collection)dtos, (Function)new Function<CourseListReponseDto, Long>(){

            public Long apply(CourseListReponseDto input) {
                return input.getOrgCourseId();
            }
        });
        Map stuCntMap = this.courseStudentService.getCourseStudentCntMap(orgId, courseIds, Boolean.valueOf(true));
        List responseDto = Lists.newArrayList();
        for (CourseListReponseDto courseListReponseDto : dtos) {
            WeiKeListInfoDto dto = new WeiKeListInfoDto();
            this.buildWeiKeListInfoDto(courseListReponseDto, dto, stuCntMap);
            responseDto.add(dto);
        }
        return responseDto;
    }

    private void buildWeiKeListInfoDto(CourseListReponseDto courseListReponseDto, WeiKeListInfoDto WeiKeListInfoDto2, Map<Long, Integer> stuCntMap) {
        WeiKeListInfoDto2.setCourseName(courseListReponseDto.getCourseName());
        WeiKeListInfoDto2.setCourseUrl(courseListReponseDto.getCourseUrl());
        WeiKeListInfoDto2.setCoverUrl(courseListReponseDto.getCoverUrl());
        WeiKeListInfoDto2.setMaxStudent(courseListReponseDto.getMaxStudent());
        WeiKeListInfoDto2.setOrgCourseId(courseListReponseDto.getOrgCourseId());
        WeiKeListInfoDto2.setStudentCount(stuCntMap.get(courseListReponseDto.getOrgCourseId()) == null ? 0 : stuCntMap.get(courseListReponseDto.getOrgCourseId()));
        WeiKeListInfoDto2.setPrice(courseListReponseDto.getPrice());
        WeiKeListInfoDto2.setStatus(courseListReponseDto.getStatus());
        WeiKeListInfoDto2.setIntroduction(courseListReponseDto.getIntroduction());
    }

    @Override
    public List<CourseListInfoDto> getCourseList(Long orgId, Date startTime, Date endTime, CourseListRequestDto params, PageDto pageDto) {
        Long orgNumber = this.getOrgNumber(orgId);
        String searchKey = params.getSearchKey();
        String teacherIds = params.getTeacherIds();
        List courseIds = null;
        Set teacherIdSet = Sets.newHashSet();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{teacherIds})) {
            String[] arr;
            for (String str : arr = teacherIds.split(",")) {
                teacherIdSet.add(Long.parseLong(str));
            }
            courseIds = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)teacherIdSet)) {
                courseIds = this.orgCourseTeacherDao.getCourseIdsByteacherIds((Collection)teacherIdSet);
            }
        }
        OrgCourseDao.OrgCourseListParam param = new OrgCourseDao.OrgCourseListParam();
        param.setKey(searchKey);
        param.setStartTime(startTime);
        param.setEndTime(endTime);
        param.setPage(pageDto);
        param.setStatus(params.getStatus());
        Map fieldShowMap = FieldShow.getColumnShowMap(CourseListInfoDto.class);
        if (StringUtils.isNotBlank((CharSequence)params.getOrderField())) {
            FieldShow fieldShow = (FieldShow)fieldShowMap.get(params.getOrderField());
            String orderField = fieldShow != null ? fieldShow.getPoName() : null;
            param.setOrderField(orderField);
            param.setOrderType(params.getOrderType());
        }
        if (StringUtils.isBlank((CharSequence)params.getOrderField())) {
            param.setOrderField("createTime");
            param.setOrderType("DESC");
        }
        param.setQueryCondition(QueryCondition.andCondtions((Collection)params.getQueryConditions(), (Map)fieldShowMap));
        param.setIsDel(params.getIsDel());
        List courses = this.orgCourseDao.getCourseList(orgNumber, (Collection)courseIds, param, new String[0]);
        List dtos = this.orgCourseListService.getCourseList(courses, orgId, true, false, true, Boolean.valueOf(true), true, true, true);
        Map<Long, List<String>> courseTeachersMap = null;
        if (params.getLoadTeacherList() != null && params.getLoadTeacherList().booleanValue()) {
            courseIds = Lists.newArrayList();
            for (OrgCourse course : courses) {
                courseIds.add(course.getId());
            }
            courseTeachersMap = this.getTeachersOfCourses(orgId, courseIds);
        }
        List responseDto = Lists.newArrayList();
        for (CourseListReponseDto courseListReponseDto : dtos) {
            List<String> teachers;
            CourseListInfoDto dto = new CourseListInfoDto();
            this.buildCourseListInfoDto(courseListReponseDto, dto);
            if (courseTeachersMap != null && CollectionUtils.isNotEmpty(teachers = courseTeachersMap.get(courseListReponseDto.getOrgCourseId()))) {
                dto.setTeacherNames(StringUtils.join(teachers, (String)","));
            }
            responseDto.add(dto);
        }
        return responseDto;
    }

    @Override
    public List<CourseListInfoDto> getCourseListWithAttendanceRate(Long orgId, String searchKey, PageDto pageDto) {
        Long orgNumber = this.getOrgNumber(orgId);
        List courses = this.orgCourseDao.getCourseList(orgNumber, null, searchKey, null, null, null, pageDto, new String[0]);
        List<CourseListReponseDto> dtos = this.getCourseListWithAttendanceRate(courses, orgId);
        List responseDto = Lists.newArrayList();
        for (CourseListReponseDto courseListReponseDto : dtos) {
            CourseListInfoDto dto = new CourseListInfoDto();
            this.buildCourseListInfoDto(courseListReponseDto, dto);
            responseDto.add(dto);
        }
        return responseDto;
    }

    private List<CourseListReponseDto> getCourseListWithAttendanceRate(List<OrgCourse> courses, Long orgId) {
        log.info("courses={},orgId={}", courses, (Object)orgId);
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId not valid!");
        if (CollectionUtils.isEmpty(courses)) {
            return Collections.emptyList();
        }
        List dtos = this.orgCourseListService.getCourseList(courses, orgId, true, false, false, Boolean.valueOf(true), false, false, false);
        List courseIds = Lists.newArrayList();
        for (OrgCourse course : courses) {
            courseIds.add(course.getId());
        }
        Map rateMap = this.orgLessonSignService.getAttendanceRateOfCourses(orgId, (Collection)courseIds);
        for (CourseListReponseDto dto : dtos) {
            Long courseId = dto.getOrgCourseId();
            Double attendanceRate = (Double)rateMap.get(courseId);
            if (attendanceRate != null) {
                dto.setAttendanceRate(attendanceRate);
                continue;
            }
            dto.setAttendanceRate(Double.valueOf(0.0));
        }
        return dtos;
    }

    private void buildCourseListInfoDto(CourseListReponseDto courseListReponseDto, CourseListInfoDto dto) {
        dto.setColor(courseListReponseDto.getColor());
        dto.setCourseName(courseListReponseDto.getCourseName());
        dto.setCourseUrl(courseListReponseDto.getCourseUrl());
        dto.setCoverUrl(courseListReponseDto.getCoverUrl());
        dto.setEndTime(courseListReponseDto.getEndTime());
        dto.setFreq(courseListReponseDto.getFreq());
        dto.setLessonCount(courseListReponseDto.getLessonCount());
        dto.setLessonFinish(courseListReponseDto.getLessonFinish());
        dto.setMaxStudent(courseListReponseDto.getMaxStudent());
        dto.setOrgCourseId(courseListReponseDto.getOrgCourseId());
        dto.setOrgCourseNumber(courseListReponseDto.getOrgCourseNumber());
        dto.setRoomCount(courseListReponseDto.getRoomCount());
        dto.setRoomNames(courseListReponseDto.getRoomNames());
        dto.setStartTime(courseListReponseDto.getStartTime());
        dto.setStudentCount(courseListReponseDto.getStudentCount());
        dto.setTeacherCount(courseListReponseDto.getTeacherCount());
        dto.setAttendanceRate(courseListReponseDto.getAttendanceRate());
        dto.setPrice(courseListReponseDto.getPrice());
        dto.setStatus(courseListReponseDto.getStatus());
        dto.setAddress(courseListReponseDto.getAddress());
    }

    @Override
    public CourseListInfoDto getCourseDetail(Long orgId, Long orgCourseId) {
        CourseListReponseDto dto = this.orgCourseListService.getCourseDetail(orgId, orgCourseId);
        CourseListInfoDto courseListInfoDto = new CourseListInfoDto();
        this.buildCourseListInfoDto(dto, courseListInfoDto);
        return courseListInfoDto;
    }
}

