/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.util;

import com.baijia.tianxiao.biz.erp.vo.ImportCourse;
import com.baijia.tianxiao.biz.erp.vo.ImportStudent;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.service.impl.ImportOrgCourseProcessServiceImpl;
import com.baijia.tianxiao.sal.upload.service.UploadFileReaderService;
import com.baijia.tianxiao.sal.upload.service.impl.ExcelUploadFileReaderServiceImpl;
import com.baijia.tianxiao.util.ExcelUtils;
import com.beust.jcommander.internal.Lists;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ErpUploadFileUtil {
    private static final Logger log = LoggerFactory.getLogger(ErpUploadFileUtil.class);
    public static final Map<String, ImportOrgCourseProcessServiceImpl.CourseFormat> colMap = Maps.newHashMap();
    public static final Map<String, StudentFormat> studentMap = Maps.newHashMap();
    private static final Map<Integer, String> courseFieldMap = Maps.newHashMap();
    private static final Map<Integer, String> studentFieldMap = Maps.newHashMap();

    public static UploadFileReaderService getUploadFileService(MultipartFile file) {
        ExcelUploadFileReaderServiceImpl service = null;
        String fileName = file.getOriginalFilename();
        if (!fileName.toLowerCase().endsWith(".xlsx")) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, fileName + "\u53ea\u652f\u6301\u6a21\u677f\u6587\u4ef6\u5bfc\u5165");
        }
        service = new ExcelUploadFileReaderServiceImpl(file);
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getTemplateHeader(String fileName) {
        List templateHeader = Lists.newArrayList();
        XSSFWorkbook xssfWorkbook = null;
        try {
            File file = new File(ErpUploadFileUtil.class.getClassLoader().getResource(fileName).getFile());
            xssfWorkbook = new XSSFWorkbook(file);
            XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(1);
            XSSFRow xssfRow = xssfSheet.getRow(1);
            for (int i = xssfRow.getFirstCellNum(); i < xssfRow.getLastCellNum(); ++i) {
                XSSFCell cell = xssfRow.getCell(i);
                templateHeader.add(cell.getStringCellValue());
            }
        }
        catch (Exception e) {
            log.error("getTemplateHeader", (Throwable)e);
        }
        finally {
            if (xssfWorkbook != null) {
                try {
                    xssfWorkbook.close();
                }
                catch (IOException e) {
                    log.error("close xssfWorkbook error!", (Throwable)e);
                }
            }
        }
        return templateHeader;
    }

    public static List<String> tranHeader(Object[] headerObjs) {
        Preconditions.checkArgument((boolean)ArrayUtils.isNotEmpty((Object[])headerObjs), (Object)"\u5934\u4fe1\u606f\u4e3a\u7a7a");
        List headers = Lists.newArrayList();
        for (Object obj : headerObjs) {
            if (obj != null) {
                headers.add(obj.toString());
                continue;
            }
            headers.add("-");
        }
        return headers;
    }

    public static XSSFWorkbook generateCourseExcel(XSSFWorkbook workbook, List<ImportCourse> data, boolean needBackColor) throws InvalidFormatException, IOException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (workbook == null) {
            File file = new File(ErpUploadFileUtil.class.getClassLoader().getResource("import_course.xlsx").getPath());
            workbook = new XSSFWorkbook(file);
        }
        XSSFSheet sheet = workbook.getSheetAt(1);
        if (CollectionUtils.isEmpty(data)) {
            return workbook;
        }
        XSSFCellStyle style = null;
        style = needBackColor ? ExcelUtils.getYellowBGStyle((XSSFWorkbook)workbook) : ExcelUtils.getWhitewBGStyle((XSSFWorkbook)workbook);
        ExcelUtils.fillCellStyleWithFullBorder((XSSFCellStyle)style, (short)1, (short)IndexedColors.GREY_25_PERCENT.getIndex());
        int currentRow = sheet.getLastRowNum() + 1;
        StopWatch stopwatch = new StopWatch();
        stopwatch.start();
        for (int i = 0; i < data.size(); ++i) {
            ImportCourse importCourse = data.get(i);
            XSSFRow row = sheet.getRow(currentRow);
            if (row == null) {
                row = sheet.createRow(currentRow);
            }
            for (int j = 0; j < 5; ++j) {
                XSSFCell cell = row.getCell(j);
                if (cell == null) {
                    cell = row.createCell(j);
                }
                cell.setCellStyle((CellStyle)style);
                cell.setCellValue(BeanUtils.getProperty((Object)importCourse, (String)courseFieldMap.get(j)));
            }
            ++currentRow;
        }
        stopwatch.stop();
        log.debug("export course stopwatch time:{}", (Object)stopwatch.getTime());
        return workbook;
    }

    public static XSSFWorkbook generateStudentExcel(XSSFWorkbook workbook, List<ImportStudent> data, boolean needBackColor) throws InvalidFormatException, IOException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (workbook == null) {
            File file = new File(ErpUploadFileUtil.class.getClassLoader().getResource("import_student.xlsx").getPath());
            workbook = new XSSFWorkbook(file);
        }
        XSSFSheet sheet = workbook.getSheetAt(1);
        if (CollectionUtils.isEmpty(data)) {
            return workbook;
        }
        XSSFCellStyle style = null;
        style = needBackColor ? ExcelUtils.getYellowBGStyle((XSSFWorkbook)workbook) : ExcelUtils.getWhitewBGStyle((XSSFWorkbook)workbook);
        ExcelUtils.fillCellStyleWithFullBorder((XSSFCellStyle)style, (short)1, (short)IndexedColors.GREY_25_PERCENT.getIndex());
        int currentRow = sheet.getLastRowNum() + 1;
        StopWatch stopwatch = new StopWatch();
        stopwatch.start();
        for (int i = 0; i < data.size(); ++i) {
            ImportStudent importStudent = data.get(i);
            XSSFRow row = sheet.getRow(currentRow);
            if (row == null) {
                row = sheet.createRow(currentRow);
            }
            for (int j = 0; j <= 5; ++j) {
                XSSFCell cell = row.getCell(j);
                if (cell == null) {
                    cell = row.createCell(j);
                }
                cell.setCellStyle((CellStyle)style);
                cell.setCellValue(BeanUtils.getProperty((Object)importStudent, (String)studentFieldMap.get(j)));
            }
            ++currentRow;
        }
        stopwatch.stop();
        log.debug("export student stopwatch time:{}", (Object)stopwatch.getTime());
        return workbook;
    }

    public static void main(String[] args) throws InvalidFormatException, IOException {
        String reg = "^[a-zA-Z0-9\u4e00-\u9fa5]{1,20}$";
        System.out.println(Pattern.matches(reg, "a9\u662f1234567890123456%"));
    }

    static {
        colMap.put("\u73ed\u7ea7\u540d\u79f0", new ImportOrgCourseProcessServiceImpl.CourseFormat("courseName", ".{1,20}", "\u3010\u73ed\u7ea7\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6700\u591a\u8f93\u516520\u4e2a\u5b57\u7b26"));
        colMap.put("\u4e0a\u8bfe\u6b21\u6570", new ImportOrgCourseProcessServiceImpl.CourseFormat("freq", "^[1-9]\\d*$", "\u3010\u4e0a\u8bfe\u6b21\u6570\u3011\u9700\u4e3a\u5927\u4e8e\u96f6\u6574\u6570"));
        colMap.put("\u73ed\u7ea7\u4eba\u6570", new ImportOrgCourseProcessServiceImpl.CourseFormat("maxStudent", "^[1-9]\\d*$", "\u3010\u73ed\u7ea7\u4eba\u6570\u3011\u9700\u4e3a\u5927\u4e8e\u96f6\u6574\u6570"));
        colMap.put("\u4ef7\u683c", new ImportOrgCourseProcessServiceImpl.CourseFormat("coursePrice", "^(?!0(\\d|\\.0+$|$))\\d+(\\.\\d{1,2})?$", "\u3010\u4ef7\u683c\u3011\u9700\u4e3a\u5927\u4e8e\u96f6\u7684\u6570\u5b57"));
        studentMap.put("\u5b66\u5458\u59d3\u540d", new StudentFormat("studentName", "^[a-zA-Z0-9\u4e00-\u9fa5]{1,15}$", "\u3010\u5b66\u5458\u59d3\u540d\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6700\u591a\u8f93\u516515\u4e2a\u5b57\u7b26\uff0c\u4ec5\u652f\u6301\u6570\u5b57\u3001\u6c49\u5b57\u548c\u5b57\u6bcd"));
        studentMap.put("\u5b66\u5458\u624b\u673a", new StudentFormat("studentMobile", "^(\\+?86\\-?)?1\\d{2}\\-?\\d{4}\\-?\\d{4}$", "\u3010\u5b66\u5458\u624b\u673a\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5e76\u4e14\u9700\u4e3a\u4ee51\u5f00\u5934\u768411\u4f4d\u6570\u5b57\uff0c\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u548c\u7a7a\u683c"));
        studentMap.put("\u73ed\u7ea7\u540d\u79f0", new StudentFormat("courseName", ".{1,20}", "\u3010\u73ed\u7ea7\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6700\u591a\u8f93\u516520\u4e2a\u5b57\u7b26"));
        studentMap.put("\u603b\u8bfe\u6b21", new StudentFormat("lessonCount", "^[0-9]*[1-9][0-9]*$|(\\s&&[^\\f\\n\\r\\t\\v])*$", "\u3010\u603b\u8bfe\u6b21\u3011\u9700\u4e3a\u5927\u4e8e\u96f6\u6574\u6570"));
        studentMap.put("\u4ece\u7b2c\u51e0\u4e2a\u8bfe\u6b21\u63d2\u73ed", new StudentFormat("insertCount", "^[0-9]*[1-9][0-9]*$|(\\s&&[^\\f\\n\\r\\t\\v])*$", "\u3010\u4ece\u7b2c\u51e0\u4e2a\u8bfe\u6b21\u63d2\u73ed\u3011\u9700\u4e3a\u5927\u4e8e\u96f6\u6574\u6570"));
        courseFieldMap.put(0, "courseName");
        courseFieldMap.put(1, "coursePrice");
        courseFieldMap.put(2, "freq");
        courseFieldMap.put(3, "maxStudent");
        courseFieldMap.put(4, "errReason");
        studentFieldMap.put(0, "studentName");
        studentFieldMap.put(1, "studentMobile");
        studentFieldMap.put(2, "courseName");
        studentFieldMap.put(3, "lessonCount");
        studentFieldMap.put(4, "insertCount");
        studentFieldMap.put(5, "errReason");
    }

    public static class StudentFormat {
        private String fieldName;
        private String formatRegex;
        private String formatMsg;

        public StudentFormat(String fieldName, String formatRegex, String formatMsg) {
            this.fieldName = fieldName;
            this.formatRegex = formatRegex;
            this.formatMsg = formatMsg;
        }

        String getFmtErrorMsg() {
            return this.formatMsg;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getFormatRegex() {
            return this.formatRegex;
        }

        public String getFormatMsg() {
            return this.formatMsg;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public void setFormatRegex(String formatRegex) {
            this.formatRegex = formatRegex;
        }

        public void setFormatMsg(String formatMsg) {
            this.formatMsg = formatMsg;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StudentFormat)) {
                return false;
            }
            StudentFormat other = (StudentFormat)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fieldName = this.getFieldName();
            String other$fieldName = other.getFieldName();
            if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
                return false;
            }
            String this$formatRegex = this.getFormatRegex();
            String other$formatRegex = other.getFormatRegex();
            if (this$formatRegex == null ? other$formatRegex != null : !this$formatRegex.equals(other$formatRegex)) {
                return false;
            }
            String this$formatMsg = this.getFormatMsg();
            String other$formatMsg = other.getFormatMsg();
            return !(this$formatMsg == null ? other$formatMsg != null : !this$formatMsg.equals(other$formatMsg));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StudentFormat;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fieldName = this.getFieldName();
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            String $formatRegex = this.getFormatRegex();
            result = result * 59 + ($formatRegex == null ? 43 : $formatRegex.hashCode());
            String $formatMsg = this.getFormatMsg();
            result = result * 59 + ($formatMsg == null ? 43 : $formatMsg.hashCode());
            return result;
        }

        public String toString() {
            return "ErpUploadFileUtil.StudentFormat(fieldName=" + this.getFieldName() + ", formatRegex=" + this.getFormatRegex() + ", formatMsg=" + this.getFormatMsg() + ")";
        }
    }
}

