/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.dto;

import com.baijia.tianxiao.util.date.TimeStamp;
import java.util.Calendar;
import java.util.Date;
import lombok.NonNull;

public class LessonTime {
    private Date startTime;
    private Date endTime;

    public LessonTime(@NonNull Calendar cal, TimeStamp startTimeStamp, TimeStamp endTimeStamp) {
        if (cal == null) {
            throw new NullPointerException("cal");
        }
        this.startTime = LessonTime.createDateTime(cal, startTimeStamp);
        this.endTime = LessonTime.createDateTime(cal, endTimeStamp);
    }

    public LessonTime(Date startTime, Date endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public static Date createDateTime(@NonNull Calendar cal, TimeStamp timeStamp) {
        if (cal == null) {
            throw new NullPointerException("cal");
        }
        if (timeStamp != null) {
            if (timeStamp.getHour() >= 0) {
                cal.set(11, timeStamp.getHour());
            }
            if (timeStamp.getMinute() >= 0) {
                cal.set(12, timeStamp.getMinute());
            }
            if (timeStamp.getSecond() >= 0) {
                cal.set(13, timeStamp.getSecond());
            }
        }
        return cal.getTime();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LessonTime)) {
            return false;
        }
        LessonTime other = (LessonTime)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        return !(this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LessonTime;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        return result;
    }

    public String toString() {
        return "LessonTime(startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
    }
}

