/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.service.ErpLessonCommentService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonCommentSmsDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgLessonCommentSms;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.comment.dto.CommentAuditDto;
import com.baijia.tianxiao.sal.comment.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.comment.service.LessonCommentAudiService;
import com.baijia.tianxiao.sal.comment.service.LessonCommentService;
import com.baijia.tianxiao.sal.course.constant.CourseErrorCode;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.service.SmsService;
import com.baijia.tianxiao.sal.course.util.CourseSmsTokenUtil;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.dto.response.StudentInfoReponseDto;
import com.baijia.tianxiao.sal.teacher.api.TeacherService;
import com.baijia.tianxiao.sal.teacher.dto.OrgTeacherResponseDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ShortUrlUtil;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import com.beust.jcommander.internal.Maps;
import com.beust.jcommander.internal.Sets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ErpLessonCommentServiceImpl
implements ErpLessonCommentService {
    private static final Logger log = LoggerFactory.getLogger(ErpLessonCommentServiceImpl.class);
    @Resource
    private OrgLessonCommentDao orgLessonCommentDao;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Resource
    private OrgLessonCommentSmsDao orgLessonCommentSmsDao;
    @Resource
    private OrgStorageDao orgStorageDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private SmsService smsService;
    @Resource
    private TeacherService teacherService;
    @Resource
    private LessonCommentService lessonCommentService;
    @Resource
    private LessonCommentAudiService LessonCommentAudiService;
    @Resource
    private OrgStudentService orgStudentService;
    @Resource
    private CourseTeacherService courseTeacherService;
    @Resource
    private Environment environment;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sendStudentSms(Long orgId, Long lessonId) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        Preconditions.checkArgument((lessonId != null ? 1 : 0) != 0, (Object)"lessonId is null!");
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        if (lesson == null) {
            throw new BussinessException((UniverseErrorCode)CourseErrorCode.LESSON_NOT_EXIST);
        }
        if (this.orgTeacherLessonDao.getByLessonId(orgId, lessonId) == null) {
            throw new BussinessException((UniverseErrorCode)CourseErrorCode.LESSON_NOT_SET_TEACHER_SMS);
        }
        List userIds = this.orgStudentLessonDao.getUserIds(lessonId, orgId);
        Map studentMap = this.orgStudentDao.getStudentMap((Collection)userIds, orgId);
        OrgCourse course = (OrgCourse)this.orgCourseDao.getById((Serializable)lesson.getCourseId(), new String[]{"name"});
        for (Long userId : userIds) {
            String content;
            OrgStudent student = (OrgStudent)studentMap.get(userId);
            if (student == null || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{content = this.getStudentSmsContent(orgId, lesson.getCourseId(), course.getName(), student, lesson.getNumber(), lessonId)})) continue;
            String mobile = student.getShowMobile();
            if (StringUtils.isBlank((CharSequence)mobile) || !ParamValidateUtils.validateMobile((String)mobile)) {
                mobile = student.getMobile();
            }
            if (!this.smsService.saveAndSendSms(orgId, null, Integer.valueOf(UserRole.STUDENT.getRole()), userId, mobile, content)) continue;
            this.updateSmsCount(orgId, userId, lessonId);
        }
    }

    @Transactional(readOnly=true)
    public String getStudentSmsContent(Long orgId, Long courseId, String courseName, OrgStudent student, Integer index, Long lessonId) {
        Map params = Maps.newHashMap();
        params.put("studentId", student.getId());
        params.put("courseId", courseId);
        try {
            String token = CourseSmsTokenUtil.encodeToken((Map)params, (Long)orgId);
            String url = this.environment.getProperty("student_center_add_comment.url");
            url = String.format(url, token, lessonId);
            String name = student.getName();
            if (StringUtils.isBlank((CharSequence)name)) {
                name = student.getNickName();
            }
            if (StringUtils.isBlank((CharSequence)name)) {
                name = MaskUtil.maskMobile((String)student.getMobile());
            }
            url = ShortUrlUtil.getShortUrl((String)url);
            return String.format("%s\u4f60\u597d\uff0c\u4f60\u5df2\u5b8c\u6210%s\u7b2c%s\u6b21\u8bfe\u3002\u662f\u5426\u5bf9\u672c\u6b21\u8bfe\u6ee1\u610f\u5462\uff1f\u5feb\u53bb\u7ed9\u8001\u5e08\u6253\u5206\u5427\u3002\u5730\u5740:%s", name, courseName, index, url);
        }
        catch (Exception e) {
            log.warn("get lesson student comment error", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        Map params = Maps.newHashMap();
        params.put("studentId", 11114);
        params.put("courseId", 727);
        String token = CourseSmsTokenUtil.encodeToken((Map)params, (Long)3618L);
        System.out.println(token);
    }

    private void updateSmsCount(Long orgId, Long userId, Long lessonId) {
        OrgLessonCommentSms sms = this.orgLessonCommentSmsDao.getCommentSms(orgId, lessonId, userId, Integer.valueOf(UserRole.STUDENT.getRole()));
        if (sms == null) {
            sms = new OrgLessonCommentSms();
            sms.setLessonId(lessonId);
            sms.setOrgId(orgId);
            sms.setSend(Integer.valueOf(1));
            sms.setUserId(userId);
            sms.setUserRole(Integer.valueOf(UserRole.STUDENT.getRole()));
            this.orgLessonCommentSmsDao.save((Object)sms, new String[0]);
        } else {
            sms.setSend(Integer.valueOf(sms.getSend() + 1));
            this.orgLessonCommentSmsDao.update((Object)sms, new String[]{"send"});
        }
    }

    @Override
    public List<CommentInfoDto> queryComments(Long orgId, Collection<Long> courseIds, Collection<Long> teacherIds, Integer commentReqType, Boolean isSystem, Integer userRole, PageDto pageDto) {
        List comments = this.lessonCommentService.queryComments(orgId, courseIds, teacherIds, commentReqType, isSystem, userRole, pageDto);
        Set fromIds = Sets.newHashSet();
        Set toIds = Sets.newHashSet();
        for (CommentInfoDto commentInfoDto : comments) {
            fromIds.add(commentInfoDto.getFromId());
            toIds.add(commentInfoDto.getToId());
        }
        this.getAndSetNameAndAVatar(orgId, fromIds, toIds, userRole, comments);
        return comments;
    }

    private void getAndSetNameAndAVatar(Long orgId, Collection<Long> fromIds, Collection<Long> toIds, Integer userRole, List<CommentInfoDto> comments) {
        if (userRole.intValue() == UserRole.STUDENT.getRole()) {
            Map studentMap = this.orgStudentService.getUserIdStudentDtoMap(fromIds, orgId);
            Map teacherMap = this.teacherService.getOrgTeacherMap(orgId, toIds);
            log.debug("studentMap={}", (Object)studentMap);
            log.debug("teachermap={}", (Object)teacherMap);
            for (CommentInfoDto commentInfoDto : comments) {
                StudentInfoReponseDto student = (StudentInfoReponseDto)studentMap.get(commentInfoDto.getFromId());
                OrgTeacherResponseDto teacher = (OrgTeacherResponseDto)teacherMap.get(commentInfoDto.getToId());
                if (student != null) {
                    commentInfoDto.setFromName(student.getName());
                    commentInfoDto.setFromAvatar(student.getAvatarUrl());
                    commentInfoDto.setFromId(student.getStudentId());
                }
                if (teacher == null) continue;
                commentInfoDto.setToName(teacher.getTeacherName());
                commentInfoDto.setToAvatar(teacher.getAvatar());
            }
        } else {
            Map studentMap = this.orgStudentService.getUserIdStudentDtoMap(toIds, orgId);
            Map teacherMap = this.teacherService.getOrgTeacherMap(orgId, fromIds);
            log.debug("studentMap={}", (Object)studentMap);
            log.debug("teachermap={}", (Object)teacherMap);
            for (CommentInfoDto commentInfoDto : comments) {
                StudentInfoReponseDto student = (StudentInfoReponseDto)studentMap.get(commentInfoDto.getToId());
                OrgTeacherResponseDto teacher = (OrgTeacherResponseDto)teacherMap.get(commentInfoDto.getFromId());
                if (teacher != null) {
                    commentInfoDto.setFromName(teacher.getTeacherName());
                    commentInfoDto.setFromAvatar(teacher.getAvatar());
                }
                if (student == null) continue;
                commentInfoDto.setToName(student.getName());
                commentInfoDto.setToAvatar(student.getAvatarUrl());
                commentInfoDto.setToId(student.getStudentId());
            }
        }
    }

    @Override
    public List<CommentAuditDto> getTeacherAuditList(Long orgId, Integer userRole, Boolean isSystem, PageDto pageDto) {
        List teachers = this.courseTeacherService.listOrgTeacher(null, orgId, null, null, pageDto);
        Map teacherMap = CollectorUtil.collectMap((Collection)teachers, (Function)new Function<TeacherResponseDto, Long>(){

            public Long apply(TeacherResponseDto arg0) {
                return arg0.getTeacherId();
            }
        });
        List comments = this.LessonCommentAudiService.getTeacherAuditList(orgId, teacherMap.keySet(), userRole, isSystem);
        for (CommentAuditDto commentAuditDto : comments) {
            TeacherResponseDto teacher = (TeacherResponseDto)teacherMap.get(commentAuditDto.getId());
            if (teacher == null) continue;
            commentAuditDto.setAvatarUrl(teacher.getAvatar());
            commentAuditDto.setName(teacher.getTeacherName());
        }
        return comments;
    }
}

