/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.constant;

import com.beust.jcommander.internal.Lists;
import com.google.common.base.Preconditions;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum RepeatUnit {
    NONE(-1){

        @Override
        protected int getCalendarType() {
            throw new UnsupportedOperationException("NONE REPEAT.");
        }
    }
    ,
    Day(0){

        @Override
        public int getCalendarType() {
            return 5;
        }
    }
    ,
    Week(1){

        @Override
        public int getCalendarType() {
            return 5;
        }

        @Override
        protected int getLength(int repeatRange) {
            return repeatRange * 7;
        }
    }
    ,
    Month(2){

        @Override
        public int getCalendarType() {
            return 2;
        }
    }
    ,
    Quarter(3){

        @Override
        public int getCalendarType() {
            return 2;
        }

        @Override
        protected int getLength(int repeatRange) {
            return repeatRange * 3;
        }
    }
    ,
    Year(4){

        @Override
        public int getCalendarType() {
            return 1;
        }
    };

    private static Map<Integer, RepeatUnit> map;
    private int code;

    private RepeatUnit(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    protected abstract int getCalendarType();

    protected int getLength(int repeatRange) {
        return repeatRange;
    }

    public List<Calendar> getAvaliableDays(Date startDay, Date endDay, Integer repeatRange) {
        if (repeatRange == null || repeatRange <= 0) {
            repeatRange = 1;
        }
        Preconditions.checkArgument((startDay != null ? 1 : 0) != 0, (Object)"\u5f00\u59cb\u65e5\u671f\u9519\u8bef");
        Preconditions.checkArgument((endDay != null ? 1 : 0) != 0, (Object)"\u7ed3\u675f\u65e5\u671f\u9519\u8bef");
        Preconditions.checkArgument((repeatRange > 0 ? 1 : 0) != 0, (Object)"\u91cd\u590d\u8303\u56f4\u5fc5\u987b\u5927\u4e8e0");
        if (endDay.before(startDay)) {
            throw new IllegalArgumentException("\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4");
        }
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDay);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endDay);
        List resultCals = Lists.newArrayList();
        while (startCal.before(endCal)) {
            resultCals.add((Calendar)startCal.clone());
            startCal.add(this.getCalendarType(), this.getLength(repeatRange));
        }
        return resultCals;
    }

    public List<Calendar> getAvaliableDays(Date startDay, Integer repeatCount, Integer repeatRange) {
        if (repeatCount == null || repeatCount <= 0) {
            repeatCount = 1;
        }
        if (repeatRange == null || repeatRange <= 0) {
            repeatRange = 1;
        }
        Preconditions.checkArgument((startDay != null ? 1 : 0) != 0, (Object)"\u5f00\u59cb\u65e5\u671f\u9519\u8bef");
        Preconditions.checkArgument((repeatCount > 0 && repeatCount < 100 ? 1 : 0) != 0, (Object)"\u91cd\u590d\u6b21\u6570\u8303\u56f4\u5fc5\u987b\u57281-99");
        Preconditions.checkArgument((repeatRange > 0 ? 1 : 0) != 0, (Object)"\u91cd\u590d\u8303\u56f4\u5fc5\u987b\u5927\u4e8e0");
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDay);
        List resultCals = Lists.newArrayList();
        if (this.code < 0) {
            resultCals.add(startCal);
            return resultCals;
        }
        while (repeatCount > 0) {
            resultCals.add((Calendar)startCal.clone());
            startCal.add(this.getCalendarType(), this.getLength(repeatRange));
            Integer n = repeatCount;
            Integer n2 = repeatCount = Integer.valueOf(repeatCount - 1);
        }
        return resultCals;
    }

    public static RepeatUnit getByCode(Integer code) {
        return map.get(code);
    }

    static {
        map = new HashMap<Integer, RepeatUnit>();
        for (RepeatUnit unit : RepeatUnit.values()) {
            map.put(unit.code, unit);
        }
    }
}

