/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.constant.UploadFileStatus;
import com.baijia.tianxiao.biz.erp.service.ErpUploadService;
import com.baijia.tianxiao.biz.erp.util.ErpUploadFileUtil;
import com.baijia.tianxiao.biz.erp.vo.ImportCourse;
import com.baijia.tianxiao.biz.erp.vo.ImportStudent;
import com.baijia.tianxiao.constants.OrgCourseStatus;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.course.dto.OrgCourseInfoDto;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.baijia.tianxiao.sal.course.service.impl.ImportOrgCourseProcessServiceImpl;
import com.baijia.tianxiao.sal.student.api.OrgStudentCourseService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.dto.StudentInfoDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentAddresponseDto;
import com.baijia.tianxiao.sal.upload.service.UploadFileReaderService;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.beust.jcommander.internal.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ErpUploadServiceImpl
implements ErpUploadService {
    private static final Logger log = LoggerFactory.getLogger(ErpUploadServiceImpl.class);
    private static final String TASK_SUFFIX = "_task_tx";
    private static final String STATUS_SUFFIX = "_status_tx";
    private static final String VALID_LIST_SUFFIX = "_valid_list_tx";
    private static final String INVALID_LIST_SUFFIX = "_invalid_list_tx";
    private static final String VALID_LIST_SIZE_SUFFIX = "_valid_list_size_tx";
    private static final String INVALID_LIST_SIZE_SUFFIX = "_invalid_list_size_tx";
    private static final Long EXPIRE = 1800L;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired(required=false)
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Resource
    private OrgCourseService orgCourseService;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private OrgStudentService orgStudentService;
    @Autowired
    private OrgStudentCourseService orgStudentCourseService;
    @Autowired
    private OrgStudentLessonDao orgStudentLessonDao;

    @Override
    public String uploadCourse(MultipartFile file) throws Exception {
        final Integer orgId = TianxiaoPCContext.getOrgId();
        boolean isProcessing = (Boolean)this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.exists(ErpUploadServiceImpl.this.getTaskKey(orgId).getBytes());
            }
        });
        if (isProcessing) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PERMISSION_DENY, "\u4e0a\u4e00\u4e2a\u4efb\u52a1\u6254\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7b49\u5f85\u5b8c\u6210\u540e\uff0c\u518d\u6b21\u4e0a\u4f20");
        }
        final String taskId = UUID.randomUUID().toString();
        final UploadFileReaderService uploadFileService = ErpUploadFileUtil.getUploadFileService(file);
        List<String> templateHeader = ErpUploadFileUtil.getTemplateHeader("import_course.xlsx");
        final List<String> headers = ErpUploadFileUtil.tranHeader(uploadFileService.readData());
        if (!headers.contains("\u9519\u8bef\u539f\u56e0")) {
            headers.add("\u9519\u8bef\u539f\u56e0");
        }
        if (!CollectionUtils.isEqualCollection(templateHeader, headers)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bf7\u4f7f\u7528\u7cfb\u7edf\u6a21\u677f");
        }
        this.threadPoolTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ErpUploadServiceImpl.this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                        public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                            connection.setEx(ErpUploadServiceImpl.this.getStatusKey(taskId).getBytes(), EXPIRE.longValue(), UploadFileStatus.PROCESSING.getCode().toString().getBytes());
                            return true;
                        }
                    });
                    final List errList = Lists.newArrayList();
                    final List validList = Lists.newArrayList();
                    Object[] lineData = null;
                    headers.remove("\u9519\u8bef\u539f\u56e0");
                    try {
                        while ((lineData = uploadFileService.readData()) != null) {
                            boolean invalid = false;
                            ImportCourse importCourse = new ImportCourse();
                            for (int i = 0; i < headers.size(); ++i) {
                                Object value = lineData[i];
                                log.debug("****************lineData:{}", lineData[i]);
                                ImportOrgCourseProcessServiceImpl.CourseFormat courseFormat = ErpUploadFileUtil.colMap.get(headers.get(i));
                                if (value == null || StringUtils.isBlank((CharSequence)value.toString().trim())) {
                                    invalid = true;
                                    BeanUtils.setProperty((Object)importCourse, (String)"errReason", (Object)("\u3010" + (String)headers.get(i) + "\u3011\u4e0d\u80fd\u4e3a\u7a7a"));
                                    continue;
                                }
                                log.debug("********************** init importCourse:{},field:{},value:{}", new Object[]{importCourse, courseFormat.getFieldName(), value});
                                BeanUtils.setProperty((Object)importCourse, (String)courseFormat.getFieldName(), (Object)value);
                                if (Pattern.matches(courseFormat.getFormatRegex(), value.toString())) continue;
                                BeanUtils.setProperty((Object)importCourse, (String)"errReason", (Object)courseFormat.getFormatMsg());
                                invalid = true;
                            }
                            if (invalid) {
                                errList.add(importCourse);
                                continue;
                            }
                            validList.add(importCourse);
                        }
                    }
                    catch (Exception e) {
                        log.error("valid upload course error~!", (Throwable)e);
                        ErpUploadServiceImpl.this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                                connection.setEx(ErpUploadServiceImpl.this.getStatusKey(taskId).getBytes(), EXPIRE.longValue(), UploadFileStatus.ERROR.getCode().toString().getBytes());
                                return true;
                            }
                        });
                        return;
                    }
                    ErpUploadServiceImpl.this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                        public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                            if (CollectionUtils.isNotEmpty((Collection)validList)) {
                                for (ImportCourse importCourse : validList) {
                                    ErpUploadServiceImpl.this.redisTemplate.opsForList().leftPush((Object)ErpUploadServiceImpl.this.getValidDataKey(taskId), (Object)JacksonUtil.obj2Str((Object)importCourse));
                                }
                                connection.expire(ErpUploadServiceImpl.this.getValidDataKey(taskId).getBytes(), EXPIRE.longValue());
                            }
                            if (CollectionUtils.isNotEmpty((Collection)errList)) {
                                for (ImportCourse importCourse : errList) {
                                    ErpUploadServiceImpl.this.redisTemplate.opsForList().leftPush((Object)ErpUploadServiceImpl.this.getErrDataKey(taskId), (Object)JacksonUtil.obj2Str((Object)importCourse));
                                }
                                connection.expire(ErpUploadServiceImpl.this.getErrDataKey(taskId).getBytes(), EXPIRE.longValue());
                            }
                            return true;
                        }
                    });
                    ErpUploadServiceImpl.this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                        public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                            connection.setEx(ErpUploadServiceImpl.this.getStatusKey(taskId).getBytes(), EXPIRE.longValue(), UploadFileStatus.PROCESSED.getCode().toString().getBytes());
                            connection.setEx(ErpUploadServiceImpl.this.getErrDataSizeKey(taskId).getBytes(), EXPIRE.longValue(), String.valueOf(errList.size()).getBytes());
                            connection.setEx(ErpUploadServiceImpl.this.getValidDataSizeKey(taskId).getBytes(), EXPIRE.longValue(), String.valueOf(validList.size()).getBytes());
                            return true;
                        }
                    });
                }
                catch (Throwable t) {
                    log.error("upload course error!", t);
                    ErpUploadServiceImpl.this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                        public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                            connection.del((byte[][])new byte[][]{ErpUploadServiceImpl.this.getTaskKey(orgId).getBytes()});
                            return true;
                        }
                    });
                }
            }
        });
        return taskId;
    }

    private final String getTaskKey(Integer orgId) {
        return orgId + TASK_SUFFIX;
    }

    private final String getStatusKey(String taskId) {
        return taskId + STATUS_SUFFIX;
    }

    private final String getErrDataKey(String taskId) {
        return taskId + INVALID_LIST_SUFFIX;
    }

    private final String getValidDataKey(String taskId) {
        return taskId + VALID_LIST_SUFFIX;
    }

    private final String getErrDataSizeKey(String taskId) {
        return taskId + INVALID_LIST_SIZE_SUFFIX;
    }

    private final String getValidDataSizeKey(String taskId) {
        return taskId + VALID_LIST_SIZE_SUFFIX;
    }

    @Override
    public List<ImportCourse> getValidCourseList(final String taskId) {
        return (List)this.redisTemplate.execute((RedisCallback)new RedisCallback<List<ImportCourse>>(){

            public List<ImportCourse> doInRedis(RedisConnection connection) throws DataAccessException {
                List data = Lists.newArrayList();
                Long size = ErpUploadServiceImpl.this.redisTemplate.opsForList().size((Object)ErpUploadServiceImpl.this.getValidDataKey(taskId));
                if (size != null && size > 0L) {
                    int i = 0;
                    while ((long)i < size) {
                        try {
                            data.add(JacksonUtil.str2Obj((String)((String)ErpUploadServiceImpl.this.redisTemplate.opsForList().rightPop((Object)ErpUploadServiceImpl.this.getValidDataKey(taskId))), ImportCourse.class));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            log.error("uploadcourse getValidList error!", (Throwable)e);
                        }
                        ++i;
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)data)) {
                    for (ImportCourse importCourse : data) {
                        ErpUploadServiceImpl.this.redisTemplate.opsForList().leftPush((Object)ErpUploadServiceImpl.this.getValidDataKey(taskId), (Object)JacksonUtil.obj2Str((Object)importCourse));
                    }
                }
                connection.expire(ErpUploadServiceImpl.this.getValidDataKey(taskId).getBytes(), EXPIRE.longValue());
                return data;
            }
        });
    }

    @Override
    public List<ImportCourse> getInValidCourseList(final String taskId) {
        return (List)this.redisTemplate.execute((RedisCallback)new RedisCallback<List<ImportCourse>>(){

            public List<ImportCourse> doInRedis(RedisConnection connection) throws DataAccessException {
                List data = Lists.newArrayList();
                Long size = ErpUploadServiceImpl.this.redisTemplate.opsForList().size((Object)ErpUploadServiceImpl.this.getErrDataKey(taskId));
                if (size != null && size > 0L) {
                    int i = 0;
                    while ((long)i < size) {
                        try {
                            data.add(JacksonUtil.str2Obj((String)((String)ErpUploadServiceImpl.this.redisTemplate.opsForList().rightPop((Object)ErpUploadServiceImpl.this.getErrDataKey(taskId))), ImportCourse.class));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            log.error("uploadcourse getValidList error!", (Throwable)e);
                        }
                        ++i;
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)data)) {
                    for (ImportCourse importCourse : data) {
                        ErpUploadServiceImpl.this.redisTemplate.opsForList().leftPush((Object)ErpUploadServiceImpl.this.getErrDataKey(taskId), (Object)JacksonUtil.obj2Str((Object)importCourse));
                    }
                }
                connection.expire(ErpUploadServiceImpl.this.getValidDataKey(taskId).getBytes(), EXPIRE.longValue());
                return data;
            }
        });
    }

    @Override
    public Map<String, String> getTaskStatus(final String taskId) {
        return (Map)this.redisTemplate.execute((RedisCallback)new RedisCallback<Map<String, String>>(){

            public Map<String, String> doInRedis(RedisConnection connection) throws DataAccessException {
                byte[] statusBytes = connection.get(ErpUploadServiceImpl.this.getStatusKey(taskId).getBytes());
                byte[] invalidDataSizeBytes = connection.get(ErpUploadServiceImpl.this.getErrDataSizeKey(taskId).getBytes());
                byte[] validDataSizeBytes = connection.get(ErpUploadServiceImpl.this.getValidDataSizeKey(taskId).getBytes());
                String status = UploadFileStatus.PROCESSING.getCode().toString();
                HashMap data = Maps.newHashMap();
                if (statusBytes != null) {
                    status = (String)ErpUploadServiceImpl.this.redisTemplate.getStringSerializer().deserialize(statusBytes);
                }
                if (invalidDataSizeBytes != null) {
                    data.put("invalidDataSize", ErpUploadServiceImpl.this.redisTemplate.getStringSerializer().deserialize(invalidDataSizeBytes));
                }
                if (validDataSizeBytes != null) {
                    data.put("validDataSize", ErpUploadServiceImpl.this.redisTemplate.getStringSerializer().deserialize(validDataSizeBytes));
                }
                data.put("status", status);
                data.put("taskId", taskId);
                return data;
            }
        });
    }

    @Override
    public void saveCourse(final String taskId) {
        final List<ImportCourse> importCourses = this.getValidCourseList(taskId);
        final Integer orgId = TianxiaoPCContext.getOrgId();
        if (orgId == null) {
            log.error("saveCourse error!orgId is null");
            return;
        }
        this.threadPoolTaskExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ErpUploadServiceImpl.this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                        public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                            connection.setEx(ErpUploadServiceImpl.this.getStatusKey(taskId).getBytes(), EXPIRE.longValue(), UploadFileStatus.PROCESSING.getCode().toString().getBytes());
                            connection.setEx(ErpUploadServiceImpl.this.getTaskKey(orgId).getBytes(), EXPIRE.longValue(), "1".getBytes());
                            return true;
                        }
                    });
                    if (CollectionUtils.isNotEmpty((Collection)importCourses)) {
                        for (final ImportCourse importCourse : importCourses) {
                            OrgCourseInfoDto course = ErpUploadServiceImpl.this.buildCourse(importCourse);
                            try {
                                if (course == null) {
                                    throw new Exception("\u975e\u6cd5\u503c");
                                }
                                ErpUploadServiceImpl.this.orgCourseService.saveOrUpdateCourse(Long.valueOf(orgId.longValue()), course, false, true);
                            }
                            catch (Exception e) {
                                log.error("save importCourse error!,importCourse:{}", (Object)importCourse, (Object)e);
                                ErpUploadServiceImpl.this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                                    public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                                        importCourse.setErrReason("\u7cfb\u7edf\u9519\u8bef\uff0c\u65e0\u6cd5\u63d2\u5165\uff0c\u8bf7\u8054\u7cfb\u5929\u6821\u5de5\u4f5c\u4eba\u5458\u4e3a\u60a8\u6392\u67e5");
                                        connection.lPush(ErpUploadServiceImpl.this.getErrDataKey(taskId).getBytes(), JacksonUtil.obj2Str((Object)importCourse).getBytes());
                                        connection.expire(ErpUploadServiceImpl.this.getErrDataKey(taskId).getBytes(), EXPIRE.longValue());
                                        connection.incr(ErpUploadServiceImpl.this.getErrDataSizeKey(taskId).getBytes());
                                        connection.expire(ErpUploadServiceImpl.this.getErrDataSizeKey(taskId).getBytes(), EXPIRE.longValue());
                                        connection.decr(ErpUploadServiceImpl.this.getValidDataSizeKey(taskId).getBytes());
                                        connection.expire(ErpUploadServiceImpl.this.getValidDataSizeKey(taskId).getBytes(), EXPIRE.longValue());
                                        return true;
                                    }
                                });
                            }
                        }
                    }
                    ErpUploadServiceImpl.this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                        public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                            connection.setEx(ErpUploadServiceImpl.this.getStatusKey(taskId).getBytes(), EXPIRE.longValue(), UploadFileStatus.PROCESSED.getCode().toString().getBytes());
                            return true;
                        }
                    });
                }
                catch (Throwable t) {
                    try {
                        log.error("save couers error!", t);
                    }
                    catch (Throwable throwable) {
                        ErpUploadServiceImpl.this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                                connection.del((byte[][])new byte[][]{ErpUploadServiceImpl.this.getTaskKey(orgId).getBytes()});
                                return true;
                            }
                        });
                        throw throwable;
                    }
                    ErpUploadServiceImpl.this.redisTemplate.execute((RedisCallback)new /* invalid duplicate definition of identical inner class */);
                }
                ErpUploadServiceImpl.this.redisTemplate.execute((RedisCallback)new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private OrgCourseInfoDto buildCourse(ImportCourse importCourse) {
        OrgCourseInfoDto course = new OrgCourseInfoDto();
        if (importCourse.getCourseName() == null || importCourse.getCoursePrice() == null || importCourse.getFreq() == null || importCourse.getMaxStudent() == null) {
            return null;
        }
        log.debug("***********importCourse:{}", (Object)importCourse);
        course.setCourseName(importCourse.getCourseName().toString());
        course.setCoursePrice(Double.valueOf(importCourse.getCoursePrice().toString()));
        course.setFreq(Integer.valueOf(importCourse.getFreq().toString()));
        course.setMaxStudent(Integer.valueOf(importCourse.getMaxStudent().toString()));
        course.setStatus(Integer.valueOf(OrgCourseStatus.IN_PROGRESS.getCode()));
        log.debug("***********course:{}", (Object)course);
        return course;
    }

    @Override
    public String uploadStudent(MultipartFile file) throws Exception {
        final Integer orgId = TianxiaoPCContext.getOrgId();
        boolean isProcessing = (Boolean)this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.exists(ErpUploadServiceImpl.this.getTaskKey(orgId).getBytes());
            }
        });
        if (isProcessing) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PERMISSION_DENY, "\u4e0a\u4e00\u4e2a\u4efb\u52a1\u6254\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7b49\u5f85\u5b8c\u6210\u540e\uff0c\u518d\u6b21\u4e0a\u4f20");
        }
        final String taskId = UUID.randomUUID().toString();
        final UploadFileReaderService uploadFileService = ErpUploadFileUtil.getUploadFileService(file);
        List<String> templateHeader = ErpUploadFileUtil.getTemplateHeader("import_student.xlsx");
        final List<String> headers = ErpUploadFileUtil.tranHeader(uploadFileService.readData());
        if (!headers.contains("\u9519\u8bef\u539f\u56e0")) {
            headers.add("\u9519\u8bef\u539f\u56e0");
        }
        if (!CollectionUtils.isEqualCollection(templateHeader, headers)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bf7\u4f7f\u7528\u7cfb\u7edf\u6a21\u677f");
        }
        this.threadPoolTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ErpUploadServiceImpl.this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                        public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                            connection.setEx(ErpUploadServiceImpl.this.getStatusKey(taskId).getBytes(), EXPIRE.longValue(), UploadFileStatus.PROCESSING.getCode().toString().getBytes());
                            return true;
                        }
                    });
                    final List errList = Lists.newArrayList();
                    final List validList = Lists.newArrayList();
                    HashMap mobileMap = Maps.newHashMap();
                    Object[] lineData = null;
                    headers.remove("\u9519\u8bef\u539f\u56e0");
                    try {
                        while ((lineData = uploadFileService.readData()) != null) {
                            boolean invalid = false;
                            ImportStudent importStudent = new ImportStudent();
                            for (int i = 0; i < headers.size(); ++i) {
                                Object value = lineData[i];
                                ErpUploadFileUtil.StudentFormat studentFormat = ErpUploadFileUtil.studentMap.get(headers.get(i));
                                if (studentFormat.getFieldName().equals("lessonCount") || studentFormat.getFieldName().equals("insertCount")) {
                                    if (value != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{value.toString().trim()})) {
                                        if (!Pattern.matches(studentFormat.getFormatRegex(), value.toString())) {
                                            BeanUtils.setProperty((Object)importStudent, (String)"errReason", (Object)studentFormat.getFormatMsg());
                                            invalid = true;
                                        }
                                        BeanUtils.setProperty((Object)importStudent, (String)studentFormat.getFieldName(), (Object)value.toString());
                                    }
                                } else if (value == null || StringUtils.isBlank((CharSequence)value.toString().trim())) {
                                    invalid = true;
                                    BeanUtils.setProperty((Object)importStudent, (String)"errReason", (Object)("\u3010" + (String)headers.get(i) + "\u3011\u4e0d\u80fd\u4e3a\u7a7a"));
                                } else {
                                    BeanUtils.setProperty((Object)importStudent, (String)studentFormat.getFieldName(), (Object)value.toString());
                                    if (!Pattern.matches(studentFormat.getFormatRegex(), value.toString())) {
                                        BeanUtils.setProperty((Object)importStudent, (String)"errReason", (Object)studentFormat.getFormatMsg());
                                        invalid = true;
                                    }
                                }
                                if (invalid) continue;
                                if (importStudent.getStudentMobile() != null && mobileMap.containsKey(importStudent.getStudentMobile())) {
                                    ImportStudent exist = (ImportStudent)mobileMap.get(importStudent.getStudentMobile().toString());
                                    if (!exist.getStudentName().toString().equals(importStudent.getStudentName().toString())) {
                                        invalid = true;
                                        importStudent.setErrReason("\u4e0e\u8868\u683c\u5185\u5176\u4ed6\u884c\u6570\u636e\u3010\u624b\u673a\u53f7\u3011\u76f8\u540c\uff0c\u4f46\u59d3\u540d\u4e0d\u540c\uff0c\u65e0\u6cd5\u5bfc\u5165");
                                    } else if (exist.getCourseName() != null && importStudent.getCourseName() != null && exist.getCourseName().toString().equals(importStudent.getCourseName().toString())) {
                                        importStudent.setErrReason("\u8be5\u884c\u4e0e\u8868\u683c\u5185\u5176\u4ed6\u884c\u6570\u636e\u91cd\u590d\uff0c\u65e0\u6cd5\u5bfc\u5165");
                                        invalid = true;
                                    } else {
                                        List tempDtos = ErpUploadServiceImpl.this.orgStudentService.listOrgStudentByMobile(Long.valueOf(orgId.longValue()), importStudent.getStudentMobile().toString());
                                        if (CollectionUtils.isNotEmpty((Collection)tempDtos)) {
                                            boolean exists = false;
                                            for (StudentInfoDto dto : tempDtos) {
                                                if (!importStudent.getStudentMobile().equals(dto.getMobile()) || !importStudent.getStudentName().equals(dto.getName())) continue;
                                                exists = true;
                                                break;
                                            }
                                            if (!exists) {
                                                importStudent.setErrReason("\u4e0e\u7cfb\u7edf\u5185\u5b66\u5458\u3010\u624b\u673a\u53f7\u3011\u76f8\u540c\uff0c\u4f46\u59d3\u540d\u4e0d\u540c\uff0c\u65e0\u6cd5\u5bfc\u5165");
                                                invalid = true;
                                            }
                                        }
                                    }
                                }
                                if (invalid || importStudent.getCourseName() == null) continue;
                                List orgCourses = ErpUploadServiceImpl.this.orgCourseService.getAllOrgCourses(Long.valueOf(orgId.longValue()), importStudent.getCourseName().toString());
                                if (CollectionUtils.isEmpty((Collection)orgCourses)) {
                                    importStudent.setErrReason("\u3010\u73ed\u7ea7\u540d\u79f0\u3011\u5728\u7cfb\u7edf\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u624b\u52a8\u5f55\u5165\u73ed\u7ea7\uff0c\u518d\u6279\u5bfc\u73ed\u7ea7\u5b66\u5458");
                                    invalid = true;
                                    continue;
                                }
                                if (orgCourses.size() > 1) {
                                    importStudent.setErrReason("\u3010\u73ed\u7ea7\u540d\u79f0\u3011\u5728\u7cfb\u7edf\u6709\u591a\u4e2a\u91cd\u540d\u73ed\u7ea7\uff0c\u91cd\u540d\u73ed\u7ea7\u7684\u5b66\u5458\u8bf7\u624b\u52a8\u5f55\u5165");
                                    invalid = true;
                                    continue;
                                }
                                List lessons = ErpUploadServiceImpl.this.orgClassLessonDao.getLessonByCourseId(((OrgCourse)orgCourses.get(0)).getId());
                                if (!CollectionUtils.isEmpty((Collection)lessons)) continue;
                                importStudent.setErrReason("\u3010\u73ed\u7ea7\u540d\u79f0\u3011\u5bf9\u5e94\u73ed\u7ea7\u5c1a\u672a\u6392\u8bfe\uff0c\u8bf7\u5148\u6392\u8bfe");
                                invalid = true;
                            }
                            if (invalid) {
                                errList.add(importStudent);
                                continue;
                            }
                            validList.add(importStudent);
                            mobileMap.put(importStudent.getStudentMobile().toString(), importStudent);
                        }
                    }
                    catch (Exception e) {
                        log.error("valid upload student error~!", (Throwable)e);
                        ErpUploadServiceImpl.this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                                connection.setEx(ErpUploadServiceImpl.this.getStatusKey(taskId).getBytes(), EXPIRE.longValue(), UploadFileStatus.ERROR.getCode().toString().getBytes());
                                return true;
                            }
                        });
                        return;
                    }
                    log.debug("*********************validstudentlist:{}", (Object)validList);
                    log.debug("*********************invalidstudentlist:{}", (Object)errList);
                    ErpUploadServiceImpl.this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                        public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                            if (CollectionUtils.isNotEmpty((Collection)validList)) {
                                for (ImportStudent importStudent : validList) {
                                    ErpUploadServiceImpl.this.redisTemplate.opsForList().leftPush((Object)ErpUploadServiceImpl.this.getValidDataKey(taskId), (Object)JacksonUtil.obj2Str((Object)importStudent));
                                }
                                connection.expire(ErpUploadServiceImpl.this.getValidDataKey(taskId).getBytes(), EXPIRE.longValue());
                                log.debug("************save validList:{}", (Object)validList);
                            }
                            if (CollectionUtils.isNotEmpty((Collection)errList)) {
                                for (ImportStudent importStudent : errList) {
                                    ErpUploadServiceImpl.this.redisTemplate.opsForList().leftPush((Object)ErpUploadServiceImpl.this.getErrDataKey(taskId), (Object)JacksonUtil.obj2Str((Object)importStudent));
                                }
                                connection.expire(ErpUploadServiceImpl.this.getErrDataKey(taskId).getBytes(), EXPIRE.longValue());
                                log.debug("************save errList:{}", (Object)errList);
                            }
                            return true;
                        }
                    });
                    ErpUploadServiceImpl.this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                        public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                            connection.setEx(ErpUploadServiceImpl.this.getStatusKey(taskId).getBytes(), EXPIRE.longValue(), UploadFileStatus.PROCESSED.getCode().toString().getBytes());
                            connection.setEx(ErpUploadServiceImpl.this.getErrDataSizeKey(taskId).getBytes(), EXPIRE.longValue(), String.valueOf(errList.size()).getBytes());
                            connection.setEx(ErpUploadServiceImpl.this.getValidDataSizeKey(taskId).getBytes(), EXPIRE.longValue(), String.valueOf(validList.size()).getBytes());
                            return true;
                        }
                    });
                }
                catch (Throwable t) {
                    log.error("upload student error!", t);
                    ErpUploadServiceImpl.this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                        public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                            connection.del((byte[][])new byte[][]{ErpUploadServiceImpl.this.getTaskKey(orgId).getBytes()});
                            return true;
                        }
                    });
                }
            }
        });
        return taskId;
    }

    @Override
    public void saveStudents(final String taskId) {
        final List<ImportStudent> importStudents = this.getValidStudentList(taskId);
        final Integer orgId = TianxiaoPCContext.getOrgId();
        if (orgId == null) {
            log.warn("saveStudents error!orgId is null");
            return;
        }
        this.threadPoolTaskExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ErpUploadServiceImpl.this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                        public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                            connection.setEx(ErpUploadServiceImpl.this.getStatusKey(taskId).getBytes(), EXPIRE.longValue(), UploadFileStatus.PROCESSING.getCode().toString().getBytes());
                            connection.setEx(ErpUploadServiceImpl.this.getTaskKey(orgId).getBytes(), EXPIRE.longValue(), "1".getBytes());
                            return true;
                        }
                    });
                    if (CollectionUtils.isNotEmpty((Collection)importStudents)) {
                        for (final ImportStudent importStudent : importStudents) {
                            try {
                                Integer insertCount;
                                List orgCourses = ErpUploadServiceImpl.this.orgCourseService.getAllOrgCourses(Long.valueOf(orgId.longValue()), importStudent.getCourseName().toString());
                                OrgCourse orgCourse = (OrgCourse)orgCourses.get(0);
                                List orgClassLessons = ErpUploadServiceImpl.this.orgClassLessonDao.querylessonsByStartTime(new Date(), orgCourse.getId(), Long.valueOf(orgId.longValue()));
                                List endLessons = ErpUploadServiceImpl.this.orgClassLessonDao.queryEndedlessons(orgCourse.getId(), Long.valueOf(orgId.longValue()));
                                if (CollectionUtils.isEmpty((Collection)orgClassLessons)) {
                                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5f53\u524d\u8bfe\u7a0b\u5df2\u6ca1\u6709\u672a\u5f00\u59cb\u8bfe\u8282");
                                }
                                StudentInfoDto orgStudent = null;
                                List dtos = ErpUploadServiceImpl.this.orgStudentService.listOrgStudentByMobile(Long.valueOf(orgId.longValue()), importStudent.getStudentMobile().toString());
                                if (CollectionUtils.isNotEmpty((Collection)dtos)) {
                                    for (StudentInfoDto dto : dtos) {
                                        if (!importStudent.getStudentMobile().equals(dto.getMobile()) || !importStudent.getStudentName().equals(dto.getName())) continue;
                                        log.debug("*************can find dto:{}", (Object)dto);
                                        orgStudent = dto;
                                    }
                                }
                                if (orgStudent == null) {
                                    orgStudent = new StudentInfoDto();
                                    orgStudent.setMobile(importStudent.getStudentMobile().toString());
                                    orgStudent.setName(importStudent.getStudentName().toString());
                                    orgStudent.setNextRemindTime(Long.valueOf(System.currentTimeMillis() - 300000L));
                                    OrgStudentAddresponseDto addDto = ErpUploadServiceImpl.this.orgStudentService.addStudentIgnoreExistMobile(orgStudent, null, null, Long.valueOf(orgId.longValue()));
                                    orgStudent.setStudentId(addDto.getUserId());
                                }
                                log.debug("**************orgStudent:{}", (Object)orgStudent);
                                OrgStudentCourse orgStudentCourse = ErpUploadServiceImpl.this.orgStudentCourseService.getBySidAndCid(Long.valueOf(orgId.longValue()), orgStudent.getStudentId(), orgCourse.getId());
                                if (orgStudentCourse == null) {
                                    orgStudentCourse = new OrgStudentCourse();
                                    orgStudentCourse.setCourseId(orgCourse.getId());
                                    orgStudentCourse.setCreateTime(new Date());
                                    orgStudentCourse.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
                                    orgStudentCourse.setOrgId(Long.valueOf(orgId.longValue()));
                                    orgStudentCourse.setStudentMobile(orgStudent.getMobile());
                                    orgStudentCourse.setStudentName(orgStudent.getName());
                                    orgStudentCourse.setUserId(orgStudent.getStudentId());
                                    orgStudentCourse.setStatus(Integer.valueOf(0));
                                    ErpUploadServiceImpl.this.orgStudentCourseService.saveOrgStudentCourse(orgStudentCourse);
                                }
                                if (orgStudentCourse.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()) {
                                    orgStudentCourse.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
                                    ErpUploadServiceImpl.this.orgStudentCourseService.updateOrgStudentCourse(orgStudentCourse);
                                }
                                if (orgStudentCourse.getStatus() != 0) {
                                    orgStudentCourse.setStatus(Integer.valueOf(0));
                                    ErpUploadServiceImpl.this.orgStudentCourseService.updateOrgStudentCourse(orgStudentCourse);
                                }
                                List orgStudentLessons = Lists.newArrayList();
                                if (importStudent.getInsertCount() == null && importStudent.getLessonCount() == null) {
                                    for (OrgClassLesson orgClassLesson : orgClassLessons) {
                                        OrgStudentLesson orgStudentLesson = new OrgStudentLesson();
                                        orgStudentLesson.setCreateTime(new Date());
                                        orgStudentLesson.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
                                        orgStudentLesson.setLessonId(orgClassLesson.getId());
                                        orgStudentLesson.setOrgId(Long.valueOf(orgId.longValue()));
                                        orgStudentLesson.setStudentMobile(orgStudent.getMobile());
                                        orgStudentLesson.setStudentName(orgStudent.getName());
                                        orgStudentLesson.setUserId(orgStudent.getStudentId());
                                        orgStudentLessons.add(orgStudentLesson);
                                    }
                                } else if (importStudent.getLessonCount() != null && importStudent.getInsertCount() == null) {
                                    Integer lessonCount = Integer.valueOf(importStudent.getLessonCount().toString());
                                    if (lessonCount >= orgClassLessons.size()) {
                                        for (OrgClassLesson orgClassLesson : orgClassLessons) {
                                            OrgStudentLesson orgStudentLesson = new OrgStudentLesson();
                                            orgStudentLesson.setCreateTime(new Date());
                                            orgStudentLesson.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
                                            orgStudentLesson.setLessonId(orgClassLesson.getId());
                                            orgStudentLesson.setOrgId(Long.valueOf(orgId.longValue()));
                                            orgStudentLesson.setStudentMobile(orgStudent.getMobile());
                                            orgStudentLesson.setStudentName(orgStudent.getName());
                                            orgStudentLesson.setUserId(orgStudent.getStudentId());
                                            orgStudentLessons.add(orgStudentLesson);
                                        }
                                    } else {
                                        for (int i = 0; i < lessonCount; ++i) {
                                            OrgClassLesson orgClassLesson = (OrgClassLesson)orgClassLessons.get(i);
                                            OrgStudentLesson orgStudentLesson = new OrgStudentLesson();
                                            orgStudentLesson.setCreateTime(new Date());
                                            orgStudentLesson.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
                                            orgStudentLesson.setLessonId(orgClassLesson.getId());
                                            orgStudentLesson.setOrgId(Long.valueOf(orgId.longValue()));
                                            orgStudentLesson.setStudentMobile(orgStudent.getMobile());
                                            orgStudentLesson.setStudentName(orgStudent.getName());
                                            orgStudentLesson.setUserId(orgStudent.getStudentId());
                                            orgStudentLessons.add(orgStudentLesson);
                                        }
                                    }
                                } else if (importStudent.getLessonCount() == null && importStudent.getInsertCount() != null) {
                                    insertCount = Integer.valueOf(importStudent.getInsertCount().toString());
                                    if (insertCount > endLessons.size()) {
                                        for (int point = insertCount - endLessons.size() - 1; point < orgClassLessons.size(); ++point) {
                                            OrgClassLesson orgClassLesson = (OrgClassLesson)orgClassLessons.get(point);
                                            OrgStudentLesson orgStudentLesson = new OrgStudentLesson();
                                            orgStudentLesson.setCreateTime(new Date());
                                            orgStudentLesson.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
                                            orgStudentLesson.setLessonId(orgClassLesson.getId());
                                            orgStudentLesson.setOrgId(Long.valueOf(orgId.longValue()));
                                            orgStudentLesson.setStudentMobile(orgStudent.getMobile());
                                            orgStudentLesson.setStudentName(orgStudent.getName());
                                            orgStudentLesson.setUserId(orgStudent.getStudentId());
                                            orgStudentLessons.add(orgStudentLesson);
                                        }
                                    } else {
                                        for (OrgClassLesson orgClassLesson : orgClassLessons) {
                                            OrgStudentLesson orgStudentLesson = new OrgStudentLesson();
                                            orgStudentLesson.setCreateTime(new Date());
                                            orgStudentLesson.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
                                            orgStudentLesson.setLessonId(orgClassLesson.getId());
                                            orgStudentLesson.setOrgId(Long.valueOf(orgId.longValue()));
                                            orgStudentLesson.setStudentMobile(orgStudent.getMobile());
                                            orgStudentLesson.setStudentName(orgStudent.getName());
                                            orgStudentLesson.setUserId(orgStudent.getStudentId());
                                            orgStudentLessons.add(orgStudentLesson);
                                        }
                                    }
                                } else if (importStudent.getLessonCount() != null && importStudent.getInsertCount() != null) {
                                    insertCount = Integer.valueOf(importStudent.getInsertCount().toString());
                                    Integer lessonCount = Integer.valueOf(importStudent.getLessonCount().toString());
                                    int start = 0;
                                    int end = lessonCount;
                                    if (insertCount > endLessons.size()) {
                                        start = insertCount - endLessons.size() - 1;
                                        end = lessonCount + start;
                                    }
                                    if (end > orgClassLessons.size()) {
                                        end = orgClassLessons.size();
                                    }
                                    while (start < end) {
                                        OrgClassLesson orgClassLesson = (OrgClassLesson)orgClassLessons.get(start);
                                        OrgStudentLesson orgStudentLesson = new OrgStudentLesson();
                                        orgStudentLesson.setCreateTime(new Date());
                                        orgStudentLesson.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
                                        orgStudentLesson.setLessonId(orgClassLesson.getId());
                                        orgStudentLesson.setOrgId(Long.valueOf(orgId.longValue()));
                                        orgStudentLesson.setStudentMobile(orgStudent.getMobile());
                                        orgStudentLesson.setStudentName(orgStudent.getName());
                                        orgStudentLesson.setUserId(orgStudent.getStudentId());
                                        orgStudentLessons.add(orgStudentLesson);
                                        ++start;
                                    }
                                }
                                if (!CollectionUtils.isNotEmpty((Collection)orgStudentLessons)) continue;
                                ErpUploadServiceImpl.this.orgStudentLessonDao.saveAll(orgStudentLessons, new String[0]);
                            }
                            catch (BussinessException be) {
                                log.warn("save importStudent error!,importStudent:{}", (Object)importStudent, (Object)be);
                                ErpUploadServiceImpl.this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                                    public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                                        importStudent.setErrReason(be.getMessage());
                                        ErpUploadServiceImpl.this.redisTemplate.opsForList().leftPush((Object)ErpUploadServiceImpl.this.getErrDataKey(taskId), (Object)JacksonUtil.obj2Str((Object)importStudent));
                                        connection.expire(ErpUploadServiceImpl.this.getErrDataKey(taskId).getBytes(), EXPIRE.longValue());
                                        connection.incr(ErpUploadServiceImpl.this.getErrDataSizeKey(taskId).getBytes());
                                        connection.expire(ErpUploadServiceImpl.this.getErrDataSizeKey(taskId).getBytes(), EXPIRE.longValue());
                                        connection.decr(ErpUploadServiceImpl.this.getValidDataSizeKey(taskId).getBytes());
                                        connection.expire(ErpUploadServiceImpl.this.getValidDataSizeKey(taskId).getBytes(), EXPIRE.longValue());
                                        return true;
                                    }
                                });
                            }
                            catch (Exception e) {
                                log.error("save importStudent error!,importStudent:{}", (Object)importStudent, (Object)e);
                                ErpUploadServiceImpl.this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                                    public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                                        importStudent.setErrReason("\u7cfb\u7edf\u65e0\u6cd5\u63d2\u5165\u6b64\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u5929\u6821\u5de5\u4f5c\u4eba\u5458\u4e3a\u60a8\u6392\u67e5");
                                        ErpUploadServiceImpl.this.redisTemplate.opsForList().leftPush((Object)ErpUploadServiceImpl.this.getErrDataKey(taskId), (Object)JacksonUtil.obj2Str((Object)importStudent));
                                        connection.expire(ErpUploadServiceImpl.this.getErrDataKey(taskId).getBytes(), EXPIRE.longValue());
                                        connection.incr(ErpUploadServiceImpl.this.getErrDataSizeKey(taskId).getBytes());
                                        connection.expire(ErpUploadServiceImpl.this.getErrDataSizeKey(taskId).getBytes(), EXPIRE.longValue());
                                        connection.decr(ErpUploadServiceImpl.this.getValidDataSizeKey(taskId).getBytes());
                                        connection.expire(ErpUploadServiceImpl.this.getValidDataSizeKey(taskId).getBytes(), EXPIRE.longValue());
                                        return true;
                                    }
                                });
                            }
                        }
                    }
                    ErpUploadServiceImpl.this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                        public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                            connection.setEx(ErpUploadServiceImpl.this.getStatusKey(taskId).getBytes(), EXPIRE.longValue(), UploadFileStatus.PROCESSED.getCode().toString().getBytes());
                            return true;
                        }
                    });
                }
                catch (Throwable t) {
                    try {
                        log.error("save couers error!", t);
                    }
                    catch (Throwable throwable) {
                        ErpUploadServiceImpl.this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                                connection.del((byte[][])new byte[][]{ErpUploadServiceImpl.this.getTaskKey(orgId).getBytes()});
                                return true;
                            }
                        });
                        throw throwable;
                    }
                    ErpUploadServiceImpl.this.redisTemplate.execute((RedisCallback)new /* invalid duplicate definition of identical inner class */);
                }
                ErpUploadServiceImpl.this.redisTemplate.execute((RedisCallback)new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    @Override
    public List<ImportStudent> getValidStudentList(final String taskId) {
        return (List)this.redisTemplate.execute((RedisCallback)new RedisCallback<List<ImportStudent>>(){

            public List<ImportStudent> doInRedis(RedisConnection connection) throws DataAccessException {
                List data = Lists.newArrayList();
                Long size = ErpUploadServiceImpl.this.redisTemplate.opsForList().size((Object)ErpUploadServiceImpl.this.getValidDataKey(taskId));
                if (size != null && size > 0L) {
                    int i = 0;
                    while ((long)i < size) {
                        try {
                            data.add(JacksonUtil.str2Obj((String)((String)ErpUploadServiceImpl.this.redisTemplate.opsForList().rightPop((Object)ErpUploadServiceImpl.this.getValidDataKey(taskId))), ImportStudent.class));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            log.error("getValidStudentList getValidList error!", (Throwable)e);
                        }
                        ++i;
                    }
                }
                log.debug("getValidList :{}", (Object)data);
                if (CollectionUtils.isNotEmpty((Collection)data)) {
                    for (ImportStudent importStudent : data) {
                        ErpUploadServiceImpl.this.redisTemplate.opsForList().leftPush((Object)ErpUploadServiceImpl.this.getValidDataKey(taskId), (Object)JacksonUtil.obj2Str((Object)importStudent));
                    }
                }
                connection.expire(ErpUploadServiceImpl.this.getValidDataKey(taskId).getBytes(), EXPIRE.longValue());
                return data;
            }
        });
    }

    @Override
    public List<ImportStudent> getInValidStudentList(final String taskId) {
        return (List)this.redisTemplate.execute((RedisCallback)new RedisCallback<List<ImportStudent>>(){

            public List<ImportStudent> doInRedis(RedisConnection connection) throws DataAccessException {
                List data = Lists.newArrayList();
                Long size = ErpUploadServiceImpl.this.redisTemplate.opsForList().size((Object)ErpUploadServiceImpl.this.getErrDataKey(taskId));
                if (size != null && size > 0L) {
                    int i = 0;
                    while ((long)i < size) {
                        try {
                            data.add(JacksonUtil.str2Obj((String)((String)ErpUploadServiceImpl.this.redisTemplate.opsForList().rightPop((Object)ErpUploadServiceImpl.this.getErrDataKey(taskId))), ImportStudent.class));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            log.error("getInValidStudentList getValidList error!", (Throwable)e);
                        }
                        ++i;
                    }
                }
                log.debug("getInValidStudentList:{}", (Object)data);
                if (CollectionUtils.isNotEmpty((Collection)data)) {
                    for (ImportStudent importStudent : data) {
                        ErpUploadServiceImpl.this.redisTemplate.opsForList().leftPush((Object)ErpUploadServiceImpl.this.getErrDataKey(taskId), (Object)JacksonUtil.obj2Str((Object)importStudent));
                    }
                }
                connection.expire(ErpUploadServiceImpl.this.getValidDataKey(taskId).getBytes(), EXPIRE.longValue());
                return data;
            }
        });
    }
}

