/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.dto.response.CourseListInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.WeiKeListInfoDto;
import com.baijia.tianxiao.biz.erp.service.ErpCourseListService;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dto.FieldShow;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.query.QueryCondition;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.course.dto.request.CourseListRequestDto;
import com.baijia.tianxiao.sal.course.dto.request.WeikeRequestDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.sal.course.service.OrgLessonSignService;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.CollectorUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErpCourseListServiceImpl
implements ErpCourseListService {
    private static final Logger log = LoggerFactory.getLogger(ErpCourseListServiceImpl.class);
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Resource
    private OrgCourseRoomDao orgCourseRoomDao;
    @Resource
    private OrgCourseListService orgCourseListService;
    @Resource
    private OrgLessonSignService orgLessonSignService;
    @Resource
    private CourseTeacherService courseTeacherService;
    @Resource
    private CourseStudentService courseStudentService;
    @Resource
    private TxCascadeCredentialService txCascadeCredentialService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;

    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (account == null) {
            return null;
        }
        Integer number = account.getNumber();
        return number != null ? Long.valueOf(number.longValue()) : null;
    }

    private Map<Long, List<String>> getTeachersOfCourses(Long orgId, Collection<Long> courseIds) {
        log.info("orgId={},courseIds={}", (Object)orgId, courseIds);
        HashMap resultMap = Maps.newHashMap();
        Map courseTeachersMap = this.orgCourseTeacherDao.getTeacherMap(courseIds);
        HashSet teacherIdsSet = Sets.newHashSet();
        for (Long key : courseTeachersMap.keySet()) {
            teacherIdsSet.addAll((Collection)courseTeachersMap.get(key));
        }
        List teacherDtoList = this.courseTeacherService.getTeachers((Collection)teacherIdsSet, orgId);
        Map teacherMap = CollectorUtil.collectMap((Collection)teacherDtoList, (Function)new Function<TeacherResponseDto, Long>(){

            public Long apply(TeacherResponseDto from) {
                return from.getTeacherId();
            }
        }, (Function)new Function<TeacherResponseDto, String>(){

            public String apply(TeacherResponseDto from) {
                return from.getTeacherName();
            }
        });
        for (Long courseId : courseIds) {
            List teacherIds = (List)courseTeachersMap.get(courseId);
            ArrayList teacherList = Lists.newArrayList();
            if (!CollectionUtils.isNotEmpty((Collection)teacherIds)) continue;
            for (Long tid : teacherIds) {
                teacherList.add(teacherMap.get(tid));
            }
            resultMap.put(courseId, teacherList);
        }
        log.debug("resultMap={}", (Object)resultMap);
        return resultMap;
    }

    @Override
    public List<WeiKeListInfoDto> getWeikeList(Long orgId, WeikeRequestDto requestDto) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"illegal orgId");
        List dtos = this.orgCourseListService.getWeikeList(orgId, requestDto);
        if (CollectionUtils.isEmpty((Collection)dtos)) {
            return Collections.emptyList();
        }
        Collection courseIds = CollectorUtil.collect((Collection)dtos, (Function)new Function<CourseListReponseDto, Long>(){

            public Long apply(CourseListReponseDto input) {
                return input.getOrgCourseId();
            }
        });
        Map stuCntMap = this.courseStudentService.getCourseStudentCntMap(orgId, courseIds, null);
        log.debug("org_id={},courseIds={},studentCntMap = {}", new Object[]{orgId, courseIds, stuCntMap});
        ArrayList responseDto = Lists.newArrayList();
        for (CourseListReponseDto courseListReponseDto : dtos) {
            WeiKeListInfoDto dto = new WeiKeListInfoDto();
            this.buildWeiKeListInfoDto(courseListReponseDto, dto, stuCntMap);
            responseDto.add(dto);
        }
        return responseDto;
    }

    private void buildWeiKeListInfoDto(CourseListReponseDto courseListReponseDto, WeiKeListInfoDto WeiKeListInfoDto2, Map<Long, Integer> stuCntMap) {
        WeiKeListInfoDto2.setCourseName(courseListReponseDto.getCourseName());
        WeiKeListInfoDto2.setCourseUrl(courseListReponseDto.getCourseUrl());
        WeiKeListInfoDto2.setCoverUrl(courseListReponseDto.getCoverUrl());
        WeiKeListInfoDto2.setMaxStudent(courseListReponseDto.getMaxStudent());
        WeiKeListInfoDto2.setOrgCourseId(courseListReponseDto.getOrgCourseId());
        WeiKeListInfoDto2.setStudentCount(stuCntMap.get(courseListReponseDto.getOrgCourseId()) == null ? 0 : stuCntMap.get(courseListReponseDto.getOrgCourseId()));
        WeiKeListInfoDto2.setPrice(courseListReponseDto.getPrice());
        WeiKeListInfoDto2.setStatus(courseListReponseDto.getStatus());
        WeiKeListInfoDto2.setCourseCount(courseListReponseDto.getFreq());
        WeiKeListInfoDto2.setIntroduction(courseListReponseDto.getIntroduction());
    }

    @Override
    public List<CourseListInfoDto> getCourseList(Long orgId, Date startTime, Date endTime, CourseListRequestDto params, PageDto pageDto) {
        Long orgNumber = this.getOrgNumber(orgId);
        String searchKey = params.getSearchKey();
        String teacherIds = params.getTeacherIds();
        String roomIds = params.getRoomIds();
        List roomCourseIds = null;
        HashSet roomIdSet = Sets.newHashSet();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{roomIds})) {
            String[] arr;
            for (String str : arr = roomIds.split(",")) {
                roomIdSet.add(Long.parseLong(str));
            }
            roomCourseIds = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)roomIdSet)) {
                roomCourseIds = this.orgCourseRoomDao.getcoursIdsByRoomIds((Collection)roomIdSet);
            }
        }
        List teacherCourseIds = null;
        HashSet teacherIdSet = Sets.newHashSet();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{teacherIds})) {
            String[] arr;
            for (String str : arr = teacherIds.split(",")) {
                teacherIdSet.add(Long.parseLong(str));
            }
            teacherCourseIds = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)teacherIdSet)) {
                teacherCourseIds = this.orgCourseTeacherDao.getCourseIdsByteacherIds((Collection)teacherIdSet);
            }
        }
        ArrayList courseIds = null;
        if (roomCourseIds == null && teacherCourseIds != null) {
            courseIds = new ArrayList();
            courseIds.addAll(teacherCourseIds);
        }
        if (teacherCourseIds == null && roomCourseIds != null) {
            courseIds = new ArrayList();
            courseIds.addAll(roomCourseIds);
        }
        if (teacherCourseIds != null && roomCourseIds != null) {
            courseIds = new ArrayList();
            for (Long tcId : teacherCourseIds) {
                for (Long rcid : roomCourseIds) {
                    if (tcId.longValue() != rcid.longValue()) continue;
                    courseIds.add(tcId);
                }
            }
        }
        OrgCourseDao.OrgCourseListParam param = new OrgCourseDao.OrgCourseListParam();
        param.setKey(searchKey);
        param.setStartTime(startTime);
        param.setEndTime(endTime);
        param.setPage(pageDto);
        param.setStatus(params.getStatus());
        param.setCascadeId(params.getCascadeId());
        Map fieldShowMap = FieldShow.getColumnShowMap(CourseListInfoDto.class);
        if (StringUtils.isNotBlank((CharSequence)params.getOrderField())) {
            FieldShow fieldShow = (FieldShow)fieldShowMap.get(params.getOrderField());
            String orderField = fieldShow != null ? fieldShow.getPoName() : null;
            param.setOrderField(orderField);
            param.setOrderType(params.getOrderType());
        }
        if (StringUtils.isBlank((CharSequence)params.getOrderField())) {
            param.setOrderField("createTime");
            param.setOrderType("DESC");
        }
        param.setQueryCondition(QueryCondition.andCondtions((Collection)params.getQueryConditions(), (Map)fieldShowMap));
        param.setIsDel(params.getIsDel());
        List courses = this.orgCourseDao.getCourseList(orgNumber, courseIds, param, new String[0]);
        List dtos = this.orgCourseListService.getCourseList(courses, orgId, true, false, true, Boolean.valueOf(true), true, true, true);
        log.debug("course List==={}", (Object)dtos);
        Map<Long, List<String>> courseTeachersMap = null;
        if (params.getLoadTeacherList() != null && params.getLoadTeacherList().booleanValue()) {
            courseIds = Lists.newArrayList();
            for (OrgCourse course : courses) {
                courseIds.add(course.getId());
            }
            courseTeachersMap = this.getTeachersOfCourses(orgId, courseIds);
        }
        Map cascadeMap = this.txCascadeCredentialService.getByTxCasCadeIds(orgId);
        ArrayList responseDto = Lists.newArrayList();
        for (CourseListReponseDto courseListReponseDto : dtos) {
            List<String> teachers;
            CourseListInfoDto dto = new CourseListInfoDto();
            this.buildCourseListInfoDto(courseListReponseDto, dto);
            if (courseTeachersMap != null && CollectionUtils.isNotEmpty(teachers = courseTeachersMap.get(courseListReponseDto.getOrgCourseId()))) {
                dto.setTeacherNames(StringUtils.join(teachers, (String)","));
            }
            dto.setCascadeIdStr((String)cascadeMap.get(dto.getCascadeId().longValue()));
            responseDto.add(dto);
        }
        return responseDto;
    }

    @Override
    public List<CourseListInfoDto> getCourseListWithAttendanceRate(Long orgId, String searchKey, PageDto pageDto) {
        Long orgNumber = this.getOrgNumber(orgId);
        List courses = null;
        if (TianxiaoMContext.getTXCascadeId() == null) {
            courses = this.orgCourseDao.getCourseList(orgNumber, null, searchKey, null, null, null, pageDto, new String[0]);
        } else {
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)TianxiaoMContext.getTXCascadeId(), new String[0]);
            if (txCascadeAccount == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b50\u5e10\u53f7\u4e0d\u5b58\u5728");
            }
            courses = txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue() ? this.orgCourseDao.getCourseList(txCascadeAccount.getId(), orgNumber, null, searchKey, null, null, null, pageDto, new String[0]) : this.orgCourseDao.getCourseList(orgNumber, null, searchKey, null, null, null, pageDto, new String[0]);
        }
        List<CourseListReponseDto> dtos = this.getCourseListWithAttendanceRate(courses, orgId);
        ArrayList responseDto = Lists.newArrayList();
        Map cascadeMap = this.txCascadeCredentialService.getByTxCasCadeIds(orgId);
        for (CourseListReponseDto courseListReponseDto : dtos) {
            CourseListInfoDto dto = new CourseListInfoDto();
            this.buildCourseListInfoDto(courseListReponseDto, dto);
            dto.setCascadeIdStr((String)cascadeMap.get(dto.getCascadeId()));
            responseDto.add(dto);
        }
        return responseDto;
    }

    private List<CourseListReponseDto> getCourseListWithAttendanceRate(List<OrgCourse> courses, Long orgId) {
        log.info("courses={},orgId={}", courses, (Object)orgId);
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId not valid!");
        if (CollectionUtils.isEmpty(courses)) {
            return Collections.emptyList();
        }
        List dtos = this.orgCourseListService.getCourseList(courses, orgId, true, false, false, Boolean.valueOf(true), false, false, false);
        ArrayList courseIds = Lists.newArrayList();
        for (OrgCourse course : courses) {
            courseIds.add(course.getId());
        }
        Map rateMap = this.orgLessonSignService.getAttendanceRateOfCourses(orgId, (Collection)courseIds);
        for (CourseListReponseDto dto : dtos) {
            Long courseId = dto.getOrgCourseId();
            Double attendanceRate = (Double)rateMap.get(courseId);
            if (attendanceRate != null) {
                dto.setAttendanceRate(attendanceRate);
                continue;
            }
            dto.setAttendanceRate(Double.valueOf(0.0));
        }
        return dtos;
    }

    private void buildCourseListInfoDto(CourseListReponseDto courseListReponseDto, CourseListInfoDto dto) {
        dto.setColor(courseListReponseDto.getColor());
        dto.setCourseName(courseListReponseDto.getCourseName());
        dto.setCourseUrl(courseListReponseDto.getCourseUrl());
        dto.setCoverUrl(courseListReponseDto.getCoverUrl());
        dto.setEndTime(courseListReponseDto.getEndTime());
        dto.setFreq(courseListReponseDto.getFreq());
        dto.setLessonCount(courseListReponseDto.getLessonCount());
        dto.setLessonFinish(courseListReponseDto.getLessonFinish());
        dto.setMaxStudent(courseListReponseDto.getMaxStudent());
        dto.setOrgCourseId(courseListReponseDto.getOrgCourseId());
        dto.setOrgCourseNumber(courseListReponseDto.getOrgCourseNumber());
        dto.setRoomCount(courseListReponseDto.getRoomCount());
        dto.setRoomNames(courseListReponseDto.getRoomNames());
        dto.setStudentNames(courseListReponseDto.getStudentNames());
        dto.setTeacherNames(courseListReponseDto.getTeacherNames());
        dto.setStartTime(courseListReponseDto.getStartTime());
        dto.setStudentCount(courseListReponseDto.getStudentCount());
        dto.setTeacherCount(courseListReponseDto.getTeacherCount());
        dto.setAttendanceRate(courseListReponseDto.getAttendanceRate());
        dto.setPrice(courseListReponseDto.getPrice());
        dto.setStatus(courseListReponseDto.getStatus());
        dto.setAddress(courseListReponseDto.getAddress());
        dto.setCreateTime(courseListReponseDto.getCreateTime());
        dto.setCascadeId(courseListReponseDto.getCascadeId());
        dto.setCutUrl(courseListReponseDto.getCutUrl());
        if (StringUtils.isNotBlank((CharSequence)courseListReponseDto.getCutUrl())) {
            dto.setCoverUrl(courseListReponseDto.getCutUrl());
        }
        dto.setCutInfo(courseListReponseDto.getCutInfo());
    }

    @Override
    public CourseListInfoDto getCourseDetail(Long orgId, Long orgCourseId) {
        CourseListReponseDto dto = this.orgCourseListService.getCourseDetail(orgId, orgCourseId);
        CourseListInfoDto courseListInfoDto = new CourseListInfoDto();
        this.buildCourseListInfoDto(dto, courseListInfoDto);
        return courseListInfoDto;
    }
}

