/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.service.ErpStudentService;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseStudentOpDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.signup.constant.SignupType;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.baijia.tianxiao.sal.signup.dto.SignupCourseInfoDto;
import com.baijia.tianxiao.sal.signup.dto.request.FillCourseInfoRequestDto;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ErpStudentServiceImpl
implements ErpStudentService {
    private static final Logger log = LoggerFactory.getLogger(ErpStudentServiceImpl.class);
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private SignupService signupService;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgCourseStudentOpDao orgCourseStudentStatusDao;
    @Resource
    private OrgCourseService orgCourseService;
    @Resource
    private CourseStudentService courseStudentService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrgCourseStudent(Long orgId, Long courseId, Collection<Long> studentIds, Collection<Header> headers, boolean doSignup) {
        if (CollectionUtils.isEmpty(studentIds)) {
            log.info("studentIds is empty");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751fID\u4e3a\u7a7a");
        }
        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(courseId, new String[0]);
        List orgStudents = this.orgStudentDao.getStudentByIds(orgId, studentIds, new String[0]);
        for (OrgStudent orgStudent : orgStudents) {
            OrgStudentCourse osc = this.orgStudentCourseDao.getStudentCourse(orgId, courseId, orgStudent.getUserId());
            if (osc == null) {
                OrgStudentCourse orgStudentCourse = new OrgStudentCourse();
                this.buildOrgStudentCourse(orgStudentCourse, orgStudent, courseId);
                orgStudentCourse.setStatus(Integer.valueOf(0));
                this.orgStudentCourseDao.save((Object)orgStudentCourse, new String[0]);
                if (!doSignup) continue;
                this.signUp(orgId, orgCourse, orgStudent.getId());
                continue;
            }
            osc.setStatus(Integer.valueOf(0));
            this.orgStudentCourseDao.update((Object)osc, new String[]{"status"});
            if (!doSignup) continue;
            this.signUp(orgId, orgCourse, orgStudent.getId());
        }
    }

    private void signUp(Long orgId, OrgCourse orgCourse, Long studentId) {
        ArrayList courseInfos = Lists.newArrayList();
        FillCourseInfoRequestDto signUpDto = new FillCourseInfoRequestDto();
        SignupCourseInfoDto courseInfo = new SignupCourseInfoDto();
        courseInfo.setCount(1);
        courseInfo.setDiscount(100);
        courseInfo.setCourseName(orgCourse.getName());
        courseInfo.setOrgCourseId(orgCourse.getId());
        courseInfo.setOrgCourseNumber(orgCourse.getNumber());
        courseInfo.setOriginPrice(orgCourse.getPrice());
        courseInfo.setPayPrice(orgCourse.getPrice());
        courseInfo.setPreferential(0.0);
        courseInfos.add(courseInfo);
        signUpDto.setCourseInfos((List)courseInfos);
        signUpDto.setOrgId(orgId);
        signUpDto.setSignupType(SignupType.FRONTED.getCode());
        OrgStudent student = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
        if (student == null || student.getDelStatus().intValue() != DeleteStatus.NORMAL.getValue()) {
            log.warn("student = null, orgId = {}, studentId = {}", (Object)orgId, (Object)studentId);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "studentId = " + studentId + " not found!");
        }
        signUpDto.setStudentMobile(student.getMobile());
        signUpDto.setStudentName(student.getName());
        log.debug("signUpDto = {}", (Object)signUpDto);
        this.signupService.signUp(signUpDto);
    }

    private void buildOrgStudentCourse(OrgStudentCourse orgStudentCourse, OrgStudent ttsStudent, @NonNull Long courseId) {
        if (courseId == null) {
            throw new NullPointerException("courseId");
        }
        orgStudentCourse.setCourseId(courseId);
        orgStudentCourse.setOrgId(ttsStudent.getOrgId());
        orgStudentCourse.setUserId(ttsStudent.getUserId());
        orgStudentCourse.setStudentMobile(MaskUtil.maskMobile((String)ttsStudent.getMobile()));
        if (StringUtils.isEmpty((String)ttsStudent.getName())) {
            orgStudentCourse.setStudentName("");
        } else {
            orgStudentCourse.setStudentName(ttsStudent.getName());
        }
        orgStudentCourse.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void transferOrgCourseStudent(@NonNull Long orgId, @NonNull Long studentId, @NonNull Long fromCourseId, @NonNull Long toCourseId, String cause, @NonNull Collection<Header> headers) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (studentId == null) {
            throw new NullPointerException("studentId");
        }
        if (fromCourseId == null) {
            throw new NullPointerException("fromCourseId");
        }
        if (toCourseId == null) {
            throw new NullPointerException("toCourseId");
        }
        if (headers == null) {
            throw new NullPointerException("headers");
        }
        this.courseStudentService.transferOrgCourseStudent(orgId, studentId, fromCourseId, toCourseId, cause);
        ArrayList studentIds = Lists.newArrayList();
        studentIds.add(studentId);
        this.addOrgCourseStudent(orgId, toCourseId, studentIds, headers, false);
    }
}

