/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.dto.response.CourseListInfoDto;
import com.baijia.tianxiao.biz.erp.service.ErpCourseListService;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.beust.jcommander.internal.Lists;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ErpCourseListServiceImpl
implements ErpCourseListService {
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Resource
    private OrgCourseRoomDao orgCourseRoomDao;
    @Resource
    private OrgCourseListService orgCourseListService;

    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (account == null) {
            return null;
        }
        Integer number = account.getNumber();
        return number != null ? Long.valueOf(number.longValue()) : null;
    }

    @Override
    public List<CourseListInfoDto> getCourseList(Long orgId, Date startTime, Date endTime, String searchKey, String teacherIds, String roomIds, PageDto pageDto) {
        Long orgNumber = this.getOrgNumber(orgId);
        List courses = this.orgCourseDao.getCourseList(orgNumber, searchKey, null, startTime, endTime, pageDto, new String[0]);
        List dtos = this.orgCourseListService.getCourseList(courses, orgId, true, false, true, Boolean.valueOf(true), true, false, true);
        List responseDto = Lists.newArrayList();
        for (CourseListReponseDto courseListReponseDto : dtos) {
            CourseListInfoDto dto = new CourseListInfoDto();
            this.buildCourseListInfoDto(courseListReponseDto, dto);
            responseDto.add(dto);
        }
        return responseDto;
    }

    private void buildCourseListInfoDto(CourseListReponseDto courseListReponseDto, CourseListInfoDto dto) {
        dto.setColor(courseListReponseDto.getColor());
        dto.setCourseName(courseListReponseDto.getCourseName());
        dto.setCourseUrl(courseListReponseDto.getCourseUrl());
        dto.setEndTime(courseListReponseDto.getEndTime());
        dto.setFreq(courseListReponseDto.getFreq());
        dto.setLessonCount(courseListReponseDto.getLessonCount());
        dto.setLessonFinish(courseListReponseDto.getLessonFinish());
        dto.setMaxStudent(courseListReponseDto.getMaxStudent());
        dto.setOrgCourseId(courseListReponseDto.getOrgCourseId());
        dto.setOrgCourseNumber(courseListReponseDto.getOrgCourseNumber());
        dto.setRoomCount(courseListReponseDto.getRoomCount());
        dto.setStartTime(courseListReponseDto.getStartTime());
        dto.setStudentCount(courseListReponseDto.getStudentCount());
        dto.setTeacherCount(courseListReponseDto.getTeacherCount());
    }

    @Override
    public CourseListInfoDto getCourseDetail(Long orgId, Long orgCourseId) {
        CourseListReponseDto dto = this.orgCourseListService.getCourseDetail(orgId, orgCourseId);
        CourseListInfoDto courseListInfoDto = new CourseListInfoDto();
        this.buildCourseListInfoDto(dto, courseListInfoDto);
        return courseListInfoDto;
    }
}

