/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.sync.impl;

import com.baijia.tianxiao.biz.erp.sync.SyncPayService;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.dal.finance.dao.TxFinanceInfoDao;
import com.baijia.tianxiao.dal.finance.po.TxxFinanceInfo;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgFinanceAccountRecordDao;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgFinanceAccountRecord;
import com.baijia.tianxiao.dal.signup.constant.SignupStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.statistic.dao.TxFinanceRecordDayDao;
import com.baijia.tianxiao.dal.statistic.dao.TxSignupRecordDayDao;
import com.baijia.tianxiao.dal.statistic.po.TxFinanceRecordDay;
import com.baijia.tianxiao.dal.statistic.po.TxSignupRecordDay;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpType;
import com.baijia.tianxiao.sal.signup.dto.request.SingupListRequestDto;
import com.baijia.tianxiao.util.date.DateUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="syncSignupRecordService")
public class SyncSignupRecordServiceImpl
implements SyncPayService {
    private static final Logger log = LoggerFactory.getLogger(SyncSignupRecordServiceImpl.class);
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;
    @Resource
    private TxSignupRecordDayDao txSignupRecordDayDao;
    @Resource
    private TxFinanceRecordDayDao txFinanceRecordDayDao;
    @Resource
    private OrgFinanceAccountRecordDao orgFinanceAccountRecordDao;
    @Resource
    private TxFinanceInfoDao txFinanceInfoDao;
    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;
    @Resource
    private CoursePurchaseDao coursePurchaseDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    private AtomicBoolean signupRecordFlag = new AtomicBoolean(false);

    @Override
    public void sync() {
        TxMsgSyncTimestamp syncInfo;
        block7: {
            syncInfo = this.getSyncInfo(MsgSyncType.CW_SIGNUP_RECORD);
            try {
                try {
                    if (!this.signupRecordFlag.get()) {
                        log.info("sync cw signuprecord info :{}", (Object)syncInfo);
                        this.signupRecordFlag.set(true);
                        this.syncSignupRecordDay(syncInfo);
                        this.signupRecordFlag.set(false);
                    } else {
                        log.warn("has not finish,skip");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("sync task error :{}", (Throwable)e);
                    this.signupRecordFlag.set(false);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.signupRecordFlag.set(false);
                throw throwable;
            }
            this.signupRecordFlag.set(false);
        }
        log.info("save sync info:{}", (Object)syncInfo);
        this.txMsgSyncTimestampDao.saveOrUpdate((Object)syncInfo, new String[0]);
    }

    private void syncSignupRecordDay(TxMsgSyncTimestamp syncInfo) {
        SingupListRequestDto requestDto = new SingupListRequestDto();
        requestDto.setSignupStatus(Integer.valueOf(SignupStatus.FINISHED.getCode()));
        List signupInfos = this.orgSignupInfoDao.getOrgSignupListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        log.info("save syncSignupRecordDay1:{} success", (Object)signupInfos.size());
        if (CollectionUtils.isNotEmpty((Collection)signupInfos)) {
            for (OrgSignupInfo orgSignupInfo : signupInfos) {
                try {
                    if (orgSignupInfo.getUpdateTime().after(syncInfo.getSyncTime())) {
                        syncInfo.setSyncTime(orgSignupInfo.getUpdateTime());
                    }
                    if (orgSignupInfo.getFinanceSync() == 1 || !requestDto.getSplitCodes().contains((int)orgSignupInfo.getSplitResult()) || !requestDto.getPurchaseStatusCodes().contains(orgSignupInfo.getPurchaseStatus().intValue())) continue;
                    this.saveSignupRecordDay(orgSignupInfo);
                    if (orgSignupInfo.getPayType().intValue() == PayType.CASH.getCode()) {
                        this.saveFinanceInfo(orgSignupInfo);
                        this.saveFinanceRecordDay(orgSignupInfo);
                    }
                    orgSignupInfo.setUpdateTime(orgSignupInfo.getUpdateTime());
                    orgSignupInfo.setFinanceSync(Integer.valueOf(1));
                    this.orgSignupInfoDao.update((Object)orgSignupInfo, new String[0]);
                }
                catch (Exception e) {
                    log.warn("sync finance record fail {}", (Throwable)e);
                }
            }
        }
    }

    private void saveFinanceInfo(OrgSignupInfo orgSignupInfo) {
        int opTo = 1;
        List orgSignupCourses = this.orgSignupCourseDao.loadByPurchaseId(orgSignupInfo.getSignupPurchaseId(), new String[0]);
        OrgFinanceAccountRecord orgFinanceAccountRecord = this.orgFinanceAccountRecordDao.currentAccount(orgSignupInfo.getOrgId(), orgSignupInfo.getCreateTime(), new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)orgSignupCourses)) {
            for (OrgSignupCourse orgSignupCourse : orgSignupCourses) {
                OrgCourse orgCourse = this.orgCourseDao.getByCourseId(orgSignupCourse.getOrgCourseId(), new String[0]);
                TxxFinanceInfo txFinanceInfo = new TxxFinanceInfo();
                txFinanceInfo.setOrgId(orgSignupInfo.getOrgId());
                txFinanceInfo.setCreateTime(orgSignupInfo.getPayTime());
                txFinanceInfo.setCurrBalance(Double.valueOf(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrBalance()));
                txFinanceInfo.setCurrFreezeMoney(Double.valueOf(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrFreezeMoney()));
                txFinanceInfo.setExpectedEarning(Double.valueOf(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrExpectedEarning()));
                txFinanceInfo.setOpMoney(Double.valueOf(orgSignupCourse.getPayPrice().doubleValue() / 100.0));
                txFinanceInfo.setOpType(FinanceOpType.BAOMING.getCode());
                txFinanceInfo.setPayType(orgSignupInfo.getPayType());
                txFinanceInfo.setPurchaseId("" + orgSignupInfo.getSignupPurchaseId());
                txFinanceInfo.setCourseId(orgCourse.getId());
                StringBuffer opinfo = new StringBuffer();
                opinfo.append(orgCourse != null ? orgCourse.getName() : "").append(" ");
                opinfo.append("\u5b66\u751f:").append(orgSignupInfo.getStudentName()).append(" ");
                txFinanceInfo.setOpInfo(opinfo.toString());
                txFinanceInfo.setOpTo(Integer.valueOf(opTo));
                log.debug("saveFinanceInfo={}", (Object)txFinanceInfo);
                this.txFinanceInfoDao.save((Object)txFinanceInfo, new String[0]);
            }
        }
    }

    private void saveFinanceRecordDay(OrgSignupInfo orgSignupInfo) {
        int opType = PayType.getCodeByPayType((int)orgSignupInfo.getPayType());
        int opTo = 1;
        String mdate = DateUtil.getStrByDate((Date)orgSignupInfo.getPayTime());
        List orgSignupCourses = this.orgSignupCourseDao.loadByPurchaseId(orgSignupInfo.getSignupPurchaseId(), new String[0]);
        TxFinanceRecordDay txFinanceRecordDay = this.txFinanceRecordDayDao.getByDayType(orgSignupInfo.getOrgId(), mdate, opType, opTo, new String[0]);
        if (txFinanceRecordDay == null) {
            txFinanceRecordDay = new TxFinanceRecordDay();
            txFinanceRecordDay.setOrgId(orgSignupInfo.getOrgId());
            txFinanceRecordDay.setMdate(orgSignupInfo.getPayTime());
            txFinanceRecordDay.setOpPrice(Double.valueOf(orgSignupInfo.getTotalPrices().doubleValue() / 100.0));
            txFinanceRecordDay.setOpType(Integer.valueOf(opType));
            txFinanceRecordDay.setOpTo(Integer.valueOf(opTo));
        } else {
            txFinanceRecordDay.setOpPrice(Double.valueOf(txFinanceRecordDay.getOpPrice() + orgSignupInfo.getTotalPrices().doubleValue() / 100.0));
        }
        txFinanceRecordDay.setOpCount(Integer.valueOf(txFinanceRecordDay.getOpCount() + (orgSignupCourses == null ? 0 : orgSignupCourses.size())));
        log.debug("saveFinanceRecordDay={}", (Object)txFinanceRecordDay);
        this.txFinanceRecordDayDao.saveOrUpdate((Object)txFinanceRecordDay, new String[0]);
    }

    private void saveSignupRecordDay(OrgSignupInfo orgSignupInfo) {
        int opType = orgSignupInfo.getSourceType();
        int opTo = 1;
        String mdate = DateUtil.getStrByDate((Date)orgSignupInfo.getPayTime());
        TxSignupRecordDay txSignupRecordDay = this.txSignupRecordDayDao.getByDayType(orgSignupInfo.getOrgId(), mdate, opType, opTo, new String[0]);
        if (txSignupRecordDay == null) {
            txSignupRecordDay = new TxSignupRecordDay();
            txSignupRecordDay.setOrgId(orgSignupInfo.getOrgId());
            txSignupRecordDay.setMdate(orgSignupInfo.getPayTime());
            txSignupRecordDay.setOpPrice(Double.valueOf(orgSignupInfo.getTotalPrices().doubleValue() / 100.0));
            txSignupRecordDay.setOpType(Integer.valueOf(opType));
            txSignupRecordDay.setOpTo(Integer.valueOf(opTo));
        } else {
            txSignupRecordDay.setOpPrice(Double.valueOf(txSignupRecordDay.getOpPrice() + orgSignupInfo.getTotalPrices().doubleValue() / 100.0));
        }
        List orgSignupCourses = this.orgSignupCourseDao.loadByPurchaseId(orgSignupInfo.getSignupPurchaseId(), new String[0]);
        for (OrgSignupCourse orgSignupCourse : orgSignupCourses) {
            CoursePurchase coursePurchase = this.coursePurchaseDao.getByPurcahseIdCourse(orgSignupCourse.getSignupPurchaseId(), orgSignupCourse.getOrgCourseId());
            if (coursePurchase == null) continue;
            txSignupRecordDay.setPoundage(Double.valueOf(txSignupRecordDay.getPoundage() + coursePurchase.getPoundage()));
        }
        txSignupRecordDay.setOpCount(Integer.valueOf(txSignupRecordDay.getOpCount() + (orgSignupCourses == null ? 0 : orgSignupCourses.size())));
        log.debug("saveSignupRecordDay={}", (Object)txSignupRecordDay);
        this.txSignupRecordDayDao.saveOrUpdate((Object)txSignupRecordDay, new String[0]);
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(Long.valueOf(0L));
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(Integer.valueOf(syncType.getSyncType()));
        }
        return syncInfo;
    }
}

