/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.sync.impl;

import com.baijia.tianxiao.biz.erp.sync.SyncPayService;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.dal.finance.dao.TxFinanceInfoDao;
import com.baijia.tianxiao.dal.finance.po.TxxFinanceInfo;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgFinanceAccountRecordDao;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgFinanceAccountRecord;
import com.baijia.tianxiao.dal.statistic.dao.TxFinanceRecordDayDao;
import com.baijia.tianxiao.dal.statistic.po.TxFinanceRecordDay;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="syncFinanceRecordService")
public class SyncFinanceRecordServiceImpl
implements SyncPayService {
    private static final Logger log = LoggerFactory.getLogger(SyncFinanceRecordServiceImpl.class);
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    @Resource
    private OrgFinanceAccountRecordDao orgFinanceAccountRecordDao;
    @Resource
    private TxFinanceInfoDao txFinanceInfoDao;
    @Resource
    private TxFinanceRecordDayDao txFinanceRecordDayDao;
    @Resource
    private CoursePurchaseDao coursePurchaseDao;
    private AtomicBoolean financeRecordFlag = new AtomicBoolean(false);

    @Override
    public void sync() {
        TxMsgSyncTimestamp syncInfo;
        block7: {
            syncInfo = this.getSyncInfo(MsgSyncType.CW_FINANCE_RECORD);
            try {
                try {
                    if (!this.financeRecordFlag.get()) {
                        log.info("sync cw financeRecord stat info :{}", (Object)syncInfo);
                        this.financeRecordFlag.set(true);
                        this.syncFinanceRecordDay(syncInfo);
                        this.financeRecordFlag.set(false);
                    } else {
                        log.warn("has not finish,skip");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("sync task error :{}", (Throwable)e);
                    this.financeRecordFlag.set(false);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.financeRecordFlag.set(false);
                throw throwable;
            }
            this.financeRecordFlag.set(false);
        }
        log.info("save sync info:{}", (Object)syncInfo);
        this.txMsgSyncTimestampDao.saveOrUpdate((Object)syncInfo, new String[0]);
    }

    private void syncFinanceRecordDay(TxMsgSyncTimestamp syncInfo) {
        List accountRecords = this.orgFinanceAccountRecordDao.getFinanceRecordListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        log.info("save syncFinanceRecordDay:{} success", (Object)accountRecords.size());
        if (CollectionUtils.isNotEmpty((Collection)accountRecords)) {
            for (OrgFinanceAccountRecord accountRecord : accountRecords) {
                try {
                    if (accountRecord.getId().longValue() > syncInfo.getSyncId()) {
                        syncInfo.setSyncId(Long.valueOf(accountRecord.getId().longValue()));
                    }
                    accountRecord.setPreBalance(Double.valueOf(NumberUtil.get2Double((double)(accountRecord.getPreBalance() == null ? 0.0 : accountRecord.getPreBalance()))));
                    accountRecord.setCurrBalance(Double.valueOf(NumberUtil.get2Double((double)(accountRecord.getCurrBalance() == null ? 0.0 : accountRecord.getCurrBalance()))));
                    accountRecord.setCurrFreezeMoney(Double.valueOf(NumberUtil.get2Double((double)(accountRecord.getCurrFreezeMoney() == null ? 0.0 : accountRecord.getCurrFreezeMoney()))));
                    accountRecord.setCurrExpectedEarning(Double.valueOf(NumberUtil.get2Double((double)(accountRecord.getCurrExpectedEarning() == null ? 0.0 : accountRecord.getCurrExpectedEarning()))));
                    accountRecord.setOpMoney(Double.valueOf(NumberUtil.get2Double((double)(accountRecord.getOpMoney() == null ? 0.0 : accountRecord.getOpMoney()))));
                    if (accountRecord.getIsShow() != 1 || accountRecord.getOpType() == 63 || accountRecord.getOpType() == 64 || !(accountRecord.getOpMoney() > 0.0)) continue;
                    this.saveFinanceInfo(accountRecord);
                    this.saveFinanceRecordDay(accountRecord);
                }
                catch (Exception e) {
                    log.warn("sync finance record fail {}", (Throwable)e);
                }
            }
        }
    }

    private void saveFinanceRecordDay(OrgFinanceAccountRecord accountRecord) {
        int payTypeCode = PayType.getCodeByPayType((String)accountRecord.getCurrPayType());
        int opTo = accountRecord.getOpDesc().equals("-") ? 2 : 1;
        String mdate = DateUtil.getStrByDate((Date)accountRecord.getCreateTime());
        TxFinanceRecordDay txFinanceRecordDay = this.txFinanceRecordDayDao.getByDayType(accountRecord.getOrgId(), mdate, payTypeCode, opTo, new String[0]);
        if (txFinanceRecordDay == null) {
            txFinanceRecordDay = new TxFinanceRecordDay();
            txFinanceRecordDay.setOrgId(accountRecord.getOrgId());
            txFinanceRecordDay.setMdate((Date)accountRecord.getCreateTime());
            txFinanceRecordDay.setOpCount(Integer.valueOf(1));
            txFinanceRecordDay.setOpPrice(accountRecord.getOpMoney());
            txFinanceRecordDay.setOpType(Integer.valueOf(payTypeCode));
            txFinanceRecordDay.setOpTo(Integer.valueOf(opTo));
        } else {
            txFinanceRecordDay.setOpPrice(Double.valueOf(txFinanceRecordDay.getOpPrice() + accountRecord.getOpMoney()));
            txFinanceRecordDay.setOpCount(Integer.valueOf(txFinanceRecordDay.getOpCount() + 1));
        }
        log.debug("saveFinanceRecordDay={}", (Object)txFinanceRecordDay);
        this.txFinanceRecordDayDao.saveOrUpdate((Object)txFinanceRecordDay, new String[0]);
    }

    private void saveFinanceInfo(OrgFinanceAccountRecord accountRecord) {
        int payTypeCode = PayType.getCodeByPayType((String)accountRecord.getCurrPayType());
        int opTo = accountRecord.getOpDesc().equals("-") ? 2 : 1;
        CoursePurchase coursePurchase = null;
        if (accountRecord != null && accountRecord.getPurchaseId() != null) {
            coursePurchase = this.coursePurchaseDao.getByPurcahseId(accountRecord.getPurchaseId());
        }
        TxxFinanceInfo txFinanceInfo = new TxxFinanceInfo();
        txFinanceInfo.setOrgId(accountRecord.getOrgId());
        txFinanceInfo.setCreateTime((Date)accountRecord.getCreateTime());
        txFinanceInfo.setCurrBalance(accountRecord.getCurrBalance());
        txFinanceInfo.setCurrFreezeMoney(accountRecord.getCurrFreezeMoney());
        txFinanceInfo.setExpectedEarning(accountRecord.getCurrExpectedEarning());
        txFinanceInfo.setOpMoney(accountRecord.getOpMoney());
        txFinanceInfo.setOpType(accountRecord.getOpType());
        txFinanceInfo.setPayType(Integer.valueOf(payTypeCode));
        txFinanceInfo.setPurchaseId("" + accountRecord.getPurchaseId());
        txFinanceInfo.setOpInfo(accountRecord.getOpInfo());
        txFinanceInfo.setOpTo(Integer.valueOf(opTo));
        if (coursePurchase != null) {
            txFinanceInfo.setCourseId(coursePurchase.getCourseId());
        }
        log.debug("saveFinanceInfo={}", (Object)txFinanceInfo);
        this.txFinanceInfoDao.save((Object)txFinanceInfo, new String[0]);
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(Long.valueOf(0L));
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(Integer.valueOf(syncType.getSyncType()));
        }
        return syncInfo;
    }
}

