/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.commons.lang.utils.JacksonUtil;
import com.baijia.tianxiao.biz.erp.service.ErpSignupService;
import com.baijia.tianxiao.biz.erp.teacherCenter.service.ExcelCourseExportService;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.excel.dto.ExportField;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSignupListDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSingupInfoDto;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ErpSignupServiceImpl
implements ErpSignupService {
    private static final Logger log = LoggerFactory.getLogger(ErpSignupServiceImpl.class);

    @Override
    public void export(HttpServletResponse response, Long orgId, OrgSignupListDto datas, String fileName) {
        Preconditions.checkArgument((datas.getList() != null ? 1 : 0) != 0, (Object)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        List list = datas.getList();
        try {
            log.debug("signuplistDto={}", (Object)JacksonUtil.obj2Str((Object)list));
        }
        catch (Exception e) {
            log.debug("" + e);
        }
        SXSSFWorkbook workbook = null;
        try {
            try {
                workbook = new SXSSFWorkbook(1000);
                HashMap<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>();
                ArrayList summaryFields = Lists.newArrayList();
                summaryFields.add(new ExportField("\u59d3\u540d", "@", 5120));
                summaryFields.add(new ExportField("\u624b\u673a\u53f7", "@", 5120));
                summaryFields.add(new ExportField("\u603b\u4ef7", "@", 5120));
                summaryFields.add(new ExportField("\u6536\u8d39\u9879\u76ee", "@", 5120));
                summaryFields.add(new ExportField("\u5e94\u6536\u91d1\u989d", "@", 5120));
                summaryFields.add(new ExportField("\u5b9e\u6536\u91d1\u989d", "@", 5120));
                summaryFields.add(new ExportField("\u4e1a\u52a1\u65e5\u671f", "@", 5120));
                summaryFields.add(new ExportField("\u62a5\u540d\u72b6\u6001", "@", 5120));
                ArrayList titles = Lists.newArrayList();
                titles.add("\u62a5\u540d\u8bb0\u5f55");
                log.debug("signupload download titile={},size={}", (Object)titles, (Object)list.size());
                ExcelCourseExportService.createSignupSheet((Workbook)workbook, "\u62a5\u540d\u8bb0\u5f55", titles, cellStyleMap, summaryFields, list);
                ExcelCourseExportService.exportExcel(response, (Workbook)workbook, fileName);
            }
            catch (Exception var20) {
                log.warn("export catch exception:", (Throwable)var20);
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u51fa\u6570\u636e\u5904\u7406\u5f02\u5e38");
            }
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException var19) {
                log.warn("close workbook catch error:", (Throwable)var19);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        String json = FileUtils.readFileToString((File)new File("/Users/wengshengli/Downloads/response1.json"));
        List dtoList = JacksonUtil.str2List((String)json, OrgSingupInfoDto.class);
        SXSSFWorkbook workbook = new SXSSFWorkbook(1000);
        HashMap<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>();
        ArrayList summaryFields = Lists.newArrayList();
        summaryFields.add(new ExportField("\u59d3\u540d", "@", 5120));
        summaryFields.add(new ExportField("\u624b\u673a\u53f7", "@", 5120));
        summaryFields.add(new ExportField("\u603b\u4ef7", "@", 5120));
        summaryFields.add(new ExportField("\u6536\u8d39\u9879\u76ee", "@", 5120));
        summaryFields.add(new ExportField("\u5e94\u6536\u91d1\u989d", "@", 5120));
        summaryFields.add(new ExportField("\u5b9e\u6536\u91d1\u989d", "@", 5120));
        summaryFields.add(new ExportField("\u4e1a\u52a1\u65e5\u671f", "@", 5120));
        ArrayList titles = Lists.newArrayList();
        titles.add("\u62a5\u540d\u8bb0\u5f55");
        System.out.println(dtoList.size());
        ExcelCourseExportService.createSignupSheet((Workbook)workbook, "\u62a5\u540d\u8bb0\u5f55", titles, cellStyleMap, summaryFields, dtoList);
        File excelFile = new File("/Users/wengshengli/Documents/test1.xlsx");
        workbook.write((OutputStream)new FileOutputStream(excelFile));
    }
}

