/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.dto.response.studentCenter;

import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;

public class StudentCenterLessonListDto {
    private Date firstLessonStartTime = null;
    private Date lastLessonStartTime = null;
    private List<InfoDay> list = Lists.newArrayList();

    public void addLessonInfo(Date startTime, Date endTime, Integer lessonId, Integer index, String courseName, String teacherName, String roomName, Integer status, Integer signStatus, Integer commentStatus) {
        int dayDiff = 1;
        if (this.lastLessonStartTime != null) {
            dayDiff = DateUtil.getDateDiff((Date)startTime, (Date)startTime);
        }
        if (dayDiff > 0) {
            InfoDay infoDay = new InfoDay();
            infoDay.setDate(startTime);
            infoDay.getLessons().add(this.buildLessonInfo(startTime, endTime, lessonId, index, courseName, teacherName, roomName, status, signStatus, commentStatus));
            this.list.add(infoDay);
        } else if (dayDiff == 0) {
            InfoDay infoDay = this.list.get(this.list.size() - 1);
            infoDay.getLessons().add(this.buildLessonInfo(startTime, endTime, lessonId, index, courseName, teacherName, roomName, status, signStatus, commentStatus));
        } else {
            throw new IllegalArgumentException("startTime \u5fc5\u987b\u6309\u65f6\u95f4\u9012\u589e\u987a\u5e8f");
        }
        if (this.firstLessonStartTime == null || this.firstLessonStartTime.getTime() > startTime.getTime()) {
            this.firstLessonStartTime = startTime;
        }
        if (this.lastLessonStartTime == null || this.lastLessonStartTime.getTime() < startTime.getTime()) {
            this.lastLessonStartTime = startTime;
        }
    }

    public LessonInfo buildLessonInfo(Date startTime, Date endTime, Integer lessonId, Integer index, String courseName, String teacherName, String roomName, Integer status, Integer signStatus, Integer commentStatus) {
        LessonInfo lessonInfo = new LessonInfo();
        lessonInfo.setStartAndEndTime(startTime, endTime);
        lessonInfo.setLessonId(lessonId);
        lessonInfo.setIndex(index);
        lessonInfo.setCourseName(courseName);
        lessonInfo.setTeacherName(teacherName);
        lessonInfo.setRoomName(roomName);
        lessonInfo.setStatus(commentStatus);
        lessonInfo.setSignStatus(signStatus);
        lessonInfo.setCommentStatus(commentStatus);
        return lessonInfo;
    }

    public Date getFirstLessonStartTime() {
        return this.firstLessonStartTime;
    }

    public Date getLastLessonStartTime() {
        return this.lastLessonStartTime;
    }

    public List<InfoDay> getList() {
        return this.list;
    }

    public void setFirstLessonStartTime(Date firstLessonStartTime) {
        this.firstLessonStartTime = firstLessonStartTime;
    }

    public void setLastLessonStartTime(Date lastLessonStartTime) {
        this.lastLessonStartTime = lastLessonStartTime;
    }

    public void setList(List<InfoDay> list) {
        this.list = list;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StudentCenterLessonListDto)) {
            return false;
        }
        StudentCenterLessonListDto other = (StudentCenterLessonListDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Date this$firstLessonStartTime = this.getFirstLessonStartTime();
        Date other$firstLessonStartTime = other.getFirstLessonStartTime();
        if (this$firstLessonStartTime == null ? other$firstLessonStartTime != null : !((Object)this$firstLessonStartTime).equals(other$firstLessonStartTime)) {
            return false;
        }
        Date this$lastLessonStartTime = this.getLastLessonStartTime();
        Date other$lastLessonStartTime = other.getLastLessonStartTime();
        if (this$lastLessonStartTime == null ? other$lastLessonStartTime != null : !((Object)this$lastLessonStartTime).equals(other$lastLessonStartTime)) {
            return false;
        }
        List<InfoDay> this$list = this.getList();
        List<InfoDay> other$list = other.getList();
        return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StudentCenterLessonListDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Date $firstLessonStartTime = this.getFirstLessonStartTime();
        result = result * 59 + ($firstLessonStartTime == null ? 43 : ((Object)$firstLessonStartTime).hashCode());
        Date $lastLessonStartTime = this.getLastLessonStartTime();
        result = result * 59 + ($lastLessonStartTime == null ? 43 : ((Object)$lastLessonStartTime).hashCode());
        List<InfoDay> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        return result;
    }

    public String toString() {
        return "StudentCenterLessonListDto(firstLessonStartTime=" + this.getFirstLessonStartTime() + ", lastLessonStartTime=" + this.getLastLessonStartTime() + ", list=" + this.getList() + ")";
    }

    public static class InfoDay {
        private String date;
        private Integer weekDay;
        private List<LessonInfo> lessons = Lists.newArrayList();

        public void setDate(Date date) {
            this.weekDay = DateUtil.getWeekDay((Date)date);
            this.date = DateUtil.getStrByDateFormate((Date)date, (String)"yyyy-MM-dd");
        }

        public String getDate() {
            return this.date;
        }

        public Integer getWeekDay() {
            return this.weekDay;
        }

        public List<LessonInfo> getLessons() {
            return this.lessons;
        }

        public void setWeekDay(Integer weekDay) {
            this.weekDay = weekDay;
        }

        public void setLessons(List<LessonInfo> lessons) {
            this.lessons = lessons;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InfoDay)) {
                return false;
            }
            InfoDay other = (InfoDay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$date = this.getDate();
            String other$date = other.getDate();
            if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
                return false;
            }
            Integer this$weekDay = this.getWeekDay();
            Integer other$weekDay = other.getWeekDay();
            if (this$weekDay == null ? other$weekDay != null : !((Object)this$weekDay).equals(other$weekDay)) {
                return false;
            }
            List<LessonInfo> this$lessons = this.getLessons();
            List<LessonInfo> other$lessons = other.getLessons();
            return !(this$lessons == null ? other$lessons != null : !((Object)this$lessons).equals(other$lessons));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InfoDay;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : $date.hashCode());
            Integer $weekDay = this.getWeekDay();
            result = result * 59 + ($weekDay == null ? 43 : ((Object)$weekDay).hashCode());
            List<LessonInfo> $lessons = this.getLessons();
            result = result * 59 + ($lessons == null ? 43 : ((Object)$lessons).hashCode());
            return result;
        }

        public String toString() {
            return "StudentCenterLessonListDto.InfoDay(date=" + this.getDate() + ", weekDay=" + this.getWeekDay() + ", lessons=" + this.getLessons() + ")";
        }
    }

    public static class LessonInfo {
        private Date startTime;
        private Date endTime;
        private Integer lessonId;
        private Integer index;
        private String courseName;
        private String teacherName;
        private String roomName;
        private Integer status = 0;
        private Integer commentTimeout = 0;
        private Integer signStatus = 0;
        private Integer commentStatus = 0;

        public void setStartAndEndTime(Date startTime, Date endTime) {
            Date now = new Date();
            this.endTime = endTime;
            this.startTime = startTime;
            this.commentTimeout = DateUtil.getDateDiff((Date)now, (Date)endTime) > 7 ? Integer.valueOf(1) : Integer.valueOf(0);
            this.status = endTime.before(now) ? Integer.valueOf(0) : (endTime.after(now) && startTime.before(now) ? Integer.valueOf(1) : Integer.valueOf(2));
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public Integer getLessonId() {
            return this.lessonId;
        }

        public Integer getIndex() {
            return this.index;
        }

        public String getCourseName() {
            return this.courseName;
        }

        public String getTeacherName() {
            return this.teacherName;
        }

        public String getRoomName() {
            return this.roomName;
        }

        public Integer getStatus() {
            return this.status;
        }

        public Integer getCommentTimeout() {
            return this.commentTimeout;
        }

        public Integer getSignStatus() {
            return this.signStatus;
        }

        public Integer getCommentStatus() {
            return this.commentStatus;
        }

        public void setStartTime(Date startTime) {
            this.startTime = startTime;
        }

        public void setEndTime(Date endTime) {
            this.endTime = endTime;
        }

        public void setLessonId(Integer lessonId) {
            this.lessonId = lessonId;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        public void setCourseName(String courseName) {
            this.courseName = courseName;
        }

        public void setTeacherName(String teacherName) {
            this.teacherName = teacherName;
        }

        public void setRoomName(String roomName) {
            this.roomName = roomName;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public void setCommentTimeout(Integer commentTimeout) {
            this.commentTimeout = commentTimeout;
        }

        public void setSignStatus(Integer signStatus) {
            this.signStatus = signStatus;
        }

        public void setCommentStatus(Integer commentStatus) {
            this.commentStatus = commentStatus;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LessonInfo)) {
                return false;
            }
            LessonInfo other = (LessonInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Date this$startTime = this.getStartTime();
            Date other$startTime = other.getStartTime();
            if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
                return false;
            }
            Date this$endTime = this.getEndTime();
            Date other$endTime = other.getEndTime();
            if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
                return false;
            }
            Integer this$lessonId = this.getLessonId();
            Integer other$lessonId = other.getLessonId();
            if (this$lessonId == null ? other$lessonId != null : !((Object)this$lessonId).equals(other$lessonId)) {
                return false;
            }
            Integer this$index = this.getIndex();
            Integer other$index = other.getIndex();
            if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
                return false;
            }
            String this$courseName = this.getCourseName();
            String other$courseName = other.getCourseName();
            if (this$courseName == null ? other$courseName != null : !this$courseName.equals(other$courseName)) {
                return false;
            }
            String this$teacherName = this.getTeacherName();
            String other$teacherName = other.getTeacherName();
            if (this$teacherName == null ? other$teacherName != null : !this$teacherName.equals(other$teacherName)) {
                return false;
            }
            String this$roomName = this.getRoomName();
            String other$roomName = other.getRoomName();
            if (this$roomName == null ? other$roomName != null : !this$roomName.equals(other$roomName)) {
                return false;
            }
            Integer this$status = this.getStatus();
            Integer other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
                return false;
            }
            Integer this$commentTimeout = this.getCommentTimeout();
            Integer other$commentTimeout = other.getCommentTimeout();
            if (this$commentTimeout == null ? other$commentTimeout != null : !((Object)this$commentTimeout).equals(other$commentTimeout)) {
                return false;
            }
            Integer this$signStatus = this.getSignStatus();
            Integer other$signStatus = other.getSignStatus();
            if (this$signStatus == null ? other$signStatus != null : !((Object)this$signStatus).equals(other$signStatus)) {
                return false;
            }
            Integer this$commentStatus = this.getCommentStatus();
            Integer other$commentStatus = other.getCommentStatus();
            return !(this$commentStatus == null ? other$commentStatus != null : !((Object)this$commentStatus).equals(other$commentStatus));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LessonInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Date $startTime = this.getStartTime();
            result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
            Date $endTime = this.getEndTime();
            result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
            Integer $lessonId = this.getLessonId();
            result = result * 59 + ($lessonId == null ? 43 : ((Object)$lessonId).hashCode());
            Integer $index = this.getIndex();
            result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
            String $courseName = this.getCourseName();
            result = result * 59 + ($courseName == null ? 43 : $courseName.hashCode());
            String $teacherName = this.getTeacherName();
            result = result * 59 + ($teacherName == null ? 43 : $teacherName.hashCode());
            String $roomName = this.getRoomName();
            result = result * 59 + ($roomName == null ? 43 : $roomName.hashCode());
            Integer $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
            Integer $commentTimeout = this.getCommentTimeout();
            result = result * 59 + ($commentTimeout == null ? 43 : ((Object)$commentTimeout).hashCode());
            Integer $signStatus = this.getSignStatus();
            result = result * 59 + ($signStatus == null ? 43 : ((Object)$signStatus).hashCode());
            Integer $commentStatus = this.getCommentStatus();
            result = result * 59 + ($commentStatus == null ? 43 : ((Object)$commentStatus).hashCode());
            return result;
        }

        public String toString() {
            return "StudentCenterLessonListDto.LessonInfo(startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", lessonId=" + this.getLessonId() + ", index=" + this.getIndex() + ", courseName=" + this.getCourseName() + ", teacherName=" + this.getTeacherName() + ", roomName=" + this.getRoomName() + ", status=" + this.getStatus() + ", commentTimeout=" + this.getCommentTimeout() + ", signStatus=" + this.getSignStatus() + ", commentStatus=" + this.getCommentStatus() + ")";
        }
    }
}

