/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.dashboard.sync.impl;

import com.baijia.tianxiao.biz.dashboard.sync.SyncDataService;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.dao.TxOrgCourseStatDao;
import com.baijia.tianxiao.dal.sync.dao.TxOrgCourseStatHourDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.dal.sync.po.TxOrgCourseStat;
import com.baijia.tianxiao.dal.sync.po.TxOrgCourseStatHour;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="syncStatPVService")
public class SyncStatPVServiceImpl
implements SyncDataService {
    private static final Logger log = LoggerFactory.getLogger(SyncStatPVServiceImpl.class);
    @Resource
    private TxOrgCourseStatDao txOrgCourseStatDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private TxOrgCourseStatHourDao txOrgCourseStatHourDao;
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    private AtomicBoolean orgCourseStatFlag = new AtomicBoolean(false);
    private AtomicBoolean wxIndexStatFlag = new AtomicBoolean(false);

    @Override
    public void sync() {
        this.syncTask(MsgSyncType.STAT_ORG_COURSE_PV, this.orgCourseStatFlag);
        this.syncTask(MsgSyncType.STAT_WX_INDEX_PV, this.wxIndexStatFlag);
    }

    private void syncTask(MsgSyncType syncType, AtomicBoolean flag) {
        TxMsgSyncTimestamp syncInfo;
        block10: {
            syncInfo = this.getSyncInfo(syncType);
            if (flag.get()) {
                log.warn("last sync is not complete");
                return;
            }
            flag.set(true);
            try {
                try {
                    switch (syncType) {
                        case STAT_ORG_COURSE_PV: {
                            this.syncOrgCourseStat(syncInfo);
                            break;
                        }
                        case STAT_WX_INDEX_PV: {
                            this.syncWxIndexStat(syncInfo);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    log.error("catch error:", (Throwable)e);
                    flag.set(false);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                flag.set(false);
                throw throwable;
            }
            flag.set(false);
        }
        log.info("save sync info:{}", (Object)syncInfo);
        this.txMsgSyncTimestampDao.saveOrUpdate((Object)syncInfo, new String[0]);
    }

    private void syncOrgCourseStat(TxMsgSyncTimestamp syncInfo) {
        List list = this.txOrgCourseStatHourDao.getListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 500, new String[0]);
        log.info("save TxOrgCourseStatHour size :{}", (Object)list.size());
        for (TxOrgCourseStatHour dto : list) {
            OrgCourse orgCourse;
            if (dto.getId() > syncInfo.getSyncId()) {
                syncInfo.setSyncId(dto.getId());
            }
            if ((orgCourse = this.orgCourseDao.getByCourseNumber(dto.getNumber(), new String[0])) == null) continue;
            TxOrgCourseStat orgCourseStat = this.txOrgCourseStatDao.getOrgAndCourseNumber(orgCourse.getOrgNumber(), orgCourse.getNumber(), new String[0]);
            if (orgCourseStat == null) {
                orgCourseStat = new TxOrgCourseStat();
                orgCourseStat.setCourseNumber(orgCourse.getNumber());
                orgCourseStat.setOrgNumber(orgCourse.getOrgNumber());
                orgCourseStat.setCourseName(orgCourse.getName());
                orgCourseStat.setPv(dto.getPv());
                orgCourseStat.setUv(dto.getUv());
            } else {
                orgCourseStat.setPv(Integer.valueOf(orgCourseStat.getPv() + dto.getPv()));
                orgCourseStat.setUv(Integer.valueOf(orgCourseStat.getUv() + dto.getUv()));
            }
            this.txOrgCourseStatDao.saveOrUpdate((Object)orgCourseStat, new String[0]);
        }
    }

    private void syncWxIndexStat(TxMsgSyncTimestamp syncInfo) {
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(Long.valueOf(0L));
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(Integer.valueOf(syncType.getSyncType()));
        }
        return syncInfo;
    }
}

