/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.dashboard.sync.impl;

import com.baijia.commons.lang.utils.JacksonUtil;
import com.baijia.tianxiao.biz.dashboard.dto.GalaxyResponseDto;
import com.baijia.tianxiao.biz.dashboard.sync.SyncDataService;
import com.baijia.tianxiao.dal.sync.dao.TxOrgCourseStatHourDao;
import com.baijia.tianxiao.dal.sync.po.TxOrgCourseStatHour;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="syncGalaxyDataService")
public class SyncGalaxyDataServiceImpl
implements SyncDataService {
    private static final Logger log = LoggerFactory.getLogger(SyncGalaxyDataServiceImpl.class);
    @Resource
    private TxOrgCourseStatHourDao txOrgCourseStatHourDao;
    private AtomicBoolean orgCourseFlag = new AtomicBoolean(false);
    private AtomicBoolean wxIndexFlag = new AtomicBoolean(false);

    @Override
    public void sync() {
        this.syncTask(1, this.orgCourseFlag);
        this.syncTask(2, this.wxIndexFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void syncTask(int type, AtomicBoolean flag) {
        if (flag.get()) {
            log.warn("last sync is not complete");
            return;
        }
        flag.set(true);
        try {
            switch (type) {
                case 1: {
                    this.syncOrgCourse();
                    return;
                }
                case 2: {
                    this.syncWxIndex();
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            log.error("catch error:", (Throwable)e);
            return;
        }
        finally {
            flag.set(false);
        }
    }

    private void syncOrgCourse() {
        block4: {
            HashMap params = Maps.newHashMap();
            params.put("app_id", "12abed26a7");
            params.put("database", "default");
            StringBuilder sb = new StringBuilder("");
            Date lastHourDate = DateUtil.getLastHourDate();
            String pt = DateUtil.getDayStr((Date)lastHourDate);
            String hour = DateUtil.getHour((Date)lastHourDate);
            sb.append("select request_path_key number, count(*) pv, count(distinct session_id) uv from base_log_data where ");
            sb.append("pt='").append(pt).append("' ");
            sb.append("and hour='").append(hour).append("' ");
            sb.append("and request_path_type = '").append("org_class_course").append("' ");
            sb.append("group by request_path_key");
            params.put("query", sb.toString());
            log.info("query params = {}", (Object)params);
            try {
                String result = HttpClientUtils.doJsonPost((String)"http://galaxy-api.baijiahulian.com/query.json", (Map)params, (String)"UTF-8");
                GalaxyResponseDto galaxyResponseDto = (GalaxyResponseDto)((Object)JacksonUtil.str2Obj((String)result, GalaxyResponseDto.class));
                log.info("galaxyResponseDto={}", (Object)galaxyResponseDto);
                if (galaxyResponseDto.getCode() == 0) {
                    if (galaxyResponseDto.getRows() != null && galaxyResponseDto.getRows().size() > 0) {
                        this.txOrgCourseStatHourDao.saveAll(this.changeWithPtHour(galaxyResponseDto.getRows(), pt, hour), new String[0]);
                    }
                    break block4;
                }
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "GALAXY\u670d\u52a1\u67e5\u8be2\u9519\u8bef," + galaxyResponseDto.getMessage());
            }
            catch (Exception e) {
                log.error("GALAXY\u670d\u52a1\u63a5\u53e3\u5f02\u5e38,{}", (Throwable)e);
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "GALAXY\u670d\u52a1\u63a5\u53e3\u5f02\u5e38");
            }
        }
    }

    private List<TxOrgCourseStatHour> changeWithPtHour(List<TxOrgCourseStatHour> list, String pt, String hour) {
        ArrayList<TxOrgCourseStatHour> result = new ArrayList<TxOrgCourseStatHour>();
        for (TxOrgCourseStatHour one : list) {
            if (one.getNumber() == null) continue;
            one.setPt(pt);
            one.setHour(hour);
            result.add(one);
        }
        log.info("save txOrgCourseStatHour size is {}", (Object)result.size());
        return result;
    }

    private void syncWxIndex() {
    }
}

