/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.dashboard.sync.impl;

import com.baijia.tianxiao.biz.dashboard.sync.SyncDataService;
import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.constants.signup.SplitCourseResult;
import com.baijia.tianxiao.dal.im.dao.ImMessageInfoDao;
import com.baijia.tianxiao.dal.im.po.ImMessageInfo;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.dao.MessageDao;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.roster.constant.ConsultUserStatus;
import com.baijia.tianxiao.dal.roster.constant.ConsulterStatus;
import com.baijia.tianxiao.dal.roster.constant.EncrollmentTypeEnum;
import com.baijia.tianxiao.dal.roster.constant.IntentionLevel;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxConsultSourceStatisticMonthDao;
import com.baijia.tianxiao.dal.sync.dao.TxConsultUserStatMonthDao;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxConsultSourceStatisticMonth;
import com.baijia.tianxiao.dal.sync.po.TxConsultUserStatMonth;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.statistics.TxConsultSourceStatisticMonthService;
import com.baijia.tianxiao.sal.statistics.TxConsultStatMonthService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import com.beust.jcommander.internal.Lists;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="syncConsultStatService")
public class SyncConsultStatServiceImpl
implements SyncDataService {
    private static final Logger log = LoggerFactory.getLogger(SyncConsultStatServiceImpl.class);
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    @Resource
    private MessageDao messageDao;
    @Resource
    private ImMessageInfoDao imMessageInfoDao;
    @Resource
    private TxConsultStatMonthService txConsultStatMonthService;
    @Resource
    private TxConsultUserStatMonthDao txConsultUserStatMonthDao;
    @Resource
    private OrgSignupInfoDao orgSingupInfoDao;
    @Resource
    private TxConsultUserDao txConsultUserDao;
    @Resource
    private OrgAccountService orgAccountService;
    @Resource
    private CoursePurchaseDao coursePurchaseDao;
    @Resource
    private UserDao userDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Autowired
    private TxConsultSourceStatisticMonthDao txConsultSourceStatisticMonthDao;
    @Autowired
    private TxConsultSourceStatisticMonthService txConsultSourceStatisticMonthService;
    @Resource
    private TXCascadeAccountDao txCascadeAccountDao;
    private AtomicBoolean msgFlag = new AtomicBoolean(false);
    private AtomicBoolean imFlag = new AtomicBoolean(false);
    private AtomicBoolean consultUserFlag = new AtomicBoolean(false);
    private AtomicBoolean signFlag = new AtomicBoolean(false);
    private AtomicBoolean purchase3810Flag = new AtomicBoolean(false);

    @Override
    @Transactional
    public void sync() {
        this.syncTask(MsgSyncType.CONSULT_MSG_STAT, this.msgFlag);
        this.syncTask(MsgSyncType.MESSAGE_RECORD_SOURCE, this.msgFlag);
        this.syncTask(MsgSyncType.CONSULT_USER_SOURCE, this.consultUserFlag);
        this.syncTask(MsgSyncType.CONSULT_USER_STAT, this.consultUserFlag);
        this.syncTask(MsgSyncType.CONSULT_SIGNUP_STAT, this.signFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncTask(MsgSyncType syncType, AtomicBoolean flag) {
        TxMsgSyncTimestamp syncInfo = this.getSyncInfo(syncType);
        try {
            if (!flag.get()) {
                log.info("sync consult stat info :{}", (Object)syncInfo);
                flag.set(true);
                switch (syncType) {
                    case CONSULT_MSG_STAT: {
                        this.syncConsultMessage(syncInfo);
                        break;
                    }
                    case CONSULT_IM_STAT: {
                        this.syncImMessageInfo(syncInfo);
                        break;
                    }
                    case CONSULT_USER_STAT: {
                        this.syncConsultUserInfo(syncInfo);
                        this.syncConsultUserByUpdate(syncInfo);
                        break;
                    }
                    case CONSULT_SIGNUP_STAT: {
                        this.syncSignupInfoByUpdate(syncInfo);
                        break;
                    }
                    case CONSULT_3810_PURCHASE_STAT: {
                        this.syncPurchase3810Info(syncInfo);
                        break;
                    }
                    case MESSAGE_RECORD_SOURCE: {
                        this.syncSouceByConsultMessage(syncInfo);
                        break;
                    }
                    case CONSULT_USER_SOURCE: {
                        this.syncSouceByConsultUser(syncInfo);
                        break;
                    }
                }
                flag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", (Throwable)e);
        }
        finally {
            flag.set(false);
        }
        log.info("save sync info:{}", (Object)syncInfo);
        this.txMsgSyncTimestampDao.saveOrUpdate((Object)syncInfo, new String[0]);
    }

    private void syncSouceByConsultMessage(TxMsgSyncTimestamp syncInfo) {
        List consultMessages = this.messageDao.getOrgStudentMessageListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[]{"senderId", "receiverId", "receiverRole", "consultType"});
        log.info("[SysConsultMessage] save consultMessages:{} success", (Object)consultMessages.size());
        if (CollectionUtils.isNotEmpty((Collection)consultMessages)) {
            for (ConsultMessage consultMessage : consultMessages) {
                if (consultMessage.getId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(Long.valueOf(consultMessage.getId()));
                }
                TxConsultSourceStatisticMonth txConsultSourceStatisticMonth = this.txConsultSourceStatisticMonthDao.getTxConsultSourceStatisticMonthBySource(consultMessage.getOrgId(), Long.valueOf(consultMessage.getSenderId()), Integer.valueOf(consultMessage.getConsultType()), DateUtil.getFirstDate((Date)new Date()), DateUtil.getNextMonthFirstDate((Date)new Date()));
                log.info("[SysConsultMessage] txConsultSourceStatisticMonth param:{}", (Object)txConsultSourceStatisticMonth);
                TxConsultUser txConsultUser = new TxConsultUser();
                if (consultMessage.getSenderId() == 0L) {
                    txConsultUser.setOrgId(Long.valueOf(consultMessage.getReceiverId()));
                    txConsultUser.setConsultSource(Integer.valueOf(consultMessage.getConsultType()));
                    this.txConsultUserDao.save((Object)txConsultUser, new String[0]);
                } else {
                    txConsultUser = (TxConsultUser)this.txConsultUserDao.getById((Serializable)Long.valueOf(consultMessage.getSenderId()), new String[0]);
                }
                if (txConsultSourceStatisticMonth == null) {
                    Long id = this.txConsultSourceStatisticMonthService.saveTxConsultSourceStatisticMonth(consultMessage.getOrgId(), Long.valueOf(consultMessage.getSenderId()), Integer.valueOf(consultMessage.getConsultType()), Integer.valueOf(1));
                    log.info("[SysConsultMessage] save souceStatistic txConsultSourceStatisticMonthId param:{}, orgId param:{}, consultId param:{}", new Object[]{id, consultMessage.getOrgId(), consultMessage.getSenderId(), consultMessage.getConsultType()});
                    continue;
                }
                log.info("[SysConsultMessage] update souceStatistic txConsultSourceStatisticMonth param:{}", (Object)txConsultSourceStatisticMonth);
                if ((consultMessage.getConsultType() == MessageSource.WECHAT.getValue() || consultMessage.getConsultType() == MessageSource.ONLINE_IM.getValue()) && DateUtil.isToday((Date)txConsultSourceStatisticMonth.getUpdateTime())) continue;
                txConsultSourceStatisticMonth.setNumber(Integer.valueOf(txConsultSourceStatisticMonth.getNumber() + 1));
                txConsultSourceStatisticMonth.setUpdateTime(new Date());
                this.txConsultSourceStatisticMonthDao.update((Object)txConsultSourceStatisticMonth, new String[0]);
                log.info("[SysConsultMessage] update souceStatistic param:{}", (Object)txConsultSourceStatisticMonth);
            }
        }
    }

    private void syncSouceByConsultUser(TxMsgSyncTimestamp syncInfo) {
        List consultUsers = this.txConsultUserDao.getOrgConsultUserListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        log.info("[SysnConsultUser] save consultUser size:{} success", (Object)consultUsers.size());
        if (CollectionUtils.isNotEmpty((Collection)consultUsers)) {
            for (TxConsultUser consultUser : consultUsers) {
                TxConsultSourceStatisticMonth txConsultSourceStatisticMonth;
                if (consultUser.getId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(consultUser.getId());
                }
                if ((txConsultSourceStatisticMonth = this.txConsultSourceStatisticMonthDao.getTxConsultSourceStatisticMonthBySource(consultUser.getOrgId(), consultUser.getId(), consultUser.getConsultSource(), DateUtil.getFirstDate((Date)new Date()), DateUtil.getNextMonthFirstDate((Date)new Date()))) != null || consultUser.getIsConsulter().intValue() != ConsulterStatus.IS.getValue()) continue;
                this.txConsultSourceStatisticMonthService.saveTxConsultSourceStatisticMonth(consultUser.getOrgId(), consultUser.getId(), consultUser.getConsultSource(), Integer.valueOf(1));
            }
        }
    }

    private void syncConsultMessage(TxMsgSyncTimestamp syncInfo) {
        List consultMessages = this.messageDao.getOrgStudentMessageListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[]{"senderId", "receiverId", "receiverRole", "consultType"});
        log.info("[SysConsultMessage] save consultMessages:{} success", (Object)consultMessages.size());
        if (CollectionUtils.isNotEmpty((Collection)consultMessages)) {
            for (ConsultMessage consultMessage : consultMessages) {
                log.info("[SysConsultMessage] messageId:{}", (Object)consultMessage.getId());
                if (consultMessage.getId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(Long.valueOf(consultMessage.getId()));
                }
                log.info("[SysConsultMessage] consultMessages param:{}", (Object)consultMessage);
                TxConsultUserStatMonth txConsultUserStatMonth = this.txConsultUserStatMonthDao.getTxConsultStatByQuery(consultMessage.getOrgId().longValue(), consultMessage.getSenderId(), 0L, null, DateUtil.getFirstDate((Date)new Date()), DateUtil.getNextMonthFirstDate((Date)new Date()));
                log.info("[SysConsultMessage] txConsultUserStatMonth param:{}, consultMessage param:{}", (Object)txConsultUserStatMonth, (Object)consultMessage);
                TxConsultUser txConsultUser = new TxConsultUser();
                if (consultMessage.getSenderId() == 0L) {
                    log.info("[SysConsultMessage] \u8bbf\u95ee\u8005\u7684senderId=0, txConsultUserStatMonth param:{}", (Object)txConsultUserStatMonth);
                    txConsultUser.setOrgId(Long.valueOf(consultMessage.getReceiverId()));
                    txConsultUser.setConsultSource(Integer.valueOf(consultMessage.getConsultType()));
                    this.txConsultUserDao.save((Object)txConsultUser, new String[0]);
                } else {
                    txConsultUser = (TxConsultUser)this.txConsultUserDao.getById((Serializable)Long.valueOf(consultMessage.getSenderId()), new String[0]);
                }
                OrgStudent orgStudent = this.getOrgStudentByConsultUser(txConsultUser);
                if (txConsultUserStatMonth != null) continue;
                long userId = txConsultUser == null ? 0L : txConsultUser.getUserId();
                Integer status = EncrollmentTypeEnum.WULEIXING.getValue();
                if (orgStudent == null && ConsulterStatus.NOT.getValue() == txConsultUser.getIsConsulter().intValue()) {
                    status = EncrollmentTypeEnum.ZIXUN.getValue();
                }
                this.txConsultStatMonthService.saveStat(txConsultUser.getOrgId().longValue(), txConsultUser.getId().longValue(), userId, status.intValue(), null, null);
            }
        }
    }

    private void syncImMessageInfo(TxMsgSyncTimestamp syncInfo) {
        List messageInfos = this.imMessageInfoDao.getOrgStudentInfoListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        log.info("save messageInfos:{} success", (Object)messageInfos.size());
        if (CollectionUtils.isNotEmpty((Collection)messageInfos)) {
            for (ImMessageInfo msgInfo : messageInfos) {
                User user;
                OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(Integer.valueOf(msgInfo.getReceiver().intValue()));
                if (orgAccount == null || (user = this.userDao.getByNumber(msgInfo.getSender(), new String[0])) == null) continue;
                msgInfo.setReceiver(Long.valueOf(orgAccount.getId().intValue()));
                msgInfo.setSender(user.getId());
                Date startDate = DateUtil.getFirstDate((Date)new Date());
                Date endDate = DateUtil.getNextMonthFirstDate((Date)new Date());
                TxConsultUserStatMonth txConsultUserStatMonth = this.txConsultUserStatMonthDao.getTxConsultStatByQuery(msgInfo.getReceiver().longValue(), 0L, msgInfo.getSender().longValue(), Integer.valueOf(MessageSource.ONLINE_IM.getValue()), startDate, endDate);
                if (msgInfo.getMsgId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(msgInfo.getMsgId());
                }
                List txConsultUserList = this.txConsultUserDao.lookByUserId(msgInfo.getReceiver(), msgInfo.getSender(), new String[0]);
                long consultUserId = 0L;
                if (txConsultUserList != null && txConsultUserList.size() > 0) {
                    consultUserId = ((TxConsultUser)txConsultUserList.get(0)).getId();
                }
                if (txConsultUserStatMonth == null) {
                    this.txConsultStatMonthService.saveStat(msgInfo.getReceiver().longValue(), consultUserId, msgInfo.getSender().longValue(), EncrollmentTypeEnum.ZIXUN.getValue(), Integer.valueOf(MessageSource.ONLINE_IM.getValue()), Integer.valueOf(1));
                    continue;
                }
                if (DateUtil.isToday((Date)txConsultUserStatMonth.getUpdateTime())) continue;
                txConsultUserStatMonth.setConsultUserId(Long.valueOf(consultUserId));
                txConsultUserStatMonth.setUserId(msgInfo.getSender());
                txConsultUserStatMonth.setNumber(Integer.valueOf(txConsultUserStatMonth.getNumber() + 1));
                txConsultUserStatMonth.setUpdateTime(new Date());
                log.debug("syncImMessageInfo update {}", (Object)txConsultUserStatMonth);
                this.txConsultUserStatMonthDao.update((Object)txConsultUserStatMonth, new String[0]);
            }
        }
    }

    private void syncConsultUserByUpdate(TxMsgSyncTimestamp syncInfo) {
        List consultUsers = this.txConsultUserDao.getOrgConsultUserListByUpdateTime(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)consultUsers)) {
            for (TxConsultUser consultUser : consultUsers) {
                Integer status;
                TxConsultUserStatMonth txConsultUserStatMonth = this.txConsultUserStatMonthDao.getTxConsultStatByQuery(consultUser.getOrgId().longValue(), consultUser.getId().longValue(), 0L, null, DateUtil.getFirstDate((Date)new Date()), DateUtil.getNextMonthFirstDate((Date)new Date()));
                log.info("[SysnConsultUser] txConsultUserStatMonth param:{}, consultUser param:{}", (Object)txConsultUserStatMonth, (Object)consultUser);
                if (consultUser.getUpdateTime().after(syncInfo.getSyncTime())) {
                    syncInfo.setSyncTime(consultUser.getUpdateTime());
                }
                OrgStudent orgStudent = this.getOrgStudentByConsultUser(consultUser);
                if (txConsultUserStatMonth != null) {
                    status = txConsultUserStatMonth.getStatus();
                    status = this.getStatusByConsultUser(status, consultUser, orgStudent, DateUtil.getFirstDate((Date)new Date()));
                    txConsultUserStatMonth.setStatus(status);
                    txConsultUserStatMonth.setUpdateTime(new Date());
                    this.txConsultUserStatMonthDao.update((Object)txConsultUserStatMonth, new String[0]);
                    log.info("[SysnConsultUser] txConsultUserStatMonth param:{}, consultUserId param:{}, status param:{}", (Object)txConsultUserStatMonth, (Object)consultUser);
                    continue;
                }
                status = EncrollmentTypeEnum.WULEIXING.getValue();
                status = this.getStatusByConsultUser(status, consultUser, orgStudent, DateUtil.getStartOfDay((Date)new Date()));
                this.txConsultStatMonthService.saveStat(consultUser.getOrgId().longValue(), consultUser.getId().longValue(), consultUser.getUserId().longValue(), status.intValue(), null, null);
                log.info("[SysnConsultUser] save  txConsultStatMonthService,orgId param:{}, consultUserId param:{}, status param:{}", new Object[]{consultUser.getOrgId(), consultUser.getId(), status});
            }
        }
    }

    private void syncConsultUserInfo(TxMsgSyncTimestamp syncInfo) {
        List consultUsers = this.txConsultUserDao.getOrgConsultUserListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        log.info("[SysnConsultUser] save consultUser size:{} success", (Object)consultUsers.size());
        if (CollectionUtils.isNotEmpty((Collection)consultUsers)) {
            for (TxConsultUser consultUser : consultUsers) {
                Integer status;
                Date startDate = DateUtil.getFirstDate((Date)new Date());
                TxConsultUserStatMonth txConsultUserStatMonth = this.txConsultUserStatMonthDao.getTxConsultStatByQuery(consultUser.getOrgId().longValue(), consultUser.getId().longValue(), 0L, null, DateUtil.getFirstDate((Date)new Date()), DateUtil.getNextMonthFirstDate((Date)new Date()));
                if (consultUser.getId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(consultUser.getId());
                }
                OrgStudent orgStudent = this.getOrgStudentByConsultUser(consultUser);
                if (txConsultUserStatMonth == null) {
                    status = EncrollmentTypeEnum.WULEIXING.getValue();
                    status = this.getStatusByConsultUser(status, consultUser, orgStudent, startDate);
                    this.txConsultStatMonthService.saveStat(consultUser.getOrgId().longValue(), consultUser.getId().longValue(), consultUser.getUserId().longValue(), status.intValue(), null, null);
                    log.info("[SysnConsultUser] save  txConsultStatMonthService, consultUserId param:{}, status param:{}", (Object)consultUser.getId(), (Object)status);
                    continue;
                }
                status = txConsultUserStatMonth.getStatus();
                status = this.getStatusByConsultUser(status, consultUser, orgStudent, DateUtil.getFirstDate((Date)new Date()));
                txConsultUserStatMonth.setStatus(status);
                txConsultUserStatMonth.setUpdateTime(new Date());
                this.txConsultUserStatMonthDao.update((Object)txConsultUserStatMonth, new String[0]);
            }
        }
    }

    private void syncSignupInfo(TxMsgSyncTimestamp syncInfo) {
        List signupInfos = this.orgSingupInfoDao.getOrgSignupListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        log.info(" \u62a5\u540d save signupInfos:{} success", (Object)signupInfos.size());
        if (CollectionUtils.isNotEmpty((Collection)signupInfos)) {
            for (OrgSignupInfo signupInfo : signupInfos) {
                log.info("signupInfo =============== param:{}", (Object)signupInfo);
                if (signupInfo.getUserId() == 0L) continue;
                Date startDate = DateUtil.getFirstDate((Date)new Date());
                Date endDate = DateUtil.getNextMonthFirstDate((Date)new Date());
                TxConsultUserStatMonth txConsultUserStatMonth = this.txConsultUserStatMonthDao.getTxConsultStatByQuery(signupInfo.getOrgId().longValue(), 0L, signupInfo.getUserId().longValue(), null, startDate, endDate);
                if (signupInfo.getId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(signupInfo.getId());
                }
                this.setSyncTxConsultUserStatMonthByOrgSignupInfo(signupInfo, txConsultUserStatMonth);
            }
        }
    }

    private void syncSignupInfoByUpdate(TxMsgSyncTimestamp syncInfo) {
        List signupInfos = this.orgSingupInfoDao.getOrgSignupListByUpdate(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        log.info("[SysnSignupInfo] signupInfos by updateTime:{} success", (Object)signupInfos.size());
        if (CollectionUtils.isNotEmpty((Collection)signupInfos)) {
            for (OrgSignupInfo signupInfo : signupInfos) {
                if (signupInfo.getUserId() == 0L) continue;
                TxConsultUserStatMonth txConsultUserStatMonth = this.txConsultUserStatMonthDao.getTxConsultStatByQuery(signupInfo.getOrgId().longValue(), 0L, signupInfo.getUserId().longValue(), null, DateUtil.getFirstDate((Date)new Date()), DateUtil.getNextMonthFirstDate((Date)new Date()));
                log.info("[SysnSignupInfo] signupInfo param:{}, txConsultUserStatMonth param:{}", (Object)signupInfo, (Object)txConsultUserStatMonth);
                if (signupInfo.getUpdateTime().after(syncInfo.getSyncTime())) {
                    syncInfo.setSyncTime(signupInfo.getUpdateTime());
                }
                this.setSyncTxConsultUserStatMonthByOrgSignupInfo(signupInfo, txConsultUserStatMonth);
            }
        }
    }

    private void setSyncTxConsultUserStatMonthByOrgSignupInfo(OrgSignupInfo signupInfo, TxConsultUserStatMonth txConsultUserStatMonth) {
        OrgStudent orgStudent = this.orgStudentDao.getStudentByUserId(signupInfo.getOrgId(), signupInfo.getUserId(), new String[0]);
        if (orgStudent != null && orgStudent.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue()) {
            long consultUserId = this.getConsultId(signupInfo, orgStudent);
            if (txConsultUserStatMonth == null) {
                int status = EncrollmentTypeEnum.WULEIXING.getValue();
                List SPLIT_CODES_FINISHED = Lists.newArrayList((Object[])new Integer[]{SplitCourseResult.FAIL.getCode(), SplitCourseResult.PENDING.getCode(), SplitCourseResult.SUCCESS.getCode()});
                int del = signupInfo.getIsDel();
                int purchaseStatus = signupInfo.getPurchaseStatus();
                if (del == 0 && SPLIT_CODES_FINISHED.contains(signupInfo.getSplitResult()) && purchaseStatus == PayResult.SUCCESS.getCode()) {
                    status = EncrollmentTypeEnum.BAOMING.getValue();
                }
                this.txConsultStatMonthService.saveStat(signupInfo.getOrgId().longValue(), consultUserId, signupInfo.getUserId().longValue(), status, null, null);
            } else {
                int status = txConsultUserStatMonth.getStatus();
                List SPLIT_CODES_FINISHED = Lists.newArrayList((Object[])new Integer[]{SplitCourseResult.FAIL.getCode(), SplitCourseResult.PENDING.getCode(), SplitCourseResult.SUCCESS.getCode()});
                int del = signupInfo.getIsDel();
                int purchaseStatus = signupInfo.getPurchaseStatus();
                if (del == 0 && SPLIT_CODES_FINISHED.contains(signupInfo.getSplitResult()) && purchaseStatus == PayResult.SUCCESS.getCode()) {
                    status = EncrollmentTypeEnum.BAOMING.getValue();
                }
                txConsultUserStatMonth.setConsultUserId(Long.valueOf(consultUserId));
                txConsultUserStatMonth.setUserId(signupInfo.getUserId());
                txConsultUserStatMonth.setUpdateTime(new Date());
                txConsultUserStatMonth.setStatus(Integer.valueOf(status));
                log.debug("syncSignupInfo update :{}", (Object)txConsultUserStatMonth);
                this.txConsultUserStatMonthDao.update((Object)txConsultUserStatMonth, new String[0]);
            }
        } else {
            log.info("[SysnSignupInfo] \u5b66\u5458\u4e0d\u5b58\u5728 orgStudent:{}", (Object)orgStudent);
            return;
        }
    }

    private long getConsultId(OrgSignupInfo signupInfo, OrgStudent orgStudent) {
        long consultUserId = 0L;
        List txConsultUserList = this.txConsultUserDao.lookByMobile(signupInfo.getOrgId(), signupInfo.getMobile(), new String[0]);
        OrgStudent student = this.orgStudentDao.getStudentByMobileAndOrgId(signupInfo.getOrgId(), signupInfo.getMobile(), new String[]{"id", "name", "delStatus", "weixin"});
        if (CollectionUtils.isEmpty((Collection)txConsultUserList) && student != null && StringUtils.isNotEmpty((CharSequence)student.getWeixin())) {
            txConsultUserList = this.txConsultUserDao.lookByParams(signupInfo.getOrgId(), student.getWeixin(), new String[0]);
        }
        log.info("[SysnSignupInfo] txConsultUserList param:{}", (Object)txConsultUserList);
        if (txConsultUserList != null && txConsultUserList.size() > 0) {
            TxConsultUser consultUser = (TxConsultUser)txConsultUserList.get(0);
            if (consultUser.getStudentId() <= 0L) {
                consultUser.setStudentId(orgStudent.getId());
                consultUser.setUpdateTime(new Date());
                log.info("[SysnSignupInfo] \u7ebf\u7d22consultId:{} sysn studentId:{}", (Object)consultUser.getId(), (Object)orgStudent.getId());
                this.txConsultUserDao.update((Object)consultUser, new String[]{"studentId", "updateTime"});
            }
            consultUserId = consultUser.getId();
        } else {
            TxConsultUser txConsultUser = this.getTxConsultUser(signupInfo, orgStudent.getId());
            this.txConsultUserDao.save((Object)txConsultUser, new String[0]);
            consultUserId = txConsultUser.getId();
            log.info("[SysnSignupInfo] \u65b0\u63d2txConsultUser param:{}", (Object)txConsultUser);
        }
        return consultUserId;
    }

    private TxConsultUser getTxConsultUser(OrgSignupInfo signupInfo, Long studentId) {
        Long userId = signupInfo.getUserId();
        Long orgId = signupInfo.getOrgId();
        TxConsultUser txConsultUser = new TxConsultUser();
        txConsultUser.setUserId(userId);
        txConsultUser.setOrgId(orgId);
        txConsultUser.setStudentId(studentId);
        txConsultUser.setName(signupInfo.getStudentName());
        txConsultUser.setConsultSource(Integer.valueOf(MessageSource.APPOINTMENT.getValue()));
        txConsultUser.setIntensionLevel(Integer.valueOf(IntentionLevel.LEVEL_2.getValue()));
        txConsultUser.setIsConsulter(Integer.valueOf(ConsulterStatus.NOT.getValue()));
        txConsultUser.setConsultStatus(Integer.valueOf(ConsultUserStatus.HAS.getValue()));
        txConsultUser.setMobile(signupInfo.getMobile());
        return txConsultUser;
    }

    private void syncPurchase3810Info(TxMsgSyncTimestamp syncInfo) {
        List coursePurchases = this.coursePurchaseDao.getCousePurchaseListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, Integer.valueOf(CourseType.ORG_COURSE.getCode()), null, Integer.valueOf(1), new String[0]);
        log.info("save coursePurchases:{} success", (Object)coursePurchases.size());
        if (CollectionUtils.isNotEmpty((Collection)coursePurchases)) {
            for (CoursePurchase coursePurchase : coursePurchases) {
                Date startDate = DateUtil.getFirstDate((Date)new Date());
                Date endDate = DateUtil.getNextMonthFirstDate((Date)new Date());
                TxConsultUserStatMonth txConsultUserStatMonth = this.txConsultUserStatMonthDao.getTxConsultStatByQuery(coursePurchase.getOrgId().longValue(), 0L, coursePurchase.getUserId().longValue(), Integer.valueOf(0), startDate, endDate);
                if (coursePurchase.getId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(coursePurchase.getId());
                }
                List txConsultUserList = this.txConsultUserDao.lookByUserId(coursePurchase.getOrgId(), coursePurchase.getUserId(), new String[0]);
                long consultUserId = 0L;
                if (txConsultUserList != null && txConsultUserList.size() > 0) {
                    consultUserId = ((TxConsultUser)txConsultUserList.get(0)).getId();
                }
                if (txConsultUserStatMonth == null) {
                    this.txConsultStatMonthService.saveStat(coursePurchase.getOrgId().longValue(), consultUserId, coursePurchase.getUserId().longValue(), EncrollmentTypeEnum.BAOMING.getValue(), Integer.valueOf(MessageSource.APPOINTMENT.getValue()), Integer.valueOf(1));
                    continue;
                }
                txConsultUserStatMonth.setConsultUserId(Long.valueOf(consultUserId));
                txConsultUserStatMonth.setUserId(coursePurchase.getUserId());
                txConsultUserStatMonth.setNumber(Integer.valueOf(txConsultUserStatMonth.getNumber() + 1));
                txConsultUserStatMonth.setUpdateTime(new Date());
                log.debug("syncPurchase3810Info update {}", (Object)txConsultUserStatMonth);
                this.txConsultUserStatMonthDao.update((Object)txConsultUserStatMonth, new String[0]);
            }
        }
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(Long.valueOf(0L));
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(Integer.valueOf(syncType.getSyncType()));
        }
        return syncInfo;
    }

    private OrgStudent getOrgStudentByConsultUser(TxConsultUser consultUser) {
        Long userId = consultUser.getUserId();
        Long orgId = consultUser.getOrgId();
        Long studentId = consultUser.getStudentId();
        OrgStudent orgStudent = null;
        orgStudent = studentId != null && studentId > 0L ? (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]) : this.orgStudentDao.getStudentByUserId(orgId, userId, new String[0]);
        return orgStudent;
    }

    private void insertTXConsultUserStatMonth(TxConsultUser consultUser, int status) {
        log.info("@@@@@@@@ A ");
        if (ConsulterStatus.IS.getValue() == consultUser.getIsConsulter().intValue()) {
            log.info("@@@@@@@@ B1 ");
            this.txConsultStatMonthService.saveStat(consultUser.getOrgId().longValue(), consultUser.getId().longValue(), consultUser.getUserId().longValue(), status, consultUser.getConsultSource(), Integer.valueOf(1));
            log.info("@@@@@@@@ B2 ");
        } else {
            log.info("@@@@@@@@ C1 ");
            this.txConsultStatMonthService.saveStat(consultUser.getOrgId().longValue(), consultUser.getId().longValue(), consultUser.getUserId().longValue(), status, consultUser.getConsultSource(), Integer.valueOf(0));
            log.info("@@@@@@@@ 1 ");
        }
    }

    private Integer getStatusByConsultUser(Integer status, TxConsultUser consultUser, OrgStudent orgStudent, Date startDate) {
        Date lastRemindTime = consultUser.getLastRemindTime();
        if (GenericsUtils.isNullOrEmpty((Object)orgStudent)) {
            if (ConsulterStatus.IS.getValue() == consultUser.getIsConsulter().intValue()) {
                List<Integer> intentionLevelZGs;
                if (lastRemindTime != null && lastRemindTime.after(startDate)) {
                    status = EncrollmentTypeEnum.GOUTONG.getValue();
                }
                if ((intentionLevelZGs = Arrays.asList(IntentionLevel.LEVEL_2.getValue(), IntentionLevel.LEVEL_3.getValue())).contains(consultUser.getIntensionLevel())) {
                    status = EncrollmentTypeEnum.YIXIANG.getValue();
                }
            } else {
                status = EncrollmentTypeEnum.ZIXUN.getValue();
            }
        } else if (status.intValue() != EncrollmentTypeEnum.BAOMING.getValue()) {
            status = EncrollmentTypeEnum.WULEIXING.getValue();
        }
        return status;
    }
}

