package com.baijia.tianxiao.biz.dashboard.sync.impl;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.baijia.tianxiao.biz.dashboard.constants.StatPageType;
import com.baijia.tianxiao.biz.dashboard.service.MonitorService;
import com.baijia.tianxiao.biz.dashboard.sync.SyncDataService;
import com.baijia.tianxiao.dal.course.dao.TeacherClassCourseDao;
import com.baijia.tianxiao.dal.course.dao.TeacherCourseDao;
import com.baijia.tianxiao.dal.course.dao.VideoCourseDao;
import com.baijia.tianxiao.dal.course.po.TeacherClassCourse;
import com.baijia.tianxiao.dal.course.po.TeacherCourse;
import com.baijia.tianxiao.dal.course.po.VideoCourse;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.sync.dao.TxMonitorCourseDayDao;
import com.baijia.tianxiao.dal.sync.dao.TxMonitorOrgDayDao;
import com.baijia.tianxiao.dal.sync.dao.TxMonitorTypeDayDao;
import com.baijia.tianxiao.dal.sync.po.TxMonitorCourseDay;
import com.baijia.tianxiao.dal.sync.po.TxMonitorOrgDay;
import com.baijia.tianxiao.dal.sync.po.TxMonitorTypeDay;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.statistics.TxMonitorTodayMinService;

import lombok.extern.slf4j.Slf4j;

/**
 * 每天凌晨从tx_monitor_today_min中清洗数据到报表中
 * 同步完后删除,同事删除redis记录的每天没有学生和机构 只能发送一次的限制
 *
 * Created by wengshengli on 15/12/26.
 */
@Service("syncMonitorDayService")
@Slf4j
public class SyncMonitorDayServiceImpl implements SyncDataService {

    @Resource
    private MonitorService monitorService;

    @Resource
    private TxMonitorTodayMinService txMonitorTodayMinService;

    @Resource
    private TxMonitorTypeDayDao txMonitorTypeDayDao;

    @Resource
    private TxMonitorCourseDayDao txMonitorCourseDayDao;

    @Resource
    private TxMonitorOrgDayDao txMonitorOrgDayDao;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private VideoCourseDao videoCourseDao;

    @Resource
    private TeacherCourseDao teacherCourseDao;

    @Resource
    private TeacherClassCourseDao teacherClassCourseDao;


    @Override
    public void sync() {
        /**
         * 清空昨天已发的redis设置
         */
        cleanRedisSendMsg();

        /**
         * 清洗数据进历史表
         */
        syncDbDay();
    }


    public void syncDbDay() {
        try {
            syncOrgPage();
            syncOrgType();
            syncOrgCourse();
            deleteTodayBase();
        } catch (Exception e) {
            log.warn("sync dbDay error ", e);
        }
    }

    /**
     * 发过消息的缓存记录清空
     */
    public void cleanRedisSendMsg() {
        try {
            monitorService.cleanRedisMsg();
        } catch (Exception e) {
            log.warn("sync msg redis data errer {}", e);
            throw new BussinessException(CommonErrorCode.UNKNOW);
        }
    }

    private void syncOrgPage() {
        List<TxMonitorOrgDay> orgDays = txMonitorTodayMinService.groupByOrgDay(null);
        log.info("syncOrgPage size is {}", orgDays.size());
        txMonitorOrgDayDao.saveAll(orgDays);
    }

    private void syncOrgType() {
        List<TxMonitorTypeDay> typeDays = txMonitorTodayMinService.groupByTypeDay(null);
        log.info("syncOrgType size is {}", typeDays.size());
        txMonitorTypeDayDao.saveAll(typeDays);
    }

    private void syncOrgCourse() {

        List<TxMonitorCourseDay> courseDays = txMonitorTodayMinService.groupByCourseDay(null, StatPageType.getCourseList());
        log.info("syncOrgCourse size is {}", courseDays.size());
        for (TxMonitorCourseDay one : courseDays) {
            if (one.getPageType() == StatPageType.WEI_COURSE.getCode()) {
                OrgCourse orgCourse = orgCourseDao.getByCourseNumber(one.getCourseNumber());
                if (orgCourse != null) {
                    one.setCourseName(orgCourse.getName());
                }
            } else if (one.getPageType() == StatPageType.ONEONE_COURSE.getCode()) {
                TeacherCourse teacherCourse = teacherCourseDao.getByCouseNumber(one.getCourseNumber());
                if (teacherCourse != null) {
                    one.setCourseName(teacherCourse.getName());
                }
            } else if (one.getPageType() == StatPageType.CLASS_COURSE.getCode()) {
                TeacherClassCourse teacherClassCourse = teacherClassCourseDao.getByCouseNumber(one.getCourseNumber());
                if (teacherClassCourse != null) {
                    one.setCourseName(teacherClassCourse.getName());
                }
            } else if (one.getPageType() == StatPageType.VIDEO_COURSE.getCode()) {
                VideoCourse videoCourse = videoCourseDao.getByNumber(one.getCourseNumber());
                if (videoCourse != null) {
                    one.setCourseName(videoCourse.getName());
                }
            }
            if (one.getCourseName() == null) {
                one.setCourseName("");
            }
        }
        txMonitorCourseDayDao.saveAll(courseDays);
    }

    private void deleteTodayBase() {
        txMonitorTodayMinService.deleteTodayBase();
    }
}
