package com.baijia.tianxiao.biz.dashboard.sync.impl;

import com.baijia.commons.lang.utils.JacksonUtil;
import com.baijia.tianxiao.biz.dashboard.constants.GalaxyConstants;
import com.baijia.tianxiao.biz.dashboard.dto.GalaxyResponseDto;
import com.baijia.tianxiao.biz.dashboard.sync.SyncDataService;
import com.baijia.tianxiao.dal.sync.dao.TxOrgCourseStatHourDao;
import com.baijia.tianxiao.dal.sync.po.TxOrgCourseStatHour;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * 从大数据galaxy中同步数据示例
 *
 * 目前暂没有用到
 *
 * galaxy 数据每小时一次原始数据入库
 */
@Service("syncGalaxyDataService")
@Slf4j
public class SyncGalaxyDataServiceImpl implements SyncDataService {

    @Resource
    private TxOrgCourseStatHourDao txOrgCourseStatHourDao;

    private AtomicBoolean orgCourseFlag = new AtomicBoolean(false);
    private AtomicBoolean wxIndexFlag = new AtomicBoolean(false);

    @Override
    public void sync() {
        /**
         * 同步机构课程
         */
        syncTask(1, orgCourseFlag);

        /**
         * 同步网校主页
         */
        syncTask(2, wxIndexFlag);
    }


    private void syncTask(int type, AtomicBoolean flag) {
        if (flag.get()) {
            log.warn("last sync is not complete");
            return;
        }
        flag.set(true);
        try {
            switch (type) {
                case 1:
                    syncOrgCourse();
                    break;
                case 2:
                    syncWxIndex();
                    break;
            }

        } catch (Exception e) {
            log.error("catch error:", e);
        } finally {
            flag.set(false);
        }
    }

    private void syncOrgCourse() {
        Map<String, String> params = Maps.newHashMap();
        params.put("app_id", GalaxyConstants.APP_ID);
        params.put("database", GalaxyConstants.DEFAULT_DB);

        StringBuilder sb = new StringBuilder("");
        Date lastHourDate = DateUtil.getLastHourDate();
        String pt = DateUtil.getDayStr(lastHourDate);
        String hour = DateUtil.getHour(lastHourDate);

        sb.append(
            "select request_path_key number, count(*) pv, count(distinct session_id) uv from base_log_data where ");
        sb.append("pt='").append(pt).append("' ");
        sb.append("and hour='").append(hour).append("' ");
        sb.append("and request_path_type = '").append(GalaxyConstants.ORG_CLASS_COURSE).append("' ");
        sb.append("group by request_path_key");

        params.put("query", sb.toString());
        log.info("query params = {}", params);

        try {
            String result = HttpClientUtils.doJsonPost(GalaxyConstants.GALAXY_URL, params, "UTF-8");

            GalaxyResponseDto galaxyResponseDto = JacksonUtil.str2Obj(result, GalaxyResponseDto.class);
            log.info("galaxyResponseDto={}", galaxyResponseDto);
            if (galaxyResponseDto.getCode() == 0) {
                if (galaxyResponseDto.getRows() != null && galaxyResponseDto.getRows().size() > 0) {
                    txOrgCourseStatHourDao.saveAll(changeWithPtHour(galaxyResponseDto.getRows(), pt, hour));
                }
            } else {
                throw new BussinessException(CommonErrorCode.SYSTEM_ERROR,
                    "GALAXY服务查询错误," + galaxyResponseDto.getMessage());
            }
        } catch (Exception e) {
            log.error("GALAXY服务接口异常,{}", e);
            throw new BussinessException(CommonErrorCode.SYSTEM_ERROR, "GALAXY服务接口异常");
        }
    }

    private List<TxOrgCourseStatHour> changeWithPtHour(List<TxOrgCourseStatHour> list, String pt, String hour) {

        List<TxOrgCourseStatHour> result = new ArrayList<TxOrgCourseStatHour>();
        for (TxOrgCourseStatHour one : list) {
            if (one.getNumber() == null) {
                continue;
            }
            one.setPt(pt);
            one.setHour(hour);
            result.add(one);
        }
        log.info("save txOrgCourseStatHour size is {}", result.size());
        return result;
    }

    private void syncWxIndex() {
    }

}
