package com.baijia.tianxiao.biz.dashboard.service.impl;

import com.baijia.commons.lang.utils.JacksonUtil;
import com.baijia.tianxiao.biz.dashboard.constants.GalaxyConstants;
import com.baijia.tianxiao.biz.dashboard.dto.YYGalaxyDto;
import com.baijia.tianxiao.biz.dashboard.dto.YunYingGalaxyDto;
import com.baijia.tianxiao.biz.dashboard.dto.YunYingSystemDto;
import com.baijia.tianxiao.biz.dashboard.service.YunyingSystemService;
import com.baijia.tianxiao.constant.YunYingEmailConstants;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.dal.callservice.dao.ConsultCallRecordDao;
import com.baijia.tianxiao.dal.comment.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.constant.TXAccountTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAppPvDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXAppPv;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoLessonDao;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoLessonStudentDao;
import com.baijia.tianxiao.dal.wechat.constant.WechatType;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.marketing.commons.utils.AttachBean;
import com.baijia.tianxiao.sal.marketing.commons.utils.Mail;
import com.baijia.tianxiao.sal.marketing.commons.utils.MailUtils;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.HanZiPinYinUtils;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.StringUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeUtility;
import javax.persistence.criteria.CriteriaBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;

import static com.baijia.tianxiao.util.ListUtil.toKeyList;

/**
 * Created by hanlaijin on 17/6/13.
 */
@Slf4j
@Service
public class YunyingSystemServiceImpl implements YunyingSystemService {

    private static final Integer STATUS_RETRUN_OK = 1;

    @Resource
    private TXAccountDao txAccountDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgSubAccountDao orgSubAccountDao;
    @Resource
    private TXCascadeAccountDao txCascadeAccountDao;
    @Resource
    private AuthorizerInfoDao authorizerInfoDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private ConsultCallRecordDao consultCallRecordDao;
    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;
    @Resource
    private OrgLessonSignDao orgLessonSignDao;
    @Resource
    private TXAppPvDao txAppPvDao;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private OrgLessonCommentDao lessonCommentDao;
    @Autowired
    private TxVZhiBoLessonDao zhiBoLessonDao;
    @Autowired
    private TxVZhiBoLessonStudentDao zhiBoLessonStudentDao;
    @Autowired
    private TXStudentCommentAPIService txStudentCommentAPIService;

    @Override
    @Transactional
    public void excelEmail() {
        // 1.填充 YunYingSystemDto
        List<YunYingSystemDto> list = getYunyingData();
        // 2.排序List<YunYingSystemDto>
        sortYunyingData(list);
        // 3.写入excel
        File file = writeYunyingDateToFile(list);
        // 4.发送email
        sendYunyingDataEmail(file);
    }

    private List<YunYingSystemDto> getYunyingData() {
        List<TXAccount> txAccounts = txAccountDao.getTXAccountByLevelStatusType(TXAccountType.getYunyingSet(),
                TXAccountStatus.VALID.getCode(), TXAccountTypeEnum.ZHENGSHI.getCode());
        log.debug("[tx account size]={}", txAccounts.size());
        List<Integer> orgIds = toKeyList(txAccounts, "orgId", TXAccount.class);
        List<Long> orgIdsLong = getLongOrgIds(orgIds);

        List<OrgAccount> orgAccounts = orgAccountDao.getByIds(orgIds);
        Map<Integer, OrgAccount> orgAccountMap = BaseUtils.listToMap(orgAccounts, "id");

        List<OrgInfo> orgInfos = orgInfoDao.getOrgInfos(orgIds);
        Map<Integer, OrgInfo> orgInfoMap = BaseUtils.listToMap(orgInfos, "orgId");

        List<Integer> studyingStatus = StudentLessonStatus.findSubStatus(StudentLessonStatus.STUDYING.getStatus());

        // 校区数=orgSubAccountMap+1(分校区+主校区)
        List<OrgSubAccount> subAccounts = orgSubAccountDao.getSlavesByMasterOrgIds(orgIds);
        Map<Integer, List<OrgSubAccount>> orgSubAccountMap = getMasterAndSlavesMap(orgIds, subAccounts);

        // 账号数=orgSubAccountMap+txCascadeAccountMap+1(分校长+主管员工+主校长)
        List<TXCascadeAccount> txCascadeAccounts =
                txCascadeAccountDao.getTXCascadeAccountListByStatusAndOrgIds(orgIds, OrgSubAccountStatus.NORMAL.getCode());
        Map<Integer, List<TXCascadeAccount>> txCascadeAccountMap = getTXCascadeAccountMap(orgIds, txCascadeAccounts);

        List<AuthorizerInfo> authorizerInfos = authorizerInfoDao.getAuthorizerInfosByOrgIds(orgIdsLong);
        Map<Integer, String> authorizerInfoMap = getAuthorizerInfoMap(orgIds, authorizerInfos);

        Map<Integer, Integer> courseMap = fillCourseMap(orgSubAccountMap);

        Map<Integer, String> allFeeMap = fillAllFeeMap(orgSubAccountMap);
        Map<Integer, String> offlineFeeMap = fillOfflineFeeMap(orgSubAccountMap);

        Map<Integer, String> signMap = fillSignMap(orgSubAccountMap);

        Map<Integer, String> callMap = fillCallMap(orgSubAccountMap);

        List<Integer> allOrgIds = Lists.newArrayList();
        allOrgIds.addAll(orgIds);
        allOrgIds.addAll(ListUtil.toKeyList(subAccounts, "orgId", OrgSubAccount.class));

        Map<Integer, Integer> studentMap = orgStudentDao.getStudentCountMapByStatus(allOrgIds, studyingStatus);
        Map<Integer, Integer> studentCountMap = fillMasterAndSlavesMap(studentMap, orgSubAccountMap);

        Map<Integer, Integer> bindMap = orgStudentDao.getBindStudentCenterCount(allOrgIds);
        Map<Integer, Integer> bindCountMap = fillMasterAndSlavesMap(bindMap, orgSubAccountMap);

        Date now = new Date();
        Map<Integer, Integer> weekMap = txAppPvDao.getByOrgIds(orgIds, DateUtil.getDayDiff(-7), now);
        Map<Integer, Integer> monthMap = txAppPvDao.getByOrgIds(orgIds, DateUtil.getDayDiff(-28), now);
        Map<Integer, Integer> threeMonthMap = txAppPvDao.getByOrgIds(orgIds, DateUtil.getDayDiff(-90), now);

        List<Long> allLongOrgIds = ListUtil.intListToLong(allOrgIds);

        Map<Long, Integer> teacherCommentMap = lessonCommentDao.getComment(UserRoleEnum.TEACHER.getCode(), DateUtil.getDayDiff(-7), now, allLongOrgIds);
        Map<Long, Integer> teacherCommentCountMap = fillMasterAndSlavesLongMap(teacherCommentMap, orgSubAccountMap);

        Map<Long, Integer> studentCommentMap = lessonCommentDao.getComment(UserRoleEnum.STUDENT.getCode(), DateUtil.getDayDiff(-7), now, allLongOrgIds);
        Map<Long, Integer> studentCommentCountMap = fillMasterAndSlavesLongMap(studentCommentMap, orgSubAccountMap);

        Map<Long, Integer> zhiboLessonMap = zhiBoLessonDao.getLessonTotal(DateUtil.getDayDiff(-28), now, allLongOrgIds);
        Map<Long, Integer> zhiboLessonCountMap = fillMasterAndSlavesLongMap(zhiboLessonMap, orgSubAccountMap);

        Map<Long, Integer> zhiboLessonStudentMap = zhiBoLessonStudentDao.getLessonStudentTotal(DateUtil.getDayDiff(-28), now, allLongOrgIds);
        Map<Long, Integer> zhiboLessonStudentCountMap = fillMasterAndSlavesLongMap(zhiboLessonStudentMap, orgSubAccountMap);

        Map<Long, Integer> weekStudentGrowMap = txStudentCommentAPIService.getCommentTotal(DateUtil.getDayDiff(-7), now, allLongOrgIds, 1, AddType.NOT_SYSTEM.getCode(), true);
        Map<Long, Integer> weekStudentGrowCountMap = fillMasterAndSlavesLongMap(weekStudentGrowMap, orgSubAccountMap);

        Map<Long, Integer> monthStudentGrowMap = txStudentCommentAPIService.getCommentTotal(DateUtil.getDayDiff(-28), now, allLongOrgIds, 1, AddType.NOT_SYSTEM.getCode(), true);
        Map<Long, Integer> monthStudentGrowCountMap = fillMasterAndSlavesLongMap(monthStudentGrowMap, orgSubAccountMap);
        log.debug("monthStudentGrowCountMap = {}", monthStudentGrowCountMap);


        List<YunYingSystemDto> result = Lists.newArrayList();
        for (TXAccount txAccount : txAccounts) {
            Integer id = txAccount.getOrgId();
            OrgInfo orgInfo = orgInfoMap.get(id);
            OrgAccount orgAccount = orgAccountMap.get(id);
            String city = AreaUtils.getAreaNameByCode(orgInfo.getAreaId()).get("city");

            YunYingSystemDto dto = new YunYingSystemDto();
            dto.setOrgName(orgInfo.getShortName());
            dto.setOrgNumber(orgAccount.getNumber());
            dto.setMobile(orgAccount.getMobile());
            dto.setPaidStudentCount(txAccount.getStudentCount() != null ? txAccount.getStudentCount() : 0);
            dto.setCity(StringUtils.isEmpty(city) ? "全国" : city + "市");
            dto.setInitial(HanZiPinYinUtils.trans2PinYin(city));
            dto.setBeginTime(DateUtil.getStrByDate(txAccount.getStartTime()));
            dto.setEndTime(DateUtil.getStrByDate(txAccount.getEndTime()));
            dto.setVersionStr(TXAccountType.getTXAccountTypeByCode(txAccount.getVipLevel()).getLabel());
            dto.setStudentCount(studentCountMap.get(id) != null ? studentCountMap.get(id) : 0);
            dto.setCampusCount(orgSubAccountMap.get(id).size() + 1);
            dto.setAccountCount(orgSubAccountMap.get(id).size() + 1 + txCascadeAccountMap.get(id).size());
            dto.setWeChatTypeStr(authorizerInfoMap.get(id));
            dto.setBindStudentCount(bindCountMap.get(id) != null ? bindCountMap.get(id) : 0);
            dto.setClassCount(courseMap.get(id));
            dto.setOnlineIncome(allFeeMap.get(id));
            dto.setOfflineIncome(offlineFeeMap.get(id));
            dto.setWeekSignCount(signMap.get(id));
            dto.setDialOutCount(callMap.get(id));
            dto.setWeekPV(weekMap.get(id) != null ? NumberUtil.get2FromDouble(weekMap.get(id) / 7.0) : "0.00");
            dto.setMonthPV(monthMap.get(id) != null ? NumberUtil.get2FromDouble(monthMap.get(id) / 4.0) : "0.00");
            dto.setThreeMonthPV(threeMonthMap.get(id) != null ? NumberUtil.get2FromDouble(threeMonthMap.get(id) / 3.0) : "0.00");

            dto.setTeacherCommentCount(teacherCommentCountMap.get(id.longValue()) != null ? teacherCommentCountMap.get(id.longValue()) : 0);
            dto.setStudentCommentCount(studentCommentCountMap.get(id.longValue()) != null ? studentCommentCountMap.get(id.longValue()) : 0);
            dto.setVzhiboClassCount(zhiboLessonCountMap.get(id.longValue()) != null ? zhiboLessonCountMap.get(id.longValue()) : 0);
            dto.setVzhiboClassStudent(zhiboLessonStudentCountMap.get(id.longValue()) != null ? zhiboLessonStudentCountMap.get(id.longValue()) : 0);
            dto.setWeekStudentGrowCount(weekStudentGrowCountMap.get(id.longValue()) != null ? weekStudentGrowCountMap.get(id.longValue()) : 0);
            dto.setMonthStudentGrowCount(monthStudentGrowCountMap.get(id.longValue()) != null ? monthStudentGrowCountMap.get(id.longValue()) : 0);

            result.add(dto);
        }

        return result;
    }

    private List<Long> getLongOrgIds(List<Integer> orgIds) {
        List<Long> list = Lists.newArrayList();
        for (Integer i : orgIds) {
            list.add(i.longValue());
        }
        return list;
    }

    private Map<Integer, List<OrgSubAccount>> getMasterAndSlavesMap(List<Integer> orgIds,
                                                                    List<OrgSubAccount> subAccounts) {
        Map<Integer, List<OrgSubAccount>> map = Maps.newHashMap();
        for (Integer orgId : orgIds) {
            map.put(orgId, new ArrayList<OrgSubAccount>());
        }
        for (OrgSubAccount account : subAccounts) {
            if (map.containsKey(account.getPid())) {
                map.get(account.getPid()).add(account);
            }
        }
        return map;
    }

    private Map<Integer, List<TXCascadeAccount>> getTXCascadeAccountMap(List<Integer> orgIds,
                                                                        List<TXCascadeAccount> txCascadeAccounts) {
        Map<Integer, List<TXCascadeAccount>> map = Maps.newHashMap();
        for (Integer orgId : orgIds) {
            map.put(orgId, new ArrayList<TXCascadeAccount>());
        }
        for (TXCascadeAccount account : txCascadeAccounts) {
            if (map.containsKey(account.getOrgId())) {
                map.get(account.getOrgId()).add(account);
            }
        }
        return map;
    }

    private Map<Integer, String> getAuthorizerInfoMap(List<Integer> orgIds, List<AuthorizerInfo> authorizerInfos) {
        Map<Integer, String> map = Maps.newHashMap();
        for (Integer orgId : orgIds) {
            map.put(orgId, WechatType.NOT_BIND);
        }
        for (AuthorizerInfo info : authorizerInfos) {
            if (map.containsKey(info.getOrgId())) {
                String type = WechatType.getWechatType(info.getServiceType(), info.getVerifyType());
                map.put(info.getOrgId(), type);
            }
        }
        return map;
    }

    private Map<Integer, Integer> fillCourseMap(Map<Integer, List<OrgSubAccount>> map) {
        Map<Integer, Integer> result = Maps.newHashMap();
        for (Integer orgId : map.keySet()) {
            List<OrgSubAccount> list = map.get(orgId);
            List<Integer> allOrgIds = Lists.newArrayList();
            allOrgIds.add(orgId);
            allOrgIds.addAll(ListUtil.toKeyList(list, "orgId", OrgSubAccount.class));
            List<OrgAccount> orgAccounts = orgAccountDao.getByIds(allOrgIds);
            List<Integer> numbers = ListUtil.toKeyList(orgAccounts, "number", OrgAccount.class);
            Integer count = orgCourseDao.getClassCount(numbers);
            result.put(orgId, count);
        }
        return result;
    }

    private Map<Integer, String> fillAllFeeMap(Map<Integer, List<OrgSubAccount>> map) {
        Map<Integer, String> result = Maps.newHashMap();
        Date now = new Date();
        Date threeMonthAgo = DateUtil.getDayDiff(-90);
        for (Integer orgId : map.keySet()) {
            List<OrgSubAccount> list = map.get(orgId);
            List<Integer> allOrgIds = Lists.newArrayList();
            allOrgIds.add(orgId);
            allOrgIds.addAll(ListUtil.toKeyList(list, "orgId", OrgSubAccount.class));
            List<Long> allOrgIdsLong = Lists.newArrayList();
            allOrgIdsLong.add(orgId.longValue());
            allOrgIdsLong.addAll(ListUtil.toKeyList(list, "orgId", OrgSubAccount.class));
            Long count = orgSignupInfoDao.getInComeByDate(allOrgIds, threeMonthAgo, now, null);
            List<Integer> payType = Lists.newArrayList();
            payType.add(PayType.TX_STUDENT_PAY.getCode());
            payType.add(PayType.TX_NO_PAY.getCode());
            payType.add(PayType.CASH.getCode());
            Long other = orgSignupInfoDao.getInComeByDate(allOrgIds, threeMonthAgo, now, payType);
            Long l = 0l;
            if (count != null) {
                if (other != null) {
                    l = count - other;
                } else {
                    l = count;
                }
            }
            Double d = l.doubleValue() / 100 / 3.0;
            result.put(orgId, NumberUtil.get2FromDouble(d));
        }
        return result;
    }

    private Map<Integer, String> fillOfflineFeeMap(Map<Integer, List<OrgSubAccount>> map) {
        Map<Integer, String> result = Maps.newHashMap();
        Date now = new Date();
        Date threeMonthAgo = DateUtil.getDayDiff(-90);
        for (Integer orgId : map.keySet()) {
            List<OrgSubAccount> list = map.get(orgId);
            List<Integer> allOrgIds = Lists.newArrayList();
            allOrgIds.add(orgId);
            allOrgIds.addAll(ListUtil.toKeyList(list, "orgId", OrgSubAccount.class));
            List<Long> allOrgIdsLong = Lists.newArrayList();
            allOrgIdsLong.add(orgId.longValue());
            allOrgIdsLong.addAll(ListUtil.toKeyList(list, "orgId", OrgSubAccount.class));
            List<Integer> payType = Lists.newArrayList();
            payType.add(PayType.CASH.getCode());
            Long count = orgSignupInfoDao.getInComeByDate(allOrgIds, threeMonthAgo, now, payType);
            Double d = count != null ? count.doubleValue() / 100 / 3.0 : 0.00;
            result.put(orgId, NumberUtil.get2FromDouble(d));
        }
        return result;
    }

    private Map<Integer, String> fillSignMap(Map<Integer, List<OrgSubAccount>> map) {
        Map<Integer, String> result = Maps.newHashMap();
        Date now = new Date();
        Date oneMonthAgo = DateUtil.getDayDiff(-28);
        for (Integer orgId : map.keySet()) {
            List<OrgSubAccount> list = map.get(orgId);
            List<Long> allOrgIdsLong = Lists.newArrayList();
            allOrgIdsLong.add(orgId.longValue());
            allOrgIdsLong.addAll(ListUtil.toKeyList(list, "orgId", OrgSubAccount.class));
            Map<Long, Integer> signStudentTotals = orgLessonSignDao.getOrgSignStudentTotal(oneMonthAgo, now, allOrgIdsLong);
            Integer count = 0;
            for (Integer i : signStudentTotals.values()) {
                count += i;
            }
            double d = count * 1.0 / 4;
            result.put(orgId, NumberUtil.get2FromDouble(d));
        }
        return result;
    }

    private Map<Integer, String> fillCallMap(Map<Integer, List<OrgSubAccount>> map) {
        Map<Integer, String> result = Maps.newHashMap();
        Date now = new Date();
        Date threeMonthAgo = DateUtil.getDayDiff(-90);
        for (Integer orgId : map.keySet()) {
            List<OrgSubAccount> list = map.get(orgId);
            List<Long> allOrgIdsLong = Lists.newArrayList();
            allOrgIdsLong.add(orgId.longValue());
            allOrgIdsLong.addAll(ListUtil.toKeyList(list, "orgId", OrgSubAccount.class));
            Integer count = consultCallRecordDao.getCallTimeByOrgIdAndType(allOrgIdsLong, STATUS_RETRUN_OK, threeMonthAgo, now);
            String s = NumberUtil.get2FromDouble(count / 60.0 / 3.0);
            result.put(orgId, s);
        }
        return result;
    }

    private Map<Integer, Integer> fillMasterAndSlavesMap(Map<Integer, Integer> studentCountMaps, Map<Integer, List<OrgSubAccount>> map) {
        Map<Integer, Integer> result = Maps.newHashMap();
        for (Integer orgId : map.keySet()) {
            List<OrgSubAccount> list = map.get(orgId);
            Integer count = studentCountMaps.get(orgId) != null ? studentCountMaps.get(orgId) : 0;
            for (OrgSubAccount sub : list) {
                if (studentCountMaps.containsKey(sub.getOrgId())) {
                    int subCount = studentCountMaps.get(sub.getOrgId()) != null ? studentCountMaps.get(sub.getOrgId()) : 0;
                    count = count + subCount;
                }
            }
            result.put(orgId, count);
        }
        return result;
    }

    private Map<Long, Integer> fillMasterAndSlavesLongMap(Map<Long, Integer> studentCountMaps, Map<Integer, List<OrgSubAccount>> map) {
        Map<Long, Integer> result = Maps.newHashMap();
        for (Integer orgId : map.keySet()) {
            List<OrgSubAccount> list = map.get(orgId);
            Integer count = studentCountMaps.get(orgId.longValue()) != null ? studentCountMaps.get(orgId.longValue()) : 0;
            for (OrgSubAccount sub : list) {
                if (studentCountMaps.containsKey(sub.getOrgId().longValue())) {
                    int subCount = studentCountMaps.get(sub.getOrgId().longValue()) != null ? studentCountMaps.get(sub.getOrgId().longValue()) : 0;
                    count = count + subCount;
                }
            }
            result.put(orgId.longValue(), count);
        }
        return result;
    }

    private void sortYunyingData(List<YunYingSystemDto> list) {
        Collections.sort(list, new Comparator<YunYingSystemDto>() {
            @Override
            public int compare(YunYingSystemDto o1, YunYingSystemDto o2) {
                return o1.getInitial().toLowerCase().compareTo(o2.getInitial().toLowerCase());
            }
        });
    }

    private File writeYunyingDateToFile(List<YunYingSystemDto> list) {
        String[] fields = new String[]{"机构名称", "机构ID", "购买在读学员", "城市", "对应销售", "销售主管", "开通日期", "结束日期", "版本类型",
                "品类", "综合评定/客户分级", "在读学员数", "生效校区数", "生效帐号数", "公众号托管类型", "绑定学员数", "线上月均交易额", "线下月均交易额", "招生中班级数量",
                "日活校区数", "周活校区数", "月活校区数", "周均签到次数", "月均外呼分钟数", "老师周评论数", "学生周评论数", "微直播月开设次数", "微直播月到课人数", "周添加成长记录数", "月添加成长记录数", "备注"};
        String[] fieldValue = new String[]{"orgName", "orgNumber", "paidStudentCount", "city", "salePerson",
                "saleManager", "beginTime", "endTime", "versionStr", "pinLei", "pingDingFenJi", "studentCount",
                "campusCount", "accountCount", "weChatTypeStr", "bindStudentCount", "onlineIncome", "offlineIncome",
                "classCount", "weekPV", "monthPV", "threeMonthPV", "weekSignCount", "dialOutCount", "teacherCommentCount", "studentCommentCount",
                "vzhiboClassCount", "vzhiboClassStudent", "weekStudentGrowCount", "monthStudentGrowCount", "remark"};
        String fileName = "天校用户运营数据" + DateUtil.getStrByDate(new Date()) + ".xls";
        File file = exportToExcelLocalFile(list, fields, fieldValue, fileName);
        return file;
    }

    public File exportToExcelLocalFile(List<YunYingSystemDto> data, String[] fields, String[] fieldValue, String file) {
        if (fields == null || fieldValue == null) {
            throw new RuntimeException("fields or header can't be null.");
        }

        Workbook wb = new HSSFWorkbook();
        Sheet sheet = wb.createSheet("天校");

        Row headerTitle = sheet.createRow(0);
        int index = 0;
        for (int i = 0; i < fields.length; i++) {
            Cell cell = headerTitle.createCell(index++ % fields.length);
            cell.setCellValue(fields[i]);
        }

        for (int i = 0; i < data.size(); i++) {
            Row row = sheet.createRow(i + 1);
            YunYingSystemDto o = data.get(i);
            for (int j = 0; j < fields.length; j++) {
                Cell cell = row.createCell(index++ % fields.length);
                try {
                    cell.setCellValue(BeanUtils.getProperty(o, fieldValue[j]));
                } catch (Exception e) {
                    throw new RuntimeException("export data error", e);
                }
            }
        }

        File localFile = new File(file);
        OutputStream out = null;
        try {
            out = new FileOutputStream(localFile);
            wb.write(out);
            out.flush();
        } catch (Exception e) {
            log.debug("------[excel error]--------- {}", e);
        } finally {
            IOUtils.closeQuietly(out);
        }
        return localFile;
    }

    private void sendYunyingDataEmail(File file) {
        Mail mail = new Mail();
        String receiver = YunYingEmailConstants.RECIEVER;
        String cc = YunYingEmailConstants.CC;
        String bcc = YunYingEmailConstants.BCC;
        String host = YunYingEmailConstants.HOST;
        String from = "tianxiao";
        String subject = "天校用户运营数据" + DateUtil.getStrByDate(new Date());
        String address = YunYingEmailConstants.ADDRESS;
        try {
            from = MimeUtility.encodeText(from);
            mail.setContent("");
            mail.setFrom(from + "<" + address + ">");
            mail.setSubject(subject);
            mail.addToAddress(receiver);
            mail.addCcAddress(cc);
            mail.addBccAddress(bcc);
            if (file.exists()) {
                AttachBean attachBean = new AttachBean();
                attachBean.setCid(file.getName());
                attachBean.setFile(file);
                attachBean.setFileName(file.getName());
                mail.addAttach(attachBean);
            }
            Session session = MailUtils.createSession(host);
            MailUtils.send(session, mail);
        } catch (MessagingException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Transactional
    public void syncOpenAppCount(String dateStr) {
        if (org.apache.commons.lang3.StringUtils.isBlank(dateStr)) {
            Date date = DateUtil.getDiffDateTime(new Date(), -1);
            dateStr = DateUtil.getDayStr(date);
        }
        List<YYGalaxyDto> list = getYYByDate(dateStr);
        saveOpenAppCount(list, dateStr);
    }

    private List<YYGalaxyDto> getYYByDate(String pt) {
        Map<String, String> params = Maps.newHashMap();
        params.put("app_id", GalaxyConstants.APP_ID);
        params.put("database", GalaxyConstants.FORMATTER_DB);

        StringBuilder sb = new StringBuilder("");

        sb.append("select user_number as number ,count(distinct(concat(user_number,get_json_object(event_attr, '$.mobile')))) as count from  formatter.app_event_log_tianxiao where ");
        sb.append("pt='").append(pt).append("' ");;
        sb.append(" and event_attr not like '%click%' group by user_number ");

        params.put("query", sb.toString());
        log.info("query params = {}", params);

        try {
            String result = HttpClientUtils.doJsonPost(GalaxyConstants.GALAXY_URL, params, "UTF-8");
            YunYingGalaxyDto dto = JacksonUtil.str2Obj(result, YunYingGalaxyDto.class);
            if (dto.getCode() == 0) {
                if (dto.getRows() != null && dto.getRows().size() > 0) {
                    return dto.getRows();
                }
            } else {
                throw new BussinessException(CommonErrorCode.SYSTEM_ERROR,
                        "GALAXY服务查询错误," + dto.getMessage());
            }
        } catch (Exception e) {
            log.warn("GALAXY服务接口异常,{}", e);
            throw new BussinessException(CommonErrorCode.SYSTEM_ERROR, "GALAXY服务接口异常");
        }
        return null;
    }

    private void saveOpenAppCount(List<YYGalaxyDto> list, String dateStr) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<Integer, Integer> resultMap = getPvMap(list);
        savePv(resultMap, dateStr);
    }

    private Map<Integer, Integer> getPvMap(List<YYGalaxyDto> list) {
        Map<Integer, Integer> numberCountMap = Maps.newHashMap();
        for (YYGalaxyDto dto : list) {
            if (dto.getNumber() != null && dto.getNumber().longValue() > 0) {
                numberCountMap.put(dto.getNumber(), dto.getCount());
            }
        }
        List<OrgAccount> orgList = orgAccountDao.getAccountByNumbers(numberCountMap.keySet());
        //主+分
        Map<Integer, Integer> orgIdCounMap = Maps.newHashMap();
        for (OrgAccount account : orgList) {
            orgIdCounMap.put(account.getId(), numberCountMap.get(account.getNumber()));
        }
        //主+分
        List<OrgSubAccount> allAccounts = orgSubAccountDao.getByOrgIds(orgIdCounMap.keySet(), OrgSubAccountStatus.NORMAL.getCode());
        //key=org_id，value=主count+分count
        Map<Integer, Integer> resultMap = Maps.newHashMap();
        for (OrgSubAccount sub : allAccounts) {
            if (sub.getPid() == 0) {
                if (resultMap.containsKey(sub.getOrgId())) {
                    Integer count = resultMap.get(sub.getOrgId()) + 1;
                    resultMap.put(sub.getOrgId(), count);
                } else {
                    resultMap.put(sub.getOrgId(), 1);
                }
            } else {
                if (resultMap.containsKey(sub.getPid())) {
                    Integer count = resultMap.get(sub.getPid()) + 1;
                    resultMap.put(sub.getPid(), count);
                } else {
                    resultMap.put(sub.getPid(), 1);
                }
            }
        }
        return resultMap;
    }


    private void savePv(Map<Integer, Integer> resultMap, String dateStr) {
        List<TXAppPv> toSave = Lists.newArrayList();
        Date date = null;
        if (org.apache.commons.lang3.StringUtils.isBlank(dateStr)) {
            date = DateUtil.getDiffDateTime(new Date(), -1);
        } else {
            date = DateUtil.getStrToDate("yyyyMMdd", dateStr);
        }
        for (Map.Entry<Integer, Integer> entry : resultMap.entrySet()) {
            TXAppPv pv = new TXAppPv();
            pv.setOrgId(entry.getKey());
            pv.setCount(entry.getValue());
            pv.setCreateTime(date);
            toSave.add(pv);
        }
        txAppPvDao.saveAll(toSave);
    }

}
