package com.baijia.tianxiao.biz.dashboard.service.impl;

import com.baijia.tianxiao.biz.dashboard.constants.KexiaoRecordType;
import com.baijia.tianxiao.biz.dashboard.constants.OrderKey;
import com.baijia.tianxiao.biz.dashboard.constants.OrderType;
import com.baijia.tianxiao.biz.dashboard.constants.RankType;
import com.baijia.tianxiao.biz.dashboard.dto.FeeRecordDto;
import com.baijia.tianxiao.biz.dashboard.dto.OperationReportResponse;
import com.baijia.tianxiao.biz.dashboard.dto.OperationReportRequest;
import com.baijia.tianxiao.biz.dashboard.service.OperationReportService;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupDao;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupRelateDao;
import com.baijia.tianxiao.dal.course.po.OrgCourseGroup;
import com.baijia.tianxiao.dal.org.dao.OrgCourseKexiaoDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.po.OrgCourseKexiao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.StringUtils;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
@Slf4j
public class OperationReportServiceImpl implements OperationReportService {
    @Autowired
    private OrgSubAccountService subAccountService;
    @Autowired
    private OrgStudentKexiaoRecordDao studentKexiaoRecordDao;
    @Autowired
    private OrgCourseKexiaoDao courseKexiaoDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgCourseGroupDao courseGroupDao;
    @Autowired
    private OrgCourseGroupRelateDao courseGroupRelateDao;


    @Override
    public List<OperationReportResponse> getOperationReport(OperationReportRequest paramDto) {
        Long orgId = TianxiaoPCContext.getOrgIdLong();
        paramDto.setIsMaster(subAccountService.isMasterAccount(orgId));
        boolean isMaster = paramDto.getIsMaster();
        List<Long> orgIds = paramDto.getOrgIds();
        List<Long> courseTypeIds = paramDto.getCourseTypeIds();
        int rankType = paramDto.getRankType();

        List<OperationReportResponse> data = new ArrayList<>();
        List<String> names = new ArrayList<>();
        if (rankType == RankType.SCHOOL.getCode()) {//按校区
            if (isMaster == true) {
                //得到所选校区的数据
                if (CollectionUtils.isEmpty(orgIds)) {
                    orgIds = new ArrayList<>();
                    List<OrgSubAccount> subAccounts = subAccountService.getMasterandslavesOrgId(orgId);
                    for (OrgSubAccount subAccount : subAccounts) {
                        orgIds.add(subAccount.getOrgId().longValue());
                        OrgInfo orgInfo = orgInfoDao.getOrgInfo(subAccount.getOrgId());
                        names.add(orgInfo.getShortName());

                    }

                } else {
                    for (Long _orgId : orgIds) {
                        OrgInfo orgInfo = orgInfoDao.getOrgInfo(_orgId.intValue());
                        names.add(orgInfo.getShortName());
                    }
                }
            } else {
                orgIds = new ArrayList<>();
                orgIds.add(orgId);
                OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId.intValue());
                names.add(orgInfo.getShortName());
            }
            if (CollectionUtils.isEmpty(courseTypeIds)) {//得到所有课程数据
                courseTypeIds = new ArrayList<>();
                List<Long> courseGroupIds = courseGroupDao.getOrgsCourseGroupList(orgIds);
                courseTypeIds.addAll(courseGroupIds);
            }
            paramDto.setOrgIds(orgIds);
            paramDto.setNames(names);
            paramDto.setCourseTypeIds(courseTypeIds);
            data = getSchoolData(paramDto);
        } else if (rankType == RankType.COURSETYPE.getCode()) {//按课程
            if (isMaster == true) {
                orgIds = new ArrayList<>();
                List<OrgSubAccount> subAccounts = subAccountService.getMasterandslavesOrgId(orgId);
                for (OrgSubAccount subAccount : subAccounts) {
                    orgIds.add(subAccount.getOrgId().longValue());
                }
            } else {
                orgIds.add(orgId);
            }
            if (CollectionUtils.isEmpty(courseTypeIds)) {//得到所有课程数据
                List<OrgCourseGroup> courseGroups = courseGroupDao.getBathCourseGroupList(orgIds);
                courseTypeIds = new ArrayList<>();
                for (OrgCourseGroup orgCourseGroup : courseGroups) {
                    courseTypeIds.add(orgCourseGroup.getId().longValue());
                    names.add(orgCourseGroup.getName());
                }
            } else {
                List<OrgCourseGroup> courseGroups = courseGroupDao.getByIds(courseTypeIds);
                for (OrgCourseGroup orgCourseGroup : courseGroups) {

                    names.add(orgCourseGroup.getName());
                }
            }
            paramDto.setOrgIds(orgIds);
            paramDto.setCourseTypeIds(courseTypeIds);
            paramDto.setNames(names);
            data = getCourseData(paramDto);


        } else {
            return null;
        }


        return data;
    }

    @Override
    public void importOldData() {
        courseKexiaoDao.deleteAll();
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(0);
        pageDto.setPageSize(1000);
        List<OrgCourseKexiao> courseKexiaos = studentKexiaoRecordDao.getRecordEveryday(KexiaoRecordType.COURSE.getCode(), pageDto);
        int pageNum = courseKexiaos.size();
        while (courseKexiaos.size() > 0) {
            pageDto.setPageNum(pageDto.getPageNum() + 1);
            courseKexiaos = studentKexiaoRecordDao.getRecordEveryday(KexiaoRecordType.COURSE.getCode(), pageDto);
            pageNum = pageNum + courseKexiaos.size();
            courseKexiaoDao.saveAll(courseKexiaos);

        }
        log.info("导入课程数据{}", pageNum);
        pageDto.setPageNum(0);
        List<OrgCourseKexiao> classKexiaos = studentKexiaoRecordDao.getRecordEveryday(KexiaoRecordType.CLASS.getCode(), pageDto);
        pageNum = classKexiaos.size();
        while (classKexiaos.size() > 0) {
            pageDto.setPageNum(pageDto.getPageNum() + 1);
            classKexiaos = studentKexiaoRecordDao.getRecordEveryday(KexiaoRecordType.CLASS.getCode(), pageDto);
            pageNum = pageNum + classKexiaos.size();
            courseKexiaoDao.saveAll(classKexiaos);

        }
        log.info("导入班级数据{}", pageNum);
    }

    @Override
    public void importData() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DATE, -1);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        Date start = calendar.getTime();
        Calendar calendarEnd = Calendar.getInstance();
        calendarEnd.add(Calendar.DATE, -1);
        calendarEnd.set(Calendar.HOUR_OF_DAY, 23);
        calendarEnd.set(Calendar.MINUTE, 59);
        calendarEnd.set(Calendar.SECOND, 59);
        calendarEnd.set(Calendar.MILLISECOND, 999);
        Date end = calendarEnd.getTime();
        courseKexiaoDao.deleteByTime(start, end);
        List<OrgCourseKexiao> courseKexiaos = studentKexiaoRecordDao.getYesterdayRecord(KexiaoRecordType.COURSE.getCode(), start, end);
        courseKexiaoDao.saveAll(courseKexiaos);
        log.info("保存课程数据{}", courseKexiaos.size());
        List<OrgCourseKexiao> classKexiaos = studentKexiaoRecordDao.getYesterdayRecord(KexiaoRecordType.CLASS.getCode(), start, end);
        courseKexiaoDao.saveAll(classKexiaos);
        log.info("保存班级数据{}", classKexiaos.size());


    }


    private List<OperationReportResponse> getSchoolData(OperationReportRequest paramDto) {
        List<OperationReportResponse> operationReportResponses = new ArrayList<>();
        List<Long> orgIds = paramDto.getOrgIds();
        List<String> names = paramDto.getNames();
        List<Long> courseTypeIds = paramDto.getCourseTypeIds();
        long start = paramDto.getStartTime();
        long end = paramDto.getEndTime();
        Date dateStart = new Date(start);
        Date dateEnd = new Date(end);
        int orderKey = paramDto.getOrderKey();
        int orderType = paramDto.getOrderType();


        for (int var = 0; var < orgIds.size(); var++) {

            String name = names.get(var);
            OperationReportResponse operationReportResponse = new OperationReportResponse();
            long orgId = orgIds.get(var);
            operationReportResponse.setId(orgId);
            operationReportResponse.setName(name);
            long kexiao = getCourseKexiao(dateStart, dateEnd, courseTypeIds);
            double kexiaoYuan = (double) kexiao / 100;
            operationReportResponse.setIncome(kexiaoYuan);
            long cost = getCourseCost(courseTypeIds, orgId, start, end);
            double costYuan = (double) cost / 100;
            operationReportResponse.setCost(costYuan);
            double profit = kexiaoYuan - costYuan;
            operationReportResponse.setProfit(profit);
            List<Long> subjectIds = getFilterSubjectId();
            long subjectsCost = getCourseSubjectsCost(subjectIds, courseTypeIds, orgId, start, end);
            double subjectCostYuan = (double) subjectsCost / 100;
            double ebitda = kexiaoYuan - subjectCostYuan;//先这么谢
            operationReportResponse.setEbitda(ebitda);
            log.info("收入:{},收费{},利润{},EBITDA{}", kexiaoYuan, costYuan, profit, ebitda);
            operationReportResponses.add(operationReportResponse);
        }
        operationReportResponses.sort(getCompare(orderKey, orderType));


        return operationReportResponses;

    }

    private List<OperationReportResponse> getCourseData(OperationReportRequest paramDto) {
        List<OperationReportResponse> operationReportResponses = new ArrayList<>();
        List<Long> orgIds = paramDto.getOrgIds();
        List<String> names = paramDto.getNames();
        List<Long> courseTypeIds = paramDto.getCourseTypeIds();
        long start = paramDto.getStartTime();
        long end = paramDto.getEndTime();
        Date dateStart = new Date(start);
        Date dateEnd = new Date(end);
        int orderKey = paramDto.getOrderKey();
        int orderType = paramDto.getOrderType();
        for (int var = 0; var < courseTypeIds.size(); var++) {

            String name = names.get(var);
            OperationReportResponse operationReportResponse = new OperationReportResponse();

            long courseTypeId = courseTypeIds.get(var);
            operationReportResponse.setId(courseTypeId);

            operationReportResponse.setName(name);
            double kexiao = getSchoolKexiao(dateStart, dateEnd, orgIds);
            double kexiaoYuan = (double) kexiao / 100;
            operationReportResponse.setIncome(kexiaoYuan);
            long cost = getSchoolCost(courseTypeId, orgIds, start, end);
            double costYuan = (double) cost / 100;
            operationReportResponse.setCost(costYuan);
            double profit = kexiaoYuan - costYuan;
            operationReportResponse.setProfit(profit);
            List<Long> subjectIds = getFilterSubjectId();
            long subjectsCost = getSchoolSubjectsCost(subjectIds, courseTypeId, orgIds, start, end);
            double subjectCostYuan = (double) subjectsCost / 100;
            double ebitda = kexiaoYuan - subjectCostYuan;//先这么谢
            operationReportResponse.setEbitda(ebitda);
            log.info("收入:{},收费{},利润{},EBITDA{}", kexiaoYuan, costYuan, profit, ebitda);
            operationReportResponses.add(operationReportResponse);
        }
        operationReportResponses.sort(getCompare(orderKey, orderType));


        return operationReportResponses;
    }

    private long getCourseSubjectsCost(List<Long> subjectIds, List<Long> courseTypeIds, Long orgId, Long start, Long end) {
        long cost = 0;
        String url = getSearchURL();
        for (Long courseTypeId : courseTypeIds) {
            Map param = Maps.newHashMap();
            param.put("courseTypeId", courseTypeId.toString());
            param.put("schoolId", orgId.toString());
            param.put("incrurreStartTime", start.toString());
            param.put("incurreEndTime", end.toString());
            for (Long subjectId : subjectIds) {
                param.put("subjectId", subjectId.toString());
                String responseStr = HttpClientUtils.doGet(url, param);
                List<FeeRecordDto> feeRecordDtos = null;
                try {
                    feeRecordDtos = JacksonUtil.str2List(responseStr, FeeRecordDto.class);
                } catch (IOException e) {
                    log.error(e.getMessage());
                }
                long amount = 0;
                for (FeeRecordDto feeRecordDto : feeRecordDtos) {
                    amount = amount + feeRecordDto.getAmount();
                }

                cost = cost + amount;
            }


        }
        return cost;
    }

    private long getSchoolSubjectsCost(List<Long> subjectIds, Long courseTypeId, List<Long> orgIds, Long start, Long end) {
        long cost = 0;
        String url = getSearchURL();
        for (Long orgId : orgIds) {
            Map param = Maps.newHashMap();
            param.put("courseTypeId", courseTypeId.toString());
            param.put("schoolId", orgId.toString());
            param.put("incrurreStartTime", start.toString());
            param.put("incurreEndTime", end.toString());
            for (Long subjectId : subjectIds) {
                param.put("subjectId", subjectId.toString());
                String responseStr = HttpClientUtils.doGet(url, param);
                List<FeeRecordDto> feeRecordDtos = null;
                try {
                    feeRecordDtos = JacksonUtil.str2List(responseStr, FeeRecordDto.class);
                } catch (IOException e) {
                    log.error(e.getMessage());
                }
                long amount = 0;
                for (FeeRecordDto feeRecordDto : feeRecordDtos) {
                    amount = amount + feeRecordDto.getAmount();
                }
                cost = cost + amount;
            }


        }
        return cost;
    }

    private long getCourseCost(List<Long> courseTypeIds, Long orgId, Long start, Long end) {
        long cost = 0;
        String url = getSearchURL();
        for (Long courseTypeId : courseTypeIds) {
            Map param = Maps.newHashMap();
            param.put("courseTypeId", courseTypeId.toString());
            param.put("schoolId", orgId.toString());
            param.put("createStartTime", start.toString());
            param.put("createEndTime", end.toString());
            String responseStr = HttpClientUtils.doGet(url, param);
            List<FeeRecordDto> feeRecordDtos = null;
            try {
                if (!StringUtils.isEmpty(responseStr)) {
                    feeRecordDtos = JacksonUtil.str2List(responseStr, FeeRecordDto.class);
                }
            } catch (IOException e) {
                log.error(e.getMessage());
            }
            long amount = 0;
            if (feeRecordDtos != null) {
                for (FeeRecordDto feeRecordDto : feeRecordDtos) {
                    amount = amount + feeRecordDto.getAmount();
                }
            }
            cost = cost + amount;


        }
        return cost;
    }

    private long getSchoolCost(Long courseTypeId, List<Long> orgIds, Long start, Long end) {
        long cost = 0;
        String url = getSearchURL();
        for (Long orgId : orgIds) {
            Map param = Maps.newHashMap();
            param.put("courseTypeId", courseTypeId.toString());
            param.put("schoolId", orgId.toString());
            param.put("incrurreStartTime", start.toString());
            param.put("incurreEndTime", end.toString());
            String responseStr = HttpClientUtils.doGet(url, param);
            List<FeeRecordDto> feeRecordDtos = null;
            try {
                feeRecordDtos = JacksonUtil.str2List(responseStr, FeeRecordDto.class);
            } catch (IOException e) {
                log.error(e.getMessage());
            }
            long amount = 0;
            for (FeeRecordDto feeRecordDto : feeRecordDtos) {
                amount = amount + feeRecordDto.getAmount();
            }
            cost = cost + amount;


        }
        return cost;
    }

    private String getSearchURL() {
        String urlStr = PropertiesReader.getProperties("fee.properties").getProperty("fee.url.search");
        return urlStr;


    }

    private List<Long> getFilterSubjectId() {
        String subjectStr = PropertiesReader.getProperties("subjectfilter.properties").getProperty("fitersubject");
        String[] idStr = subjectStr.split(".");
        List<Long> ids = new ArrayList<>();
        for (String id : idStr) {
            ids.add(Long.parseLong(id));
        }
        return ids;
    }


    private long getSchoolKexiao(Date start, Date end, List<Long> orgIds) {
        return courseKexiaoDao.getSchoolIncome(start, end, orgIds);
    }

    private long getCourseKexiao(Date start, Date end, List<Long> courseTypeIds) {
        List<Long> courseIds = (List<Long>) courseGroupRelateDao.getCourseIdsByGroupIds(courseTypeIds);
        log.info("符合条件课程:{}", courseIds);
        return courseKexiaoDao.getIncome(start, end, courseIds);
    }

    private Comparator<OperationReportResponse> getCompare(int orderKey, int orderType) {
        return new Comparator<OperationReportResponse>() {
            @Override
            public int compare(OperationReportResponse o1, OperationReportResponse o2) {
                if (orderKey == OrderKey.INCOME.getCode()) {//收入
                    if (orderType == OrderType.ASC.getCode()) {
                        return (int) (o1.getIncome() - o2.getIncome());
                    } else {
                        return (int) (o2.getIncome() - o1.getIncome());
                    }
                } else if (orderKey == OrderKey.COST.getCode()) {//费用
                    if (orderType == OrderType.ASC.getCode()) {
                        return (int) (o1.getCost() - o2.getCost());
                    } else {
                        return (int) (o2.getCost() - o1.getCost());
                    }

                } else if (orderKey == OrderKey.PROFIT.getCode()) {//利润
                    if (orderType == OrderType.ASC.getCode()) {
                        return (int) (o1.getProfit() - o2.getProfit());
                    } else {
                        return (int) (o2.getProfit() - o1.getProfit());
                    }

                } else {
                    if (orderType == OrderType.ASC.getCode()) {
                        return (int) (o1.getEbitda() - o2.getEbitda());
                    } else {
                        return (int) (o2.getEbitda() - o1.getEbitda());
                    }
                }
            }
        };
    }


}
