package com.baijia.tianxiao.biz.dashboard.service.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import lombok.extern.slf4j.Slf4j;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.util.CellRangeAddress;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.classdetail.ClassDetailStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.classdetail.ClassDetailListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.excel.ClassDataDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.excel.StudentDataDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.excel.TeacherDataDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.param.ClassDetailParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.param.SignInStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.param.TeacherDetailParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.param.TeacherListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.param.TeacherSearchParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.teacherdetail.TeacherDetailListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.teacherdetail.TeacherDetailStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.teacherlist.TeacherListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.teacherlist.TeacherListStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.teacherlist.TeacherSearchDto;
import com.baijia.tianxiao.biz.dashboard.service.DashboardKeXiaoV1Service;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ExcelUtils;
import com.baijia.tianxiao.util.storage.StorageUtil;

/**   
 * @title       : DashboardKeXiaoV1ServiceImpl 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2017年2月10日 上午11:21:38 
 */
@Service
@Slf4j
public class DashboardKeXiaoV1ServiceImpl implements DashboardKeXiaoV1Service {
	
	@Autowired
	private OrgInfoDao orgInfoDao;
	@Autowired
	private OrgAccountDao orgAccountDao;
	@Autowired
	private OrgSubAccountDao orgSubAccountDao;
	@Autowired
	private OrgStudentDao orgStudentDao;
	@Autowired
	private OrgTeacherLessonDao orgTeacherLessonDao;
	@Autowired
	private OrgClassLessonDao orgClassLessonDao;
	@Autowired
	private OrgStudentKexiaoRecordDao orgStudentKexiaoRecordDao;
	@Autowired
	private OrgLessonSignDao orgLessonSignDao;
	@Autowired
	private OrgStudentCourseDao orgStudentCourseDao;
	@Autowired
	private OrgTeacherDao orgTeacherDao;
	@Autowired
	private TeacherDao teacherDao;
	@Autowired
	private OrgCourseDao orgCourseDao;
	@Autowired
	private OrgStudentLessonDao orgStudentLessonDao;
	@Autowired
	private StorageDao storageDao;
	
	static <T> List<T> getArrayList(T obj){
		List<T> list = new ArrayList<T>();
		list.add(obj);
		return list;
	}
	
	SignInStatisticsDto getSignInStatisticsDto(List<Long> lessonIds){
		
		//1，签到；2，请假；3，旷课
		Integer originalSigninCount = orgStudentLessonDao.countLessonStudent(lessonIds);
		
		SignInStatisticsDto dto = new SignInStatisticsDto();
		if(originalSigninCount>0){
			Map<Integer, Integer> signInStatusMap = orgLessonSignDao.mapKeyStatusValueCount(lessonIds,null);
			
			dto.setOriginalSigninCount(originalSigninCount);
			dto.setSigninCount( MapUtils.getInteger(signInStatusMap, 1,0) );
			dto.setAskForLeaveCount( MapUtils.getInteger(signInStatusMap, 2,0) );
			dto.setAbsenteeismcCount( MapUtils.getInteger(signInStatusMap, 3,0) );
			dto.setNotSigninCount(dto.getOriginalSigninCount() - dto.getSigninCount() - dto.getAskForLeaveCount() - dto.getAbsenteeismcCount());
		}
		
		return dto;
	}
	
	
	public List<Long> getOrgIds(Long loginerOrgId, Long selectedOrgId){
		List<Long> orgIds = new ArrayList<Long>();
		if(selectedOrgId!=null){
			orgIds.add(selectedOrgId);
		}else{
			orgIds.add(loginerOrgId);
			List<OrgSubAccount> subAccounts = orgSubAccountDao.getSlavesByMasterOrgId(loginerOrgId.intValue(), null);
			if(CollectionUtils.isNotEmpty(subAccounts)){
				for(OrgSubAccount account:subAccounts){
					orgIds.add( account.getOrgId().longValue() );
				}
			}
		}
		return orgIds;
	}
	
	
	
	public List<TeacherSearchDto> teacherSearch(TeacherSearchParamDto param){
		Long orgId = param.getOrgId();
		Long selectedOrgId = param.getSelectedOrgId();
		String teacherName = param.getTeacherName();
		Integer size = param.getSize();
		
		List<TeacherSearchDto> result = new ArrayList<TeacherSearchDto>();
		
		if(StringUtils.isBlank(teacherName)){
			return result;
		}
		
		List<Long> orgIds = getOrgIds(orgId, selectedOrgId);
		PageDto pageDto = new PageDto();
		pageDto.setPageSize(size);
		
		List<Long> teacherIds = orgTeacherDao.listTeacherUserIds(orgIds);
		if(CollectionUtils.isNotEmpty(teacherIds)){
			List<Teacher> teachers = teacherDao.listTeacher(null, teacherIds, teacherName, pageDto);
			TeacherSearchDto dto = null;
			if(CollectionUtils.isNotEmpty(teachers)){
				for(Teacher teacher:teachers){
					dto = new TeacherSearchDto();
					dto.setTeacherId( teacher.getUserId() );
					dto.setTeacherName( teacher.getRealName() );
					result.add(dto);
				}
			}
		}
		
		return result;
	}
	
	
	@Transactional(readOnly=true)
	@Override
	public TeacherListStatisticsDto getTeacherListStatisticsDto(TeacherListParamDto param){
		Long orgId = param.getOrgId();
		Date startTime = param.getStartTimeDate();
		Date endTime = param.getEndTimeDate();
		Long selectedOrgId = param.getSelectedOrgId();
		String teacherName = param.getTeacherName();
		
		List<Long> orgIds = getOrgIds(orgId, selectedOrgId);
		Long kexiaoTotalMoney = 0L;
		Integer teacherCount = 0;
		
		List<Long> teacherIds = orgTeacherDao.listTeacherUserIds(orgIds);
		if(CollectionUtils.isNotEmpty(teacherIds)){
			if(StringUtils.isNotBlank(teacherName)){
				//当按老师搜索是 查询老师对应的lesson 再根据lesson计算课消
				List<Teacher> teachers = teacherDao.listTeacher(null, teacherIds, teacherName, null);
				teacherIds = new ArrayList<Long>();
				for(Teacher teacher : teachers){
					teacherIds.add(teacher.getUserId());
				}
			}
			
			if(CollectionUtils.isNotEmpty(teacherIds)){
				Map<Long, List<Long>> teacherLessonsMap = orgTeacherLessonDao.getTeacherLessonByStartTime(startTime, endTime, teacherIds);
				List<Long> lessonIds = new ArrayList<Long>();
				if( MapUtils.isNotEmpty(teacherLessonsMap) ){
					for(List<Long> values:teacherLessonsMap.values()){
						lessonIds.addAll(values);
					}
					kexiaoTotalMoney = orgStudentKexiaoRecordDao.sumAmountByLesson(lessonIds);
				}
			}
		}
		teacherCount = teacherIds.size();
		
		TeacherListStatisticsDto dto = new TeacherListStatisticsDto();
		dto.setKexiaoTotalMoney(kexiaoTotalMoney);
		if(teacherCount != 0L){
			dto.setKexiaoTeacherAverageMoney( kexiaoTotalMoney/teacherCount );
		}else{
			dto.setKexiaoTeacherAverageMoney(0L);
		}
		
		return dto;
	}
	
	
	@Transactional(readOnly=true)
	@Override
	public List<TeacherListDto> listTeacherListDto(TeacherListParamDto param, PageDto pageDto) {
		Long orgId = param.getOrgId();
		Date startTime = param.getStartTimeDate();
		Date endTime = param.getEndTimeDate();
		Long selectedOrgId = param.getSelectedOrgId();
		String teacherName = param.getTeacherName();
		
		List<Long> orgIds = getOrgIds(orgId, selectedOrgId);
		List<Integer> orgIdsInt = new ArrayList<Integer>();
		for(Long obj:orgIds){
			orgIdsInt.add(obj.intValue());
		}
		
		//数据查询
		Integer count = 0;
		Map<Long,OrgTeacher> teacherMap = orgTeacherDao.mapKeyUserIdVauleTeacher(orgIds);
		Set<Long> teacherIds = teacherMap.keySet();
		if(CollectionUtils.isNotEmpty(teacherIds)){
			count = teacherDao.countTeacher(null, teacherIds, teacherName);
		}
		if(pageDto!=null){
			pageDto.setCount(count);
		}
		
		if(count == 0 ){
			log.info("listTeacherListDto - return - teacherUserIds is empty");
			return new ArrayList<TeacherListDto>();
			
		}else{
			List<TeacherListDto> result = new ArrayList<TeacherListDto>();
			List<Teacher> teachers = teacherDao.listTeacher(null, teacherIds, teacherName, pageDto);
			
			//orgInfo
			Map<Long, OrgInfo> orgInfoMap = new HashMap<Long, OrgInfo>();
			List<OrgInfo> orgs = orgInfoDao.getOrgInfos(orgIdsInt);
			for(OrgInfo orgInfo:orgs){
				orgInfoMap.put(orgInfo.getOrgId().longValue(), orgInfo);
			}
			
			List<Long> teacherUserIds = new ArrayList<Long>();
			for(Teacher teacher : teachers){
				teacherUserIds.add(teacher.getUserId());
			}
			
			//teacherLesson
			Map<Long, List<Long>> teacherLessonsMap = orgTeacherLessonDao.getTeacherLessonByStartTime(startTime, endTime, teacherUserIds);
			Map<Long,Integer> lessonIdVsSignCountMap = new HashMap<Long,Integer>();
			Map<Long,OrgClassLesson> lessonMap = new HashMap<Long,OrgClassLesson>();
			
			List<Long> allLessonIds = new ArrayList<Long>();
			for(List<Long> obj:teacherLessonsMap.values()){
				if(CollectionUtils.isNotEmpty(obj)){
					allLessonIds.addAll(obj);
				}
			}
			
			if(CollectionUtils.isNotEmpty(allLessonIds)){
				lessonIdVsSignCountMap = orgLessonSignDao.mapKeyLessonIdValueCount(allLessonIds);
				lessonMap = orgClassLessonDao.mapOrgClassLesson(allLessonIds);
			}
			
			for(Teacher teacher : teachers){
				List<Long> lessonIds = teacherLessonsMap.get(teacher.getUserId());
				Long teacherOrgId = teacherMap.get(teacher.getUserId()).getOrgId();
				
				TeacherListDto dto = new TeacherListDto();
				dto.setTeacherId(teacher.getUserId());
				dto.setTeacherName(teacher.getRealName());
				dto.setOrgName(orgInfoMap.get(teacherOrgId).getShortName());
				dto.setMobile(teacherMap.get(teacher.getUserId()).getMobile());
				
				if(CollectionUtils.isEmpty(lessonIds)){
					dto.setKexiaoMoney(0L);
					dto.setClassCount(0);
					dto.setLessonTimes(0);
					dto.setLessonMinute(0L);
					dto.setOriginalSigninCount(0);
					dto.setSigninCount(0);
					dto.setAskForLeaveCount(0);
					dto.setAbsenteeismcCount(0);
					dto.setNotSigninCount(0);
					
				}else{
					Set<Long> classIds = new HashSet<Long>();
					Long lessonMinute = 0L;
					Integer lessonTimes = 0;
					OrgClassLesson lesson = null;
					
					for(Long lessonId:lessonIds){
						lesson = lessonMap.get(lessonId);
						classIds.add(lesson.getCourseId());
						if(lessonIdVsSignCountMap.get(lesson.getId().longValue())!=null){
							lessonMinute += lesson.getDurationMinute();
							lessonTimes++;
						}
					}

					dto.setKexiaoMoney( orgStudentKexiaoRecordDao.sumAmountByLesson(lessonIds) );
					dto.setClassCount(classIds.size());
					dto.setLessonTimes(lessonTimes);
					dto.setLessonMinute(lessonMinute);
					
					SignInStatisticsDto signInStatisticsDto = getSignInStatisticsDto(lessonIds);
					dto.setOriginalSigninCount(signInStatisticsDto.getOriginalSigninCount());
					dto.setSigninCount(signInStatisticsDto.getSigninCount());
					dto.setAskForLeaveCount(signInStatisticsDto.getAskForLeaveCount());
					dto.setAbsenteeismcCount(signInStatisticsDto.getAbsenteeismcCount());
					dto.setNotSigninCount(signInStatisticsDto.getNotSigninCount());
				}
				result.add(dto);
			}
			return result;
		}
	}


	@Transactional(readOnly=true)
	@Override
	public TeacherDetailStatisticsDto getTeacherDetailStatisticsDto(TeacherDetailParamDto param) {
		Long teacherId = param.getTeacherId();
		Date startTime = param.getStartTimeDate();
		Date endTime = param.getEndTimeDate();
		
		Teacher teacher = teacherDao.getByUserId(teacherId);
		OrgTeacher orgTeacher = orgTeacherDao.getByUserId(teacherId);
		OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgTeacher.getOrgId().intValue());
		Long kexiaoTotalMoney = 0L;
		Long lessonMinute = 0L;
		Integer lessonTimes = 0;
		
		List<Long> lessonIds = orgTeacherLessonDao.getTeacherLessonIdsByStartTime(startTime, endTime, teacher.getUserId());
		List<Long> lessonIdsFiltrate = new ArrayList<>();
		if(CollectionUtils.isNotEmpty(lessonIds)){
			Map<Long,Integer> lessonIdVsSignInCountMap = orgLessonSignDao.mapKeyLessonIdValueCount(lessonIds);
	
			for(Long lessonId:lessonIds){
				if(lessonIdVsSignInCountMap.get(lessonId)!=null){
					lessonIdsFiltrate.add(lessonId);
				}
			}
		}
		
		if( CollectionUtils.isNotEmpty(lessonIdsFiltrate) ){
			kexiaoTotalMoney = orgStudentKexiaoRecordDao.sumAmountByLesson(lessonIdsFiltrate);
			lessonMinute = orgClassLessonDao.sumLessonDuration(lessonIdsFiltrate)/60;
			lessonTimes = lessonIdsFiltrate.size();
		}
		
		Storage storage = storageDao.getById(teacher.getAvatar());
		String avatarUrl = null;
		if(storage!=null){
			avatarUrl = StorageUtil.constructUrl(storage.getFid(), storage.getMimetype(), storage.getSn());
		}
		
		TeacherDetailStatisticsDto result = new TeacherDetailStatisticsDto();
		result.setHeadImgUrl(avatarUrl);
		result.setTeacherName(teacher.getRealName());
		result.setGender(teacher.getSex());
		result.setOrgName(orgInfo.getShortName());
		result.setKexiaoTotalMoney(kexiaoTotalMoney);
		result.setLessonTimes(lessonTimes);
		result.setLessonMinute(lessonMinute);
		return result;
	}


	@Transactional(readOnly=true)
	@Override
	public List<TeacherDetailListDto> listTeacherDetailListDto(TeacherDetailParamDto param, PageDto pageDto) {
		Long teacherId = param.getTeacherId();
		Date startTime = param.getStartTimeDate();
		Date endTime = param.getEndTimeDate();
		
		Integer count = orgTeacherLessonDao.countClassId(startTime, endTime, teacherId);
		if(pageDto!=null){
			pageDto.setCount(count);
		}
		
		if(count==0){
			log.info("listTeacherDetailListDto - return - classIds is empty");
			return new ArrayList<TeacherDetailListDto>();
			
		}else{
			List<TeacherDetailListDto> result = new ArrayList<TeacherDetailListDto>();
			
			List<Long> classIds = orgTeacherLessonDao.listClassId(startTime, endTime, teacherId, pageDto);
			List<Long> allLessonIds = orgTeacherLessonDao.getTeacherLessonIdsByStartTime(startTime, endTime, teacherId);
			Map<Long, OrgCourse> classMap = orgCourseDao.getOrgCourseMap(classIds);
			
			for(Long classId:classIds){
				TeacherDetailListDto dto = new TeacherDetailListDto();
				dto.setClassId(classId);
				dto.setClassName(classMap.get(classId).getName());
				
				List<OrgClassLesson> lessons = null;
				if(CollectionUtils.isNotEmpty(allLessonIds)){
					lessons = orgClassLessonDao.queryBy(startTime, endTime, classId, allLessonIds);
				}
				
				if(CollectionUtils.isEmpty(lessons)){
					dto.setKexiaoMoney( 0L );
					dto.setLessonTimes(0);
					dto.setLessonMinute(0L);
					dto.setOriginalSigninCount(0);
					dto.setSigninCount(0);
					dto.setAskForLeaveCount(0);
					dto.setAbsenteeismcCount(0);
					dto.setNotSigninCount(0);
					
				}else{
					List<Long> lessonIds = new ArrayList<Long>();
					for(OrgClassLesson lesson:lessons){
						lessonIds.add(lesson.getId());
					}
					
					Map<Long,Integer> lessonIdVsSignCountMap = orgLessonSignDao.mapKeyLessonIdValueCount(lessonIds);
					Long lessonMinute = 0L;
					Integer lessonTimes = 0;
					for(OrgClassLesson lesson:lessons){
						if(lessonIdVsSignCountMap.get(lesson.getId())!=null){
							lessonMinute += lesson.getDurationMinute();
							lessonTimes++;
						}
					}
					dto.setKexiaoMoney( orgStudentKexiaoRecordDao.sumAmountByLesson(lessonIds) );
					dto.setLessonTimes(lessonTimes);
					dto.setLessonMinute(lessonMinute);
					
					SignInStatisticsDto signInStatisticsDto = getSignInStatisticsDto(lessonIds);
					dto.setOriginalSigninCount(signInStatisticsDto.getOriginalSigninCount());
					dto.setSigninCount(signInStatisticsDto.getSigninCount());
					dto.setAskForLeaveCount(signInStatisticsDto.getAskForLeaveCount());
					dto.setAbsenteeismcCount(signInStatisticsDto.getAbsenteeismcCount());
					dto.setNotSigninCount(signInStatisticsDto.getNotSigninCount());
					result.add(dto);
				}
			}			
			return result;
		}
	}

	
	@Transactional(readOnly=true)
	@Override
	public ClassDetailStatisticsDto getClassDetailStatisticsDto(ClassDetailParamDto param) {
		Long classId = param.getClassId();
		Long teacherId = param.getTeacherId();
		Date startTime = param.getStartTimeDate();
		Date endTime = param.getEndTimeDate();
		
		List<Long> lessonIds = new ArrayList<Long>();
		List<OrgClassLesson> lessons = orgClassLessonDao.queryBy(startTime, endTime, classId, null);

		if(CollectionUtils.isNotEmpty(lessons)){
			for(OrgClassLesson lesson:lessons){
				lessonIds.add(lesson.getId());
			}
			lessonIds = orgTeacherLessonDao.listLessonId(lessonIds, teacherId);
		}
		
		Long kexiaoTotalMoney = 0L;
		if(CollectionUtils.isNotEmpty(lessonIds)){
			kexiaoTotalMoney = orgStudentKexiaoRecordDao.sumAmountByLesson(lessonIds);
		}
		
		ClassDetailStatisticsDto result = new ClassDetailStatisticsDto();
		result.setKexiaoTotalMoney(kexiaoTotalMoney);
		return result;
	}

	
	@Transactional(readOnly=true)
	@Override
	public List<ClassDetailListDto> listCLassDetailListDto(ClassDetailParamDto param, PageDto pageDto) {

		Long classId = param.getClassId();
		Long teacherId = param.getTeacherId();
		Date startTime = param.getStartTimeDate();
		Date endTime = param.getEndTimeDate();
		
		
		Integer count = orgStudentCourseDao.countStudents(null, classId, null);
		if(pageDto!=null){
			pageDto.setCount(count);
		}
		
		if(count==0){
			log.info("listCLassDetailListDto - return - students is empty");
			return new ArrayList<ClassDetailListDto>();
			
		}else{
			List<ClassDetailListDto> result = new ArrayList<ClassDetailListDto>();
			log.info("#######################0   classId:"+classId);
			List<Long> studentsUserIds = orgStudentCourseDao.listStudentUserIdsByCourseIds(null, classId);
			log.info("#######################1   studentsUserIds:"+studentsUserIds);
			if(CollectionUtils.isEmpty(studentsUserIds)){
				log.info("listCLassDetailListDto - return - students is empty");
				return new ArrayList<ClassDetailListDto>();
				
			}else{
				List<OrgStudentCourse> studentCourseList = orgStudentCourseDao.listOrderByName(classId, studentsUserIds, pageDto);
				log.info(studentCourseList.size()+" #######################2   studentCourseList:"+studentCourseList);
				//查找老师在班级下的课节
				List<OrgClassLesson> teacherLessons = new ArrayList<OrgClassLesson>();
				List<OrgClassLesson> classLessons = orgClassLessonDao.queryBy(startTime, endTime, classId, null);
				Map<Long,OrgClassLesson> classLessonMap = new HashMap<Long,OrgClassLesson>();
				List<Long> lessonIds = new ArrayList<Long>();

				if(CollectionUtils.isNotEmpty(classLessons)){
					for(OrgClassLesson classLesson:classLessons){
						lessonIds.add(classLesson.getId());
						classLessonMap.put(classLesson.getId(), classLesson);
					}
			
					lessonIds = orgTeacherLessonDao.listLessonId(lessonIds, teacherId);
					if(CollectionUtils.isNotEmpty(lessonIds)){
						for(Long lessonId:lessonIds){
							teacherLessons.add( classLessonMap.get(lessonId) );
						}
					}
				}

				//查学生课节数
				List<Long> studentUserIds = new ArrayList<Long>();
				for(OrgStudentCourse studentCourse:studentCourseList){
					studentUserIds.add( studentCourse.getUserId() );
				}

				Map<Long,Integer> stuLessonCountMap = orgStudentLessonDao.mapStuLessonCount(lessonIds, studentUserIds);
				Map<Long, Long>  kexiaoAmountMap = orgStudentKexiaoRecordDao.sumAmountBy(lessonIds, studentUserIds);

				//Map<courseId,Map<userId,Map<signinStatus, count>>>
			    Map<Long,Map<Long,Map<Integer, Integer>>> courseStuSignStatusMap = orgLessonSignDao.mapStudentSignStatus(lessonIds);
			    //Map<userId,Map<signinStatus, count>>>
			    Map<Long,Map<Integer, Integer>> stuSignStatusMap = courseStuSignStatusMap.get(classId);
			    
				for(OrgStudentCourse studentCourse:studentCourseList){
					Map<Integer, Integer> signInStatusMap = (Map<Integer, Integer>) MapUtils.getMap(stuSignStatusMap, studentCourse.getUserId());
					Long kexiaoMoney = kexiaoAmountMap.get(studentCourse.getUserId());
					if(kexiaoMoney==null){
						kexiaoMoney = 0L;
					}
					
					ClassDetailListDto dto = new ClassDetailListDto();
					dto.setStudentId(studentCourse.getUserId());
					dto.setStudentName(studentCourse.getStudentName());
					dto.setKexiaoMoney( kexiaoMoney );
					dto.setOriginalSigninCount( MapUtils.getInteger(stuLessonCountMap, studentCourse.getUserId(),0) );
					dto.setSigninCount( MapUtils.getInteger(signInStatusMap, 1,0) );
					dto.setAskForLeaveCount( MapUtils.getInteger(signInStatusMap, 2,0) );
					dto.setAbsenteeismcCount( MapUtils.getInteger(signInStatusMap, 3,0) );
					dto.setNotSigninCount(dto.getOriginalSigninCount() - dto.getSigninCount() - dto.getAskForLeaveCount() - dto.getAbsenteeismcCount());
				
					result.add(dto);
				}
			}
			return result;
		}
	}

	
	@Transactional(readOnly=true)
	@Override
	public void downloadExcel(TeacherListParamDto param, OutputStream os) {
		List<TeacherDataDto> teacherDataDtoList = getExcelData(param);
		
		InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("excel/dashboard_kexiao_v1.xlsx");//FIXME
		try{
			XSSFWorkbook workbook = new XSSFWorkbook(in);
	        XSSFSheet sheet = workbook.getSheetAt(0);
	        
	        //1. 汇总页
	        int rowIndex = 1;
	        //CellStyle cellStyle = null;
	        CellStyle cellStyle = sheet.getRow(rowIndex).getCell(0).getCellStyle();
	        for(TeacherDataDto teacherDataDto : teacherDataDtoList){
	        	ExcelUtils.fillTheXSSFCellWithStringValue(sheet, rowIndex, 0,  cellStyle, teacherDataDto.getTeacherName());
	        	ExcelUtils.fillTheXSSFCellWithStringValue(sheet, rowIndex, 1,  cellStyle, teacherDataDto.getMobile());
	        	ExcelUtils.fillTheXSSFCellWithStringValue(sheet, rowIndex, 2,  cellStyle, teacherDataDto.getOrgName());
	        	ExcelUtils.fillTheXSSFCellWithDoubleValue(sheet, rowIndex, 3,  cellStyle, teacherDataDto.getKexiaoMoney());
	        	ExcelUtils.fillTheXSSFCellWithIntValue   (sheet, rowIndex, 4,  cellStyle, teacherDataDto.getClassCount());
	        	ExcelUtils.fillTheXSSFCellWithIntValue   (sheet, rowIndex, 5,  cellStyle, teacherDataDto.getLessonTimes());
	        	ExcelUtils.fillTheXSSFCellWithStringValue(sheet, rowIndex, 6,  cellStyle, teacherDataDto.getLessonDurationStr());
	        	ExcelUtils.fillTheXSSFCellWithIntValue   (sheet, rowIndex, 7,  cellStyle, teacherDataDto.getOriginalSigninCount());
	        	ExcelUtils.fillTheXSSFCellWithIntValue   (sheet, rowIndex, 8,  cellStyle, teacherDataDto.getSigninCount());
	        	ExcelUtils.fillTheXSSFCellWithIntValue   (sheet, rowIndex, 9,  cellStyle, teacherDataDto.getAskForLeaveCount());
	        	ExcelUtils.fillTheXSSFCellWithIntValue   (sheet, rowIndex, 10, cellStyle, teacherDataDto.getAbsenteeismcCount());
	        	ExcelUtils.fillTheXSSFCellWithIntValue   (sheet, rowIndex, 11, cellStyle, teacherDataDto.getNotSigninCount());
	        	rowIndex++;
	        }
	        
	        //2. 详情页
	        sheet = workbook.getSheetAt(1);
	        Integer rowStartIndex = 1;
	        Integer rowEndIndex = rowStartIndex;
	        Integer classDataRowStartIndex = rowStartIndex;
	        Integer classDataRowEndIndex = rowStartIndex;
        	Integer studentDataRowStartIndex = rowStartIndex;
	        
	        for(TeacherDataDto teacherDataDto : teacherDataDtoList){
	        	//填充老师数据
	        	rowEndIndex = rowStartIndex + (teacherDataDto.getRowSize()>0 ? teacherDataDto.getRowSize()-1:0);

	        	if(teacherDataDto.getRowSize()>1){
	        		sheet.addMergedRegion(new CellRangeAddress(rowStartIndex, rowEndIndex, 0, 0));
	        		sheet.addMergedRegion(new CellRangeAddress(rowStartIndex, rowEndIndex, 1, 1));
	        		sheet.addMergedRegion(new CellRangeAddress(rowStartIndex, rowEndIndex, 2, 2));
	        		sheet.addMergedRegion(new CellRangeAddress(rowStartIndex, rowEndIndex, 3, 3));
	        	}
	        	ExcelUtils.fillTheXSSFCellWithStringValue(sheet, rowStartIndex, 0, cellStyle, teacherDataDto.getTeacherName());
	        	ExcelUtils.fillTheXSSFCellWithStringValue(sheet, rowStartIndex, 1, cellStyle, teacherDataDto.getMobile());
	        	ExcelUtils.fillTheXSSFCellWithStringValue(sheet, rowStartIndex, 2, cellStyle, teacherDataDto.getOrgName());
	        	ExcelUtils.fillTheXSSFCellWithDoubleValue(sheet, rowStartIndex, 3, cellStyle, teacherDataDto.getKexiaoMoney());
	        	
	        	//填充班级数据
	        	List<ClassDataDto> classDataDtoList = teacherDataDto.getClassDataDtoList();
	        	if(CollectionUtils.isNotEmpty(classDataDtoList)){
	        		for(ClassDataDto classDataDto : classDataDtoList){
	        			classDataRowEndIndex = classDataRowStartIndex + (classDataDto.getRowSize()>0 ? classDataDto.getRowSize()-1:0);
	        			
	        			if(classDataDto.getRowSize()>1){
	    	        		sheet.addMergedRegion(new CellRangeAddress(classDataRowStartIndex, classDataRowEndIndex, 4, 4));
	    	        		sheet.addMergedRegion(new CellRangeAddress(classDataRowStartIndex, classDataRowEndIndex, 5, 5));
	    	        		sheet.addMergedRegion(new CellRangeAddress(classDataRowStartIndex, classDataRowEndIndex, 6, 6));
	    	        		sheet.addMergedRegion(new CellRangeAddress(classDataRowStartIndex, classDataRowEndIndex, 7, 7));
	    	        	}
	        			ExcelUtils.fillTheXSSFCellWithStringValue(sheet, classDataRowStartIndex, 4, cellStyle, classDataDto.getClassName());
	    	        	ExcelUtils.fillTheXSSFCellWithDoubleValue(sheet, classDataRowStartIndex, 5, cellStyle, classDataDto.getKexiaoMoney());
	    	        	ExcelUtils.fillTheXSSFCellWithIntValue   (sheet, classDataRowStartIndex, 6, cellStyle, classDataDto.getLessonTimes());
	    	        	ExcelUtils.fillTheXSSFCellWithStringValue(sheet, classDataRowStartIndex, 7, cellStyle, classDataDto.getLessonDurationStr());
	    	        	
	    	        	//填充学员数据
	    	        	List<StudentDataDto> studentDataDtoList = classDataDto.getStudentDataDtoList();
	    	        	if(CollectionUtils.isNotEmpty(studentDataDtoList)){
	    	        		for(StudentDataDto studentDataDto:studentDataDtoList){
	    	        			ExcelUtils.fillTheXSSFCellWithStringValue(sheet, studentDataRowStartIndex, 8,  cellStyle, studentDataDto.getStudentName());
	    	        			ExcelUtils.fillTheXSSFCellWithDoubleValue(sheet, studentDataRowStartIndex, 9,  cellStyle, studentDataDto.getKexiaoMoney());
	    	    	        	ExcelUtils.fillTheXSSFCellWithIntValue   (sheet, studentDataRowStartIndex, 10, cellStyle, studentDataDto.getOriginalSigninCount());
	    	    	        	ExcelUtils.fillTheXSSFCellWithIntValue   (sheet, studentDataRowStartIndex, 11, cellStyle, studentDataDto.getSigninCount());
	    	    	        	ExcelUtils.fillTheXSSFCellWithIntValue   (sheet, studentDataRowStartIndex, 12, cellStyle, studentDataDto.getAskForLeaveCount());
	    	    	        	ExcelUtils.fillTheXSSFCellWithIntValue   (sheet, studentDataRowStartIndex, 13, cellStyle, studentDataDto.getAbsenteeismcCount());
	    	    	        	ExcelUtils.fillTheXSSFCellWithIntValue   (sheet, studentDataRowStartIndex, 14, cellStyle, studentDataDto.getNotSigninCount());
	    	    	        	
	    	    	        	studentDataRowStartIndex += 1;//换行
	    	        		}
	    	        	}
	    	        	
	    	        	classDataRowStartIndex = classDataRowEndIndex + 1;//换行
	        		}
	        	}
        		rowStartIndex = rowEndIndex + 1;//换行
        		classDataRowStartIndex = rowStartIndex;
        		studentDataRowStartIndex = rowStartIndex;
	        }
	        
	        workbook.write(os);
		}catch(Exception e){
			log.error("",e);
		}
	}
	
	
	@Transactional(readOnly=true)
	List<TeacherDataDto> getExcelData(TeacherListParamDto param){
		Long orgId = param.getOrgId();
		Date startTime = param.getStartTimeDate();
		Date endTime = param.getEndTimeDate();
		Long selectedOrgId = param.getSelectedOrgId();
		Long teacherId = param.getTeacherId();
		String teacherName = param.getTeacherName();
		
		List<TeacherDataDto> teacherDataDtoList = new ArrayList<TeacherDataDto>();
		
		//查找老师
		List<Long> orgIds = getOrgIds(orgId, selectedOrgId);
		List<Long> teacherIds = new ArrayList<Long>();
		List<Teacher> teachers = null;
		if(teacherId!=null){
			teacherIds.add(teacherId);
		}else{
			teacherIds = orgTeacherDao.listTeacherUserIds(orgIds);
			
			if(CollectionUtils.isNotEmpty(teacherIds)){
				if(StringUtils.isNotBlank(teacherName)){
					//当按老师搜索是 查询老师对应的lesson 再根据lesson计算课消
					teachers = teacherDao.listTeacher(null, teacherIds, teacherName, null);
					teacherIds = new ArrayList<Long>();
					for(Teacher teacher : teachers){
						teacherIds.add(teacher.getUserId());
					}
				}
			}
		}
		
		if(CollectionUtils.isNotEmpty(teacherIds)){
			//Map<teacherUserId, Map<courseId, List<lessonId>>>
			Map<Long, Map<Long, List<Long>>> teacherCourseMap =  orgTeacherLessonDao.getTeacherCourseLessonBy(startTime, endTime, teacherIds);
			Map<Long, Integer> courseTeacherCountMap = orgTeacherLessonDao.mapDisticntTeacherCountByCourse(startTime, endTime, teacherIds);
			Map<Long,OrgTeacher> orgTeacherMap = orgTeacherDao.mapKeyUserIdVauleTeacher(orgIds);
			
			if(teacherCourseMap.size()>0){
				//老师信息
				if(teachers==null){
					teachers = teacherDao.listTeacher(null, teacherIds, null, null);
				}
				
				//机构信息
				List<Integer> orgIdsInt = new ArrayList<Integer>();
				for(Long orgIdLong:orgIds){
					orgIdsInt.add(orgIdLong.intValue());
				}
				Map<Integer,OrgInfo> orgInfoMap = orgInfoDao.getOrgInfoMap(orgIdsInt);
				
				//班级信息
				List<Long> courseIds = new ArrayList<Long>();
				List<Long> lessonIds = new ArrayList<Long>();
				Map<Long, List<Long>> courseLessonMap = null;
				for(Long teacherUserId :teacherCourseMap.keySet()){
					courseLessonMap = teacherCourseMap.get(teacherUserId);
					courseIds.addAll(courseLessonMap.keySet());
					for(List<Long> courseLessonIds:courseLessonMap.values()){
						lessonIds.addAll(courseLessonIds);
					}
				}
				Map<Long, OrgCourse> orgCourses = orgCourseDao.getOrgCourseMap(courseIds);
				
				//学员信息
				Map<Long,List<Long>> courseStuUserIdMap = orgStudentCourseDao.mapCourseIdStuList(courseIds);
				Map<Long, OrgStudent> studentMap = new HashMap<Long, OrgStudent>();
				if(MapUtils.isNotEmpty(courseStuUserIdMap)){
					List<Long> studentIdsList = new ArrayList<Long>();
					for(List<Long> list:courseStuUserIdMap.values()){
						if(CollectionUtils.isNotEmpty(list)){
							studentIdsList.addAll(list);
						}
					}
					if(CollectionUtils.isNotEmpty(studentIdsList)){
						studentMap = orgStudentDao.getStudentMap(studentIdsList,null);
					}
				}
				
				//Map<courseId,Map<studentUserId,lessonCount>>
			    Map<Long,Map<Long,Integer>> courseStuLessonCountMap = orgStudentLessonDao.mapCourseStuLessonCount(lessonIds);
			    //已上课次课时 (有签到才算已上课次课时)
			    Map<Long,Integer> lessonIdVsSignCountMap = orgLessonSignDao.mapKeyLessonIdValueCount(lessonIds);
			    //课消信息
			    //Map<courseId,Map<studentUserId,amount>> 
			    Map<Long, Map<Long, Long>> courseStuKexiao = orgStudentKexiaoRecordDao.mapCourseStudentAmountBy(lessonIds);
			    //签到信息
			    //Map<courseId,Map<userId,Map<signinStatus, count>>>
			    Map<Long,Map<Long,Map<Integer, Integer>>> courseStuSignStatusMap = orgLessonSignDao.mapStudentSignStatus(lessonIds);
			    //课节信息
			    Map<Long,OrgClassLesson> lessonMap = orgClassLessonDao.mapOrgClassLesson(lessonIds);
			    
			    
				for(Teacher teacher:teachers){
					OrgTeacher orgTeacher = orgTeacherMap.get(teacher.getUserId());
					
					TeacherDataDto teacherDataDto = new TeacherDataDto();
					teacherDataDto.setTeacherId(teacher.getUserId());
					teacherDataDto.setTeacherName(teacher.getRealName());
					teacherDataDto.setMobile(orgTeacher.getMobile());
					teacherDataDto.setOrgName( orgInfoMap.get(orgTeacher.getOrgId().intValue()).getShortName() );
					teacherDataDto.setKexiaoMoney(0L);
					teacherDataDto.setLessonTimes(0);
					teacherDataDto.setLessonMinute(0L);
					teacherDataDto.setClassCount(0);
					teacherDataDto.setOriginalSigninCount( 0 );
					teacherDataDto.setSigninCount( 0 );
					teacherDataDto.setAskForLeaveCount( 0 );
					teacherDataDto.setAbsenteeismcCount( 0 );
					teacherDataDto.setNotSigninCount(0);
					teacherDataDtoList.add(teacherDataDto);
					
					courseLessonMap = teacherCourseMap.get(teacher.getUserId());
					if(MapUtils.isNotEmpty(courseLessonMap)){
						teacherDataDto.setClassCount(courseLessonMap.size());
						List<ClassDataDto> classDataDtoList = new ArrayList<ClassDataDto>();
						for(Long courseId:courseLessonMap.keySet()){
							
							//有签到的课节 计入 已上课时、课次
							Long lessonMinute = 0L;
							Integer lessonTimes = 0;
							courseLessonMap = teacherCourseMap.get(teacher.getUserId());
							List<Long> courseLessonIds = courseLessonMap.get(courseId);

							Map<Long,Map<Long,Map<Integer, Integer>>> courseStuSignStatusMapTemp = courseStuSignStatusMap;
							Map<Long,Map<Long,Integer>> courseStuLessonCountMapTemp = courseStuLessonCountMap;
							Map<Long,Integer> lessonIdVsSignCountMapTemp = lessonIdVsSignCountMap;
							Map<Long, Map<Long, Long>> courseStuKexiaoTemp = courseStuKexiao;
							if(courseTeacherCountMap.get(courseId.longValue())>1){ //如果该班级下的老师数大于1 则重新计算该班数据
								courseStuSignStatusMapTemp = orgLessonSignDao.mapStudentSignStatus(courseLessonIds);;
								courseStuLessonCountMapTemp = orgStudentLessonDao.mapCourseStuLessonCount(courseLessonIds);
								lessonIdVsSignCountMapTemp =  orgLessonSignDao.mapKeyLessonIdValueCount(courseLessonIds);
								courseStuKexiaoTemp = orgStudentKexiaoRecordDao.mapCourseStudentAmountBy(courseLessonIds);
							}
							
						    if(CollectionUtils.isNotEmpty(courseLessonIds)){
								//List<OrgClassLesson> lessons = orgClassLessonDao.queryByIds(courseLessonIds);
								for(Long lessonId:courseLessonIds){
									OrgClassLesson lesson = lessonMap.get(lessonId.longValue());
									if(lessonIdVsSignCountMapTemp.get(lesson.getId().longValue())!=null){
										lessonMinute += lesson.getDurationMinute();
										lessonTimes++;
									}
								}
							}
							
							ClassDataDto classDataDto = new ClassDataDto();
							classDataDto.setClassId(courseId);
							classDataDto.setClassName( orgCourses.get(courseId).getName() );
							classDataDto.setKexiaoMoney(0L);
							classDataDto.setLessonTimes(lessonTimes);
							classDataDto.setLessonMinute(lessonMinute);
							
							teacherDataDto.setLessonTimes( teacherDataDto.getLessonTimes() + classDataDto.getLessonTimes());
							teacherDataDto.setLessonMinute( teacherDataDto.getLessonMinute() + classDataDto.getLessonMinute());
							
							List<Long> courseStudentList = courseStuUserIdMap.get(courseId);
							List<StudentDataDto> studentDataDtoList = new ArrayList<StudentDataDto>();
							if(CollectionUtils.isNotEmpty(courseStudentList)){
								for(Long courseStuUserId: courseStudentList){
									Map<Long, Long> stuKexiaoMap = courseStuKexiaoTemp.get(courseId);
									Map<Long, Integer> stuLessonCountMap = courseStuLessonCountMapTemp.get(courseId);
									Map<Integer, Integer> signStatusMap = null;
									if(courseStuSignStatusMapTemp.get(courseId)!=null){
										signStatusMap = courseStuSignStatusMapTemp.get(courseId).get(courseStuUserId);
									}
									
									StudentDataDto studentDataDto = new StudentDataDto();
									studentDataDto.setStudentId(courseStuUserId);
									studentDataDto.setStudentName(studentMap.get(courseStuUserId.longValue()).getName());
									studentDataDto.setKexiaoMoney( MapUtils.getLong(stuKexiaoMap, courseStuUserId,0L) );
									studentDataDto.setOriginalSigninCount( MapUtils.getInteger(stuLessonCountMap, courseStuUserId,0) );
									studentDataDto.setSigninCount( MapUtils.getInteger(signStatusMap, 1,0) );
									studentDataDto.setAskForLeaveCount( MapUtils.getInteger(signStatusMap, 2,0) );
									studentDataDto.setAbsenteeismcCount( MapUtils.getInteger(signStatusMap, 3,0) );
									studentDataDto.setNotSigninCount(studentDataDto.getOriginalSigninCount() - studentDataDto.getSigninCount() - studentDataDto.getAskForLeaveCount() - studentDataDto.getAbsenteeismcCount());
									studentDataDtoList.add(studentDataDto);
									
									classDataDto.setKexiaoMoney( classDataDto.getKexiaoMoneyLong() + studentDataDto.getKexiaoMoneyLong());
									classDataDto.setRowSize( classDataDto.getRowSize() + 1);
									
									teacherDataDto.setKexiaoMoney( teacherDataDto.getKexiaoMoneyLong() + studentDataDto.getKexiaoMoneyLong() );
									teacherDataDto.setOriginalSigninCount( teacherDataDto.getOriginalSigninCount() + studentDataDto.getOriginalSigninCount() );
									teacherDataDto.setSigninCount( teacherDataDto.getSigninCount() + studentDataDto.getSigninCount() );
									teacherDataDto.setAskForLeaveCount( teacherDataDto.getAskForLeaveCount() + studentDataDto.getAskForLeaveCount() );
									teacherDataDto.setAbsenteeismcCount( teacherDataDto.getAbsenteeismcCount() + studentDataDto.getAbsenteeismcCount() );
									teacherDataDto.setNotSigninCount( teacherDataDto.getNotSigninCount() + studentDataDto.getNotSigninCount() );
									teacherDataDto.setRowSize( teacherDataDto.getRowSize() + 1);
								}
							}
							classDataDto.setStudentDataDtoList(studentDataDtoList);
							classDataDtoList.add(classDataDto);
						}
						teacherDataDto.setClassDataDtoList(classDataDtoList);
					}
				}
			}
		}
		
		return teacherDataDtoList;
	}
	
	
}
