package com.baijia.tianxiao.biz.dashboard.dto.unKexiao.request;

import com.google.common.base.Preconditions;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Collection;

/**
 * @title       : OrgUnKexiaoListParam
 * @description :校区待消列表请求参数
 * @author      : fulinyu
 * @date        : 2017年8月21日
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper = true)
public class OrgUnKexiaoListParam extends UnKexiaoListParam{

    private Long orgId;

    private boolean containSubOrg;//是否包含子校区

    private Collection<Integer> filterSubOrgTypes;//不计入统计的子校区类型

    public void validate(){
        Preconditions.checkArgument(orgId!=null,"校区id为空");
    }

}
