package com.baijia.tianxiao.biz.dashboard.dto.unKexiao.request;

import com.baijia.tianxiao.biz.dashboard.dto.unKexiao.constant.StatisticsScaleEnum;
import com.google.common.base.Preconditions;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.apache.commons.lang.StringUtils;

/**
 * @author : fulinyu
 * @title : ClassUnKexiaoListParam
 * @description : 班级待消列表请求参数
 * @date : 2017年8月21日
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ClassUnKexiaoListParam extends UnKexiaoListParam {

    private Long orgId;
    private Long studentUserId;
    private String keyword;//班级名称
    private Integer courseType;
    private Integer chargeType;
    private Integer chargeUnit;
    private Integer scale; //统计维度

    public void validate() {
        Preconditions.checkArgument(StatisticsScaleEnum.validate(scale), "统计范围类型无效");
        if (scale.intValue() == StatisticsScaleEnum.ORG.getCode()) {//校区维度下的班级待消统计
            this.orgClassValidate();
        } else if (scale.intValue() == StatisticsScaleEnum.STUDENT.getCode()) {//学生维度下的待消班级统计
            this.studentClassValidate();
        }
    }

    private void orgClassValidate() {
        Preconditions.checkArgument(orgId != null, "校区id为空");
    }

    private void studentClassValidate() {
        Preconditions.checkArgument(orgId != null, "校区id为空");
        Preconditions.checkArgument(studentUserId != null, "学员id为空");
    }

    public boolean isEmptyConditionQuery() {
        if (StringUtils.isNotBlank(keyword) || courseType != null || chargeType != null || chargeUnit != null) {
            return false;
        } else {
            return true;
        }
    }

}
