package com.baijia.tianxiao.biz.dashboard.dto.unKexiao.reponse;

import com.baijia.tianxiao.biz.dashboard.dto.kexiao.DashboadrKexiaoDtoHelper;
import com.baijia.tianxiao.sal.kexiao.dto.LessonKexiaoStatisticsDto;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * @author : fulinyu
 * @title : UnKexiaoStatisticsDto
 * @description : 待消统计信息
 * @date : 2017年8月21日
 */
@Data
@Slf4j
public class UnKexiaoStatisticsDto {

    /**
     * 待消小时数及金额
     */
    private Long unKexiaoMinute;
    private String unKexiaoHourStr;
    private Long unKexiaoHourMoneyLong;
    private Double unKexiaoHourMoney;

    /**
     * 待消次数及金额
     */
    private Long unKexiaoTimes;
    private Long unKexiaoTimesMoneyLong;
    private Double unKexiaoTimesMoney;


    /**
     * 待消金额
     */
    private Double unKexiaoMoney;

    /**
     * 待消总金额[同待消金额]
     */
    private Double totalUnKexiaoMoney;

    public static boolean isZero(UnKexiaoStatisticsDto dto) {
        if (dto == null) {
            return true;
        }
        if ((dto.getUnKexiaoMinute() == null || dto.getUnKexiaoMinute() == 0) && (dto.getUnKexiaoHourMoneyLong() == null || dto.getUnKexiaoHourMoneyLong() == 0) && (dto.getUnKexiaoTimes() == null || dto.getUnKexiaoTimes() == 0) && (dto.getUnKexiaoTimesMoneyLong() == null || dto.getUnKexiaoTimesMoneyLong() == 0)) {
            return true;
        }
        return false;
    }

    /**
     * 创建0值对象[创建对象,并赋所有属性为0值]
     *
     * @return
     */
    public static UnKexiaoStatisticsDto createWithZeroValue() {
        UnKexiaoStatisticsDto dto = new UnKexiaoStatisticsDto();
        dto.setUnKexiaoMinute(0l);
        dto.setUnKexiaoHourStr("0小时");
        dto.setUnKexiaoHourMoneyLong(0l);
        dto.setUnKexiaoHourMoney(0.00);
        dto.setUnKexiaoTimes(0l);
        dto.setUnKexiaoTimesMoneyLong(0l);
        dto.setUnKexiaoTimesMoney(0.00);
        dto.setUnKexiaoMoney(0.00);
        dto.setTotalUnKexiaoMoney(0.00);
        return dto;
    }

    public static List<UnKexiaoStatisticsDto> createWithZeroValue(int count) {
        List<UnKexiaoStatisticsDto> dtoList = Lists.newArrayList();
        for (int i = 0; i < count; i++) {
            dtoList.add(UnKexiaoStatisticsDto.createWithZeroValue());
        }
        return dtoList;
    }

    /**
     * 根据:[报名+超排(赠送)-已消-退费-转出] 数据 计算出 [待消] 数据
     *
     * @param signupStatisticsDto
     * @param freeLessonStatisticsDto
     * @param kexiaoFinishedStatisticsDto
     * @param refundStatisticsDto
     * @param transferStatisticsDto
     * @return
     */
    public static UnKexiaoStatisticsDto fromLessonKexiaoStatisticsDto(LessonKexiaoStatisticsDto signupStatisticsDto, LessonKexiaoStatisticsDto freeLessonStatisticsDto, LessonKexiaoStatisticsDto kexiaoFinishedStatisticsDto, LessonKexiaoStatisticsDto refundStatisticsDto, LessonKexiaoStatisticsDto transferStatisticsDto) {
        log.info("待消统计计算参数 : 报名 = {}, 超排 = {}, 已消 = {}, 退费 = {}, 转出 = {} .", signupStatisticsDto, freeLessonStatisticsDto, kexiaoFinishedStatisticsDto, refundStatisticsDto, transferStatisticsDto);
        UnKexiaoStatisticsDto dto = UnKexiaoStatisticsDto.createWithZeroValue();
        //如果报名数据为空,则后续数据不用统计
        if (!LessonKexiaoStatisticsDto.isZero(signupStatisticsDto)) {
            //待消=报名+超排(赠送)-已消-退费-转出
            dto.plus(signupStatisticsDto);
            dto.plus(freeLessonStatisticsDto);
            dto.minus(kexiaoFinishedStatisticsDto);
            dto.minus(refundStatisticsDto);
            dto.minus(transferStatisticsDto);
            dto.transferUnit();
        }
        log.info("待消统计计算结果 : {} ", dto);
        return dto;
    }

    /**
     * 将时长信息置null
     */
    public void setMinuteInfoNull() {
        unKexiaoMinute = null;
        unKexiaoHourStr = null;
        unKexiaoHourMoneyLong = null;
        unKexiaoHourMoney = null;
    }

    /**
     * 将时间信息置null
     */
    public void setTimeInfoNull() {
        unKexiaoTimes = null;
        unKexiaoTimesMoneyLong = null;
        unKexiaoTimesMoney = null;
    }

    public void transferUnit() {
        this.transferMinuteToHour();
        this.transferFenToYuan();
    }

    private void transferMinuteToHour() {
        if (unKexiaoMinute != null) {
            unKexiaoHourStr = DateUtil.minutesToHHmmStr(unKexiaoMinute);
        } else {
            unKexiaoHourStr = null;
        }
    }

    private void transferFenToYuan() {//把钱的数值由单位分转换为单位元
        if (unKexiaoHourMoneyLong != null) {
            unKexiaoHourMoney = DashboadrKexiaoDtoHelper.moneyDividedBy100(unKexiaoHourMoneyLong);
        } else {
            unKexiaoHourMoneyLong = 0l;
            unKexiaoHourMoney = 0.00;
        }
        if (unKexiaoTimesMoneyLong != null) {
            unKexiaoTimesMoney = DashboadrKexiaoDtoHelper.moneyDividedBy100(unKexiaoTimesMoneyLong);
        } else {
            unKexiaoTimesMoneyLong = 0l;
            unKexiaoTimesMoney = 0.00;
        }
        totalUnKexiaoMoney = unKexiaoHourMoney + unKexiaoTimesMoney;
        totalUnKexiaoMoney = DashboadrKexiaoDtoHelper.twoDecimal(totalUnKexiaoMoney);
        unKexiaoMoney = totalUnKexiaoMoney;
    }

    /**
     * 加
     *
     * @param dto
     */
    private void plus(LessonKexiaoStatisticsDto dto) {
        log.info("plus params : {}", dto);
        if (!LessonKexiaoStatisticsDto.isZero(dto)) {
            this.unKexiaoMinute = this.unKexiaoMinute + dto.getMinutes();
            this.unKexiaoHourMoneyLong = this.unKexiaoHourMoneyLong + dto.getMinutesMoneyLong();
            this.unKexiaoTimes = this.unKexiaoTimes + dto.getTimes();
            this.unKexiaoTimesMoneyLong = this.unKexiaoTimesMoneyLong + dto.getTimesMoneyLong();
        }
    }

    /**
     * 加
     *
     * @param dto
     */
    public void add(UnKexiaoStatisticsDto dto) {
        log.info("add params : {}", dto);
        if (!UnKexiaoStatisticsDto.isZero(dto)) {
            if (dto.getUnKexiaoMinute() != null) {
                this.unKexiaoMinute = this.unKexiaoMinute + dto.getUnKexiaoMinute();
            }
            if (dto.getUnKexiaoHourMoneyLong() != null) {
                this.unKexiaoHourMoneyLong = this.unKexiaoHourMoneyLong + dto.getUnKexiaoHourMoneyLong();
            }
            if (dto.getUnKexiaoTimes() != null) {
                this.unKexiaoTimes = this.unKexiaoTimes + dto.getUnKexiaoTimes();
            }
            if (dto.getUnKexiaoTimesMoneyLong() != null) {
                this.unKexiaoTimesMoneyLong = this.unKexiaoTimesMoneyLong + dto.getUnKexiaoTimesMoneyLong();
            }
        }
    }

    /**
     * 减
     *
     * @param dto
     */
    private void minus(LessonKexiaoStatisticsDto dto) {
        log.info("minus params : {}", dto);
        if (!LessonKexiaoStatisticsDto.isZero(dto)) {
            this.unKexiaoMinute = this.unKexiaoMinute - dto.getMinutes();
            this.unKexiaoHourMoneyLong = this.unKexiaoHourMoneyLong - dto.getMinutesMoneyLong();
            this.unKexiaoTimes = this.unKexiaoTimes - dto.getTimes();
            this.unKexiaoTimesMoneyLong = this.unKexiaoTimesMoneyLong - dto.getTimesMoneyLong();
        }
    }

}
