package com.baijia.tianxiao.biz.dashboard.dto.unKexiao.reponse;

import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.google.common.collect.Lists;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NonNull;
import lombok.ToString;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author : fulinyu
 * @title : StudentUnKexiaoDto
 * @description : 学员待消数据
 * @date : 2017年8月21日
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class StudentUnKexiaoDto extends UnKexiaoStatisticsDto {

    private Long studentUserId;
    private String studentName;

    //删除状态
    private Integer isDel;

    public static StudentUnKexiaoDto from(OrgStudent orgStudent, UnKexiaoStatisticsDto statisticsDto) {
        StudentUnKexiaoDto studentDto = new StudentUnKexiaoDto();
        if (orgStudent != null) {
            studentDto.setStudentUserId(orgStudent.getUserId());
            String name = orgStudent.getName();
            if (orgStudent.getDelStatus() == 1) {
                name = name + "(已删除)";
            }
            studentDto.setStudentName(name);
            studentDto.setIsDel(orgStudent.getDelStatus());
        }
        if (statisticsDto == null) {
            statisticsDto = UnKexiaoStatisticsDto.createWithZeroValue();
        }
        BeanUtils.copyProperties(statisticsDto, studentDto);
        return studentDto;
    }

    public static List<StudentUnKexiaoDto> listFrom(List<Long> userIds, @NonNull Map<Long, OrgStudent> OrgStudentMap, @NonNull Map<Long, UnKexiaoStatisticsDto> statisticsDtoMap) {
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.emptyList();
        }
        List<StudentUnKexiaoDto> result = Lists.newArrayList();
        for (Long userId : userIds) {
            StudentUnKexiaoDto studentDto = StudentUnKexiaoDto.from(OrgStudentMap.get(userId), statisticsDtoMap.get(userId));
            result.add(studentDto);
        }
        return result;
    }

    public static UnKexiaoStatisticsDto sum(List<StudentUnKexiaoDto> dtoList){
        UnKexiaoStatisticsDto sumDto = UnKexiaoStatisticsDto.createWithZeroValue();
        for(StudentUnKexiaoDto dto : dtoList){
            sumDto.add(dto);
        }
        sumDto.transferUnit();
        return sumDto;
    }

}
