package com.baijia.tianxiao.biz.dashboard.dto.unKexiao.reponse;

import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.google.common.collect.Lists;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NonNull;
import lombok.ToString;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author : fulinyu
 * @title : OrgUnKexiaoDto
 * @description : 校区待消数据
 * @date : 2017年8月21日
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class OrgUnKexiaoDto extends UnKexiaoStatisticsDto {

    private String orgName;
    private Long campusNumber;

    public static OrgUnKexiaoDto from(OrgInfo orgInfo, Long orgNumber, UnKexiaoStatisticsDto dto) {
        OrgUnKexiaoDto orgDto = new OrgUnKexiaoDto();
        if (dto == null) {
            dto = UnKexiaoStatisticsDto.createWithZeroValue();
        }
        if (orgInfo != null) {
            orgDto.setOrgName(orgInfo.getShortName());
            orgDto.setCampusNumber(orgNumber);
        }
        BeanUtils.copyProperties(dto, orgDto);
        return orgDto;
    }

    public static List<OrgUnKexiaoDto> listFrom(List<Long> orgIds, Map<Long, Long> orgNumbers, @NonNull Map<Long, OrgInfo> orgInfoMap, @NonNull Map<Long, UnKexiaoStatisticsDto> statisticsDtoMap) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Collections.emptyList();
        }
        List<OrgUnKexiaoDto> result = Lists.newArrayList();
        for (Long orgId : orgIds) {
            OrgUnKexiaoDto orgDto = OrgUnKexiaoDto.from(orgInfoMap.get(orgId), orgNumbers.get(orgId), statisticsDtoMap.get(orgId));
            result.add(orgDto);
        }
        return result;
    }

    public static UnKexiaoStatisticsDto sum(List<OrgUnKexiaoDto> dtoList) {
        UnKexiaoStatisticsDto sumDto = UnKexiaoStatisticsDto.createWithZeroValue();
        for (OrgUnKexiaoDto dto : dtoList) {
            sumDto.add(dto);
        }
        sumDto.transferUnit();
        return sumDto;
    }

}
