package com.baijia.tianxiao.biz.dashboard.dto.unKexiao.reponse;

import com.baijia.tianxiao.biz.dashboard.dto.kexiao.DashboadrKexiaoDtoHelper;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.google.common.collect.Lists;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NonNull;
import lombok.ToString;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author : fulinyu
 * @title : ClassUnKexiaoDto
 * @description : 班级待消数据
 * @date : 2017年8月21日
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ClassUnKexiaoDto extends UnKexiaoStatisticsDto {

    //班级
    private Long classId;
    private String className;
    //删除状态
    private Integer isDel;

    //课程类型
    private Integer courseType;
    private String courseTypeStr;

    //收费类型
    private Integer chargeType;
    private String chargeTypeStr;

    //计费类型
    private Integer chargeUnit;
    private String chargeUnitStr;

    public static ClassUnKexiaoDto from(OrgCourse orgClass, UnKexiaoStatisticsDto dto) {
        ClassUnKexiaoDto classDto = new ClassUnKexiaoDto();
        if (dto == null) {
            dto = UnKexiaoStatisticsDto.createWithZeroValue();
        }
        BeanUtils.copyProperties(dto, classDto);
        if (orgClass != null) {
            classDto.setClassId(orgClass.getId());
            String name = orgClass.getName();
            if (orgClass.getIsDel() == 1) {
                name = name + "(已删除)";
            }
            classDto.setClassName(name);
            classDto.setIsDel(orgClass.getIsDel());
            classDto.setCourseType(orgClass.getCourseType());
            classDto.setChargeType(orgClass.getChargeType());
            classDto.setChargeUnit(orgClass.getChargeUnit());
            if (ChargeUnit.isByDuration(orgClass.getChargeUnit())) {//按时长
                classDto.setTimeInfoNull();
            } else {
                classDto.setMinuteInfoNull();
            }
        }
        return classDto;
    }

    public static List<ClassUnKexiaoDto> listFrom(List<Long> classIds, @NonNull Map<Long, OrgCourse> orgClassMap, @NonNull Map<Long, UnKexiaoStatisticsDto> statisticsDtoMap) {
        if (CollectionUtils.isEmpty(classIds)) {
            return Collections.emptyList();
        }
        List<ClassUnKexiaoDto> result = Lists.newArrayList();
        for (Long orgId : classIds) {
            ClassUnKexiaoDto orgDto = ClassUnKexiaoDto.from(orgClassMap.get(orgId), statisticsDtoMap.get(orgId));
            result.add(orgDto);
        }
        return result;
    }

    public static UnKexiaoStatisticsDto sum(List<ClassUnKexiaoDto> dtoList) {
        UnKexiaoStatisticsDto sumDto = UnKexiaoStatisticsDto.createWithZeroValue();
        for (ClassUnKexiaoDto dto : dtoList) {
            sumDto.add(dto);
        }
        sumDto.transferUnit();
        return sumDto;
    }

    public String getCourseTypeStr() {

        return DashboadrKexiaoDtoHelper.getCourseTypeStr(this.courseType);
    }

    public String getChargeTypeStr() {

        return DashboadrKexiaoDtoHelper.getChargeTypeStr(this.chargeType);
    }

    public String getChargeUnitStr() {

        return DashboadrKexiaoDtoHelper.getChargeUnitStr(this.chargeUnit);
    }

}
