package com.baijia.tianxiao.biz.dashboard.dto.unKexiao.reponse;

import com.baijia.tianxiao.biz.dashboard.dto.kexiao.DashboadrKexiaoDtoHelper;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.springframework.beans.BeanUtils;

import java.math.BigDecimal;

/**
 * @title       : ClassStatisticsDto
 * @description : 班级待消汇总
 * @author      : fulinyu
 * @date        : 2017年8月21日
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper = true)
public class ClassStatisticsDto extends ClassUnKexiaoDto{

    private Integer kexiaoRule;
    private String kexiaoRuleStr;

    private Integer studentCount;

    public String getKexiaoRuleStr(){
        return DashboadrKexiaoDtoHelper.getKexiaoRuleStr(kexiaoRule);
    }

    public static ClassStatisticsDto from(OrgCourse orgClass, Integer kexiaoRule, Integer studentCount, UnKexiaoStatisticsDto dto){
        ClassStatisticsDto classDto = new ClassStatisticsDto();
        if (dto == null) {
            dto = UnKexiaoStatisticsDto.createWithZeroValue();
        }
        if (orgClass != null) {
            classDto.setClassId(orgClass.getId());
            classDto.setClassName(orgClass.getName());
            classDto.setCourseType(orgClass.getCourseType());
            classDto.setChargeType(orgClass.getChargeType());
            classDto.setChargeUnit(orgClass.getChargeUnit());
        }
        classDto.setKexiaoRule(kexiaoRule);
        classDto.setStudentCount(studentCount);
        BeanUtils.copyProperties(dto, classDto);
        return classDto;
    }

    public static void main(String[] args){
        BigDecimal minutes =new BigDecimal(75);
        BigDecimal hourMinutes =new BigDecimal(60);
        double hours =  minutes.divide(hourMinutes,2,BigDecimal.ROUND_HALF_UP).doubleValue();
        System.out.print(hours);
    }

}
