package com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.excel;



import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.DashboadrKexiaoDtoHelper;
import com.baijia.tianxiao.excel.ExcelColumn;
import com.baijia.tianxiao.excel.ExcelExporterDto;

import lombok.Data;

/**   
 * @title       : TeacherDataDto 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2017年3月1日 上午2:13:52 
 */
@Data
@ExcelExporterDto
public class TeacherDataDto  {
	
	private Long teacherId;
	
	private String teacherName;
	
	private String mobile;
	
	private String orgName;
	
	private Long kexiaoMoney;
	
	private Integer classCount;//带班数
	
	private Integer lessonTimes;//已上课次
	
	private String lessonDurationStr;
	private Long lessonMinute;//已上课时
	
	private Integer originalSigninCount;//预计签到数
	
	private Integer signinCount;//实际签到数
	
	private Integer askForLeaveCount;//请假数
	
	private Integer absenteeismcCount;//缺勤数
	
	private Integer notSigninCount;//未签到数
	
	private Integer rowSize = 0;
	
	private List<ClassDataDto> classDataDtoList;
	
	
	public Double getKexiaoMoney(){
		if(this.kexiaoMoney!=null){
			return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.kexiaoMoney);
		}
		return null;
	}
	
	public String getLessonDurationStr(){
		return DashboadrKexiaoDtoHelper.getTimeStr(this.lessonMinute);
	}
	
	public Long getKexiaoMoneyLong(){
		return this.kexiaoMoney;
	}
	
}
