package com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.excel;



import java.util.List;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.DashboadrKexiaoDtoHelper;

import lombok.Data;

/**   
 * @title       : ClassDataDto 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2017年3月1日 上午2:16:17 
 */
@Data
public class ClassDataDto  {
	
	private Long classId;
	private String className;
	private Long kexiaoMoney;
	private Integer lessonTimes;//已上课次
	private Long lessonMinute;//已上课时
	
	private Integer rowSize = 0;
	
	private List<StudentDataDto> studentDataDtoList;
	
	public Double getKexiaoMoney(){
		if(this.kexiaoMoney!=null){
			return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.kexiaoMoney);
		}
		return null;
	}
	
	
	public String getLessonDurationStr(){
		return DashboadrKexiaoDtoHelper.getTimeStr(this.lessonMinute);
	}
	
	
	public Long getKexiaoMoneyLong(){
		return this.kexiaoMoney;
	}
	
	
	
	@Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
}
