package com.baijia.tianxiao.biz.dashboard.dto.kexiao.param;




import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.dal.enums.CourseTypeEnum;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**   
 * @title       : OrgDetailClassListParamDto 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2017年1月3日 上午11:56:53 
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class OrgDetailClassListParamDto extends DashboardKexiaoParamDto {
	
	private Long orgId;
	private String keyword;
	private Integer courseType;
	private Integer chargeType;
	private Integer chargeUnit;
	
	public boolean conditionQuery(){
		if(  StringUtils.isNotBlank(keyword)
		  || courseType!=null
		  || chargeType!=null
		  || chargeUnit!=null){
			return true;
		}
		
		return false;
	}
	
	public List<Integer> getCourseTypeList(){
		if(this.courseType!=null){
			List<Integer> result = new ArrayList<Integer>();
			if(this.courseType == CourseTypeEnum.COURSE_TYPE_CLASS.getCode()
			 ||this.courseType == CourseTypeEnum.COURSE_TYPE_NEW_CLASS.getCode()){
				result.add(CourseTypeEnum.COURSE_TYPE_CLASS.getCode());
				result.add(CourseTypeEnum.COURSE_TYPE_NEW_CLASS.getCode());
			}else{
				result.add(this.courseType);
			}
			return result;
		}
		return null;
	}
	
	
}
