package com.baijia.tianxiao.biz.dashboard.dto.kexiao.orgdetail;


import com.baijia.tianxiao.biz.dashboard.dto.kexiao.DashboadrKexiaoDtoHelper;
import com.baijia.tianxiao.excel.ExcelColumn;
import com.baijia.tianxiao.excel.ExcelExporterDto;
import com.baijia.tianxiao.util.date.DateUtil;
import lombok.Data;

/**
 * @author : zhenyujian
 * @title : OrgDetailStudentListDto
 * @description :
 * @date : 2017年1月3日 上午11:57:02
 */
@Data
@ExcelExporterDto
public class OrgDetailStudentListDto {


    @ExcelColumn("学员")
    private String studentName;
    private Long studentUserId;

    private String kexiaoHourStr;
    @ExcelColumn("课消时长(分钟)")
    private Integer kexiaoMinute;

    @ExcelColumn("课消次数")
    private Integer kexiaoTimes;

    @ExcelColumn("按小时课消金额")
    private Long kexiaoHourMoney;

    @ExcelColumn("按次课消金额")
    private Long kexiaoTimesMoney;

    @ExcelColumn("退班手续费")
    private Long quitClassMoney;

    @ExcelColumn("课消总额")
    private Long totalKexiaoMoney;


    public String getKexiaoHourStr() {
        if (this.kexiaoMinute != null) {
            return DateUtil.minutesToHHmmStr(this.kexiaoMinute.longValue());
        }
        return null;
    }


    public Double getKexiaoHourMoney() {
        if (this.kexiaoHourMoney != null) {
            return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.kexiaoHourMoney);
        }
        return null;
    }

    public Double getKexiaoTimesMoney() {
        if (this.kexiaoTimesMoney != null) {
            return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.kexiaoTimesMoney);
        }
        return null;
    }

    public Double getQuitClassMoney() {
        if (this.quitClassMoney != null) {
            return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.quitClassMoney);
        }
        return null;
    }

    public Double getTotalKexiaoMoney() {
        if (this.totalKexiaoMoney != null) {
            return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.totalKexiaoMoney);
        }
        return null;
    }

    public Long getTotalKexiaoMoneyLong() {
        return this.totalKexiaoMoney;
    }

    public Long getQuitClassMoneyLong() {
        return this.quitClassMoney;
    }

    public Long getKexiaoHourMoneyLong() {
        return this.kexiaoHourMoney;
    }

    public Long getKexiaoTimesMoneyLong() {
        return this.kexiaoTimesMoney;
    }
}
