/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.dashboard.service.impl;

import com.baijia.tianxiao.biz.dashboard.service.ConsultStatRedisService;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.redis.AbstractBaseRedisDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;

@Service
public class ConsultStatRedisServiceImpl
extends AbstractBaseRedisDao
implements ConsultStatRedisService {
    private static final Logger log = LoggerFactory.getLogger(ConsultStatRedisServiceImpl.class);

    @Override
    public void setConsultUserId(long orgId, long studentId, long userId, final long consultUserId) {
        final String key = RedisKeyEnums.CRM.CONSULT_USER_ID_KEY.getRedisKey();
        final String fieldStr = this.getField(orgId, studentId, userId);
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Integer>(){

            public Integer doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = ConsultStatRedisServiceImpl.this.getRedisSerializer();
                byte[] keyBytes = serializer.serialize((Object)key);
                byte[] field = serializer.serialize((Object)fieldStr);
                RedisSerializer redisSerializer = ConsultStatRedisServiceImpl.this.redisTemplate.getDefaultSerializer();
                byte[] value = redisSerializer.serialize((Object)consultUserId);
                connection.hSet(keyBytes, field, value);
                log.info("[SysnSignupInfo] success to save consultId for for field : {} with consultId : {}  ", (Object)fieldStr, (Object)consultUserId);
                return null;
            }
        });
    }

    private String getField(long orgId, long studentId, long userId) {
        String format = "%s_%s_%s";
        String fieldStr = String.format(format, orgId, studentId, userId);
        return fieldStr;
    }

    @Override
    public Long getConsultIdFromRedis(long orgId, long studentId, long userId) {
        final String fieldStr = this.getField(orgId, studentId, userId);
        return (Long)this.redisTemplate.execute((RedisCallback)new RedisCallback<Long>(){

            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = ConsultStatRedisServiceImpl.this.getRedisSerializer();
                byte[] keyBytes = serializer.serialize((Object)RedisKeyEnums.CRM.CONSULT_USER_ID_KEY.getRedisKey());
                byte[] field = serializer.serialize((Object)fieldStr);
                RedisSerializer redisSerializer = ConsultStatRedisServiceImpl.this.redisTemplate.getDefaultSerializer();
                byte[] value = connection.hGet(keyBytes, field);
                log.info("[SysnSignupInfo] getValue:{}", redisSerializer.deserialize(value));
                return (Long)redisSerializer.deserialize(value);
            }
        });
    }
}

