package com.baijia.tianxiao.biz.dashboard.service;

import com.baijia.tianxiao.biz.dashboard.dto.unKexiao.reponse.*;
import com.baijia.tianxiao.biz.dashboard.dto.unKexiao.request.ClassUnKexiaoListParam;
import com.baijia.tianxiao.biz.dashboard.dto.unKexiao.request.OrgUnKexiaoListParam;
import com.baijia.tianxiao.biz.dashboard.dto.unKexiao.request.StudentUnKexiaoListParam;

import java.util.Collection;
import java.util.List;

/**
 * @author : fulinyu
 * @title : DashboardUnKexiaoService
 * @description : 待消统计
 * @date : 2017年8月21日
 */
public interface DashboardUnKexiaoService {

    /**
     * 校区待消汇总
     *
     * @param orgId
     * @param containSubOrg
     * @return 某个校区的待消汇总(containSubOrg=false)或校区及其所有子校区[不包括过滤类型的自校区]的待消汇总(containSubOrg=true)
     */
    OrgUnKexiaoDto getOrgUnKexiaoStatistics(Long orgId, boolean containSubOrg, Collection<Integer> filterSubOrgTypes);

    /**
     * 校区待消列表
     *
     * @param param
     * @return
     */
    List<OrgUnKexiaoDto> getOrgUnKexiaoList(OrgUnKexiaoListParam param);

    /**
     * 校区待消列表总计
     *
     * @param param
     * @return
     */
    UnKexiaoStatisticsDto getOrgUnKexiaoTotal(OrgUnKexiaoListParam param);

    /**
     * 班级待消汇总
     *
     * @param orgId
     * @param classId
     * @return
     */
    ClassStatisticsDto getClassUnKexiaoStatistics(Long orgId, Long classId);

    /**
     * 班级待消列表
     *
     * @param param
     * @return
     */
    List<ClassUnKexiaoDto> getClassUnKexiaoList(ClassUnKexiaoListParam param);

    /**
     * 班级待消列表总计
     *
     * @param param
     * @return
     */
    UnKexiaoStatisticsDto getClassUnKexiaoTotal(ClassUnKexiaoListParam param);

    /**
     * 学员待消汇总
     *
     * @param orgId
     * @param studentUserId
     * @return
     */
    StudentStatisticsDto getStudentUnKexiaoStatistics(Long orgId, Long studentUserId);

    /**
     * 学员待消待消列表
     *
     * @param param
     * @return
     */
    List<StudentUnKexiaoDto> getStudentUnKexiaoList(StudentUnKexiaoListParam param);

    /**
     * 学员列表总计
     *
     * @param param
     * @return
     */
    UnKexiaoStatisticsDto getStudentUnKexiaoTotal(StudentUnKexiaoListParam param);

}
