package com.baijia.tianxiao.biz.dashboard.dto.unKexiao.request;

import com.baijia.tianxiao.biz.dashboard.dto.unKexiao.constant.StatisticsScaleEnum;
import com.google.common.base.Preconditions;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.apache.commons.lang.StringUtils;

/**
 * @title       : StudentUnKexiaoListParam
 * @description : 学员待消列表请求参数
 * @author      : fulinyu
 * @date        : 2017年8月21日
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper = true)
public class StudentUnKexiaoListParam extends UnKexiaoListParam {

    private Long orgId;
    private Long classId;
    private String keyword;//学员姓名
    private Integer scale;

    public void validate() {
        Preconditions.checkArgument(StatisticsScaleEnum.validate(scale), "统计范围类型无效");
        if (scale.intValue() == StatisticsScaleEnum.ORG.getCode()) {//校区维度下的学员待消统计
            this.orgStudentValidate();
        } else if (scale.intValue() == StatisticsScaleEnum.STUDENT.getCode()) {//班级维度下的待消学员统计
            this.classStudentValidate();
        }
    }

    public void orgStudentValidate(){
        Preconditions.checkArgument(orgId!=null,"校区id为空");
    }

    public void classStudentValidate(){
        Preconditions.checkArgument(orgId!=null,"校区id为空");
        Preconditions.checkArgument(classId!=null,"班级id为空");
    }

    public boolean isEmptyConditionQuery() {
        if (StringUtils.isNotBlank(keyword)) {
            return false;
        } else {
            return true;
        }
    }

}
