package com.baijia.tianxiao.biz.dashboard.dto.unKexiao.reponse;

import com.baijia.tianxiao.biz.dashboard.dto.kexiao.DashboadrKexiaoDtoHelper;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.springframework.beans.BeanUtils;

/**
 * @author : fulinyu
 * @title : StudentStatisticsDto
 * @description : 学员待消汇总
 * @date : 2017年8月21日
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class StudentStatisticsDto extends StudentUnKexiaoDto {

    private Integer classCount; //在读班级数
    private Double payMoney; //缴费总额
    private Long payMoneyLong;
    private Double remainingMoney; //剩余学费
    private Long remainingMoneyLong;

    public static StudentStatisticsDto from(OrgStudent orgStudent, Integer classCount, Long payMoneyLong, Long remainingMoneyLong, UnKexiaoStatisticsDto statisticsDto) {
        StudentStatisticsDto studentDto = new StudentStatisticsDto();
        if (statisticsDto == null) {
            statisticsDto = UnKexiaoStatisticsDto.createWithZeroValue();
        }
        BeanUtils.copyProperties(statisticsDto, studentDto);
        if (orgStudent != null) {
            studentDto.setStudentUserId(orgStudent.getUserId());
            studentDto.setStudentName(orgStudent.getName());
        }
        studentDto.setClassCount(classCount);
        studentDto.setPayMoneyLong(payMoneyLong);
        studentDto.setRemainingMoneyLong(remainingMoneyLong);
        studentDto.transferUnit();
        return studentDto;
    }

    public void transferUnit() {
        if (payMoneyLong != null) {
            payMoney = DashboadrKexiaoDtoHelper.moneyDividedBy100(payMoneyLong);
        } else {
            payMoneyLong = 0l;
            payMoney = 0.00;
        }
        if (remainingMoneyLong != null) {
            remainingMoney = DashboadrKexiaoDtoHelper.moneyDividedBy100(remainingMoneyLong);
        } else {
            remainingMoneyLong = 0l;
            remainingMoney = 0.00;
        }
    }

}
