package com.baijia.tianxiao.biz.dashboard.dto.unKexiao.constant;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @author : fulinyu
 * @title : StatisticsScaleEnum
 * @description : 统计范围枚举
 * @date : 2017年8月21日
 */
public enum StatisticsScaleEnum {

    ORG(1, "校区"), CLASS(2, "班级"), STUDENT(3, "学员"),;

    private static Map<Integer, StatisticsScaleEnum> map = Maps.newHashMap();

    static {
        for (StatisticsScaleEnum e : values()) {
            map.put(e.getCode(), e);
        }
    }

    private int code;
    private String desc;

    StatisticsScaleEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static boolean validate(Integer scale) {
        if (scale == null) {
            return false;
        }
        return map.keySet().contains(scale);
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

}
