package com.baijia.tianxiao.biz.dashboard.dto.kexiao.orgdetail;


import com.baijia.tianxiao.biz.dashboard.dto.kexiao.DashboadrKexiaoDtoHelper;
import com.baijia.tianxiao.util.date.DateUtil;
import lombok.Data;

/**
 * @author : zhenyujian
 * @title : OrgDetailStatisticsDto
 * @description :
 * @date : 2017年1月3日 上午11:57:01
 */
@Data
public class OrgDetailStatisticsDto {

    private Long orgId;
    private String orgName;
    private Integer todayKexiaoMinute;
    private String todayKexiaoHourStr;
    private Long todayKexiaoHourMoney;
    private Integer todayKexiaoTimes;
    private Long todayKexiaoTimesMoney;
    private Long todayKexiaoTotalMoney;
    private Long todayQuitClassMoney;

    private Integer kexiaoMinute;
    private String kexiaoHourStr;
    private Double kexiaoHourMoney;
    private Integer kexiaoTimes;
    private Double kexiaoTimesMoney;
    private Double totalKexiaoMoney;
    private Double quitClassMoney;

    public String getTodayKexiaoHourStr() {
        if (this.todayKexiaoMinute != null) {
            return DateUtil.minutesToHHmmStr(this.todayKexiaoMinute.longValue());
        }
        return null;
    }

    public Double getTodayKexiaoTimesMoney() {
        if (this.todayKexiaoTimesMoney != null) {
            return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.todayKexiaoTimesMoney);
        }
        return null;
    }

    public Double getTodayKexiaoHourMoney() {
        if (this.todayKexiaoHourMoney != null) {
            return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.todayKexiaoHourMoney);
        }
        return null;
    }

    public Double getTodayKexiaoTotalMoney() {
        if (this.todayKexiaoTotalMoney != null) {
            return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.todayKexiaoTotalMoney);
        }
        return null;
    }

    public Double getTodayQuitClassMoney() {
        if (this.todayQuitClassMoney != null) {
            return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.todayQuitClassMoney);
        }
        return null;
    }

    public void setKexiaoInfo() {
        this.setKexiaoHourStr(this.getTodayKexiaoHourStr());
        this.setKexiaoHourMoney(this.getTodayKexiaoHourMoney());
        this.setKexiaoMinute(this.getTodayKexiaoMinute());
        this.setKexiaoTimes(this.getTodayKexiaoTimes());
        this.setKexiaoTimesMoney(this.getTodayKexiaoTimesMoney());
        this.setTotalKexiaoMoney(this.getTodayKexiaoTotalMoney());
        this.setQuitClassMoney(this.getTodayQuitClassMoney());
    }
}
