package com.baijia.tianxiao.biz.dashboard.dto.kexiao.classdetail;


import com.baijia.tianxiao.biz.dashboard.dto.kexiao.DashboadrKexiaoDtoHelper;
import com.baijia.tianxiao.excel.ExcelColumn;
import com.baijia.tianxiao.excel.ExcelExporterDto;
import com.baijia.tianxiao.util.StringUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import lombok.Data;

import java.util.Date;

/**
 * @author : zhenyujian
 * @title : ClassDetailListDto
 * @description :
 * @date : 2017年1月3日 上午11:56:50
 */
@Data
@ExcelExporterDto
public class ClassDetailListDto {

    @ExcelColumn("学员")
    private String studentName;
    private Long studentUserId;

    @ExcelColumn("上课时间")
    private Double lessonTimeStr;
    private Date lessonStartTime;
    private Date lessonEndTime;

    @ExcelColumn("上课老师")
    private String teacherName;


    private String lessonHourStr;
    @ExcelColumn("上课时长(分钟)")
    private Integer lessonMinute;

    @ExcelColumn("上课次数")
    private Integer lessonTimes;

    @ExcelColumn("本次课消金额")
    private Long kexiaoMoney;

    @ExcelColumn("签到状态")
    private String signinStatusStr;
    private Integer signinStatus;

    private Date quitClassTime;


    public String getLessonTimeStr() {
        return DashboadrKexiaoDtoHelper.getLessonTimeStr(this.lessonStartTime, this.lessonEndTime, this.quitClassTime);
    }

    public String getSigninStatusStr() {
        if (StringUtils.isEmpty(signinStatusStr)) {
            return DashboadrKexiaoDtoHelper.getSigninStatusStr(this.signinStatus, this.quitClassTime);
        } else {
            return signinStatusStr;
        }
    }


    public String getLessonHourStr() {
        if (this.lessonMinute != null) {
            return DateUtil.minutesToHHmmStr(this.lessonMinute.longValue());
        }
        return null;
    }

    public Double getKexiaoMoney() {
        if (this.kexiaoMoney != null) {
            return DashboadrKexiaoDtoHelper.moneyDividedBy100(this.kexiaoMoney);
        }
        return null;
    }


}
