/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.dashboard.service.impl;

import com.baijia.commons.lang.utils.JacksonUtil;
import com.baijia.tianxiao.biz.dashboard.dto.YYGalaxyDto;
import com.baijia.tianxiao.biz.dashboard.dto.YunYingGalaxyDto;
import com.baijia.tianxiao.biz.dashboard.dto.YunYingSystemDto;
import com.baijia.tianxiao.biz.dashboard.service.YunyingSystemService;
import com.baijia.tianxiao.constant.YunYingEmailConstants;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.dal.callservice.dao.ConsultCallRecordDao;
import com.baijia.tianxiao.dal.comment.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.constant.TXAccountTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAppPvDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXAppPv;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoLessonDao;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoLessonStudentDao;
import com.baijia.tianxiao.dal.wechat.constant.WechatType;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.marketing.commons.utils.AttachBean;
import com.baijia.tianxiao.sal.marketing.commons.utils.Mail;
import com.baijia.tianxiao.sal.marketing.commons.utils.MailUtils;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.HanZiPinYinUtils;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.StringUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeUtility;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class YunyingSystemServiceImpl
implements YunyingSystemService {
    private static final Logger log = LoggerFactory.getLogger(YunyingSystemServiceImpl.class);
    private static final Integer STATUS_RETRUN_OK = 1;
    @Resource
    private TXAccountDao txAccountDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgSubAccountDao orgSubAccountDao;
    @Resource
    private TXCascadeAccountDao txCascadeAccountDao;
    @Resource
    private AuthorizerInfoDao authorizerInfoDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private ConsultCallRecordDao consultCallRecordDao;
    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;
    @Resource
    private OrgLessonSignDao orgLessonSignDao;
    @Resource
    private TXAppPvDao txAppPvDao;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private OrgLessonCommentDao lessonCommentDao;
    @Autowired
    private TxVZhiBoLessonDao zhiBoLessonDao;
    @Autowired
    private TxVZhiBoLessonStudentDao zhiBoLessonStudentDao;
    @Autowired
    private TXStudentCommentAPIService txStudentCommentAPIService;

    @Override
    @Transactional
    public void excelEmail() {
        List<YunYingSystemDto> list = this.getYunyingData();
        this.sortYunyingData(list);
        File file = this.writeYunyingDateToFile(list);
        this.sendYunyingDataEmail(file);
    }

    private List<YunYingSystemDto> getYunyingData() {
        List txAccounts = this.txAccountDao.getTXAccountByLevelStatusType((Collection)TXAccountType.getYunyingSet(), TXAccountStatus.VALID.getCode(), TXAccountTypeEnum.ZHENGSHI.getCode());
        log.debug("[tx account size]={}", (Object)txAccounts.size());
        List orgIds = ListUtil.toKeyList((Collection)txAccounts, (String)"orgId", TXAccount.class);
        List<Long> orgIdsLong = this.getLongOrgIds(orgIds);
        List orgAccounts = this.orgAccountDao.getByIds((Collection)orgIds, new String[0]);
        Map orgAccountMap = BaseUtils.listToMap((List)orgAccounts, (String)"id");
        List orgInfos = this.orgInfoDao.getOrgInfos((Collection)orgIds, new String[0]);
        Map orgInfoMap = BaseUtils.listToMap((List)orgInfos, (String)"orgId");
        List studyingStatus = StudentLessonStatus.findSubStatus((int)StudentLessonStatus.STUDYING.getStatus());
        List subAccounts = this.orgSubAccountDao.getSlavesByMasterOrgIds((Collection)orgIds);
        Map<Integer, List<OrgSubAccount>> orgSubAccountMap = this.getMasterAndSlavesMap(orgIds, subAccounts);
        List txCascadeAccounts = this.txCascadeAccountDao.getTXCascadeAccountListByStatusAndOrgIds((Collection)orgIds, OrgSubAccountStatus.NORMAL.getCode());
        Map<Integer, List<TXCascadeAccount>> txCascadeAccountMap = this.getTXCascadeAccountMap(orgIds, txCascadeAccounts);
        List authorizerInfos = this.authorizerInfoDao.getAuthorizerInfosByOrgIds(orgIdsLong);
        Map<Integer, String> authorizerInfoMap = this.getAuthorizerInfoMap(orgIds, authorizerInfos);
        Map<Integer, Integer> courseMap = this.fillCourseMap(orgSubAccountMap);
        Map<Integer, String> allFeeMap = this.fillAllFeeMap(orgSubAccountMap);
        Map<Integer, String> offlineFeeMap = this.fillOfflineFeeMap(orgSubAccountMap);
        Map<Integer, String> signMap = this.fillSignMap(orgSubAccountMap);
        Map<Integer, String> callMap = this.fillCallMap(orgSubAccountMap);
        ArrayList allOrgIds = Lists.newArrayList();
        allOrgIds.addAll(orgIds);
        allOrgIds.addAll(ListUtil.toKeyList((Collection)subAccounts, (String)"orgId", OrgSubAccount.class));
        Map studentMap = this.orgStudentDao.getStudentCountMapByStatus((List)allOrgIds, studyingStatus);
        Map<Integer, Integer> studentCountMap = this.fillMasterAndSlavesMap(studentMap, orgSubAccountMap);
        Map bindMap = this.orgStudentDao.getBindStudentCenterCount((List)allOrgIds);
        Map<Integer, Integer> bindCountMap = this.fillMasterAndSlavesMap(bindMap, orgSubAccountMap);
        Date now = new Date();
        Map weekMap = this.txAppPvDao.getByOrgIds(orgIds, DateUtil.getDayDiff((int)-7), now);
        Map monthMap = this.txAppPvDao.getByOrgIds(orgIds, DateUtil.getDayDiff((int)-28), now);
        Map threeMonthMap = this.txAppPvDao.getByOrgIds(orgIds, DateUtil.getDayDiff((int)-90), now);
        List allLongOrgIds = ListUtil.intListToLong((List)allOrgIds);
        Map teacherCommentMap = this.lessonCommentDao.getComment(UserRoleEnum.TEACHER.getCode(), DateUtil.getDayDiff((int)-7), now, allLongOrgIds);
        Map<Long, Integer> teacherCommentCountMap = this.fillMasterAndSlavesLongMap(teacherCommentMap, orgSubAccountMap);
        Map studentCommentMap = this.lessonCommentDao.getComment(UserRoleEnum.STUDENT.getCode(), DateUtil.getDayDiff((int)-7), now, allLongOrgIds);
        Map<Long, Integer> studentCommentCountMap = this.fillMasterAndSlavesLongMap(studentCommentMap, orgSubAccountMap);
        Map zhiboLessonMap = this.zhiBoLessonDao.getLessonTotal(DateUtil.getDayDiff((int)-28), now, allLongOrgIds);
        Map<Long, Integer> zhiboLessonCountMap = this.fillMasterAndSlavesLongMap(zhiboLessonMap, orgSubAccountMap);
        Map zhiboLessonStudentMap = this.zhiBoLessonStudentDao.getLessonStudentTotal(DateUtil.getDayDiff((int)-28), now, allLongOrgIds);
        Map<Long, Integer> zhiboLessonStudentCountMap = this.fillMasterAndSlavesLongMap(zhiboLessonStudentMap, orgSubAccountMap);
        Map weekStudentGrowMap = this.txStudentCommentAPIService.getCommentTotal(DateUtil.getDayDiff((int)-7), now, allLongOrgIds, Integer.valueOf(1), Integer.valueOf(AddType.NOT_SYSTEM.getCode()), Boolean.valueOf(true));
        Map<Long, Integer> weekStudentGrowCountMap = this.fillMasterAndSlavesLongMap(weekStudentGrowMap, orgSubAccountMap);
        Map monthStudentGrowMap = this.txStudentCommentAPIService.getCommentTotal(DateUtil.getDayDiff((int)-28), now, allLongOrgIds, Integer.valueOf(1), Integer.valueOf(AddType.NOT_SYSTEM.getCode()), Boolean.valueOf(true));
        Map<Long, Integer> monthStudentGrowCountMap = this.fillMasterAndSlavesLongMap(monthStudentGrowMap, orgSubAccountMap);
        log.debug("monthStudentGrowCountMap = {}", monthStudentGrowCountMap);
        ArrayList result = Lists.newArrayList();
        for (TXAccount txAccount : txAccounts) {
            Integer id = txAccount.getOrgId();
            OrgInfo orgInfo = (OrgInfo)orgInfoMap.get(id);
            OrgAccount orgAccount = (OrgAccount)orgAccountMap.get(id);
            String city = (String)AreaUtils.getAreaNameByCode((Long)orgInfo.getAreaId()).get("city");
            YunYingSystemDto dto = new YunYingSystemDto();
            dto.setOrgName(orgInfo.getShortName());
            dto.setOrgNumber(orgAccount.getNumber());
            dto.setMobile(orgAccount.getMobile());
            dto.setPaidStudentCount(txAccount.getStudentCount() != null ? txAccount.getStudentCount() : 0);
            dto.setCity(StringUtils.isEmpty((String)city) ? "\u5168\u56fd" : city + "\u5e02");
            dto.setInitial(HanZiPinYinUtils.trans2PinYin((String)city));
            dto.setBeginTime(DateUtil.getStrByDate((Date)txAccount.getStartTime()));
            dto.setEndTime(DateUtil.getStrByDate((Date)txAccount.getEndTime()));
            dto.setVersionStr(TXAccountType.getTXAccountTypeByCode((Integer)txAccount.getVipLevel()).getLabel());
            dto.setStudentCount(studentCountMap.get(id) != null ? studentCountMap.get(id) : Integer.valueOf(0));
            dto.setCampusCount(orgSubAccountMap.get(id).size() + 1);
            dto.setAccountCount(orgSubAccountMap.get(id).size() + 1 + txCascadeAccountMap.get(id).size());
            dto.setWeChatTypeStr(authorizerInfoMap.get(id));
            dto.setBindStudentCount(bindCountMap.get(id) != null ? bindCountMap.get(id) : Integer.valueOf(0));
            dto.setClassCount(courseMap.get(id));
            dto.setOnlineIncome(allFeeMap.get(id));
            dto.setOfflineIncome(offlineFeeMap.get(id));
            dto.setWeekSignCount(signMap.get(id));
            dto.setDialOutCount(callMap.get(id));
            dto.setWeekPV(weekMap.get(id) != null ? NumberUtil.get2FromDouble((double)((double)((Integer)weekMap.get(id)).intValue() / 7.0)) : "0.00");
            dto.setMonthPV(monthMap.get(id) != null ? NumberUtil.get2FromDouble((double)((double)((Integer)monthMap.get(id)).intValue() / 4.0)) : "0.00");
            dto.setThreeMonthPV(threeMonthMap.get(id) != null ? NumberUtil.get2FromDouble((double)((double)((Integer)threeMonthMap.get(id)).intValue() / 3.0)) : "0.00");
            dto.setTeacherCommentCount(teacherCommentCountMap.get(id.longValue()) != null ? teacherCommentCountMap.get(id.longValue()) : Integer.valueOf(0));
            dto.setStudentCommentCount(studentCommentCountMap.get(id.longValue()) != null ? studentCommentCountMap.get(id.longValue()) : Integer.valueOf(0));
            dto.setVzhiboClassCount(zhiboLessonCountMap.get(id.longValue()) != null ? zhiboLessonCountMap.get(id.longValue()) : Integer.valueOf(0));
            dto.setVzhiboClassStudent(zhiboLessonStudentCountMap.get(id.longValue()) != null ? zhiboLessonStudentCountMap.get(id.longValue()) : Integer.valueOf(0));
            dto.setWeekStudentGrowCount(weekStudentGrowCountMap.get(id.longValue()) != null ? weekStudentGrowCountMap.get(id.longValue()) : Integer.valueOf(0));
            dto.setMonthStudentGrowCount(monthStudentGrowCountMap.get(id.longValue()) != null ? monthStudentGrowCountMap.get(id.longValue()) : Integer.valueOf(0));
            result.add(dto);
        }
        return result;
    }

    private List<Long> getLongOrgIds(List<Integer> orgIds) {
        ArrayList list = Lists.newArrayList();
        for (Integer i : orgIds) {
            list.add(i.longValue());
        }
        return list;
    }

    private Map<Integer, List<OrgSubAccount>> getMasterAndSlavesMap(List<Integer> orgIds, List<OrgSubAccount> subAccounts) {
        HashMap map = Maps.newHashMap();
        for (Integer orgId : orgIds) {
            map.put(orgId, new ArrayList());
        }
        for (OrgSubAccount account : subAccounts) {
            if (!map.containsKey(account.getPid())) continue;
            ((List)map.get(account.getPid())).add(account);
        }
        return map;
    }

    private Map<Integer, List<TXCascadeAccount>> getTXCascadeAccountMap(List<Integer> orgIds, List<TXCascadeAccount> txCascadeAccounts) {
        HashMap map = Maps.newHashMap();
        for (Integer orgId : orgIds) {
            map.put(orgId, new ArrayList());
        }
        for (TXCascadeAccount account : txCascadeAccounts) {
            if (!map.containsKey(account.getOrgId())) continue;
            ((List)map.get(account.getOrgId())).add(account);
        }
        return map;
    }

    private Map<Integer, String> getAuthorizerInfoMap(List<Integer> orgIds, List<AuthorizerInfo> authorizerInfos) {
        HashMap map = Maps.newHashMap();
        for (Integer orgId : orgIds) {
            map.put(orgId, "\u672a\u7ed1\u5b9a");
        }
        for (AuthorizerInfo info : authorizerInfos) {
            if (!map.containsKey(info.getOrgId())) continue;
            String type = WechatType.getWechatType((Integer)info.getServiceType(), (Integer)info.getVerifyType());
            map.put(info.getOrgId(), type);
        }
        return map;
    }

    private Map<Integer, Integer> fillCourseMap(Map<Integer, List<OrgSubAccount>> map) {
        HashMap result = Maps.newHashMap();
        for (Integer orgId : map.keySet()) {
            List<OrgSubAccount> list = map.get(orgId);
            ArrayList allOrgIds = Lists.newArrayList();
            allOrgIds.add(orgId);
            allOrgIds.addAll(ListUtil.toKeyList(list, (String)"orgId", OrgSubAccount.class));
            List orgAccounts = this.orgAccountDao.getByIds((Collection)allOrgIds, new String[0]);
            List numbers = ListUtil.toKeyList((Collection)orgAccounts, (String)"number", OrgAccount.class);
            Integer count = this.orgCourseDao.getClassCount(numbers);
            result.put(orgId, count);
        }
        return result;
    }

    private Map<Integer, String> fillAllFeeMap(Map<Integer, List<OrgSubAccount>> map) {
        HashMap result = Maps.newHashMap();
        Date now = new Date();
        Date threeMonthAgo = DateUtil.getDayDiff((int)-90);
        for (Integer orgId : map.keySet()) {
            List<OrgSubAccount> list = map.get(orgId);
            ArrayList allOrgIds = Lists.newArrayList();
            allOrgIds.add(orgId);
            allOrgIds.addAll(ListUtil.toKeyList(list, (String)"orgId", OrgSubAccount.class));
            ArrayList allOrgIdsLong = Lists.newArrayList();
            allOrgIdsLong.add(orgId.longValue());
            allOrgIdsLong.addAll(ListUtil.toKeyList(list, (String)"orgId", OrgSubAccount.class));
            Long count = this.orgSignupInfoDao.getInComeByDate((List)allOrgIds, threeMonthAgo, now, null);
            ArrayList payType = Lists.newArrayList();
            payType.add(PayType.TX_STUDENT_PAY.getCode());
            payType.add(PayType.TX_NO_PAY.getCode());
            payType.add(PayType.CASH.getCode());
            Long other = this.orgSignupInfoDao.getInComeByDate((List)allOrgIds, threeMonthAgo, now, (List)payType);
            Long l = 0L;
            if (count != null) {
                l = other != null ? Long.valueOf(count - other) : count;
            }
            Double d = l.doubleValue() / 100.0 / 3.0;
            result.put(orgId, NumberUtil.get2FromDouble((double)d));
        }
        return result;
    }

    private Map<Integer, String> fillOfflineFeeMap(Map<Integer, List<OrgSubAccount>> map) {
        HashMap result = Maps.newHashMap();
        Date now = new Date();
        Date threeMonthAgo = DateUtil.getDayDiff((int)-90);
        for (Integer orgId : map.keySet()) {
            List<OrgSubAccount> list = map.get(orgId);
            ArrayList allOrgIds = Lists.newArrayList();
            allOrgIds.add(orgId);
            allOrgIds.addAll(ListUtil.toKeyList(list, (String)"orgId", OrgSubAccount.class));
            ArrayList allOrgIdsLong = Lists.newArrayList();
            allOrgIdsLong.add(orgId.longValue());
            allOrgIdsLong.addAll(ListUtil.toKeyList(list, (String)"orgId", OrgSubAccount.class));
            ArrayList payType = Lists.newArrayList();
            payType.add(PayType.CASH.getCode());
            Long count = this.orgSignupInfoDao.getInComeByDate((List)allOrgIds, threeMonthAgo, now, (List)payType);
            Double d = count != null ? count.doubleValue() / 100.0 / 3.0 : 0.0;
            result.put(orgId, NumberUtil.get2FromDouble((double)d));
        }
        return result;
    }

    private Map<Integer, String> fillSignMap(Map<Integer, List<OrgSubAccount>> map) {
        HashMap result = Maps.newHashMap();
        Date now = new Date();
        Date oneMonthAgo = DateUtil.getDayDiff((int)-28);
        for (Integer orgId : map.keySet()) {
            List<OrgSubAccount> list = map.get(orgId);
            ArrayList allOrgIdsLong = Lists.newArrayList();
            allOrgIdsLong.add(orgId.longValue());
            allOrgIdsLong.addAll(ListUtil.toKeyList(list, (String)"orgId", OrgSubAccount.class));
            Map signStudentTotals = this.orgLessonSignDao.getOrgSignStudentTotal(oneMonthAgo, now, (List)allOrgIdsLong);
            Integer count = 0;
            for (Integer i : signStudentTotals.values()) {
                count = count + i;
            }
            double d = (double)count.intValue() * 1.0 / 4.0;
            result.put(orgId, NumberUtil.get2FromDouble((double)d));
        }
        return result;
    }

    private Map<Integer, String> fillCallMap(Map<Integer, List<OrgSubAccount>> map) {
        HashMap result = Maps.newHashMap();
        Date now = new Date();
        Date threeMonthAgo = DateUtil.getDayDiff((int)-90);
        for (Integer orgId : map.keySet()) {
            List<OrgSubAccount> list = map.get(orgId);
            ArrayList allOrgIdsLong = Lists.newArrayList();
            allOrgIdsLong.add(orgId.longValue());
            allOrgIdsLong.addAll(ListUtil.toKeyList(list, (String)"orgId", OrgSubAccount.class));
            Integer count = this.consultCallRecordDao.getCallTimeByOrgIdAndType((List)allOrgIdsLong, STATUS_RETRUN_OK, threeMonthAgo, now);
            String s = NumberUtil.get2FromDouble((double)((double)count.intValue() / 60.0 / 3.0));
            result.put(orgId, s);
        }
        return result;
    }

    private Map<Integer, Integer> fillMasterAndSlavesMap(Map<Integer, Integer> studentCountMaps, Map<Integer, List<OrgSubAccount>> map) {
        HashMap result = Maps.newHashMap();
        for (Integer orgId : map.keySet()) {
            List<OrgSubAccount> list = map.get(orgId);
            Integer count = studentCountMaps.get(orgId) != null ? studentCountMaps.get(orgId) : Integer.valueOf(0);
            for (OrgSubAccount sub : list) {
                if (!studentCountMaps.containsKey(sub.getOrgId())) continue;
                int subCount = studentCountMaps.get(sub.getOrgId()) != null ? studentCountMaps.get(sub.getOrgId()) : 0;
                count = count + subCount;
            }
            result.put(orgId, count);
        }
        return result;
    }

    private Map<Long, Integer> fillMasterAndSlavesLongMap(Map<Long, Integer> studentCountMaps, Map<Integer, List<OrgSubAccount>> map) {
        HashMap result = Maps.newHashMap();
        for (Integer orgId : map.keySet()) {
            List<OrgSubAccount> list = map.get(orgId);
            Integer count = studentCountMaps.get(orgId.longValue()) != null ? studentCountMaps.get(orgId.longValue()) : Integer.valueOf(0);
            for (OrgSubAccount sub : list) {
                if (!studentCountMaps.containsKey(sub.getOrgId().longValue())) continue;
                int subCount = studentCountMaps.get(sub.getOrgId().longValue()) != null ? studentCountMaps.get(sub.getOrgId().longValue()) : 0;
                count = count + subCount;
            }
            result.put(orgId.longValue(), count);
        }
        return result;
    }

    private void sortYunyingData(List<YunYingSystemDto> list) {
        Collections.sort(list, new Comparator<YunYingSystemDto>(){

            @Override
            public int compare(YunYingSystemDto o1, YunYingSystemDto o2) {
                return o1.getInitial().toLowerCase().compareTo(o2.getInitial().toLowerCase());
            }
        });
    }

    private File writeYunyingDateToFile(List<YunYingSystemDto> list) {
        String[] fields = new String[]{"\u673a\u6784\u540d\u79f0", "\u673a\u6784ID", "\u8d2d\u4e70\u5728\u8bfb\u5b66\u5458", "\u57ce\u5e02", "\u5bf9\u5e94\u9500\u552e", "\u9500\u552e\u4e3b\u7ba1", "\u5f00\u901a\u65e5\u671f", "\u7ed3\u675f\u65e5\u671f", "\u7248\u672c\u7c7b\u578b", "\u54c1\u7c7b", "\u7efc\u5408\u8bc4\u5b9a/\u5ba2\u6237\u5206\u7ea7", "\u5728\u8bfb\u5b66\u5458\u6570", "\u751f\u6548\u6821\u533a\u6570", "\u751f\u6548\u5e10\u53f7\u6570", "\u516c\u4f17\u53f7\u6258\u7ba1\u7c7b\u578b", "\u7ed1\u5b9a\u5b66\u5458\u6570", "\u7ebf\u4e0a\u6708\u5747\u4ea4\u6613\u989d", "\u7ebf\u4e0b\u6708\u5747\u4ea4\u6613\u989d", "\u62db\u751f\u4e2d\u73ed\u7ea7\u6570\u91cf", "\u65e5\u6d3b\u6821\u533a\u6570", "\u5468\u6d3b\u6821\u533a\u6570", "\u6708\u6d3b\u6821\u533a\u6570", "\u5468\u5747\u7b7e\u5230\u6b21\u6570", "\u6708\u5747\u5916\u547c\u5206\u949f\u6570", "\u8001\u5e08\u5468\u8bc4\u8bba\u6570", "\u5b66\u751f\u5468\u8bc4\u8bba\u6570", "\u5fae\u76f4\u64ad\u6708\u5f00\u8bbe\u6b21\u6570", "\u5fae\u76f4\u64ad\u6708\u5230\u8bfe\u4eba\u6570", "\u5468\u6dfb\u52a0\u6210\u957f\u8bb0\u5f55\u6570", "\u6708\u6dfb\u52a0\u6210\u957f\u8bb0\u5f55\u6570", "\u5907\u6ce8"};
        String[] fieldValue = new String[]{"orgName", "orgNumber", "paidStudentCount", "city", "salePerson", "saleManager", "beginTime", "endTime", "versionStr", "pinLei", "pingDingFenJi", "studentCount", "campusCount", "accountCount", "weChatTypeStr", "bindStudentCount", "onlineIncome", "offlineIncome", "classCount", "weekPV", "monthPV", "threeMonthPV", "weekSignCount", "dialOutCount", "teacherCommentCount", "studentCommentCount", "vzhiboClassCount", "vzhiboClassStudent", "weekStudentGrowCount", "monthStudentGrowCount", "remark"};
        String fileName = "\u5929\u6821\u7528\u6237\u8fd0\u8425\u6570\u636e" + DateUtil.getStrByDate((Date)new Date()) + ".xls";
        File file = this.exportToExcelLocalFile(list, fields, fieldValue, fileName);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File exportToExcelLocalFile(List<YunYingSystemDto> data, String[] fields, String[] fieldValue, String file) {
        int i;
        if (fields == null || fieldValue == null) {
            throw new RuntimeException("fields or header can't be null.");
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        Sheet sheet = wb.createSheet("\u5929\u6821");
        Row headerTitle = sheet.createRow(0);
        int index = 0;
        for (i = 0; i < fields.length; ++i) {
            Cell cell = headerTitle.createCell(index++ % fields.length);
            cell.setCellValue(fields[i]);
        }
        for (i = 0; i < data.size(); ++i) {
            Row row = sheet.createRow(i + 1);
            YunYingSystemDto o = data.get(i);
            for (int j = 0; j < fields.length; ++j) {
                Cell cell = row.createCell(index++ % fields.length);
                try {
                    cell.setCellValue(BeanUtils.getProperty((Object)o, (String)fieldValue[j]));
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("export data error", e);
                }
            }
        }
        File localFile = new File(file);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(localFile);
            wb.write((OutputStream)out);
            out.flush();
        }
        catch (Exception e) {
            try {
                log.debug("------[excel error]--------- {}", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
        IOUtils.closeQuietly((OutputStream)out);
        return localFile;
    }

    private void sendYunyingDataEmail(File file) {
        Mail mail = new Mail();
        String receiver = YunYingEmailConstants.RECIEVER;
        String cc = YunYingEmailConstants.CC;
        String bcc = YunYingEmailConstants.BCC;
        String host = YunYingEmailConstants.HOST;
        String from = "tianxiao";
        String subject = "\u5929\u6821\u7528\u6237\u8fd0\u8425\u6570\u636e" + DateUtil.getStrByDate((Date)new Date());
        String address = YunYingEmailConstants.ADDRESS;
        try {
            from = MimeUtility.encodeText((String)from);
            mail.setContent("");
            mail.setFrom(from + "<" + address + ">");
            mail.setSubject(subject);
            mail.addToAddress(receiver);
            mail.addCcAddress(cc);
            mail.addBccAddress(bcc);
            if (file.exists()) {
                AttachBean attachBean = new AttachBean();
                attachBean.setCid(file.getName());
                attachBean.setFile(file);
                attachBean.setFileName(file.getName());
                mail.addAttach(attachBean);
            }
            Session session = MailUtils.createSession((String)host);
            MailUtils.send((Session)session, (Mail)mail);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Transactional
    public void syncOpenAppCount(String dateStr) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dateStr)) {
            Date date = DateUtil.getDiffDateTime((Date)new Date(), (int)-1);
            dateStr = DateUtil.getDayStr((Date)date);
        }
        List<YYGalaxyDto> list = this.getYYByDate(dateStr);
        this.saveOpenAppCount(list, dateStr);
    }

    private List<YYGalaxyDto> getYYByDate(String pt) {
        block4: {
            HashMap params = Maps.newHashMap();
            params.put("app_id", "12abed26a7");
            params.put("database", "formatter");
            StringBuilder sb = new StringBuilder("");
            sb.append("select user_number as number ,count(distinct(concat(user_number,get_json_object(event_attr, '$.mobile')))) as count from  formatter.app_event_log_tianxiao where ");
            sb.append("pt='").append(pt);
            sb.append(" and event_attr not like '%click%' group by user_number ");
            params.put("query", sb.toString());
            log.info("query params = {}", (Object)params);
            try {
                String result = HttpClientUtils.doJsonPost((String)"http://galaxy-api.baijiahulian.com/query.json", (Map)params, (String)"UTF-8");
                YunYingGalaxyDto dto = (YunYingGalaxyDto)JacksonUtil.str2Obj((String)result, YunYingGalaxyDto.class);
                if (dto.getCode() == 0) {
                    if (dto.getRows() != null && dto.getRows().size() > 0) {
                        return dto.getRows();
                    }
                    break block4;
                }
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "GALAXY\u670d\u52a1\u67e5\u8be2\u9519\u8bef," + dto.getMessage());
            }
            catch (Exception e) {
                log.warn("GALAXY\u670d\u52a1\u63a5\u53e3\u5f02\u5e38,{}", (Throwable)e);
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "GALAXY\u670d\u52a1\u63a5\u53e3\u5f02\u5e38");
            }
        }
        return null;
    }

    private void saveOpenAppCount(List<YYGalaxyDto> list, String dateStr) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<Integer, Integer> resultMap = this.getPvMap(list);
        this.savePv(resultMap, dateStr);
    }

    private Map<Integer, Integer> getPvMap(List<YYGalaxyDto> list) {
        HashMap numberCountMap = Maps.newHashMap();
        for (YYGalaxyDto dto : list) {
            if (dto.getNumber() == null || dto.getNumber().longValue() <= 0L) continue;
            numberCountMap.put(dto.getNumber(), dto.getCount());
        }
        List orgList = this.orgAccountDao.getAccountByNumbers(numberCountMap.keySet(), new String[0]);
        HashMap orgIdCounMap = Maps.newHashMap();
        for (OrgAccount account : orgList) {
            orgIdCounMap.put(account.getId(), numberCountMap.get(account.getNumber()));
        }
        List allAccounts = this.orgSubAccountDao.getByOrgIds(orgIdCounMap.keySet(), OrgSubAccountStatus.NORMAL.getCode(), new String[0]);
        HashMap resultMap = Maps.newHashMap();
        for (OrgSubAccount sub : allAccounts) {
            Integer count;
            if (sub.getPid() == 0) {
                if (resultMap.containsKey(sub.getOrgId())) {
                    count = (Integer)resultMap.get(sub.getOrgId()) + 1;
                    resultMap.put(sub.getOrgId(), count);
                    continue;
                }
                resultMap.put(sub.getOrgId(), 1);
                continue;
            }
            if (resultMap.containsKey(sub.getPid())) {
                count = (Integer)resultMap.get(sub.getPid()) + 1;
                resultMap.put(sub.getPid(), count);
                continue;
            }
            resultMap.put(sub.getPid(), 1);
        }
        return resultMap;
    }

    private void savePv(Map<Integer, Integer> resultMap, String dateStr) {
        ArrayList toSave = Lists.newArrayList();
        Date date = null;
        date = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dateStr) ? DateUtil.getDiffDateTime((Date)new Date(), (int)-1) : DateUtil.getStrToDate((String)"yyyyMMdd", (String)dateStr);
        for (Map.Entry<Integer, Integer> entry : resultMap.entrySet()) {
            TXAppPv pv = new TXAppPv();
            pv.setOrgId(entry.getKey());
            pv.setCount(entry.getValue());
            pv.setCreateTime(date);
            toSave.add(pv);
        }
        this.txAppPvDao.saveAll((List)toSave, new String[0]);
    }
}

